/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database.tools;

import fable.framework.database.DerbyDatabase;
import fable.framework.views.FableIOConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class DerbyDumbConsole {
    FableIOConsole sqlConsole;
    RunConsoleThread runConsoleThread = new RunConsoleThread();
    Connection conn = null;

    public DerbyDumbConsole() {
        this.sqlConsole = new FableIOConsole("SQL Console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.sqlConsole});
    }

    public void run() {
        new Thread(this.runConsoleThread).start();
    }

    void executeQuery(String string) {
        if (DerbyDatabase.getDatabase() == null) {
            this.sqlConsole.displayOut("Database is disabled, please enable it in Edit->Preferences->Database and restart application\n");
        } else {
            this.sqlConsole.displayOut("Execute query " + string + "\n");
            try {
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                this.sqlConsole.displayOut("Results of query " + string + "\n");
                int n2 = 1;
                while (n2 <= n) {
                    this.sqlConsole.displayOut(String.valueOf(resultSetMetaData.getColumnLabel(n2)) + "\t\t");
                    ++n2;
                }
                this.sqlConsole.displayOut("\n-------------------------------------------------\n");
                while (resultSet.next()) {
                    n2 = 1;
                    while (n2 <= n) {
                        String string2 = resultSet.getString(n2);
                        this.sqlConsole.displayOut(String.valueOf(string2) + "\t\t");
                        ++n2;
                    }
                    this.sqlConsole.displayOut("\n");
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    class RunConsoleThread
    implements Runnable {
        final Runtime runtime = Runtime.getRuntime();
        String outputMessage;

        RunConsoleThread() {
        }

        @Override
        public void run() {
            DerbyDumbConsole.this.conn = DerbyDatabase.getConnection();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)DerbyDumbConsole.this.sqlConsole.getInputStream()));
                String string = "";
                while (string != null) {
                    DerbyDumbConsole.this.sqlConsole.displayOut("sql > ");
                    string = bufferedReader.readLine();
                    if (string == null) continue;
                    DerbyDumbConsole.this.sqlConsole.displayOut(String.valueOf(string) + "\n");
                    DerbyDumbConsole.this.executeQuery(string);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream inputStream) {
            this.inStream = inputStream;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int n;
                while ((n = bufferedReader.read()) != -1) {
                    DerbyDumbConsole.this.sqlConsole.displayOut(String.valueOf((char)n));
                }
            }
            catch (IOException iOException) {}
            System.out.println("exit StreamReaderThread() ...");
        }
    }

    public class StreamWriterThread
    extends Thread {
        byte inMessage;
        OutputStream outStream;
        String newline = System.getProperty("line.separator");

        public StreamWriterThread(OutputStream outputStream) {
            this.outStream = outputStream;
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)DerbyDumbConsole.this.sqlConsole.getInputStream()));
                String string = "";
                while (string != null) {
                    string = bufferedReader.readLine();
                    if (string == null) continue;
                    this.outStream.write(string.getBytes());
                    this.outStream.write(this.newline.getBytes());
                    this.outStream.flush();
                }
            }
            catch (IOException iOException) {}
            System.out.println("exit StreamWriterThread() ...");
        }
    }
}

