/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database.test;

import fable.framework.database.Activator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DatabaseTest {
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PROTOCOL = "jdbc:derby:";
    private static final String DATABASE = "grainsDB";
    private static final String CREATE_TABLE = "CREATE TABLE grains(id int, gvectors int)";
    private static final String SELECT_RECORDS_QUERY = "SELECT SUM(id) FROM grains";
    private static final String INSERT_RECORDS_QUERY = "INSERT INTO grains (id,gvectors) VALUES(1,10)";

    public DatabaseTest() throws SQLException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Statement statement;
        Connection connection = null;
        System.setProperty("derby.system.home", Activator.getDefault().getStateLocation().toFile().getAbsolutePath());
        Properties properties = new Properties();
        try {
            Class.forName(DRIVER).newInstance();
            connection = DriverManager.getConnection("jdbc:derby:grainsDB", properties);
        }
        catch (SQLException sQLException) {
            connection = DriverManager.getConnection("jdbc:derby:grainsDB;create=true", properties);
            try {
                statement = connection.createStatement();
                try {
                    statement.execute(CREATE_TABLE);
                }
                finally {
                    statement.close();
                }
                connection.commit();
            }
            catch (SQLException sQLException2) {
                connection.close();
                throw sQLException2;
            }
        }
        try {
            statement = connection.createStatement();
            try {
                statement.execute(INSERT_RECORDS_QUERY);
                ResultSet resultSet = statement.executeQuery(SELECT_RECORDS_QUERY);
                resultSet.next();
                ResultSet resultSet2 = statement.executeQuery("select * from grains");
                ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                int n2 = 1;
                while (n2 <= n) {
                    System.out.print(String.valueOf(resultSetMetaData.getColumnLabel(n2)) + "\t\t");
                    ++n2;
                }
                System.out.println("\n-------------------------------------------------");
                while (resultSet2.next()) {
                    n2 = resultSet2.getInt(1);
                    int n3 = resultSet2.getInt(2);
                    System.out.println(String.valueOf(n2) + "\t\t" + n3);
                }
                resultSet2.close();
            }
            finally {
                statement.close();
            }
            connection.commit();
        }
        finally {
            connection.close();
        }
    }
}

