/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DerbyDatabase {
    private String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private String protocol = "jdbc:derby:";
    private static Connection conn = null;
    private Statement statement = null;
    private static DerbyDatabase database = null;
    private static boolean databaseSupport = false;

    private DerbyDatabase() {
        Properties properties = new Properties();
        properties.put("user", "user");
        properties.put("password", "");
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        try {
            conn = DriverManager.getConnection(String.valueOf(this.protocol) + "derbyDB;create=true", properties);
            conn.setAutoCommit(false);
            this.statement = conn.createStatement();
            this.statement.execute("create table test(name varchar(40), num int, addr varchar(80))");
            this.statement.execute("insert into test values ('ESRF', 6,'rue Jules Horowitz, Grenoble')");
            this.statement.execute("insert into test values ('SOLEIL', 1,'Orme des Merisiers, Saint-Aubin, Gif-sur-Yvette')");
            this.statement.execute("insert into test values ('ELETTRA', 14,'Strada Statale, Basovizza, Trieste')");
            this.statement.execute("insert into test values ('ALBA', 1,'Edifici Ci\u00e8ncies Nord. M\u00f2dul C-3 central., Bellaterra, Barcelona')");
            this.statement.execute("insert into test values ('PETRA III', 85,'Notke strasse, Altona, Hamburg')");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static Connection getConnection() {
        return conn;
    }

    private static void createDatabase() {
        database = new DerbyDatabase();
    }

    public void createTable(String string) {
        try {
            this.statement.execute("create table " + string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void insert(String string, String string2) {
        try {
            this.statement.execute("insert into " + string + " values " + string2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static void select() {
    }

    public static DerbyDatabase getDatabase() {
        if (databaseSupport && database == null) {
            DerbyDatabase.createDatabase();
        }
        return database;
    }

    public static void setDatabaseSupport(boolean bl) {
        databaseSupport = bl;
    }
}

