/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.navigator.controller.SampleController;
import fable.framework.views.FableMessageConsole;
import fable.peaksearch.Activator;
import fable.peaksearch.actions.OpensptFile;
import fable.peaksearch.object.PeakSelectionProvider;
import fable.peaksearch.object.Peaksearch;
import fable.python.FabioFileException;
import fable.python.Peak;
import fable.python.PeakSearchSpt;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public class PeaksSptView
extends ViewPart
implements IPropertyChangeListener {
    private static final String ID = "fable.peaksearch.PeaksSptView";
    public static PeaksSptView view;
    private TableViewer table;
    private TableViewer tableHeaderSpt;
    private String sptFile;
    private Vector<PeakSearchSpt> filePeaks;
    private PeakSearchSpt currentPeaks = null;
    private SashForm sash;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private Logger logger;
    private ImageDescriptor check_imageDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/check.gif");
    private ImageDescriptor uncheck_imageDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/uncheck.gif");
    private Listener sortListener;
    String[] titles = new String[]{"#", "Number_of_pixels", "Average_counts", "f", "s", "fc", "sc", "sig_f", "sig_s", "cov_fs"};
    Text directoryTextField;
    String currentDirectory = "";
    FableMessageConsole console;
    PeakSelectionProvider selectionProvider;
    private SampleController controller = SampleController.getController();
    private Button browse;
    private OpensptFile loadAction;
    private ImageDescriptor openFile = Activator.getImageDescriptor("images/openFiles.gif");

    public void createPartControl(Composite composite) {
        this.logger = Logger.getLogger(Peaksearch.class);
        this.selectionProvider = new PeakSelectionProvider();
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = PeaksSptView.this.table.getTable().getSortColumn();
                TableColumn tableColumn2 = (TableColumn)event.widget;
                int n = PeaksSptView.this.table.getTable().getSortDirection();
                if (tableColumn == tableColumn2) {
                    n = n == 128 ? 1024 : 128;
                } else {
                    PeaksSptView.this.table.getTable().setSortColumn(tableColumn2);
                    n = 1024;
                }
                TableColumn[] tableColumnArray = PeaksSptView.this.table.getTable().getColumns();
                TableColumn tableColumn3 = (TableColumn)event.widget;
                int n2 = 0;
                int n3 = 0;
                while (n2 == 0 && n3 < tableColumnArray.length) {
                    if (tableColumnArray[n3].getText().equals(tableColumn3.getText())) {
                        n2 = n3;
                    }
                    ++n3;
                }
                PeaksSptView.this.currentPeaks.setComparator(tableColumn3.getText(), n);
                PeaksSptView.this.table.getTable().setSortDirection(n);
                PeaksSptView.this.table.getTable().setSortColumn(tableColumn3);
                PeaksSptView.this.updatePeaksTable();
            }
        };
        view = this;
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        this.filePeaks = new Vector();
        composite.setLayout((Layout)new GridLayout(3, false));
        this.console = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[0];
        boolean bl = false;
        int n = 0;
        while (!bl && n < ConsolePlugin.getDefault().getConsoleManager().getConsoles().length) {
            if (ConsolePlugin.getDefault().getConsoleManager().getConsoles()[n] instanceof FableMessageConsole) {
                bl = true;
                this.console = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[n];
            }
            ++n;
        }
        if (this.console == null) {
            this.console = new FableMessageConsole("Peaksearch console");
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        Label label = new Label(composite, 0);
        label.setText("Images directory path");
        label.setToolTipText("If your images haven't been found, please set the images directory here.");
        this.directoryTextField = new Text(composite, 2048);
        this.directoryTextField.setEnabled(false);
        this.directoryTextField.setLayoutData((Object)new GridData(4, 2, true, false));
        this.directoryTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    PeaksSptView.this.currentDirectory = PeaksSptView.this.directoryTextField.getText();
                    PeaksSptView.this.updateImageSelected();
                }
            }
        });
        this.browse = new Button(composite, 8);
        this.browse.setText("Browse...");
        this.browse.setEnabled(false);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                directoryDialog.setFilterPath(PeaksSptView.this.currentDirectory);
                String string = directoryDialog.open();
                if (string != null) {
                    PeaksSptView.this.currentDirectory = String.valueOf(string) + System.getProperty("file.separator");
                    if (!PeaksSptView.this.currentDirectory.equals("")) {
                        PeaksSptView.this.directoryTextField.setText(PeaksSptView.this.currentDirectory);
                        PeaksSptView.this.updateImageSelected();
                    }
                }
            }
        });
        this.sash = new SashForm(composite, 256);
        this.sash.setLayoutData((Object)gridData);
        this.createleftTable();
        this.createTable();
        this.sash.setWeights(new int[]{20, 50});
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        if (this.tableHeaderSpt != null) {
            this.selectionProvider.setSelectionProviderDelegate((ISelectionProvider)this.tableHeaderSpt);
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.loadAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.loadAction);
    }

    private void makeActions() {
        this.loadAction = new OpensptFile();
        this.loadAction.setText("Load a 2D peak file (.spt)");
        this.loadAction.setToolTipText("Load a 2D peak file (.spt)");
        this.loadAction.setImageDescriptor(this.openFile);
    }

    protected void updatePeaksTable() {
        Object[] objectArray = this.currentPeaks.getSortedpeaks().toArray();
        this.table.setInput((Object)objectArray);
        this.table.setItemCount(this.currentPeaks.getNbPeaks());
    }

    public void dispose() {
        if (this.currentPeaks != null) {
            this.currentPeaks.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.getSite().setSelectionProvider(null);
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public final void loadSptFile(String string) {
        String string2;
        this.sptFile = string;
        if (this.sptFile != null) {
            this.browse.setEnabled(true);
            this.directoryTextField.setEnabled(true);
            string2 = this.getSptFileName();
            this.setPartName("2D peaks: " + string2);
        }
        this.filePeaks.removeAllElements();
        string2 = new Job("Loading " + this.sptFile){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    iProgressMonitor.beginTask("Please, wait while loading peaks in table....", -1);
                    FileInputStream fileInputStream = new FileInputStream(PeaksSptView.this.sptFile);
                    long l = System.currentTimeMillis();
                    Scanner scanner = new Scanner(fileInputStream);
                    try {
                        Pattern pattern = Pattern.compile("#\\s+File\\s+");
                        scanner.useDelimiter(pattern);
                        Pattern pattern2 = Pattern.compile("[\t\r\n]*");
                        scanner.skip(pattern2);
                        while (scanner.hasNextLine()) {
                            try {
                                long l2 = System.currentTimeMillis();
                                String string = scanner.next();
                                Scanner scanner2 = new Scanner(string);
                                scanner2.useDelimiter("[\n\r]+");
                                String string2 = scanner2.next();
                                scanner2.close();
                                PeakSearchSpt peakSearchSpt = new PeakSearchSpt(PeaksSptView.this.sptFile);
                                PeaksSptView.this.currentPeaks = peakSearchSpt;
                                peakSearchSpt.setFabioFileName(string2);
                                PeaksSptView.this.currentPeaks.addPropertyChangeListener((IPropertyChangeListener)view);
                                PeaksSptView.this.filePeaks.add(peakSearchSpt);
                                peakSearchSpt.setKeys(PeaksSptView.this.titles);
                                peakSearchSpt.setNbPeaks(PeaksSptView.this.getNnPeaksInfo(string));
                                peakSearchSpt.setPeaks(PeaksSptView.this.getBlockPeaks(string));
                                l2 = System.currentTimeMillis() - l2;
                                if (!iProgressMonitor.isCanceled()) continue;
                                scanner.close();
                                try {
                                    fileInputStream.close();
                                }
                                catch (IOException iOException) {
                                    PeaksSptView.this.logger.error((Object)("initfabioFile: Problem closing input file reader after monitor cancel: " + iOException.getMessage()));
                                }
                                return Status.CANCEL_STATUS;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                if (FableMessageConsole.console == null) continue;
                                FableMessageConsole.console.displayError("Fable cannot parse " + PeaksSptView.this.sptFile + " Pattern File not found.");
                            }
                        }
                        l = System.currentTimeMillis() - l;
                        PeaksSptView.this.populateLeftTable();
                        scanner.close();
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            PeaksSptView.this.logger.error((Object)("initfabioFile: Problem closing input file reader: " + iOException.getMessage()));
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        scanner.close();
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            PeaksSptView.this.logger.error((Object)("initfabioFile: Problem closing input file reader after PatternSyntaxException: " + iOException.getMessage()));
                        }
                        FableMessageConsole.console.displayIn("Peaks cannot be retrieved from this file. Make sure you have chosen a spt file.");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FableMessageConsole.console.displayIn("File " + PeaksSptView.this.sptFile + " not found.");
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        string2.setUser(true);
        string2.schedule();
        string2.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.selectImageAt(0);
                    }
                });
            }
        });
    }

    private String getSptFileName() {
        assert (this.sptFile != null);
        int n = this.sptFile.lastIndexOf(System.getProperty("file.separator"));
        if (n + 1 <= this.sptFile.length()) {
            ++n;
        }
        String string = this.sptFile.substring(n);
        return string;
    }

    private void selectImageAt(int n) {
        if (this.tableHeaderSpt.getTable().getItemCount() > 0) {
            if (n >= this.tableHeaderSpt.getTable().getItemCount()) {
                n = 0;
            } else if (n < 0) {
                n = this.tableHeaderSpt.getTable().getItemCount() - 1;
            }
            this.tableHeaderSpt.getTable().setFocus();
            TableItem tableItem = this.tableHeaderSpt.getTable().getItem(n);
            Event event = new Event();
            event.item = tableItem;
            event.widget = this.tableHeaderSpt.getTable();
            event.type = 13;
            this.tableHeaderSpt.setSelection((ISelection)new StructuredSelection(tableItem.getData()));
        }
    }

    private int getNnPeaksInfo(String string) {
        String string2;
        String[] stringArray;
        int n = 0;
        String[] stringArray2 = string.split("(#\\s+npks\\s+=)");
        if (stringArray2.length > 1 && (stringArray = (string2 = stringArray2[1]).split("\\n")).length > 0) {
            try {
                String string3 = stringArray[0].trim();
                n = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    private String getBlockPeaks(String string) {
        String string2;
        Scanner scanner;
        block5: {
            scanner = null;
            string2 = "";
            try {
                scanner = new Scanner(string);
                Pattern pattern = Pattern.compile("(#(.+)\\r*\\n)+");
                scanner.useDelimiter(pattern);
                if (scanner.hasNext()) {
                    scanner.next();
                    if (scanner.hasNext()) {
                        string2 = scanner.next();
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (scanner == null) break block5;
                scanner.close();
            }
        }
        if (scanner != null) {
            scanner.close();
        }
        return string2;
    }

    private void populatePeaksTable() {
        if (this.table != null && !this.table.getTable().isDisposed()) {
            this.table.getTable().clearAll();
            this.table.getTable().removeAll();
            int n = 0;
            n = this.currentPeaks.getNbPeaks();
            this.table.setItemCount(n);
            this.table.setInput((Object)this.currentPeaks.getChildren().toArray());
        }
    }

    public void setFocus() {
    }

    public void createleftTable() {
        this.tableHeaderSpt = new TableViewer((Composite)this.sash);
        this.tableHeaderSpt.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableHeaderSpt.setLabelProvider((IBaseLabelProvider)new TableSptLabelProvider());
        this.tableHeaderSpt.setUseHashlookup(true);
        this.initTableHeaderSpt();
        this.tableHeaderSpt.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                PeaksSptView.this.selectionProvider.setSelectionProviderDelegate(null);
                IStructuredSelection iStructuredSelection = (IStructuredSelection)PeaksSptView.this.tableHeaderSpt.getSelection();
                PeaksSptView.this.selectionProvider.setSelectionProviderDelegate((ISelectionProvider)PeaksSptView.this.tableHeaderSpt);
                if (iStructuredSelection != null && !iStructuredSelection.isEmpty()) {
                    PeakSearchSpt peakSearchSpt = (PeakSearchSpt)iStructuredSelection.getFirstElement();
                    PeaksSptView.this.currentPeaks = peakSearchSpt;
                    if (PeaksSptView.this.currentPeaks.getImageFile() == null || !PeaksSptView.this.currentPeaks.getImageFile().getFullFilename().equals(String.valueOf(PeaksSptView.this.currentDirectory) + PeaksSptView.this.currentPeaks.getFabioFileName())) {
                        PeaksSptView.this.initfabioFile();
                    }
                    this.doParsing();
                }
            }

            private void doParsing() {
                if (!$assertionsDisabled && PeaksSptView.this.currentPeaks == null) {
                    throw new AssertionError();
                }
                if (!PeaksSptView.this.currentPeaks.isParsed()) {
                    PeaksSptView.this.currentPeaks.parse();
                } else {
                    PeaksSptView.this.updatePeaksTable();
                }
            }
        });
    }

    private void initTableHeaderSpt() {
        Table table = this.tableHeaderSpt.getTable();
        String[] stringArray = new String[]{"File", "NbPeaks"};
        int n = 0;
        while (n < stringArray.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            table.getColumn(n).pack();
            ++n;
        }
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
    }

    public void populateLeftTable() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PeaksSptView.this.tableHeaderSpt.getTable().removeAll();
                PeaksSptView.this.tableHeaderSpt.getTable().clearAll();
                PeaksSptView.this.tableHeaderSpt.setInput((Object)PeaksSptView.this.filePeaks.toArray());
                int n = 0;
                while (n < PeaksSptView.this.tableHeaderSpt.getTable().getColumnCount()) {
                    PeaksSptView.this.tableHeaderSpt.getTable().getColumn(n).pack();
                    ++n;
                }
            }
        });
    }

    public void createTable() {
        this.table = new TableViewer((Composite)this.sash, 268503074);
        this.table.getTable().setLinesVisible(false);
        this.table.getTable().setHeaderVisible(true);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new PeakLabelProvider());
        int n = 0;
        while (n < this.titles.length) {
            TableColumn tableColumn = new TableColumn(this.table.getTable(), 0);
            tableColumn.setText(this.titles[n]);
            tableColumn.addListener(13, this.sortListener);
            ++n;
        }
        n = 0;
        while (n < this.titles.length) {
            this.table.getTable().getColumn(n).pack();
            ++n;
        }
        this.table.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3 && PeaksSptView.this.table.getTable().getSelectionIndex() > 0) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem menuItem = new MenuItem(menu, 8);
                    menuItem.setText("Check");
                    final Image image = PeaksSptView.this.check_imageDescriptor.createImage();
                    final Image image2 = PeaksSptView.this.uncheck_imageDescriptor.createImage();
                    menuItem.setImage(image);
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int n = 0;
                            while (n < PeaksSptView.this.table.getTable().getSelectionCount()) {
                                PeaksSptView.this.table.getTable().getItem(PeaksSptView.this.table.getTable().getSelectionIndices()[n]).setChecked(true);
                                ++n;
                            }
                            PeaksSptView.this.table.getTable().notifyListeners(13, new Event());
                        }
                    });
                    MenuItem menuItem2 = new MenuItem(menu, 8);
                    menuItem2.setText("Uncheck");
                    menuItem2.setImage(image2);
                    menuItem2.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int n = 0;
                            while (n < PeaksSptView.this.table.getTable().getSelectionCount()) {
                                PeaksSptView.this.table.getTable().getItem(PeaksSptView.this.table.getTable().getSelectionIndices()[n]).setChecked(false);
                                ++n;
                            }
                            PeaksSptView.this.table.getTable().notifyListeners(13, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            if (image != null) {
                                image.dispose();
                            }
                            if (image2 != null) {
                                image2.dispose();
                            }
                        }
                    });
                    menu.dispose();
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = null;
                TableItem[] tableItemArray = PeaksSptView.this.tableHeaderSpt.getTable().getSelection();
                if (tableItemArray != null && tableItemArray.length > 0) {
                    PeaksSptView.this.currentPeaks = (PeakSearchSpt)tableItemArray[0].getData();
                }
                if (event.detail == 32 && (tableItem = (TableItem)event.item).getData() != null) {
                    PeaksSptView.this.table.setSelection((ISelection)new StructuredSelection(tableItem.getData()), true);
                }
            }
        };
        this.table.getTable().addListener(13, listener);
        this.table.getTable().addListener(32, listener);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)PeaksSptView.this.table.getSelection();
                if (iStructuredSelection != null && !iStructuredSelection.isEmpty()) {
                    Object[] objectArray = iStructuredSelection.toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        Peak peak = (Peak)objectArray[n];
                        if (peak != null) {
                            peak.show(PeaksSptView.this.table.getTable().getSelection()[n].getChecked());
                        }
                        ++n;
                    }
                }
                PeaksSptView.this.selectionProvider.setSelectionProviderDelegate((ISelectionProvider)PeaksSptView.this.table);
            }
        });
        this.table.getTable().addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int n = event.index;
                int n2 = PeaksSptView.this.tableHeaderSpt.getTable().getSelectionIndex();
                if (n2 < 0) {
                    n2 = 0;
                }
                PeakSearchSpt peakSearchSpt = (PeakSearchSpt)PeaksSptView.this.filePeaks.elementAt(n2);
                Color color = n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : PeaksSptView.this.light_blue;
                Vector vector = peakSearchSpt.getChildren();
                Peak peak = (Peak)vector.elementAt(n);
                tableItem.setChecked(peak.isVisible());
                tableItem.setData((Object)peak);
                tableItem.setBackground(color);
            }
        });
    }

    public void initfabioFile() {
        assert (this.currentPeaks != null);
        try {
            this.currentPeaks.initFabioFile(String.valueOf(this.currentDirectory) + this.currentPeaks.getFabioFileName());
        }
        catch (FabioFileException fabioFileException) {
            this.currentPeaks.setFabioFile(null);
            if (FableMessageConsole.console != null) {
                if (this.currentDirectory != null && this.currentPeaks != null && this.currentPeaks.getFabioFileName() != null) {
                    FableMessageConsole.console.displayError("Image file " + this.currentDirectory + this.currentPeaks.getFabioFileName() + " not found. ");
                }
                FableMessageConsole.console.displayInfo(" Please check image file directory is correct.");
            }
            this.logger.debug((Object)("PeaksSptView.initfabioFile: Problem with PeakSearchSpt.initFabioFile: " + fabioFileException.getMessage()));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty() != null) {
            if (propertyChangeEvent.getProperty().equals("Parsing_working")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.populatePeaksTable();
                    }
                });
            } else if (propertyChangeEvent.getProperty().equals("Parsing_completed")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.populatePeaksTable();
                        PeaksSptView.this.updateImageSelected();
                    }
                });
            } else if (propertyChangeEvent.getProperty().equals("next image")) {
                final int n = (Integer)propertyChangeEvent.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n2 = PeaksSptView.this.tableHeaderSpt.getTable().getSelectionIndex();
                        PeaksSptView.this.selectImageAt(n2 += n);
                    }
                });
            } else if (propertyChangeEvent.getProperty().equals("last image")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n = PeaksSptView.this.tableHeaderSpt.getTable().getItemCount();
                        PeaksSptView.this.selectImageAt(--n);
                    }
                });
            } else if (propertyChangeEvent.getProperty().equals("first image")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.selectImageAt(0);
                    }
                });
            }
        }
    }

    private void updateImageSelected() {
        int n = this.tableHeaderSpt.getTable().getSelectionIndex();
        if (n == -1) {
            n = 0;
        }
        if (n >= 0) {
            this.selectImageAt(n);
        }
    }

    public static String getID() {
        return ID;
    }

    class PeakLabelProvider
    implements ITableLabelProvider {
        PeakLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = "";
            if (object instanceof Peak) {
                Peak peak = (Peak)object;
                String string2 = PeaksSptView.this.table.getTable().getColumn(n).getText();
                string = peak.getValue(string2);
            }
            return string;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    class TableSptLabelProvider
    implements ITableLabelProvider {
        private ImageDescriptor IDgreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot.gif");
        private ImageDescriptor IDred = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/darkred.gif");
        private ImageDescriptor IDbigGreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot_big.gif");
        private Image imggreen = this.IDgreen.createImage();
        private Image bigGreen = this.IDbigGreen.createImage();
        private Image red = this.IDred.createImage();

        public Image getColumnImage(Object object, int n) {
            if (object instanceof PeakSearchSpt && n == 0) {
                PeakSearchSpt peakSearchSpt = (PeakSearchSpt)object;
                if (peakSearchSpt.getNbPeaks() <= 100) {
                    return this.imggreen;
                }
                if (peakSearchSpt.getNbPeaks() <= 1000) {
                    return this.bigGreen;
                }
                return this.red;
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (object instanceof PeakSearchSpt) {
                PeakSearchSpt peakSearchSpt = (PeakSearchSpt)object;
                switch (n) {
                    case 0: {
                        string = peakSearchSpt.getFabioFileName();
                        break;
                    }
                    case 1: {
                        string = String.valueOf(peakSearchSpt.getNbPeaks());
                        break;
                    }
                    case 2: {
                        string = String.valueOf(peakSearchSpt.getTreshold());
                        break;
                    }
                }
            }
            return string;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
            if (this.imggreen != null) {
                this.imggreen.dispose();
            }
            if (this.bigGreen != null) {
                this.bigGreen.dispose();
            }
            if (this.red != null) {
                this.red.dispose();
            }
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

