/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.framework.xmlparser.object.FableXmlContentHandler;
import fable.framework.xmlparser.object.Xmloption;
import fable.peaksearch.Activator;
import fable.peaksearch.object.PeaksearchException;
import fable.python.Sample;
import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class Peaksearch {
    private Vector<Xmloption> options;
    private Vector<Sample> samples;
    private Sample sample;
    private static Logger logger;
    private FableXmlContentHandler xmlContentHandler;
    private XMLReader saxReader;
    private static Peaksearch peaksearch;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private ArrayList<String> listKillFile = new ArrayList();
    private static String iniFile;
    private Job job;
    private ArrayList<PeaksearchThread> peaksearchersRunning;
    private boolean forceQuit = false;
    private IProgressMonitor peaksearchProgressMonitor;

    static {
        peaksearch = null;
        iniFile = "";
    }

    public static Peaksearch getPeaksearch() throws PeaksearchException, JepException {
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    public static Peaksearch getPeaksearch(String string) throws PeaksearchException, JepException {
        iniFile = string;
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    private Peaksearch() throws PeaksearchException {
        logger = Logger.getLogger(Peaksearch.class);
        logger.info((Object)"Create Peaksearch");
        this.xmlContentHandler = new FableXmlContentHandler();
        iniFile = Activator.getDefault().getPreferenceStore().getString("pref_ini_peaksearch");
        if (ToolBox.checkIfFileExists((String)iniFile)) {
            this.parse();
        }
        this.peaksearchersRunning = new ArrayList();
    }

    private void parse() throws PeaksearchException {
        if (this.saxReader == null) {
            try {
                this.saxReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error reading XML file", (Throwable)sAXException);
                throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", sAXException.getMessage());
            }
        }
        try {
            this.saxReader.setContentHandler((ContentHandler)this.xmlContentHandler);
            this.saxReader.parse(new InputSource("file:" + iniFile));
            this.setOptions(this.xmlContentHandler.getOptions());
            this.fireIniFile();
        }
        catch (IOException iOException) {
            FableUtils.excNoTraceMsg((Object)this, (String)(String.valueOf(iniFile) + " used to create view not found"), (Throwable)iOException);
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", iOException.getMessage());
        }
        catch (SAXException sAXException) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error reading XML file", (Throwable)sAXException);
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", sAXException.getMessage());
        }
    }

    public void loadIniFile(String string) throws PeaksearchException {
        if (ToolBox.checkIfFileExists((String)string)) {
            iniFile = string;
            logger.info((Object)("loadIniFile" + string));
            this.parse();
        } else {
            logger.debug((Object)(String.valueOf(string) + " file used to load peaksearch doesn't exist. " + "User must set a valid xml file name in peaksearch preferences"));
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayIn(" is unable to load  option view with xml file set in peaksearch preferences.");
            }
        }
    }

    public Vector<Xmloption> getOptions() {
        return this.options;
    }

    public Sample getSample(int n) {
        Sample sample = null;
        if (this.samples != null) {
            this.samples.elementAt(n);
        }
        return sample;
    }

    public Vector<Sample> getSamples() {
        return this.samples;
    }

    public void setIniFile(String string) {
        iniFile = string;
        this.fireGetOptions();
    }

    public void setOptions(Vector<Xmloption> vector) {
        this.options = vector;
    }

    public void setSamples(Vector<Sample> vector) {
        this.samples = vector;
    }

    public void run() {
        this.forceQuit = false;
        this.job = new Job(""){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                int n = 0;
                if (Peaksearch.this.samples != null) {
                    n = Peaksearch.this.samples.size();
                }
                if (n > 0 && !Peaksearch.this.forceQuit) {
                    Peaksearch.this.firePeakSearchRuns();
                    int n2 = 0;
                    n2 = 0;
                    while (n2 < n && !Peaksearch.this.forceQuit) {
                        Peaksearch.this.sample = Peaksearch.this.getSamples().elementAt(n2);
                        Peaksearch.this.peaksearchProgressMonitor = iProgressMonitor;
                        Peaksearch.this.peaksearchProgressMonitor.beginTask("Search for peaks in sample " + Peaksearch.this.sample.getDirectoryName(), -1);
                        Peaksearch.this.peaksearchersRunning.add(new PeaksearchThread(Peaksearch.this.sample));
                        ((PeaksearchThread)Peaksearch.this.peaksearchersRunning.get(n2)).run();
                        if (Peaksearch.this.peaksearchProgressMonitor.isCanceled()) {
                            Peaksearch.this.forceQuit = true;
                            Peaksearch.this.firePeakSearchStops();
                            Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
                            return Status.CANCEL_STATUS;
                        }
                        ++n2;
                    }
                } else {
                    Peaksearch.this.firePeakSearchRuns();
                    new PeaksearchThread().run();
                }
                Peaksearch.this.firePeakSearchStops();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(false);
        if (this.samples == null) {
            logger.error((Object)" can not be launched : There are no samples");
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)" can not be launched : There are no samples");
                }
            });
            this.firePeakSearchStops();
            return;
        }
        this.peaksearchersRunning.removeAll(this.peaksearchersRunning);
        this.listKillFile.removeAll(this.listKillFile);
        this.job.schedule();
    }

    public void forceQuit() {
        this.forceQuit = true;
        for (String string : this.listKillFile) {
            File file = new File(string);
            try {
                if (file.createNewFile()) {
                    logger.debug((Object)("Force peaksearch to exit with killFile = " + string));
                } else {
                    logger.debug((Object)("file " + string + " already exists "));
                }
                this.peaksearchProgressMonitor.setCanceled(true);
                this.job.done(Status.CANCEL_STATUS);
            }
            catch (IOException iOException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error creating a file to kill PeakSearch", (Throwable)iOException);
            }
        }
        this.peaksearchProgressMonitor.setCanceled(true);
    }

    public boolean isRunning() {
        if (this.job == null) {
            return false;
        }
        return this.job.getState() == 4;
    }

    public boolean hasBeenCanceled() {
        return this.forceQuit;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    public void fireGetOptions() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "save_ini", null, (Object)iniFile));
        }
    }

    public void firePeakSearchRuns() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "run", (Object)false, (Object)true));
        }
    }

    public void fireIniFile() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "load_ini", (Object)false, (Object)true));
        }
    }

    public void fireLaunchPeaksearch() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "start", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchStops() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "stop", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchforceQuit() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "quit", (Object)false, (Object)false));
        }
    }

    public void createTempOptionFile() {
        try {
            FableJep fableJep = new FableJep();
            FableJep.jepImportSpecificDefinition((Jep)fableJep.getJep(), (String)"ImageD11", (String)"xml_pks");
            fableJep.eval("");
        }
        catch (JepException jepException) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error creating temporary option file for PeakSearch", (Throwable)jepException);
        }
    }

    public ArrayList<IPropertyChangeListener> getPropertyChangeListeners() {
        return this.listeners;
    }

    class PeaksearchThread
    implements Runnable {
        private Sample sample = null;
        private FableJep peaksearchJep = null;
        private StdoutRead stdout;
        private boolean stop = false;
        private String killFile;
        protected String currentStem;

        public PeaksearchThread(Sample sample) {
            this.sample = sample;
        }

        public PeaksearchThread() {
        }

        private boolean init() {
            boolean bl = true;
            try {
                this.peaksearchJep = new FableJep();
                try {
                    File file = File.createTempFile("peaksearcher", ".stdout");
                    file.deleteOnExit();
                    logger.debug((Object)("tempFile = " + file.getAbsolutePath()));
                    this.peaksearchJep.redirectStdout(file.getAbsolutePath());
                    this.stdout = new StdoutRead(file.getAbsolutePath());
                    this.stdout.start();
                    String string = file.getPath();
                    int n = string.lastIndexOf(file.getName());
                    if (n > 0 && n < string.length()) {
                        string = string.substring(0, n);
                    }
                    this.killFile = String.valueOf(string) + "killPeakSearch." + new Date().getTime();
                    Peaksearch.this.listKillFile.add(this.killFile);
                }
                catch (IOException iOException) {
                    FableUtils.excNoTraceMsg((Object)this, (String)("Error getting getting PeakSearch output for sample " + this.sample.getDirectoryName()), (Throwable)iOException);
                    FableMessageConsole.console.displayIn("Error getting getting PeakSearch output for sample " + this.sample.getDirectoryName());
                    bl = false;
                }
            }
            catch (JepException jepException) {
                FableUtils.excNoTraceMsg((Object)this, (String)("Error running PeakSearch for sample " + this.sample.getDirectoryName()), (Throwable)jepException);
                FableMessageConsole.console.displayIn("Error running PeakSearch for sample " + this.sample.getDirectoryName());
            }
            return bl;
        }

        public void _run() {
            if (this.stop) {
                this.stdout.stopped = true;
                return;
            }
            if (!this.init()) {
                this.stop = true;
                this.stdout.stopped = true;
                return;
            }
            try {
                this.getDefaultPythonOptions();
            }
            catch (JepException jepException) {
                this.catchJepException(jepException);
            }
            try {
                String string = null;
                if (this.sample != null) {
                    string = this.sample.getDirectoryPath().replaceAll("\\\\", "/");
                } else {
                    boolean bl = true;
                    if (bl) {
                        this.stop = true;
                        this.stdout.stopped = true;
                        FableUtils.errMsg((Object)this, (String)"No sample files loaded.  Open a directory containing the images.");
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError("No sample files loaded.  Open a directory containing the images.");
                            }
                        });
                        return;
                    }
                    if (Peaksearch.this.options != null) {
                        for (Xmloption xmloption : Peaksearch.this.options) {
                            if (!xmloption.getOption().equals("outfile")) continue;
                            string = xmloption.getValue().replaceAll("\\\\", "/");
                            break;
                        }
                        if (string == null) {
                            this.stop = true;
                            this.stdout.stopped = true;
                            FableUtils.errMsg((Object)this, (String)"Cannot determine directory for images");
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FableMessageConsole.console.displayError("Cannot determine directory for images");
                                }
                            });
                            return;
                        }
                    }
                }
                final String string2 = string;
                if (this.peaksearchJep != null) {
                    FableJep.jepImportModules((Jep)this.peaksearchJep.getJep(), (String)"os");
                    this.peaksearchJep.eval("os.chdir(\"" + string + "\")");
                    try {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayOut("Peak searching on " + string2);
                            }
                        });
                        this.transferOptionsJavaToPython(this.sample);
                        this.stdout.stopped = true;
                        this.stop = true;
                    }
                    catch (PeaksearchException peaksearchException) {
                        this.stdout.stopped = true;
                        this.stop = true;
                        FableUtils.excNoTraceMsg((Object)this, (String)"Error launching Peaksearcher.py", (Throwable)peaksearchException);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError("Error launching Peaksearcher.py");
                            }
                        });
                    }
                }
            }
            catch (JepException jepException) {
                this.catchJepException(jepException);
            }
            this.stop = true;
        }

        @Override
        public void run() {
            if (this.stop) {
                this.stdout.stopped = true;
                return;
            }
            if (!this.init()) {
                this.stop = true;
                this.stdout.stopped = true;
                return;
            }
            try {
                this.getDefaultPythonOptions();
            }
            catch (JepException jepException) {
                this.catchJepException(jepException);
            }
            try {
                String string = null;
                if (this.sample != null) {
                    final String string2 = string = this.sample.getDirectoryPath().replaceAll("\\\\", "/");
                    if (this.peaksearchJep != null) {
                        FableJep.jepImportModules((Jep)this.peaksearchJep.getJep(), (String)"os");
                        this.peaksearchJep.eval("os.chdir(\"" + string + "\")");
                        try {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FableMessageConsole.console.displayOut("Peak searching on " + string2);
                                }
                            });
                            this.transferOptionsJavaToPython(this.sample);
                            this.stdout.stopped = true;
                            this.stop = true;
                        }
                        catch (PeaksearchException peaksearchException) {
                            this.stdout.stopped = true;
                            this.stop = true;
                            FableUtils.excNoTraceMsg((Object)this, (String)"Error launching Peaksearcher.py", (Throwable)peaksearchException);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FableMessageConsole.console.displayError("Error launching Peaksearcher.py");
                                }
                            });
                        }
                    }
                } else {
                    try {
                        this.transferOptionsJavaToPython();
                    }
                    catch (PeaksearchException peaksearchException) {
                        this.stdout.stopped = true;
                        this.stop = true;
                        final String string3 = "Program failed " + peaksearchException.getMessage();
                        FableUtils.errMsg((Object)this, (String)string3);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError(string3);
                            }
                        });
                    }
                }
            }
            catch (JepException jepException) {
                this.catchJepException(jepException);
            }
            this.stop = true;
        }

        private void catchJepException(JepException jepException) {
            this.stdout.stopped = true;
            this.stop = true;
            Peaksearch.this.firePeakSearchStops();
            FableUtils.excNoTraceMsg((Object)this, (String)"Jep Exception in PeakSearch", (Throwable)jepException);
            if (Peaksearch.this.peaksearchProgressMonitor != null) {
                Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
            }
        }

        private void getDefaultPythonOptions() throws JepException {
            try {
                FableJep.jepImportSpecificDefinition((Jep)this.peaksearchJep.getJep(), (String)"ImageD11", (String)"peaksearcher");
                this.peaksearchJep.eval("class o:\n    def add_option(self, *a, **k):\n        setattr(self, k[\"dest\"], k[\"default\"])\n");
                this.peaksearchJep.eval("option_holder = o()");
                this.peaksearchJep.eval("peaksearcher.get_options( option_holder )");
                this.peaksearchJep.flushStdout();
            }
            catch (JepException jepException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error getting Python options", (Throwable)jepException);
            }
        }

        public void notifyEndToPeaksearch() {
            logger.debug((Object)("killFile = " + this.killFile));
            new File(this.killFile);
            this.stop = true;
        }

        private void transferOptionsJavaToPython(final Sample sample) throws PeaksearchException {
            String string = null;
            int n = 0;
            while (n < Peaksearch.this.options.size() && !this.stop) {
                Xmloption xmloption = (Xmloption)Peaksearch.this.options.elementAt(n);
                if (xmloption.getOption().equals("stem")) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            logger.info((Object)("we are peaksearching for these files stem = " + sample.getStem()));
                            PeaksearchThread.this.currentStem = sample.getStem();
                        }
                    });
                    xmloption.setValue(this.currentStem);
                } else if (xmloption.getOption().equals("first")) {
                    xmloption.setValue(String.valueOf(sample.getFirst()));
                } else if (xmloption.getOption().equals("format")) {
                    xmloption.setValue(String.valueOf(sample.getFileFormat()));
                } else if (xmloption.getOption().equals("last")) {
                    xmloption.setValue(String.valueOf(sample.getLast()));
                } else if (xmloption.getOption().equals("outfile")) {
                    string = sample.getPeaksearchoutStem();
                    if (string != null) {
                        xmloption.setValue(String.valueOf(string) + ".spt");
                    }
                    string = xmloption.getValue();
                } else if (xmloption.getOption().equals("ndigits")) {
                    xmloption.setValue(String.valueOf(sample.getNDigits()));
                }
                this.optionHolder(xmloption);
                ++n;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    this.optionDriver();
                }
                catch (JepException jepException) {
                    FableUtils.excNoTraceMsg((Object)this, (String)("Error setting kill file for PeakSearch for stem " + sample.getDirectoryName()), (Throwable)jepException);
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error setting kill file for PeakSearch for stem " + sample.getDirectoryName() + ".");
                    }
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", jepException.getMessage());
                }
            } else if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Search stopped by user.");
            }
        }

        private void transferOptionsJavaToPython() throws PeaksearchException {
            int n = 0;
            while (n < Peaksearch.this.options.size() && !this.stop) {
                Xmloption xmloption = (Xmloption)Peaksearch.this.options.elementAt(n);
                this.optionHolder(xmloption);
                ++n;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    this.optionDriver();
                }
                catch (JepException jepException) {
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", jepException.getMessage());
                }
            } else if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Search stopped by user.");
            }
        }

        private void setKillFile() {
            if (this.killFile != null && !Peaksearch.this.forceQuit) {
                try {
                    this.peaksearchJep.set("killfile", this.killFile);
                    this.peaksearchJep.eval("option_holder.killfile=killfile");
                }
                catch (JepException jepException) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Error setting kill file name for PeakSearch", (Throwable)jepException);
                }
            }
        }

        private void optionDriver() throws JepException {
            this.peaksearchJep.eval("peaksearcher.peaksearch_driver( option_holder , () )");
            this.peaksearchJep.flushStdout();
        }

        private void optionHolder(Xmloption xmloption) throws PeaksearchException {
            logger.info((Object)(String.valueOf(xmloption.getDest()) + " " + xmloption.getOption() + " get value: " + xmloption.getValue() + " and type " + xmloption.getType()));
            if (xmloption.getValue() != null && !xmloption.getValue().equals("")) {
                try {
                    this.peaksearchJep.eval("option_holder." + xmloption.toString());
                    logger.info((Object)("option_holder." + xmloption.toString()));
                }
                catch (JepException jepException) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Error running kill file for PeakSearch", (Throwable)jepException);
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", jepException.getMessage());
                }
            }
            try {
                this.peaksearchJep.flushStdout();
            }
            catch (JepException jepException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error flushing stdout for PeakSearch", (Throwable)jepException);
            }
            FableMessageConsole.console.displayOut("opt:" + xmloption.getOption() + "=" + xmloption.getValue());
        }
    }
}

