/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class PeakSelectionProvider
implements ISelectionProvider {
    private ArrayList<ISelectionChangedListener> selectionListeners = new ArrayList();
    private ISelectionProvider delegate;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (selectionChangedEvent.getSelectionProvider() == PeakSelectionProvider.this.delegate) {
                PeakSelectionProvider.this.fireSelectionChanged(selectionChangedEvent.getSelection());
            }
        }
    };

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionListeners.add(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? null : this.delegate.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionListeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        if (this.delegate != null) {
            this.delegate.setSelection(iSelection);
        }
    }

    public void setSelectionProviderDelegate(ISelectionProvider iSelectionProvider) {
        if (this.delegate == iSelectionProvider) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
        }
        this.delegate = iSelectionProvider;
        if (iSelectionProvider != null) {
            iSelectionProvider.addSelectionChangedListener(this.selectionListener);
            this.fireSelectionChanged(iSelectionProvider.getSelection());
        }
    }

    protected void fireSelectionChanged(ISelection iSelection) {
        this.fireSelectionChanged(this.selectionListeners, iSelection);
    }

    private void fireSelectionChanged(ArrayList<ISelectionChangedListener> arrayList, ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this.delegate, iSelection);
        Object[] objectArray = arrayList.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }
}

