/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.writer.Xmlwriter;
import fable.framework.writer.XmlwriterException;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;
import fable.framework.xmlparser.views.Options;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OptionsImpl
implements IPropertyChangeListener {
    private Peaksearch peaksearch;
    private Options optionPeaksearch;
    Logger logger = Logger.getLogger(OptionsImpl.class);

    public OptionsImpl() {
        try {
            this.peaksearch = Peaksearch.getPeaksearch();
            this.peaksearch.addPropertyChangeListener(this);
        }
        catch (PeaksearchException peaksearchException) {
            this.logger.error((Object)peaksearchException.getMessage());
        }
        catch (JepException jepException) {
            this.logger.error((Object)jepException.getMessage());
        }
    }

    public void create(Composite composite) throws XmlParserException {
        if (this.peaksearch != null) {
            this.optionPeaksearch = new Options(composite, this.peaksearch.getOptions());
        }
    }

    public boolean launch() {
        boolean bl = false;
        if (this.validateView()) {
            this.logger.info((Object)"Options for peaksearch are valid");
            this.setOptions();
            bl = true;
        } else {
            this.optionPeaksearch.fireOptionsAreNotValides();
            this.peaksearch.firePeakSearchStops();
            this.optionPeaksearch.stop();
            this.logger.warn((Object)"Options for peaksearch are not valid");
        }
        return bl;
    }

    public void setOptions() {
        this.optionPeaksearch.setOptions();
    }

    public boolean validateView() {
        return this.optionPeaksearch.validateView();
    }

    public void addListener(IPropertyChangeListener iPropertyChangeListener) {
        this.optionPeaksearch.addListener(iPropertyChangeListener);
    }

    public void removeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.optionPeaksearch.removeListener(iPropertyChangeListener);
    }

    public boolean updateFields(String string, String string2) {
        return this.optionPeaksearch.updateFields(string, string2);
    }

    public void setCurrentPath(String string) {
        this.optionPeaksearch.setCurrentPath(string);
    }

    public boolean updateFields(Control[] controlArray, String string, String string2) {
        return this.optionPeaksearch.updateFields(controlArray, string, string2);
    }

    public boolean loadOptions(Control[] controlArray, Xmloption xmloption) {
        return this.optionPeaksearch.loadOptions(controlArray, xmloption);
    }

    public boolean loadOptions(Xmloption xmloption) {
        return this.optionPeaksearch.loadOptions(xmloption);
    }

    public String getdefaultValue(String string) {
        return this.optionPeaksearch.getdefaultValue(string);
    }

    public void resetFields() {
        this.optionPeaksearch.resetFields();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("save_ini")) {
            try {
                this.optionPeaksearch.storeDefaultOptions();
                new Xmlwriter("root", "option", (String)propertyChangeEvent.getNewValue(), this.peaksearch.getOptions());
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Peaksearch ini file", (String)"Load fields value in default tag");
            }
            catch (XmlwriterException xmlwriterException) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)xmlwriterException.getMessage());
            }
        } else if (propertyChangeEvent.getProperty().equals("stop")) {
            this.optionPeaksearch.stop();
        } else if (propertyChangeEvent.getProperty().equals("run")) {
            this.optionPeaksearch.run();
        }
    }

    public void stop() {
        this.optionPeaksearch.stop();
    }
}

