/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import jep.JepException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class LoadXmlOption
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.peaksearch.actions.LoadXmlOption";
    String[] filterName = new String[]{".xml", "All(*.*)"};
    String[] filterExt = new String[]{"*.xml", "*.*;*"};
    Shell shell;

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.shell = iWorkbenchWindow.getShell();
        this.loadDeafultOption();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void run() {
        this.shell = Display.getDefault().getActiveShell();
        this.loadDeafultOption();
    }

    private void loadDeafultOption() {
        FileDialog fileDialog = new FileDialog(this.shell, 64);
        fileDialog.setFilterNames(this.filterName);
        fileDialog.setFilterExtensions(this.filterExt);
        try {
            String string;
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                if (ToolBox.isSmallPerspectiveSet()) {
                    iWorkbenchWindow.getWorkbench().showPerspective("fable.peaksearch.perspective.smallScreen", iWorkbenchWindow);
                } else {
                    iWorkbenchWindow.getWorkbench().showPerspective("fable.peaksearch.perspective", iWorkbenchWindow);
                }
            }
            if ((string = fileDialog.open()) != null) {
                Peaksearch.getPeaksearch(string).loadIniFile(string);
                MessageDialog.openInformation((Shell)this.shell, (String)"PeakSearch ini file", (String)("PeakSearch options loaded from:\n" + string));
            }
        }
        catch (PeaksearchException peaksearchException) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)peaksearchException);
        }
        catch (JepException jepException) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)jepException);
        }
        catch (WorkbenchException workbenchException) {
            FableUtils.excTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)workbenchException);
        }
    }

    public static String getID() {
        return ID;
    }
}

