/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.rcp.texteditor.editors.xml;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.examples.rcp.texteditor.editors.xml.ColorManager;
import org.eclipse.ui.examples.rcp.texteditor.editors.xml.IXMLColorConstants;
import org.eclipse.ui.examples.rcp.texteditor.editors.xml.NonRuleBasedDamagerRepairer;
import org.eclipse.ui.examples.rcp.texteditor.editors.xml.XMLDoubleClickStrategy;
import org.eclipse.ui.examples.rcp.texteditor.editors.xml.XMLScanner;
import org.eclipse.ui.examples.rcp.texteditor.editors.xml.XMLTagScanner;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private ColorManager colorManager;

    public XMLConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__xml_tag");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__xml_tag");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer nonRuleBasedDamagerRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IXMLColorConstants.XML_COMMENT)));
        presentationReconciler.setDamager((IPresentationDamager)nonRuleBasedDamagerRepairer, "__xml_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)nonRuleBasedDamagerRepairer, "__xml_comment");
        return presentationReconciler;
    }
}

