/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.rcp.texteditor.editors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class SimpleDocumentProvider
extends AbstractDocumentProvider {
    protected IDocument createDocument(Object object) throws CoreException {
        if (object instanceof IEditorInput) {
            Document document = new Document();
            if (this.setDocumentContent((IDocument)document, (IEditorInput)object)) {
                this.setupDocument((IDocument)document);
            }
            return document;
        }
        return null;
    }

    private boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        FileReader fileReader;
        block5: {
            try {
                if (iEditorInput instanceof IPathEditorInput) {
                    fileReader = new FileReader(((IPathEditorInput)iEditorInput).getPath().toFile());
                    break block5;
                }
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return true;
            }
        }
        try {
            this.setDocumentContent(iDocument, fileReader);
            return true;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error reading file", (Throwable)iOException));
        }
    }

    private void setDocumentContent(IDocument iDocument, Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            StringBuffer stringBuffer = new StringBuffer(512);
            char[] cArray = new char[512];
            int n = bufferedReader.read(cArray);
            while (n > 0) {
                stringBuffer.append(cArray, 0, n);
                n = bufferedReader.read(cArray);
            }
            iDocument.set(stringBuffer.toString());
        }
        finally {
            ((Reader)bufferedReader).close();
        }
    }

    protected void setupDocument(IDocument iDocument) {
    }

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)object;
            IPath iPath = iPathEditorInput.getPath();
            File file = iPath.toFile();
            try {
                file.createNewFile();
                if (file.exists()) {
                    if (!file.canWrite()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "file is read-only", null));
                    }
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error creating file", null));
                }
                FileWriter fileWriter = new FileWriter(file);
                this.writeDocumentContent(iDocument, fileWriter, iProgressMonitor);
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error when saving file", (Throwable)iOException));
            }
        }
    }

    private void writeDocumentContent(IDocument iDocument, Writer writer, IProgressMonitor iProgressMonitor) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        try {
            bufferedWriter.write(iDocument.get());
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        return null;
    }

    public boolean isModifiable(Object object) {
        if (object instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)object;
            File file = iPathEditorInput.getPath().toFile();
            return file.canWrite() || !file.exists();
        }
        return false;
    }

    public boolean isReadOnly(Object object) {
        return !this.isModifiable(object);
    }

    public boolean isStateValidated(Object object) {
        return true;
    }
}

