/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.rcp.texteditor.actions;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.examples.rcp.texteditor.editors.PathEditorInput;

public class OpenFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public OpenFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private File queryFile() {
        FileDialog fileDialog = new FileDialog(this.fWindow.getShell(), 4096);
        fileDialog.setText("Open File");
        String string = fileDialog.open();
        if (string != null && string.length() > 0) {
            return new File(string);
        }
        return null;
    }

    public void run() {
        File file = this.queryFile();
        if (file != null) {
            IEditorInput iEditorInput = this.createEditorInput(file);
            String string = this.getEditorId(file);
            IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
            try {
                iWorkbenchPage.openEditor(iEditorInput, string);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        } else if (file != null) {
            String string = MessageFormat.format("File is null: {0}", file.getName());
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)"Problem", (String)string);
        }
    }

    private String getEditorId(File file) {
        IWorkbench iWorkbench = this.fWindow.getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(file.getName());
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return "org.eclipse.ui.examples.rcp.texteditor.editors.SimpleEditor";
    }

    private IEditorInput createEditorInput(File file) {
        Path path = new Path(file.getAbsolutePath());
        PathEditorInput pathEditorInput = new PathEditorInput((IPath)path);
        return pathEditorInput;
    }
}

