/*
 * Decompiled with CFR 0.152.
 */
package fable.python.views;

import fable.framework.logging.FableLogger;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class PythonPlotView
extends ViewPart {
    public static final String ID = "fable.python.views.PythonPlotView";
    private Vector<JLDataView> dataViewSeries = new Vector();
    private JLChart chart;
    Button y1Button;
    Button y2Button;
    int[] dataMarkers = new int[]{2, 9, 8, 4, 1, 5};
    static int iDataMarker = 0;
    Color[] dataColors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.YELLOW};
    static int iDataColor = 0;
    public static PythonPlotView view;
    private String title = "Python Plot";
    private Composite swtAwtComponent;
    Frame chartFrame;
    Logger logger = FableLogger.getLogger(PythonPlotView.class);
    private JApplet chartContainer;
    private JLDataView dataView = null;

    public void createPartControl(Composite composite) {
        view = this;
        composite.setLayout((Layout)new GridLayout());
        this.createChartFrame(composite);
        this.createChart();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.y1Button = new Button(composite2, 16);
        this.y1Button.setText("add to Y1");
        this.y1Button.setToolTipText("add next plot to Y1 axis");
        this.y1Button.setSelection(true);
        this.y2Button = new Button(composite2, 16);
        this.y2Button.setText("add to Y2");
        this.y2Button.setToolTipText("add next plot to Y2 axis");
        this.y2Button.setSelection(false);
        Button button = new Button(composite2, 8);
        button.setText("clear plot");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                PythonPlotView.this.clearAllPlots();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                PythonPlotView.this.clearAllPlots();
            }
        });
        this.setPartName("Python Plot");
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite composite) {
        this.swtAwtComponent = new Composite(composite, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader(this.title);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("value");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY2Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("index");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chartContainer.add((Component)this.chart);
    }

    public void plotArray(String string, float[] fArray) {
        if (this.dataView == null) {
            this.dataView = new JLDataView();
            this.dataView.setName(string);
            this.dataView.setMarker(this.dataMarkers[iDataMarker]);
            this.dataView.setMarkerColor(this.dataColors[iDataColor]);
            this.dataView.setColor(this.dataColors[iDataColor]);
            if (this.y1Button.getSelection()) {
                this.chart.getY1Axis().addDataView(this.dataView);
            } else {
                this.chart.getY2Axis().addDataView(this.dataView);
            }
        }
        double[] dArray = new double[fArray.length];
        double[] dArray2 = new double[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            dArray[n] = n + 1;
            dArray2[n] = fArray[n];
            ++n;
        }
        this.dataView.setData(dArray, dArray2);
        this.chart.repaint();
        if (++iDataMarker >= this.dataMarkers.length) {
            iDataMarker = 0;
        }
        if (++iDataColor >= this.dataColors.length) {
            iDataColor = 0;
        }
        this.dataViewSeries.add(this.dataView);
        this.dataView = null;
    }

    public void clearAllPlots() {
        int n = 0;
        while (n < this.dataViewSeries.size()) {
            this.chart.removeDataView(this.dataViewSeries.get(n));
            ++n;
        }
        Dimension dimension = this.chartContainer.getSize();
        this.chart.setSize(dimension);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PythonPlotView.this.chartContainer.repaint();
            }
        });
        this.dataViewSeries.clear();
    }
}

