/*
 * Decompiled with CFR 0.152.
 */
package fable.python.views;

import fable.framework.views.FableIOConsole;
import fable.python.jep.FableJep;
import fable.python.views.PythonPlotView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import jep.Jep;
import jep.JepException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class PythonConsole {
    static FableIOConsole pythonConsole;
    RunConsoleThread runConsoleThread = new RunConsoleThread();
    Jep jep = null;
    boolean consoleError = false;

    public PythonConsole() {
        pythonConsole = new FableIOConsole("Python Console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{pythonConsole});
    }

    public void run() {
        new Thread(this.runConsoleThread).start();
    }

    void evaluateCommand(String string) {
        if (this.jep == null) {
            pythonConsole.displayOut("There is no Jep Python object, please fix the problem and then try again !");
        } else {
            String string2;
            boolean bl = false;
            if (string.length() > 7 && string.substring(0, 7).equalsIgnoreCase("plot.1d")) {
                string2 = string.substring(string.indexOf(40) + 1, string.indexOf(41));
                this.plotArray(string2);
                bl = true;
            }
            if (!bl) {
                try {
                    this.jep.eval("mystdout.clear()");
                    this.jep.eval(string);
                    this.jep.eval("res=mystdout.stdouttext");
                    this.jep.eval(null);
                    string2 = (String)this.jep.getValue("res");
                    pythonConsole.displayOut(string2);
                }
                catch (JepException jepException) {
                    pythonConsole.displayError(String.valueOf(jepException.getMessage().substring(jepException.getMessage().indexOf(62) + 3)) + "\n");
                }
            }
        }
    }

    private void plotArray(String string) {
        final String string2 = string;
        try {
            this.jep.eval("res = " + string2 + ".astype(numpy.float32).tostring()");
            final float[] fArray = this.jep.getValue_floatarray("res");
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PythonPlotView pythonPlotView = (PythonPlotView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.python.views.PythonPlotView", "0", 1);
                            if (pythonPlotView != null) {
                                pythonPlotView.plotArray(string2, fArray);
                            }
                        }
                        catch (PartInitException partInitException) {
                            partInitException.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (JepException jepException) {
            pythonConsole.displayError(String.valueOf(jepException.getMessage().substring(jepException.getMessage().indexOf(62) + 3)) + "\n");
        }
    }

    class RunConsoleThread
    implements Runnable {
        final Runtime runtime = Runtime.getRuntime();
        String outputMessage;

        RunConsoleThread() {
        }

        @Override
        public void run() {
            try {
                PythonConsole.this.jep = new FableJep().getJep();
                PythonConsole.this.jep.setInteractive(true);
                PythonConsole.this.jep.eval("import sys\n");
                PythonConsole.this.jep.eval("class mystdout:\n\tdef write(self, text):\n\t\tself.stdouttext += text\n\tdef clear(self):\n\t\tself.stdouttext = \"\"\n");
                PythonConsole.this.jep.eval("mystdout=mystdout()\n");
                PythonConsole.this.jep.eval("sys.stdout=mystdout");
                PythonConsole.this.jep.eval(null);
            }
            catch (JepException jepException) {
                jepException.printStackTrace();
            }
            pythonConsole.getInputStream();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)pythonConsole.getInputStream(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            String string = null;
            File file = null;
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader2 = null;
            boolean bl = false;
            boolean bl2 = false;
            while (!PythonConsole.this.consoleError) {
                try {
                    String string2 = "";
                    String string3 = "";
                    int n = 0;
                    bl2 = false;
                    if (!bl) {
                        pythonConsole.displayOut(">>> ");
                        string2 = bufferedReader.readLine();
                    } else {
                        string2 = bufferedReader2.readLine();
                        if (string2 == null) {
                            string2 = "";
                            bl = false;
                        }
                        pythonConsole.displayOut(String.valueOf(string) + ":>>> " + string2 + "\n");
                    }
                    if (string2 != null && string2.length() > 10 && string2.substring(0, 10).equals("script.run") && (file = new File(string = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41)))).exists()) {
                        fileInputStream = new FileInputStream(file);
                        bufferedReader2 = new BufferedReader(new InputStreamReader(fileInputStream));
                        if (fileInputStream.available() > 0) {
                            bl = true;
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    string3 = String.valueOf(string2) + "\n";
                    if (string2 != null && string2.length() > 1 && string2.charAt(string2.length() - 1) == ':') {
                        ++n;
                    }
                    while (n != 0) {
                        int n2 = 0;
                        if (!bl) {
                            pythonConsole.displayOut("... ");
                            string2 = bufferedReader.readLine();
                        } else {
                            string2 = bufferedReader2.readLine();
                            if (string2 == null) {
                                string2 = "";
                                bl = false;
                            }
                            pythonConsole.displayOut(String.valueOf(string) + ":... " + string2 + "\n");
                        }
                        string3 = String.valueOf(string3) + string2 + "\n";
                        int n3 = 0;
                        while (n3 < string2.length()) {
                            if (string2.charAt(n3) != ' ') break;
                            ++n2;
                            ++n3;
                        }
                        n = n2 / 4;
                    }
                    PythonConsole.this.evaluateCommand(string3);
                }
                catch (IOException iOException) {
                    PythonConsole.this.consoleError = true;
                }
            }
        }
    }
}

