/*
 * Decompiled with CFR 0.152.
 */
package fable.python.jep.test;

import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import jep.Jep;
import jep.JepException;
import org.junit.Assert;
import org.junit.Test;

public class FableJepTest {
    @Test
    public final void testGetJep() {
        Jep jep = null;
        try {
            jep = new FableJep().getJep();
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
        if (jep == null) {
            Assert.fail((String)"could not get Jep object");
        }
    }

    @Test
    public final void testJepEval() {
        Jep jep = null;
        try {
            jep = new FableJep().getJep();
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
        if (jep == null) {
            Assert.fail((String)"could not get Jep object");
        }
        try {
            jep.eval("print 'hello world'");
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
    }

    @Test
    public final void testRedirectStdout() {
        System.out.println("testRedirectStdout(): test redirection of stdout ...");
        FableJep fableJep = null;
        try {
            fableJep = new FableJep();
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
        if (fableJep == null) {
            Assert.fail((String)"could not get Jep object");
        }
        try {
            fableJep.redirectStdout("/tmp/stdout.test");
            long l = System.currentTimeMillis();
            fableJep.eval("print 'hello world 1';print 'hello world 2'");
            StdoutRead stdoutRead = new StdoutRead("/tmp/stdout.test");
            stdoutRead.setOutputToSystemOut(true);
            stdoutRead.setOutputToFableConsole(false);
            stdoutRead.start();
            fableJep.eval("sys.stdout.flush()");
            fableJep.eval("import sys");
            fableJep.eval("import time");
            fableJep.eval("time.sleep(10)");
            System.out.println("print was received " + (stdoutRead.lasttime - l) + " millisecond(s) later");
            if (Math.abs(stdoutRead.lasttime - l) > 1000L) {
                Assert.fail((String)("print was received at least " + (l - stdoutRead.lasttime) / 1000L + " seconds late !"));
            }
            stdoutRead.lasttime = 0L;
            fableJep.eval("print 'goodbye world 1';print 'goodbye world 2'");
            l = System.currentTimeMillis();
            fableJep.eval("sys.stdout.flush()");
            fableJep.eval("time.sleep(10)");
            System.out.println("print was received " + (l - stdoutRead.lasttime) / 1000L + " seconds later");
            if (Math.abs(stdoutRead.lasttime - l) > 1000L) {
                Assert.fail((String)("print was received at least " + (stdoutRead.lasttime - l) + " millisecond(s) late !"));
            }
            stdoutRead.stopped = true;
            stdoutRead.join();
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Test
    public final void testSysArgv() {
        System.out.println("testSysArgv(): test sys.argv is set to jep ...");
        FableJep fableJep = null;
        try {
            fableJep = new FableJep();
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
        if (fableJep == null) {
            Assert.fail((String)"could not get Jep object");
        }
        try {
            fableJep.eval("print sys.argv");
            String string = fableJep.getStringValue("sys.argv[0]");
            System.out.println("sys.argv[0] = " + string);
            if (!string.equalsIgnoreCase("jep")) {
                Assert.fail((String)"sys.argv[0] != jep");
            }
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
    }
}

