/*
 * Decompiled with CFR 0.152.
 */
package fable.python.jep;

import fable.framework.views.FableMessageConsole;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.swt.widgets.Display;

public class StdoutRead
extends Thread {
    String outputMessage;
    BufferedReader outputread;
    public boolean stopped = false;
    private boolean outputSystemOut = false;
    private boolean outputFableConsole = true;
    public long lasttime;
    private String file = "";

    public StdoutRead(String string) {
        try {
            this.lasttime = 0L;
            this.file = string;
            this.outputread = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("failed to open file " + this.file + " because " + fileNotFoundException.getMessage());
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                this.outputMessage = this.outputread.readLine();
                while (this.outputMessage == null && !this.stopped) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    this.outputMessage = this.outputread.readLine();
                }
                if (this.outputMessage == null) continue;
                this.lasttime = System.currentTimeMillis();
                if (this.outputSystemOut) {
                    System.out.println(this.outputMessage);
                }
                if (!this.outputFableConsole || Display.getDefault().isDisposed()) continue;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayOut(StdoutRead.this.outputMessage);
                        } else {
                            System.out.println(StdoutRead.this.outputMessage);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayIn(this.outputMessage);
                    FableMessageConsole.console.displayIn(iOException.getMessage());
                    continue;
                }
                System.out.println(this.outputMessage);
                System.out.println(iOException.getMessage());
            }
        }
    }

    public void setOutputToSystemOut(boolean bl) {
        this.outputSystemOut = bl;
    }

    public void setOutputToFableConsole(boolean bl) {
        this.outputFableConsole = bl;
    }
}

