/*
 * Decompiled with CFR 0.152.
 */
package fable.python.jep;

import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import fable.python.jep.PythonInfo;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FableJep {
    private static String pythonPath = "";
    private Jep jep;
    private static FableJep fablejep;
    private static String jepError;
    private static long jepLastError;
    private FableMessageConsole fableConsole;
    Logger logger;
    private static String filename;
    private static boolean bRecord;

    static {
        jepLastError = 0L;
        filename = "";
        bRecord = false;
    }

    public Jep getJep() {
        return this.jep;
    }

    public static FableJep getFableJep() throws JepException {
        if (fablejep == null) {
            fablejep = new FableJep();
        }
        return fablejep;
    }

    public FableJep() throws JepException {
        block7: {
            this.jep = null;
            this.fableConsole = null;
            try {
                this.jep = new Jep();
                FableJep.jepImportModules(this.jep, "sys");
                this.jep.eval("if not hasattr(sys,'argv'):\n\tsys.argv = ['fable']");
                FableJep.jepSetPythonPath(this.jep);
                this.logger = Logger.getLogger(FableJep.class);
                this.logger.setLevel(Level.ERROR);
            }
            catch (JepException jepException) {
                throw jepException;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (System.currentTimeMillis() - jepLastError <= 5000L) break block7;
                jepLastError = System.currentTimeMillis();
                String string = System.getProperty("os.name");
                if (string.toLowerCase().contains("windows")) {
                    jepError = "Failed to create the Java embedded Python interpreter (jep).";
                    jepError = String.valueOf(jepError) + "The error was :\n\n";
                    jepError = String.valueOf(jepError) + unsatisfiedLinkError.getMessage() + "\n\n";
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed. ";
                    jepError = String.valueOf(jepError) + "You can (partially) test your environment by typing python";
                } else if (string.toLowerCase().contains("mac")) {
                    jepError = "Failed to create the Java embedded Python interpreter (jep).";
                    jepError = String.valueOf(jepError) + "The error was :\n\n";
                    jepError = String.valueOf(jepError) + unsatisfiedLinkError.getMessage() + "\n\n";
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and and that you have a ";
                    jepError = String.valueOf(jepError) + "symbolic link from $IMAGEVIEWER_HOME/plugins/jep_2.0.1/lib.macosx ";
                    jepError = String.valueOf(jepError) + "to /Library/Java/Extensions e.g.\n\n";
                    jepError = String.valueOf(jepError) + "sudo ln -s $IMAGEVIEWER_HOME/plugins/jep_2.0.1/lib/macosx/libjep.dylib   /Library/Java/Extensions/libjep.jnilib";
                } else {
                    jepError = "Failed to create the Java embedded Python interpreter (jep). ";
                    jepError = String.valueOf(jepError) + "The error was :\n\n";
                    jepError = String.valueOf(jepError) + unsatisfiedLinkError.getMessage() + "\n\n";
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and that the environment ";
                    jepError = String.valueOf(jepError) + "variable LD_PRELOAD is pointing to your Python shared object interpreter ";
                    jepError = String.valueOf(jepError) + "e.g. LD_PRELOAD=/usr/lib/libpython2.5.so.1.0. ";
                    jepError = String.valueOf(jepError) + "Your current LD_PRELOAD is :\n\n" + System.getenv("LD_PRELOAD") + "\n\n";
                    jepError = String.valueOf(jepError) + "You can (partially) test your environment by typing python ";
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)jepError);
                    }
                });
                jepLastError = System.currentTimeMillis();
            }
        }
    }

    public static void jepSetPythonPath(Jep jep) throws JepException {
        String string = System.getProperty("path.separator", "|");
        String string2 = pythonPath.replace("\\", "\\\\");
        String[] stringArray = string2.split(string);
        int n = stringArray.length - 1;
        while (n >= 0) {
            String string3 = "sys.path.insert(0, '" + stringArray[n] + "')";
            jep.eval(string3);
            --n;
        }
    }

    public static void jepImportModules(Jep jep, String string) throws JepException {
        try {
            jep.eval("import " + string);
            FableJep.writeScript("import " + string);
        }
        catch (JepException jepException) {
            if (System.currentTimeMillis() - jepLastError > 5000L) {
                jepLastError = System.currentTimeMillis();
                String string2 = System.getProperty("os.name");
                jepError = "Failed to import the modules " + string + " into " + "the Java embedded Python interpreter (jep). ";
                jepError = String.valueOf(jepError) + "The error was :\n\n";
                jepError = String.valueOf(jepError) + jepException.getMessage() + "\n\n";
                if (string2.toLowerCase().contains("windows")) {
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and jep.dll is in your PATH ";
                } else {
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and that the environment ";
                    jepError = String.valueOf(jepError) + "variable LD_PRELOAD is pointing to your Python shared object interpreter ";
                    jepError = String.valueOf(jepError) + "e.g. LD_PRELOAD=/usr/lib/libpython2.5.so.1.0. ";
                    jepError = String.valueOf(jepError) + "Your current LD_PRELOAD is :\n\n" + System.getenv("LD_PRELOAD") + "\n\n";
                }
                jepError = String.valueOf(jepError) + "and that the Python modules " + string + " are installed and in your PYTHONPATH. ";
                jepError = String.valueOf(jepError) + "Your current PYTHONPATH is :\n\n" + PythonInfo.getPythonPathFromEnvironment("  ") + "\n";
                jepError = String.valueOf(jepError) + "You can test your environment by starting python and then typing :\n\nimport " + string;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)jepError);
                        jepLastError = System.currentTimeMillis();
                    }
                });
            }
            throw jepException;
        }
    }

    public static void jepImportSpecificDefinition(Jep jep, String string, String string2) throws JepException {
        try {
            jep.eval("from " + string + " import " + string2);
            FableJep.writeScript("from " + string + " import " + string2);
        }
        catch (JepException jepException) {
            if (System.currentTimeMillis() - jepLastError > 5000L) {
                jepLastError = System.currentTimeMillis();
                jepError = "Failed to import the modules " + string + " into the" + " Java embedded Python interpreter (jep).";
                jepError = String.valueOf(jepError) + "The error was :\n\n";
                jepError = String.valueOf(jepError) + jepException.getMessage() + "\n\n";
                jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and jep.dll is in your PATH and that the Python modules " + string + " are installed and in your PYTHONPATH. ";
                jepError = String.valueOf(jepError) + "Your current PYTHONPATH is :\n\n" + PythonInfo.getPythonPathFromEnvironment("  ") + "\n";
                jepError = String.valueOf(jepError) + "You can test your environment by starting python and then typing :\n\nimport " + string;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)jepError);
                        jepLastError = System.currentTimeMillis();
                    }
                });
                jepLastError = System.currentTimeMillis();
            }
            throw jepException;
        }
    }

    public boolean eval(String string) throws JepException {
        this.logger.info((Object)string);
        if (this.fableConsole != null) {
            this.fableConsole.displayIn(string);
        }
        FableJep.writeScript(string);
        boolean bl = this.jep.eval(string);
        return bl;
    }

    public void set(String string, String string2) throws JepException {
        this.logger.info((Object)(String.valueOf(string) + "= " + string2));
        FableJep.writeScript(String.valueOf(string) + "= \"" + string2 + "\"");
        this.jep.set(string, string2);
    }

    public void set(String string, double d) throws JepException {
        this.logger.info((Object)(String.valueOf(string) + "= " + d));
        FableJep.writeScript(String.valueOf(string) + "= " + d);
        this.jep.set(string, d);
    }

    public void set(String string, int n) throws JepException {
        this.logger.info((Object)(String.valueOf(string) + "= \"" + n + "\""));
        FableJep.writeScript(String.valueOf(string) + "= " + n);
        this.jep.set(string, n);
    }

    public void set(String string, float f) throws JepException {
        this.logger.info((Object)(String.valueOf(string) + "= " + f));
        FableJep.writeScript(String.valueOf(string) + "= " + f);
        this.jep.set(string, f);
    }

    public Object getValue(String string) throws JepException {
        this.logger.info((Object)string);
        Object object = null;
        try {
            object = this.jep.getValue(string);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return object;
    }

    public Integer getIntegerValue(String string) {
        Integer n = null;
        try {
            n = (Integer)this.jep.getValue("int(" + string + ")");
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return n;
    }

    public Float getFloatValue(String string) {
        Float f = null;
        try {
            f = (Float)this.jep.getValue("float(" + string + ")");
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return f;
    }

    public String getStringValue(String string) {
        String string2 = null;
        try {
            string2 = (String)this.jep.getValue(string);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return string2;
    }

    public float[] getValue_floatarray(String string) throws JepException {
        this.logger.info((Object)"getValue_floatarray");
        return this.jep.getValue_floatarray(string);
    }

    public void redirectStdout(String string) throws JepException {
        this.set("filename", string);
        this.jep.eval("logstdout=open(filename, 'w')");
        this.jep.eval("sys.stdout=logstdout");
        this.flushStdout();
    }

    public void flushStdout() throws JepException {
        this.jep.eval("sys.stdout.flush()");
    }

    public void outputConsole(FableMessageConsole fableMessageConsole) {
        this.fableConsole = fableMessageConsole;
    }

    private static void writeScript(String string) {
        if (bRecord) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filename, true));
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                FableUtils.excMsg(FableJep.class, (String)"Error writing script", (Throwable)iOException);
            }
        }
    }

    public static void record(boolean bl) {
        bRecord = bl;
    }

    public static void setScriptFileName(String string) {
        filename = string;
    }

    public void close() {
        if (this.jep != null) {
            this.jep.close();
        }
    }

    public static String getPythonPath() {
        return pythonPath;
    }

    public static void setPythonPath(String string) {
        pythonPath = string;
    }
}

