/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.Peak;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PeakSearchSpt {
    private int npks = 0;
    private String parentName = "";
    private Vector<Peak> peaks;
    private float treshold = 0.0f;
    float[] tabPeak = null;
    private List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
    private String scannedPeak = "";
    private String[] peakKeys;
    private FabioFile imageFile = null;
    private String fabioFileName = "";
    private PeakSearchSpt parent = this;
    protected boolean parsed = false;

    public PeakSearchSpt(String string) {
        this.peaks = new Vector(this.npks);
        this.parentName = string;
    }

    public void setNbPeaks(int n) {
        this.npks = n;
    }

    public void setTreshold(float f) {
        this.treshold = f;
    }

    public int getNbPeaks() {
        return this.npks;
    }

    public FabioFile getImageFile() {
        return this.imageFile;
    }

    public void initFabioFile(String string) throws FabioFileException {
        this.imageFile = new FabioFile(string);
    }

    public float getTreshold() {
        return this.treshold;
    }

    public void addPeak(Peak peak) {
        this.peaks.add(peak);
        this.addPropertyChangeListener(peak);
    }

    public Vector<Peak> getSortedpeaks() {
        if (this.peaks != null && this.peaks.size() > 0) {
            Collections.sort(this.peaks);
        }
        return this.peaks;
    }

    public void setComparator(String string, int n) {
        this.fireChangeSorter(string);
        this.firechangeSortdirection(n);
    }

    public Peak getPeak(int n) {
        return this.peaks.elementAt(n);
    }

    public int getSize() {
        return this.peaks.size();
    }

    public String getParentFileName() {
        return this.parentName;
    }

    public String getFabioFileName() {
        return this.fabioFileName;
    }

    public Vector<Peak> getChildren() {
        return this.peaks;
    }

    public Vector<Float> getTabChildren() {
        Vector<Float> vector = new Vector<Float>(this.peaks.size());
        if (this.peaks != null) {
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.peaks.size()) {
                if (this.getPeak(n3).isVisible()) {
                    n = n2 + 1;
                    vector.add(n2, Float.valueOf(this.getPeak(n3).getS()));
                    vector.add(n, Float.valueOf(this.getPeak(n3).getF()));
                    n2 += 2;
                }
                vector.setSize(n + 1);
                ++n3;
            }
        }
        return vector;
    }

    public String toString() {
        return this.parentName;
    }

    public void setKeys(String string) {
        this.peakKeys = string.split("\\s+");
    }

    public void setKeys(String[] stringArray) {
        this.peakKeys = stringArray;
    }

    public void setPeaks(String string) {
        this.scannedPeak = string;
    }

    public void concatPeaks(String string) {
        this.scannedPeak = this.scannedPeak.concat(string);
        this.scannedPeak = String.valueOf(this.scannedPeak) + System.getProperty("line.separator");
    }

    public void parse() {
        Job job = new Job("Getting " + this.npks + " peaks in file " + this.parentName){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (!PeakSearchSpt.this.parsed) {
                    PeakSearchSpt.this.parsed = true;
                    Scanner scanner = new Scanner(PeakSearchSpt.this.scannedPeak);
                    scanner.useDelimiter("[\n\r]+");
                    iProgressMonitor.beginTask("Wait while loading peaks", PeakSearchSpt.this.npks);
                    int n = 0;
                    int n2 = 0;
                    while (scanner.hasNext()) {
                        String string = scanner.nextLine();
                        if (string.trim().equals("")) continue;
                        string = String.valueOf(PeakSearchSpt.this.peaks.size()) + " " + string;
                        Peak peak = new Peak(PeakSearchSpt.this.peakKeys, string);
                        peak.setParent(PeakSearchSpt.this.parent);
                        peak.show(true);
                        PeakSearchSpt.this.peaks.add(peak);
                        n = PeakSearchSpt.this.peaks.size() * 100 / PeakSearchSpt.this.npks;
                        iProgressMonitor.subTask(String.valueOf(n) + "% done");
                        if (n2 % 250 == 0 && n2 > 0) {
                            PeakSearchSpt.this.fireSomePeaksLoaded();
                        } else if (n2 == PeakSearchSpt.this.npks - 1) {
                            PeakSearchSpt.this.fireSomePeaksLoaded();
                        }
                        ++n2;
                        iProgressMonitor.worked(1);
                        if (!iProgressMonitor.isCanceled()) continue;
                        scanner.close();
                        return Status.CANCEL_STATUS;
                    }
                    scanner.close();
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                PeakSearchSpt.this.fireParseCompleted();
            }
        });
        job.setUser(true);
        job.schedule();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed(boolean bl) {
        this.parsed = bl;
    }

    private void fireSomePeaksLoaded() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "Parsing_working", null, null));
        }
    }

    private void fireParseCompleted() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "Parsing_completed", null, null));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    public void fireChangeSorter(String string) {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "comparator", null, (Object)string));
        }
    }

    public void firechangeSortdirection(int n) {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "dir", null, (Object)n));
        }
    }

    public void setParentFileName(String string) {
        this.parentName = string;
    }

    public void setFabioFileName(String string) {
        this.fabioFileName = string;
    }

    public void setFabioFile(FabioFile fabioFile) {
        this.imageFile = fabioFile;
    }
}

