/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.framework.toolbox.ToolBox;
import fable.python.FabioFileException;
import fable.python.jep.FableJep;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class FabioFile
implements Comparable<Object>,
IPropertyChangeListener {
    private Semaphore semaphore = new Semaphore(1);
    public boolean headerRead = false;
    public boolean imageRead = false;
    private HashMap<String, String> header;
    private String fullFileName;
    private String fileName;
    private Vector<String> vKeysInHeader;
    private int width;
    private int height;
    private float minimum = Float.MAX_VALUE;
    private float maximum = Float.MIN_VALUE;
    private float sum = 0.0f;
    private float mean = Float.MIN_VALUE;
    private int floatImageBufferI = 0;
    private long timeToReadImage = 0L;
    private String stem;
    private String fileNumber;
    ImageLoader loader;
    ImageData[] imageDataArray;
    Logger logger = Logger.getLogger(FabioFile.class);
    private int index;
    private boolean flag = true;
    private static float[][] floatImageBuffer = null;
    private static int floatImageBufferPointer = 0;
    private static String[] fileImageBuffer = null;
    private String comparatorKey = "filename";
    private int comparatorDir = 1024;
    private int comparedResult;

    public FabioFile(String string) throws FabioFileException {
        if (floatImageBuffer == null) {
            floatImageBuffer = new float[10][];
            fileImageBuffer = new String[10];
            int n = 0;
            while (n < 10) {
                FabioFile.floatImageBuffer[n] = null;
                FabioFile.fileImageBuffer[n] = new String();
                ++n;
            }
        }
        if (!new File(string).exists()) {
            throw new FabioFileException(this.getClass().getName(), "FabioFile", "File not found: " + string);
        }
        this.headerRead = false;
        this.header = new HashMap();
        this.vKeysInHeader = new Vector();
        this.fullFileName = string;
        String[] stringArray = this.fullFileName.split("[\\\\/]");
        this.fileName = this.fullFileName;
        if (stringArray.length > 1) {
            this.fileName = stringArray[stringArray.length - 1];
        }
    }

    public synchronized void acquire() {
        this.semaphore.acquireUninterruptibly();
    }

    public synchronized void release() {
        this.semaphore.release();
    }

    private void importFabioModules(Jep jep) throws JepException {
        FableJep.jepImportModules(jep, "sys");
        FableJep.jepImportModules(jep, "numpy");
        FableJep.jepImportModules(jep, "PIL");
        FableJep.jepImportModules(jep, "fabio.openimage");
    }

    public void setFullFileName(String string) {
        this.fullFileName = string;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public String toString() {
        if (!this.headerRead) {
            try {
                this.loadHeader();
            }
            catch (FabioFileException fabioFileException) {}
        }
        String string = "{ \\n";
        Set<Map.Entry<String, String>> set = this.header.entrySet();
        for (Map.Entry<String, String> entry : set) {
            string = String.valueOf(string) + entry.getKey() + "=" + entry.getValue() + ";\\n";
        }
        string = String.valueOf(string) + "} \\n";
        return string;
    }

    public void loadHeader() throws FabioFileException {
        if (!this.headerRead) {
            try {
                this.loadHeader(FableJep.getFableJep());
            }
            catch (JepException jepException) {
                throw new FabioFileException(this.getClass().getName(), "loadHeader" + this.fullFileName, jepException.getMessage());
            }
        }
    }

    public synchronized void loadHeader(FableJep fableJep) throws FabioFileException {
        if (!this.headerRead) {
            this.acquire();
            File file = new File(this.fullFileName);
            if (file.exists()) {
                try {
                    this.importFabioModules(fableJep.getJep());
                    fableJep.set("filename", this.fullFileName);
                    fableJep.eval("im = fabio.openimage.openheader(filename)");
                    fableJep.eval("keys = im.header.keys()");
                    fableJep.eval("vals = im.header.values()");
                    fableJep.eval("res = len(keys)");
                    int n = (Integer)fableJep.getValue("res");
                    this.header = new HashMap();
                    int n2 = 0;
                    while (n2 < n) {
                        fableJep.set("i", n2);
                        fableJep.eval("res = str(keys[i])");
                        String string = (String)fableJep.getValue("res");
                        fableJep.eval("res = str(vals[i])");
                        String string2 = (String)fableJep.getValue("res");
                        this.header.put(string, string2);
                        this.vKeysInHeader.add(string);
                        ++n2;
                    }
                    this.addHeaderInfo("name", this.fileName);
                    this.addHeaderInfo("#", "" + this.index);
                    this.headerRead = true;
                }
                catch (JepException jepException) {
                    this.release();
                    this.logger.error((Object)jepException.getMessage());
                    throw new FabioFileException(this.getClass().getName(), "loadHeader" + this.fullFileName, jepException.getMessage());
                }
            } else {
                this.release();
                throw new FabioFileException(this.getClass().getName(), "loadHeader", "File not found" + this.fullFileName);
            }
            this.release();
        }
    }

    public void addHeaderInfo(String string, String string2) {
        this.header.put(string, string2);
    }

    public String[] getKeys() throws FabioFileException, JepException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        Set<String> set = this.header.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        ToolBox.quicksort((String[])stringArray, (int)0, (int)stringArray.length);
        return stringArray;
    }

    public Vector<String> getKeysAsListedInHeader() throws FabioFileException, JepException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        return this.vKeysInHeader;
    }

    public String getValue(String string) throws FabioFileException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        String string2 = "";
        if (!this.header.containsKey(string)) {
            throw new FabioFileException(this.getClass().getName(), "getValue()", "The key " + string + " has not be found in the header for the file " + this.fileName);
        }
        string2 = this.header.get(string);
        return string2;
    }

    public void addIndex(int n) {
        this.index = n;
    }

    public String getFullFilename() {
        return this.fullFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getTimeToReadImage() {
        return this.timeToReadImage;
    }

    /*
     * Unable to fully structure code
     */
    public String getStems() {
        if (this.stem == null) {
            block7: {
                var1_1 = null;
                var2_2 = this.fileName.split("\\.");
                var1_1 = this.fileName;
                if (var2_2 != null && var2_2.length >= 2) {
                    var3_3 = var2_2[1];
                    try {
                        Integer.valueOf(var3_3);
                        var4_4 = this.fileName.indexOf(".");
                        var1_1 = this.fileName.substring(0, var4_4);
                        break block7;
                    }
                    catch (NumberFormatException v0) {
                        var4_5 = var2_2[0].length() - 1;
                        ** while (var4_5 > 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Integer.valueOf(var2_2[0].substring(var4_5 - 1, var4_5));
                            --var4_5;
                        }
                        catch (NumberFormatException v1) {
                            var1_1 = var2_2[0].substring(0, var4_5);
                            var4_5 = 0;
                        }
                        continue;
                    }
                }
            }
            this.stem = var1_1;
        }
        return this.stem;
    }

    /*
     * Unable to fully structure code
     */
    public String getFileNumber() {
        if (this.fileNumber == null) {
            block7: {
                var1_1 = null;
                var2_2 = this.fileName.split("\\.");
                var1_1 = this.fileName;
                if (var2_2 != null && var2_2.length >= 2) {
                    var3_3 = var2_2[1];
                    try {
                        Integer.valueOf(var3_3);
                        var1_1 = var3_3;
                        break block7;
                    }
                    catch (NumberFormatException v0) {
                        var4_4 = var2_2[0].length() - 1;
                        ** while (var4_4 > 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Integer.valueOf(var2_2[0].substring(var4_4 - 1, var4_4));
                            --var4_4;
                        }
                        catch (NumberFormatException v1) {
                            var1_1 = var2_2[0].substring(var4_4, var2_2[0].length());
                            var4_4 = 0;
                        }
                        continue;
                    }
                }
            }
            this.fileNumber = var1_1;
        }
        return this.fileNumber;
    }

    public int getWidth() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.width;
    }

    public int getHeight() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.height;
    }

    public int getBytesPerPixel() {
        return 2;
    }

    public void readImage() throws JepException {
        this.readImageAsFloat();
    }

    public void readImageAsFloat() throws JepException {
        this.readImageAsFloat(FableJep.getFableJep());
    }

    public synchronized void readImageAsFloat(FableJep fableJep) {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!this.imageRead || !bl) {
            this.logger.debug((Object)("read file " + this.fileName));
            try {
                long l = System.currentTimeMillis();
                this.importFabioModules(fableJep.getJep());
                fableJep.set("filename", this.fullFileName);
                fableJep.eval("im = fabio.openimage.openimage(filename)");
                fableJep.eval("res = im.data.astype(numpy.float32).tostring()");
                FabioFile.floatImageBuffer[FabioFile.floatImageBufferPointer] = fableJep.getValue_floatarray("res");
                this.floatImageBufferI = floatImageBufferPointer;
                FabioFile.fileImageBuffer[FabioFile.floatImageBufferPointer] = this.fullFileName;
                this.incrementBufferPointer();
                fableJep.eval("res = im.dim1");
                this.width = (Integer)fableJep.getValue("res");
                fableJep.eval("res = im.dim2");
                this.height = (Integer)fableJep.getValue("res");
                if (this.minimum == Float.MAX_VALUE || this.maximum == Float.MIN_VALUE) {
                    this.sum = 0.0f;
                    int n = 0;
                    while (n < floatImageBuffer[this.floatImageBufferI].length) {
                        this.sum += floatImageBuffer[this.floatImageBufferI][n];
                        if (floatImageBuffer[this.floatImageBufferI][n] < this.minimum) {
                            this.minimum = floatImageBuffer[this.floatImageBufferI][n];
                        }
                        if (floatImageBuffer[this.floatImageBufferI][n] > this.maximum) {
                            this.maximum = floatImageBuffer[this.floatImageBufferI][n];
                        }
                        ++n;
                    }
                    this.mean = this.sum / (float)floatImageBuffer[this.floatImageBufferI].length;
                }
                this.timeToReadImage = System.currentTimeMillis() - l;
                this.imageRead = true;
            }
            catch (JepException jepException) {
                jepException.printStackTrace();
            }
        }
    }

    private void incrementBufferPointer() {
        if (++floatImageBufferPointer >= floatImageBuffer.length) {
            floatImageBufferPointer = 0;
        }
    }

    public float[] getImageAsFloat() throws JepException {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!bl) {
            this.readImageAsFloat();
        }
        return floatImageBuffer[this.floatImageBufferI];
    }

    public float[] getImageAsFloat(FableJep fableJep) {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!bl) {
            this.readImageAsFloat(fableJep);
        }
        return floatImageBuffer[this.floatImageBufferI];
    }

    public int[] getImageAsInt() throws JepException {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!bl) {
            this.readImageAsFloat();
        }
        int[] nArray = new int[this.getWidth() * this.getHeight()];
        int n = 0;
        while (n < floatImageBuffer[this.floatImageBufferI].length) {
            nArray[n] = (int)floatImageBuffer[this.floatImageBufferI][n];
            ++n;
        }
        return nArray;
    }

    public float getMinimum() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.minimum;
    }

    public float getMaximum() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.maximum;
    }

    public float getMean() throws JepException {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.mean;
    }

    public void setFlag(boolean bl) {
        this.flag = bl;
    }

    public boolean getFlag() {
        return this.flag;
    }

    @Override
    public int compareTo(Object object) {
        try {
            String string = ((FabioFile)object).getValue(this.comparatorKey);
            String string2 = this.getValue(this.comparatorKey);
            this.comparedResult = this.comparatorDir == 128 ? string.compareTo(string2) : string2.compareTo(string);
        }
        catch (FabioFileException fabioFileException) {
            this.logger.error((Object)fabioFileException.getMessage());
        }
        return this.comparedResult;
    }

    public int compareTo(String string, Object object) {
        this.comparatorKey = string;
        return this.compareTo(object);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("comparator")) {
            this.comparatorKey = (String)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getProperty().equals("dir")) {
            this.comparatorDir = (Integer)propertyChangeEvent.getNewValue();
        }
    }
}

