/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.python.FabioFileException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class EdfFile {
    private HashMap<String, String> header;
    private String fileName;
    private Vector<String> vKeysInHeader;
    private byte[] buffer = null;
    private int[] imageAsInt = null;
    private int headerEnd = 0;
    private int skipbytes;
    private int width;
    private int height;
    private double minimum = Double.MAX_VALUE;
    private double maximum = Double.MIN_VALUE;
    ImageLoader loader;
    ImageData[] imageDataArray;

    public EdfFile(String string) throws FabioFileException {
        this.header = new HashMap();
        this.vKeysInHeader = new Vector();
        this.fileName = string;
        this.loadHeader();
    }

    /*
     * Unable to fully structure code
     */
    private void loadHeader() throws FabioFileException {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = false;
        try {
            var3_3 = new FileReader(this.fileName);
            var2_2 = new BufferedReader(var3_3);
            if (true) ** GOTO lbl24
        }
        catch (IOException var5_5) {
            throw new FabioFileException(this.getClass().getName(), "loadHeader()", var5_5.getMessage());
        }
        {
            do {
                if (var1_1.startsWith("{")) {
                    var4_4 = true;
                    continue;
                }
                if (!var4_4 || (var5_6 = var1_1.split("=")).length != 2) continue;
                var6_8 = var5_6[0].trim();
                var7_9 = var5_6[1].replaceAll(";", "");
                this.header.put(var6_8, var7_9);
                this.vKeysInHeader.add(var6_8);
                this.skipbytes += var1_1.length();
                ++this.headerEnd;
lbl24:
                // 4 sources

            } while ((var1_1 = var2_2.readLine()) != null && !var1_1.contains("}"));
        }
        try {
            var3_3.close();
            var2_2.close();
        }
        catch (IOException var5_7) {
            throw new FabioFileException(this.getClass().getName(), "loadHeader()", var5_7.getMessage());
        }
    }

    public String toString() {
        String string = "{ \\n";
        Set<Map.Entry<String, String>> set = this.header.entrySet();
        for (Map.Entry<String, String> entry : set) {
            string = String.valueOf(string) + entry.getKey() + "=" + entry.getValue() + ";\\n";
        }
        string = String.valueOf(string) + "} \\n";
        return string;
    }

    public String[] getKeys() {
        Set<String> set = this.header.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Vector<String> getKeysAsListedInHeader() {
        return this.vKeysInHeader;
    }

    public String getValue(String string) throws FabioFileException {
        String string2 = "";
        if (!this.header.containsKey(string)) {
            throw new FabioFileException(this.getClass().getName(), "getValue()", "The key " + string + " has not be found in the header for the file ");
        }
        string2 = this.header.get(string);
        return string2;
    }

    public int getWidth() {
        this.width = 0;
        try {
            this.width = Integer.parseInt(this.getValue("Dim_1").replaceAll("\\p{Space}", ""));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (FabioFileException fabioFileException) {
            fabioFileException.printStackTrace();
        }
        return this.width;
    }

    public int getHeight() {
        this.height = 0;
        try {
            this.height = Integer.parseInt(this.getValue("Dim_2").replaceAll("\\p{Space}", ""));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (FabioFileException fabioFileException) {
            fabioFileException.printStackTrace();
        }
        return this.height;
    }

    public int getBytesPerPixel() {
        return 2;
    }

    public void readBuffer() {
        RandomAccessFile randomAccessFile = null;
        this.buffer = null;
        try {
            randomAccessFile = new RandomAccessFile(this.fileName, "r");
            try {
                System.out.println("readBuffer(): read buffer");
                int n = this.getHeight() * this.getWidth() * this.getBytesPerPixel();
                this.buffer = new byte[n];
                randomAccessFile.seek(randomAccessFile.length() - (long)n);
                randomAccessFile.readFully(this.buffer);
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public int[] getImageAsInt() {
        if (this.buffer == null) {
            this.readBuffer();
        }
        if (this.imageAsInt == null) {
            System.out.println("getImageAsInt(): convert buffer to int");
            this.imageAsInt = new int[this.getWidth() * this.getHeight()];
            int n = 0;
            while (n < this.buffer.length / 2) {
                int n2 = 0xFF & this.buffer[n * 2];
                int n3 = 0xFF & this.buffer[n * 2 + 1];
                this.imageAsInt[n] = n3 * 256 + n2;
                ++n;
            }
        }
        return this.imageAsInt;
    }

    public double getMinimum() {
        if (this.minimum == Double.MAX_VALUE) {
            this.getImageAsInt();
            int n = 0;
            while (n < this.imageAsInt.length) {
                if ((double)this.imageAsInt[n] < this.minimum) {
                    this.minimum = this.imageAsInt[n];
                }
                ++n;
            }
        }
        return this.minimum;
    }

    public double getMaximum() {
        if (this.maximum == Double.MIN_VALUE) {
            this.getImageAsInt();
            int n = 0;
            while (n < this.imageAsInt.length) {
                if ((double)this.imageAsInt[n] > this.maximum) {
                    this.maximum = this.imageAsInt[n];
                }
                ++n;
            }
        }
        return this.maximum;
    }
}

