/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.python.FabioFile;
import fable.python.FabioFileException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import jep.JepException;
import org.junit.Assert;
import org.junit.Test;

public class CompressFile {
    public static void compress(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            System.out.println("Compressing " + string);
            int n = fileInputStream.read();
            while (n != -1) {
                gZIPOutputStream.write(n);
                n = fileInputStream.read();
            }
        }
        finally {
            fileInputStream.close();
        }
        gZIPOutputStream.close();
    }

    @Test
    public void testcompressFile() {
        try {
            CompressFile.compress("d:\\My Documents\\ANTC_quench_2_\\ANTC_quench_2_3537.cor", "d:\\\\My Documents\\\\ANTC_quench_2_\\\\ANTC_quench_2_3537.cor.gzip");
        }
        catch (IOException iOException) {
            Assert.fail((String)("An error occured while testing java zip compression : " + iOException.getMessage()));
        }
    }

    @Test
    public void testReadCompressedFile() {
        try {
            FabioFile fabioFile = new FabioFile("d:\\\\My Documents\\\\ANTC_quench_2_\\\\ANTC_quench_2_3537.edf");
            System.out.println("Try to read");
            fabioFile.readImage();
            System.out.println("end reading");
        }
        catch (FabioFileException fabioFileException) {
            Assert.fail((String)"Fabio is unable to load this file");
            Assert.fail((String)fabioFileException.getMessage());
        }
        catch (JepException jepException) {
            Assert.fail((String)"Fabio is unable to read this file");
            Assert.fail((String)jepException.getMessage());
        }
    }
}

