/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.ColumnFileId;
import fable.framework.toolbox.FableUtils;
import fable.python.jep.FableJep;
import java.io.File;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.HashMap;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class ColumnFile {
    private FableJep fableJep;
    protected HashMap<String, double[]> columns = new HashMap();
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private Logger logger;
    private String fullFileName;
    private String fileName;
    int nCols = 0;
    int nRows = 0;
    float[] unitCell;
    public String[] titles;
    private float[] table_data;
    private HashMap<String, Integer> column_index;
    private int sortedColumnIndex;
    private int sortedDirection;
    private float[] bigArraySorted;

    public ColumnFile() throws JepException {
        this.fableJep = new FableJep();
        this.importModules();
        this.logger = Logger.getLogger(ColumnFile.class);
    }

    public ColumnFile(FableJep fableJep) throws JepException {
        this.fableJep = fableJep;
        this.importModules();
        this.logger = Logger.getLogger(ColumnFile.class);
        this.fireAddColumnFile();
    }

    private void importModules() {
        try {
            FableJep.jepImportModules(this.fableJep.getJep(), "numpy");
            FableJep.jepImportSpecificDefinition(this.fableJep.getJep(), "ImageD11", "columnfile");
        }
        catch (JepException jepException) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error importing modules", (Throwable)jepException);
        }
    }

    public ColumnFile(String string) throws JepException {
        this();
        this.loadColumnFile(string);
    }

    public void loadColumnFile(String string) {
        try {
            this.fableJep.set("name", string);
            this.setFileName(string);
            this.fableJep.eval("column_object=columnfile.columnfile(name)");
            this.fableJep.eval("column_object.readfile(name)");
            this.loadRows();
            this.sortedColumnIndex = this.getColumnIDIndex();
            this.setSortedIndex(this.sortedColumnIndex, 128);
            if (this.sortedColumnIndex < 0) {
                this.sortedColumnIndex = 0;
            }
            this.fireAddColumnFile();
        }
        catch (JepException jepException) {
            this.logger.debug((Object)jepException.getMessage());
        }
    }

    public void setFileName(String string) {
        this.fullFileName = string;
        this.fileName = this.fullFileName != null && this.fullFileName.length() > 1 ? this.fullFileName.substring(this.fullFileName.lastIndexOf(File.separatorChar) + 1) : "";
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPythonObject(FableJep fableJep) throws JepException {
        this.fableJep = fableJep;
        this.logger = Logger.getLogger(ColumnFile.class);
        this.fullFileName = (String)this.fableJep.getValue("column_object.filename");
    }

    public void loadRows() {
        try {
            float f = 0.0f;
            Object object = this.fableJep.getValue("column_object.nrows");
            if (object instanceof Integer) {
                FableLogger.getLogger().debug((Object)"Integer");
                this.nRows = (Integer)this.fableJep.getValue("column_object.nrows");
            } else if (object instanceof Float) {
                FableLogger.getLogger().debug((Object)"Float");
                f = ((Float)this.fableJep.getValue("column_object.nrows")).floatValue();
                this.nRows = (int)f;
            }
            f = 0.0f;
            Object object2 = this.fableJep.getValue("column_object.ncols");
            if (object2 instanceof Integer) {
                FableLogger.getLogger().debug((Object)"Integer");
                this.nCols = (Integer)this.fableJep.getValue("column_object.ncols");
            } else if (object2 instanceof Float) {
                FableLogger.getLogger().debug((Object)"Float");
                f = ((Float)this.fableJep.getValue("column_object.ncols")).floatValue();
                this.nCols = (int)f;
            }
            this.titles = new String[this.nCols];
            this.column_index = new HashMap();
            int n = 0;
            while (n < this.nCols) {
                this.fableJep.set("i", n);
                this.titles[n] = (String)this.fableJep.getValue("column_object.titles[i]");
                this.column_index.put(this.titles[n], n);
                ++n;
            }
            this.table_data = this.fableJep.getValue_floatarray("column_object.bigarray.astype(numpy.float32).tostring()");
        }
        catch (JepException jepException) {
            this.logger.error((Object)("can not create loadRows : " + jepException.getMessage()));
        }
    }

    public String getColumnfileId() {
        String string = "";
        if (this.fileName != null && this.fileName.toLowerCase().endsWith(ColumnFileId.getString((String)"ColumnFile.flt"))) {
            string = ColumnFileId.getString((String)"ColumnFile.idflt");
        }
        return string;
    }

    public int getColumnIDIndex() {
        int n = 0;
        boolean bl = false;
        n = 0;
        while (!bl && n < this.titles.length) {
            if (this.titles[n].equals(this.getColumnfileId())) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            n = -1;
        }
        return n - 1;
    }

    public float[] getSortedIndex(int n) {
        try {
            this.fableJep.set("i", n);
            if (this.sortedDirection == 128) {
                return this.fableJep.getValue_floatarray("numpy.argsort(column_object.bigarray[i,:]).astype(numpy.float32).tostring()");
            }
            return this.fableJep.getValue_floatarray("numpy.argsort(column_object.bigarray[i,:])[::-1].astype(numpy.float32).tostring()");
        }
        catch (JepException jepException) {
            this.logger.debug((Object)jepException.getMessage());
            return null;
        }
    }

    public boolean saveColumnFile(String string) {
        boolean bl = true;
        try {
            this.fableJep.set("filename", string);
            this.fableJep.eval("column_object.writefile(filename)");
            this.setFileName(string);
            this.fireSaveDone();
        }
        catch (JepException jepException) {
            bl = false;
        }
        return bl;
    }

    public HashMap<String, double[]> getColumnstoPlot() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnFile.this.columns.clear();
                    if (ColumnFile.this.fableJep == null) {
                        throw new InvalidObjectException("FableJep is null");
                    }
                    Object object = ColumnFile.this.fableJep.getValue("column_object.ncols");
                    if (object == null) {
                        throw new InvalidObjectException("Value received from FableJep is null");
                    }
                    ColumnFile.this.nCols = (Integer)object;
                    ColumnFile.this.titles = new String[ColumnFile.this.nCols];
                    int n = 0;
                    while (n < ColumnFile.this.nCols) {
                        ColumnFile.this.fableJep.set("i", n);
                        String string = (String)ColumnFile.this.fableJep.getValue("column_object.titles[i]");
                        ColumnFile.this.fableJep.eval("filteredValues=column_object.getcolumn(column_object.titles[i])");
                        float[] fArray = ColumnFile.this.fableJep.getValue_floatarray("filteredValues.astype(numpy.float32).tostring()");
                        double[] dArray = new double[fArray.length];
                        ColumnFile.this.nRows = fArray.length;
                        int n2 = 0;
                        while (n2 < fArray.length) {
                            dArray[n2] = fArray[n2];
                            ++n2;
                        }
                        ColumnFile.this.titles[n] = string;
                        ColumnFile.this.columns.put(string, dArray);
                        ++n;
                    }
                }
                catch (JepException jepException) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Cannot create columns to plot", (Throwable)jepException);
                }
                catch (Exception exception) {
                    FableUtils.excTraceMsg((Object)this, (String)"Unexpected error creating columns to plot", (Throwable)exception);
                }
            }
        });
        return this.columns;
    }

    public float getColumnFileCell(int n, String string) {
        float f = 0.0f;
        Integer n2 = this.column_index.get(string);
        if (n2 != null && (n += n2 * this.nRows) < this.table_data.length) {
            f = this.table_data[n];
        }
        return f;
    }

    public void update() {
        this.fireColumnHasBeenUpdated();
    }

    public void AddUnitCell(float[] fArray) {
        this.unitCell = fArray;
        this.fireAddUnitCell();
    }

    public float[] getUnitCell() {
        return this.unitCell;
    }

    public int getNRows() {
        return this.nRows;
    }

    public int getNCols() {
        return this.nCols;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    public void fireAddColumnFile() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "AddColumn", null, (Object)this));
        }
    }

    public void fireColumnHasBeenUpdated() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "updateColumn", null, (Object)this));
        }
    }

    private void fireSaveDone() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "propdirty", (Object)true, (Object)false));
        }
    }

    public void fireAddUnitCell() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "AddUnitCell", null, (Object)this));
        }
    }

    public void removeDots(String string, double d, double d2, String string2, double d3, double d4) throws JepException {
        if (this.fableJep != null) {
            this.fableJep.set("key1min", d);
            this.fableJep.set("key1max", d2);
            this.fableJep.set("key2min", d3);
            this.fableJep.set("key2max", d4);
            this.fableJep.eval("column_object." + string);
            this.fableJep.eval("mask = (column_object." + string + " > key1min) & " + "(column_object." + string + "<key1max) & " + "(column_object." + string2 + " > key2min) & " + "(column_object." + string2 + "< key2max)");
            this.fableJep.eval("column_object.filter(~mask)");
            this.loadRows();
            this.initBigArraySorted();
            this.update();
        }
    }

    public void removeRow(Object[] objectArray, String string) {
        if (this.fableJep != null) {
            this.makeMaskForSelectedRows(objectArray, string);
            try {
                this.fableJep.eval("column_object.filter(~mask)");
                this.loadRows();
                this.initBigArraySorted();
            }
            catch (JepException jepException) {
                this.logger.debug((Object)"filter on selected rows canno be apply.");
                this.logger.debug((Object)jepException.getMessage());
            }
            this.update();
        }
    }

    public void keepRow(Object[] objectArray, String string) {
        if (this.fableJep != null) {
            this.makeMaskForSelectedRows(objectArray, string);
            try {
                this.fableJep.eval("column_object.filter(mask)");
                this.loadRows();
                this.initBigArraySorted();
            }
            catch (JepException jepException) {
                this.logger.debug((Object)"filter on selected rows cannot be apply.");
                this.logger.debug((Object)jepException.getMessage());
            }
            this.update();
        }
    }

    private void initBigArraySorted() {
        this.bigArraySorted = new float[this.nRows];
        this.bigArraySorted = this.getSortedIndex(this.sortedColumnIndex);
    }

    private void makeMaskForSelectedRows(Object[] objectArray, String string) {
        try {
            this.fableJep.eval("myid = column_object." + string + ".copy().astype(numpy.int32)");
            this.fableJep.eval("mask = numpy.zeros(myid.shape, numpy.int32)");
        }
        catch (JepException jepException) {
            this.logger.debug((Object)"mask can not be instantiate.");
            this.logger.debug((Object)jepException.getMessage());
        }
        int n = 0;
        while (n < objectArray.length) {
            try {
                this.fableJep.eval("numpy.add(mask, myid == " + objectArray[n] + ", mask)");
            }
            catch (JepException jepException) {
                this.logger.debug((Object)"mask can not be build.");
                this.logger.debug((Object)jepException.getMessage());
            }
            ++n;
        }
        try {
            this.fableJep.eval("mask = (mask != 0)");
        }
        catch (JepException jepException) {
            this.logger.debug((Object)"mask can not be converted into a logical type.");
            this.logger.debug((Object)jepException.getMessage());
        }
    }

    public void keepDots(String string, double d, double d2, String string2, double d3, double d4) throws JepException {
        if (this.fableJep != null) {
            this.fableJep.set("key1min", d);
            this.fableJep.set("key1max", d2);
            this.fableJep.set("key2min", d3);
            this.fableJep.set("key2max", d4);
            this.fableJep.eval("mask = (column_object." + string + " > key1min) & " + "(column_object." + string + "<key1max) & " + "(column_object." + string2 + " > key2min) & " + "(column_object." + string2 + "< key2max)");
            this.fableJep.eval("column_object.filter(mask)");
            this.loadRows();
            this.initBigArraySorted();
            this.update();
        }
    }

    public void displayComputedData(String[] stringArray) {
        this.firePlotData(stringArray);
    }

    private void firePlotData(String[] stringArray) {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "PlotData", null, (Object)stringArray));
        }
    }

    public void fireRemoveAll() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "removeAll", null, null));
        }
    }

    public float[] getData() {
        return this.table_data;
    }

    public void setSortedIndex(int n, int n2) {
        this.sortedColumnIndex = n;
        this.sortedDirection = n2;
        this.initBigArraySorted();
    }

    public float[] getRowAt(int n) {
        float[] fArray = null;
        try {
            this.fableJep.set("col", this.bigArraySorted[n]);
        }
        catch (JepException jepException) {
            this.logger.debug((Object)("getRowAt/bigArraySorted" + jepException.getMessage()));
        }
        try {
            fArray = this.fableJep.getValue_floatarray("column_object.bigarray[:,col].astype(numpy.float32).tostring()");
        }
        catch (JepException jepException) {
            this.logger.debug((Object)("getRowAt/getValue_floatarray" + jepException.getMessage()));
        }
        return fArray;
    }
}

