/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.framework.database.DerbyDatabase;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.actions.OpenLogFileAction;
import fable.grainspotter.providers.GrainspotterContentProvider;
import fable.grainspotter.providers.GrainspotterLabelProvider;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.LogFile;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class OutputView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.grainspotter.view.outputview";
    public static OutputView view = null;
    Composite parent;
    private TreeViewer viewer;
    public GrainSpotter grainSpotter;
    private LogFile logFile;
    private OpenLogFileAction openFileAction;

    public void createPartControl(Composite composite) {
        view = this;
        this.parent = composite;
        this.grainSpotter = GrainSpotter.getInstance();
        this.grainSpotter.addPropertyChangeListener(this);
        this.createTree();
        this.makeActions();
        this.contributeToActionBars();
        if (Activator.database != null) {
            this.createDbTables();
        }
    }

    public void dispose() {
        if (this.grainSpotter != null) {
            this.grainSpotter.removePropertyChangeListener(this);
        }
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.openFileAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.openFileAction);
    }

    private void makeActions() {
        this.openFileAction = new OpenLogFileAction();
    }

    public void setFocus() {
    }

    public void loadLogFile(String string) {
        this.logFile = new LogFile(string);
        this.parseFile();
    }

    private void initViewPartName(String string) {
        final String string2 = string;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                view.setPartName(new File(string2).getName());
                view.setTitleToolTip(string2);
                view.setContentDescription(string2);
            }
        });
    }

    private void createTree() {
        this.viewer = new TreeViewer(this.parent, 783);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn treeColumn = new TreeColumn(this.viewer.getTree(), 0x1000000);
        this.viewer.getTree().setHeaderVisible(true);
        treeColumn.setText("Text");
        treeColumn.setWidth(400);
        TreeColumn treeColumn2 = new TreeColumn(this.viewer.getTree(), 0x1000000);
        treeColumn2.setText("Values");
        treeColumn2.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new GrainspotterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GrainspotterLabelProvider());
    }

    private void createDbTables() {
        Activator.database.createTable("grains (grain int, gve_expected int, gve_measured int, ia double, u11 double, u12 double, u13 double, u21 double, u22 double, u23 double, u31 double, u32 double, u33 double)");
        Activator.database.createTable("grainfits (grain int, gvector int, h int, k int, l int,h_pred double,k_pred double, l_pred double, dh double, dk double, dl double,  tth_meas double, tth_pred double, dtth double, omega_meas double, omega_pred double, domega double, eta_meas double, eta_pred double, deta double, ia double)");
    }

    private void dropDbTables() {
        Statement statement = null;
        try {
            statement = DerbyDatabase.getConnection().createStatement();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        try {
            statement.execute("drop table grains");
            statement.execute("drop table grainfits");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("grainspotter") && propertyChangeEvent.getNewValue().equals("stopped")) {
            this.logFile = GrainSpotter.getInstance().getLogFile();
            this.parseFile();
        }
    }

    private void parseFile() {
        this.grainSpotter.grainGvectors.clear();
        if (Activator.database != null) {
            this.dropDbTables();
            this.createDbTables();
        }
        try {
            FableMessageConsole.console.displayOut("load grainspotter output log file " + this.logFile.getFileName());
            this.initViewPartName(this.logFile.getFileName());
            Job job = this.logFile.getParsingJob();
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            OutputView.this.viewer.setInput((Object)OutputView.this.logFile.getGrains());
                        }
                    });
                }
            });
        }
        catch (GrainSpotterException grainSpotterException) {
            this.initViewPartName("Grainspotter outputfile grid.");
            SWTUtils.excMsgAsync((String)("cannot load grainspotter output log file " + this.logFile.getFileName()), (Exception)grainSpotterException);
            grainSpotterException.printStackTrace();
            FableMessageConsole.console.displayOut("cannot load grainspotter output log file " + this.logFile.getFileName());
            FableMessageConsole.console.displayOut("are you sure the file exists, did grainspotter run correctly");
        }
    }
}

