/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.actions.OpenGveFileAction;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.LogFile;
import fable.grainspotter.run.ReadGveThread;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Grains3DView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.grainspotter.grains3dview";
    public static Grains3DView thisView = null;
    public static GLContext context;
    public static GLU glu;
    private static SceneGrip grip;
    private Button gvectorShowButton;
    private Composite controlsComposite;
    private Composite canvasComposite;
    private Composite xyzControlsComposite;
    private static GLCanvas canvas;
    private static double[] oneGrain_xyz;
    private static int pointSize;
    private static Spinner pointSizeSpinner;
    private static int grains;
    private static Combo grainSelectCombo;
    private static int selectedGrain;
    private Text xoffText;
    private Text yoffText;
    private Text zoffText;
    private Text xrotText;
    private Text yrotText;
    private static Boolean showGVectors;
    private static Boolean allGvectorsListFirst;
    private static int allGvectorsList;
    private static int width;
    private static int height;
    private static float aspect;
    private Action infoAction;
    private OpenGveFileAction openGvecFileAction;
    public static ReadGveThread readgveThread;
    private LogFile logFile;
    private Text logFileText;
    private Logger logger;

    static {
        glu = new GLU();
        pointSize = 1;
        grains = 1;
        selectedGrain = 1;
        showGVectors = false;
        allGvectorsListFirst = true;
    }

    static void init(GLCanvas gLCanvas) {
        gLCanvas.setCurrent();
        Grains3DView.resize(gLCanvas);
        try {
            GLContext.useContext((Object)gLCanvas);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glHint((int)3152, (int)4354);
    }

    static void render() {
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
        GL11.glClear((int)16640);
        GL11.glClearColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        GL11.glLoadIdentity();
        grip.adjust();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)1, (int)0, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)1, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)0, (int)1);
        GL11.glPointSize((float)pointSize);
        GL11.glCallList((int)allGvectorsList);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRasterPos2i((int)1, (int)1);
        GL11.glEnable((int)2896);
    }

    static void resize(GLCanvas gLCanvas) {
        gLCanvas.setCurrent();
        Rectangle rectangle = gLCanvas.getClientArea();
        width = rectangle.width;
        height = Math.max(rectangle.height, 1);
        aspect = (float)width / (float)height;
        try {
            GLContext.useContext((Object)gLCanvas);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    public void createPartControl(Composite composite) {
        this.makeActions();
        this.contributeToActionBars();
        thisView = this;
        GrainSpotter.getInstance().addPropertyChangeListener(this);
        this.logger = Logger.getLogger(Grains3DView.class);
        readgveThread = new ReadGveThread();
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.controlsComposite = new Composite(composite, 4);
        this.controlsComposite.setLayout((Layout)gridLayout);
        this.controlsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Group group = new Group(this.controlsComposite, 0);
        group.setText("plot gvectors");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new FillLayout());
        this.gvectorShowButton = new Button((Composite)group, 32);
        this.gvectorShowButton.setText("show all gvectors");
        this.gvectorShowButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Grains3DView.this.updatePlot3D();
            }
        });
        Group group2 = new Group(this.controlsComposite, 0);
        group2.setText("plot grain");
        group2.setLayout((Layout)new GridLayout(4, false));
        group2.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label((Composite)group2, 0);
        this.logFileText = new Text((Composite)group2, 2048);
        this.logFileText.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Log file");
        this.logFileText.setToolTipText("Set log file name from grainspotter output to plot gve against grains");
        this.logFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Grains3DView.this.parseLogFile();
            }
        });
        this.logFileText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    Grains3DView.this.parseLogFile();
                }
            }
        });
        Button button = new Button((Composite)group2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell(), 4096);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDialog.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDialog.setText("Select a log file.");
                String string = fileDialog.open();
                if (string != null) {
                    Grains3DView.this.logFileText.setText(string);
                }
            }
        });
        grainSelectCombo = new Combo((Composite)group2, 4);
        grainSelectCombo.setToolTipText("Plot g-vectors per Grain number from log file.");
        grainSelectCombo.add("all grains");
        int n = 0;
        while (n < grains) {
            grainSelectCombo.add(Integer.toString(n + 1));
            ++n;
        }
        grainSelectCombo.select(0);
        grainSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                selectedGrain = grainSelectCombo.getSelectionIndex();
                if (selectedGrain > 0) {
                    selectedGrain = selectedGrain - 1;
                }
                Grains3DView.this.plotGrain();
                Grains3DView.drawAllGvectorsList();
                Grains3DView.render();
                Grains3DView.resize(canvas);
            }
        });
        Group group3 = new Group(this.controlsComposite, 0);
        group3.setText("point size");
        group3.setLayout((Layout)new FillLayout());
        group3.setLayoutData((Object)new GridData(4, 4, true, false));
        pointSizeSpinner = new Spinner((Composite)group3, 0x1000004);
        pointSizeSpinner.setMinimum(1);
        pointSizeSpinner.setMaximum(10);
        pointSizeSpinner.setSelection(1);
        pointSizeSpinner.setIncrement(1);
        pointSizeSpinner.setPageIncrement(5);
        pointSizeSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                pointSize = pointSizeSpinner.getSelection();
                Grains3DView.drawAllGvectorsList();
            }
        });
        GLData gLData = new GLData();
        gLData.doubleBuffer = true;
        Composite composite2 = new Composite(composite, 4);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite2.setLayout((Layout)gridLayout2);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvasComposite = new Composite(composite2, 4);
        this.canvasComposite.setLayout((Layout)new GridLayout());
        this.canvasComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas = new GLCanvas(this.canvasComposite, 262144, gLData);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Grains3DView.resize(canvas);
            }
        });
        this.xyzControlsComposite = new Composite(composite2, 4);
        this.xyzControlsComposite.setLayout((Layout)new GridLayout());
        this.xyzControlsComposite.setLayoutData((Object)new GridData(0, 4, false, true));
        Group group4 = new Group(this.xyzControlsComposite, 4);
        group4.setText("xoff");
        group4.setLayout((Layout)new FillLayout());
        group4.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xoffText = new Text((Composite)group4, 0x1000004);
        Group group5 = new Group(this.xyzControlsComposite, 4);
        group5.setText("yoff");
        group5.setLayout((Layout)new FillLayout());
        group5.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yoffText = new Text((Composite)group5, 0x1000004);
        Group group6 = new Group(this.xyzControlsComposite, 4);
        group6.setText("zoff");
        group6.setLayout((Layout)new FillLayout());
        group6.setLayoutData((Object)new GridData(4, 4, false, true));
        this.zoffText = new Text((Composite)group6, 0x1000004);
        Group group7 = new Group(this.xyzControlsComposite, 4);
        group7.setText("xrot");
        group7.setLayout((Layout)new FillLayout());
        group7.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xrotText = new Text((Composite)group7, 0x1000004);
        Group group8 = new Group(this.xyzControlsComposite, 4);
        group8.setText("yrot");
        group8.setLayout((Layout)new FillLayout());
        group8.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yrotText = new Text((Composite)group8, 0x1000004);
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
        Grains3DView.init(canvas);
        grip = new SceneGrip();
        grip.setDefaultView();
        canvas.addMouseListener((MouseListener)grip);
        canvas.addMouseMoveListener((MouseMoveListener)grip);
        canvas.addListener(37, (Listener)grip);
        canvas.addKeyListener((KeyListener)grip);
        new Runnable(){

            @Override
            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                Grains3DView.render();
                canvas.swapBuffers();
                canvas.getDisplay().timerExec(100, (Runnable)this);
            }
        }.run();
        composite.pack();
    }

    private void parseLogFile() {
        if (!this.logFileText.getText().equals("")) {
            this.loadLogFile(this.logFileText.getText());
        } else {
            oneGrain_xyz = null;
            this.logFile = null;
            grainSelectCombo.removeAll();
            Grains3DView.drawAllGvectorsList();
        }
    }

    public void dispose() {
        GrainSpotter.getInstance().removePropertyChangeListener(this);
    }

    private static void drawAllGvectorsList() {
        if (allGvectorsListFirst.booleanValue()) {
            GL11.glDeleteLists((int)allGvectorsList, (int)1);
            allGvectorsList = GL11.glGenLists((int)1);
            FableLogger.debug((Object)"Grains3DView :drawAllGvectorsList -GL11.glDeleteLists(allGvectorsList, 1);");
        }
        allGvectorsListFirst = false;
        GL11.glNewList((int)allGvectorsList, (int)4864);
        GL11.glPointSize((float)pointSize);
        if (showGVectors.booleanValue()) {
            GL11.glBegin((int)0);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            ArrayList<double[]> arrayList = readgveThread.getGveXYZ();
            int n = 0;
            while (n < arrayList.size()) {
                double[] dArray = arrayList.get(n);
                GL11.glVertex3d((double)dArray[0], (double)dArray[1], (double)dArray[2]);
                ++n;
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)0);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (oneGrain_xyz != null) {
            int n = 0;
            while (n < oneGrain_xyz.length / 3) {
                GL11.glVertex3d((double)oneGrain_xyz[n * 3], (double)oneGrain_xyz[n * 3 + 1], (double)oneGrain_xyz[n * 3 + 2]);
                ++n;
            }
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public void setFocus() {
        canvas.setFocus();
    }

    public static int getPointSize() {
        return pointSize;
    }

    public static void setPointSize(int n) {
        pointSize = n;
    }

    public static int getGrains() {
        return grains;
    }

    public static void setGrains(int n) {
        grains = n;
        String[] stringArray = new String[n + 1];
        stringArray[0] = "all grains";
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2 + 1] = Integer.toString(n2 + 1);
            ++n2;
        }
        grainSelectCombo.setItems(stringArray);
    }

    public void plotGrain() {
        int n = grainSelectCombo.getSelectionIndex();
        boolean bl = true;
        bl = n > 0 ? this.fillGvecPerGrains(n - 1) : this.getAllGrains();
        this.updatePlot3D();
        if (!bl) {
            SWTUtils.infoMsgAsync((String)"All g-vectors available in log file couldn' t be loaded.\nCheck in your Grainspotter ini file if log file has been generated with this g-vector file");
            FableMessageConsole.console.displayInfo("All g-vectors available in log file couldn' t be loaded.\nCheck in your Grainspotter ini file if log file has been generated with this g-vector file");
        }
    }

    private boolean getAllGrains() {
        boolean bl = true;
        if (this.logFile != null) {
            GrainSyntaxModel grainSyntaxModel = this.logFile.getGrains();
            oneGrain_xyz = new double[grainSyntaxModel.getgvecExpected() * 3];
            int n = 0;
            int n2 = 0;
            while (n2 < grainSyntaxModel.getGrains().size()) {
                GrainSyntaxModel grainSyntaxModel2 = grainSyntaxModel.getGrains().get(n2);
                List<GrainGvectorModel> list = grainSyntaxModel2.getGVectors();
                this.logger.info((Object)("Get Grain #" + grainSyntaxModel2.getId() + " for plotting in getAllGrains() "));
                int n3 = 0;
                while (n3 < list.size()) {
                    int n4 = list.get(n3).getid();
                    int n5 = n3 * 3 + n;
                    if (readgveThread.getGveXYZ().size() > n4) {
                        double[] dArray = readgveThread.getGveXYZ().get(n4);
                        Grains3DView.oneGrain_xyz[n5] = dArray[0];
                        Grains3DView.oneGrain_xyz[++n5] = dArray[1];
                        Grains3DView.oneGrain_xyz[++n5] = dArray[2];
                    } else {
                        bl = false;
                        this.logger.info((Object)("G-Vector id= " + n4 + " not found for Grain #" + grainSyntaxModel2.getId()));
                    }
                    ++n3;
                }
                n += list.size() * 3;
                ++n2;
            }
        }
        return bl;
    }

    private boolean fillGvecPerGrains(int n) {
        boolean bl = true;
        if (this.logFile != null) {
            GrainSyntaxModel grainSyntaxModel = this.logFile.getGrains().getGrains().get(n);
            List<GrainGvectorModel> list = grainSyntaxModel.getGVectors();
            oneGrain_xyz = new double[list.size() * 3];
            this.logger.info((Object)("Grain #" + grainSyntaxModel.getId()));
            int n2 = 0;
            while (n2 < list.size()) {
                int n3 = list.get(n2).getid();
                if (readgveThread.getGveXYZ().size() > n3) {
                    double[] dArray = readgveThread.getGveXYZ().get(n3);
                    Grains3DView.oneGrain_xyz[n2 * 3] = dArray[0];
                    Grains3DView.oneGrain_xyz[n2 * 3 + 1] = dArray[1];
                    Grains3DView.oneGrain_xyz[n2 * 3 + 2] = dArray[2];
                } else {
                    bl = false;
                    this.logger.info((Object)("G-Vector id = " + n3));
                }
                ++n2;
            }
        }
        return bl;
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.openGvecFileAction);
        iMenuManager.add((IAction)this.infoAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.openGvecFileAction);
        iToolBarManager.add((IAction)this.infoAction);
    }

    private void makeActions() {
        this.openGvecFileAction = new OpenGveFileAction();
        this.infoAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicsHelpDialog graphicsHelpDialog = new GraphicsHelpDialog(Grains3DView.this.getSite().getWorkbenchWindow().getShell());
                        graphicsHelpDialog.open();
                    }
                });
            }
        };
        this.infoAction.setText("Graphics Help");
        this.infoAction.setToolTipText("Summary of Graphics Manipulations");
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private static String getGraphicsHelp() {
        String string = System.getProperty("line.separator");
        String string2 = "";
        string2 = String.valueOf(string2) + "Button 1: Drag to examine" + string;
        string2 = String.valueOf(string2) + "Button 2: Drag vertically to zoom" + string;
        string2 = String.valueOf(string2) + "Button 3: Drag to pan" + string;
        string2 = String.valueOf(string2) + "Mouse Wheel: Zoom in/out" + string;
        string2 = String.valueOf(string2) + string;
        string2 = String.valueOf(string2) + "Up Arrow: Pan up" + string;
        string2 = String.valueOf(string2) + "Down Arrow: Pan down" + string;
        string2 = String.valueOf(string2) + "Left Arrow: Pan left" + string;
        string2 = String.valueOf(string2) + "Right Arrow: Pan right" + string;
        string2 = String.valueOf(string2) + string;
        string2 = String.valueOf(string2) + "Ctrl + Up Arrow: Rotate one way about horizontal axis" + string;
        string2 = String.valueOf(string2) + "Ctrl + Down Arrow: Rotate other way about horizontal axis" + string;
        string2 = String.valueOf(string2) + "Ctrl + Left Arrow: Rotate one way about about vertical axis" + string;
        string2 = String.valueOf(string2) + "Ctrl + Right Arrow: Rotate other way about vertical axis" + string;
        string2 = String.valueOf(string2) + string;
        string2 = String.valueOf(string2) + "Page Up: Zoom in" + string;
        string2 = String.valueOf(string2) + "Page Down: Zoom out" + string;
        string2 = String.valueOf(string2) + string;
        string2 = String.valueOf(string2) + "Home: Reset" + string;
        string2 = String.valueOf(string2) + "End: Reset to X-Axis right, Y-axis up, Z-axis out";
        return string2;
    }

    public void loadGVectors(String string) {
        readgveThread.setGvectorFile(string);
        readgveThread.run();
        File file = new File(string);
        String string2 = file.getName();
        if (string2 != null) {
            this.setPartName(string2);
            this.setTitleToolTip(string);
            this.setContentDescription(string);
        } else {
            this.setPartName("3DView");
            this.setContentDescription("");
        }
        this.gvectorShowButton.setSelection(true);
        this.plotGrain();
        if (!this.logFileText.getText().trim().equals("")) {
            this.loadLogFile(this.logFileText.getText());
        }
    }

    private void updatePlot3D() {
        showGVectors = this.gvectorShowButton.getSelection();
        Grains3DView.drawAllGvectorsList();
    }

    private void loadLogFile(String string) {
        this.logFile = new LogFile(string);
        try {
            Job job = this.logFile.getParsingJob();
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int n = Grains3DView.this.logFile.getGrains().getGrains().size();
                            Grains3DView.setGrains(n);
                            grainSelectCombo.select(0);
                            Grains3DView.this.plotGrain();
                        }
                    });
                }
            });
        }
        catch (GrainSpotterException grainSpotterException) {
            SWTUtils.infoMsgAsync((String)(String.valueOf(grainSpotterException.get_message()) + ".\n\nTry to plot when you are sure log file exists."));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("new log file")) {
            this.logFile = (LogFile)propertyChangeEvent.getNewValue();
            final String string = String.valueOf((String)propertyChangeEvent.getOldValue()) + System.getProperty("file.separator") + this.logFile.getFileName();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    File file = new File(Grains3DView.this.logFile.getFileName());
                    if (!file.exists()) {
                        Grains3DView.this.logFileText.setText(string);
                    } else {
                        Grains3DView.this.logFileText.setText(Grains3DView.this.logFile.getFileName());
                    }
                }
            });
        } else if (propertyChangeEvent.getProperty().equals("new gve file")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string2 = String.valueOf((String)propertyChangeEvent.getOldValue()) + System.getProperty("file.separator") + string;
            File file = new File(string);
            if (!file.exists()) {
                this.loadGVectors(string2);
            } else {
                this.loadGVectors(string);
            }
        } else if (propertyChangeEvent.getProperty().equals("grainspotter") && propertyChangeEvent.equals("stopped")) {
            this.logFile = GrainSpotter.getInstance().getLogFile();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Grains3DView.this.logFileText.setText(Grains3DView.this.logFile.getFileName());
                }
            });
        }
    }

    public class GraphicsHelpDialog
    extends Dialog {
        public GraphicsHelpDialog(Shell shell) {
            this(shell, 2144);
        }

        public GraphicsHelpDialog(Shell shell, int n) {
            super(shell, n);
        }

        public String open() {
            Shell shell = new Shell(this.getParent(), this.getStyle());
            shell.setText("Graphics Help");
            shell.setImage(Grains3DView.this.getTitleImage());
            this.createContents(shell);
            shell.pack();
            shell.open();
            Display display = this.getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return null;
        }

        private void createContents(final Shell shell) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            shell.setLayout((Layout)gridLayout);
            Group group = new Group((Composite)shell, 2048);
            group.setText("Graphics Manipulations");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            group.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 1;
            group.setLayoutData((Object)gridData);
            Text text = new Text((Composite)group, 2);
            text.setEditable(false);
            text.setText(Grains3DView.getGraphicsHelp());
            gridData = new GridData();
            text.setLayoutData((Object)gridData);
            Button button = new Button((Composite)shell, 8);
            button.setText("Close");
            gridData = new GridData(64);
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell.close();
                }
            });
            shell.setDefaultButton(button);
        }
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private boolean move;
        private boolean zoom;
        private int xdown;
        private int ydown;
        private int ylast;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            this.zoff = -8.0f;
            Grains3DView.this.xrotText.setText(Float.toString(this.xrot));
            Grains3DView.this.yrotText.setText(Float.toString(this.yrot));
            Grains3DView.this.xoffText.setText(Float.toString(this.xoff));
            Grains3DView.this.yoffText.setText(Float.toString(this.yoff));
            Grains3DView.this.zoffText.setText(Float.toString(this.zoff));
        }

        public void setDefaultView() {
            this.init();
            grip.setOffsets(-0.25f, -0.25f, -5.5f);
            grip.setRotation(45.0f, -30.0f);
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (++this.mouseDown == 1) {
                this.move = false;
                this.zoom = false;
                if (mouseEvent.button == 2) {
                    this.zoom = true;
                } else {
                    this.move = mouseEvent.button == 3;
                    if (this.move) {
                        this.xcpy = this.xoff;
                        this.ycpy = this.yoff;
                        ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(21));
                    } else {
                        this.xcpy = this.xrot;
                        this.ycpy = this.yrot;
                        ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(5));
                    }
                }
                this.xdown = mouseEvent.x;
                this.ydown = this.ylast = mouseEvent.y;
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (--this.mouseDown == 0) {
                ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent mouseEvent) {
            Point point = ((Control)mouseEvent.widget).getSize();
            if (this.mouseDown > 0) {
                if (this.zoom) {
                    int n = mouseEvent.y - this.ylast;
                    this.ylast = mouseEvent.y;
                    this.zoff += (float)n / 6.0f;
                } else if (this.move) {
                    int n = mouseEvent.x - this.xdown;
                    int n2 = mouseEvent.y - this.ydown;
                    this.yoff = this.ycpy + (this.zoff + 1.0f) * (float)n2 / (2.0f * (float)point.y);
                    this.xoff = this.xcpy - (this.zoff + 1.0f) * (float)n / (2.0f * (float)point.x);
                } else {
                    int n = mouseEvent.x - this.xdown;
                    int n3 = mouseEvent.y - this.ydown;
                    this.xrot = this.xcpy + (float)n3 / 2.0f;
                    this.yrot = this.ycpy + (float)n / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff += (float)event.count / 6.0f;
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.xrot -= 0.5f;
                        break;
                    }
                    this.yoff += 0.05f;
                    break;
                }
                case 0x1000002: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.xrot += 0.5f;
                        break;
                    }
                    this.yoff -= 0.05f;
                    break;
                }
                case 0x1000003: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.yrot -= 0.5f;
                        break;
                    }
                    this.xoff -= 0.05f;
                    break;
                }
                case 0x1000004: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.yrot += 0.5f;
                        break;
                    }
                    this.xoff += 0.05f;
                    break;
                }
                case 0x1000005: {
                    this.zoff += 0.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff -= 0.05f;
                    break;
                }
                case 0x1000007: {
                    this.setDefaultView();
                    break;
                }
                case 0x1000008: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void updateTextDisplay() {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.applyPattern("0.0");
            Grains3DView.this.xrotText.setText(decimalFormat.format(this.xrot));
            Grains3DView.this.yrotText.setText(decimalFormat.format(this.yrot));
            Grains3DView.this.xoffText.setText(decimalFormat.format(this.xoff));
            Grains3DView.this.yoffText.setText(decimalFormat.format(this.yoff));
            Grains3DView.this.zoffText.setText(decimalFormat.format(this.zoff));
        }

        public void adjust() {
            try {
                GLContext.useContext((Object)canvas);
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
            GL11.glOrtho((double)(-grip.zoff), (double)grip.zoff, (double)(-grip.zoff / aspect), (double)(grip.zoff / aspect), (double)-100000.0, (double)100000.0);
            GL11.glTranslatef((float)this.xoff, (float)this.yoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)0.1f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)0.1f, (float)0.0f);
            this.updateTextDisplay();
        }

        public void setOffsets(float f, float f2, float f3) {
            this.xoff = f;
            this.yoff = f2;
            this.zoff = f3;
        }

        public void setRotation(float f, float f2) {
            this.xrot = f;
            this.yrot = f2;
        }
    }
}

