/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.views.FableMessageConsole;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorViewPart;

public class ReadGveThread
implements Runnable {
    String outputMessage;
    private int nGvectors = 0;
    String gvectorFile = null;
    public ArrayList<double[]> gveXYZ = new ArrayList();

    @Override
    public void run() {
        block11: {
            if (this.gvectorFile != null) {
                this.gveXYZ.clear();
                assert (this.gvectorFile != null);
                this.nGvectors = 0;
                boolean bl = false;
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayIn("Start reading gve file " + this.gvectorFile);
                }
                Pattern pattern = Pattern.compile("(.*?xr\\s+yr\\s+zr.*?$)||(.*?gx\\s+gy\\s+gz.*?$)");
                try {
                    String string;
                    File file = new File(this.gvectorFile);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.length() <= 0) continue;
                        Matcher matcher = pattern.matcher(string);
                        if (matcher.matches()) {
                            bl = true;
                        }
                        if (!bl || matcher.matches()) continue;
                        double[] dArray = new double[3];
                        ++this.nGvectors;
                        try {
                            String[] stringArray = string.split("\\s+");
                            dArray[0] = Double.valueOf(stringArray[0]);
                            dArray[1] = Double.valueOf(stringArray[1]);
                            dArray[2] = Double.valueOf(stringArray[2]);
                            this.gveXYZ.add(dArray);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("A problem occured while parsing gve at line:" + string);
                            if (FableMessageConsole.console == null) continue;
                            FableMessageConsole.console.displayError("An error occured while parsing file " + file.getName() + " at line " + string);
                        }
                    }
                    bufferedReader.close();
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayIn("Finished reading gve file " + this.gvectorFile + " found " + this.nGvectors + " vectors");
                    }
                    this.open3Dview();
                }
                catch (IOException iOException) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error while opening or reading gve file = " + this.gvectorFile);
                    }
                    if (FableMessageConsole.console == null) break block11;
                    FableMessageConsole.console.displayError("Make sure the path and file name are correct and verify the contents");
                }
            }
        }
    }

    public void open3Dview() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Object var1_1 = null;
                try {
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                        iWorkbenchPage.showView("fable.grainspotter.grains3dview");
                    }
                }
                catch (PartInitException partInitException) {
                    FableMessageConsole.console.displayError("Exception occurred showing Grains3DView: " + (Object)((Object)partInitException) + "\n" + partInitException.getMessage());
                    partInitException.printStackTrace();
                }
                if (var1_1 instanceof ErrorViewPart) {
                    FableMessageConsole.console.displayError("Error showing Grains3DView");
                }
            }
        });
    }

    public int getNGvectors() {
        return this.nGvectors;
    }

    public void setNGvectors(int n) {
        this.nGvectors = n;
    }

    public String getGvectorFile() {
        return this.gvectorFile;
    }

    public void setGvectorFile(String string) {
        this.gvectorFile = string;
    }

    public ArrayList<double[]> getGveXYZ() {
        return this.gveXYZ;
    }

    public void setGveXYZ(ArrayList<double[]> arrayList) {
        this.gveXYZ = arrayList;
    }
}

