/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.toolbox.FableUtils;
import fable.grainspotter.preferences.DefaultvaluesPreferencePage;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotterException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;

public class InputFile {
    private HashMap<String, String> options;
    public String iniFileName = "";
    public String iniFilePath = "";
    public String gveFileName = "";
    public String gveFilePath = "";
    public String logFileName = "";
    public String logFilePath = "";
    private float deltaOmegaSpecs;
    private int minMeasurementCuts;
    private float minCompletenessCuts;
    private float ttUncertainties;
    private float omegaUncertainties;
    private float etaUncertainties;
    private float stepEuler;
    private float nSigmas;
    private int nHKLs;
    private float minfracg;
    private boolean positionFit = false;
    private int random;
    private int spaceGroup;
    private float minEtatSpecs;
    private float maxEtatSpecs;
    private Vector<float[]> dsRange = new Vector();
    private Vector<float[]> omegaRange = new Vector();
    private Vector<float[]> tthRange = new Vector();
    private Vector<float[]> etaRange = new Vector();
    private float cutsMinUniqueness;
    private boolean ignoreOptionDeltaOmegaSpec = true;
    private boolean ignoreOptionCuts = true;
    private boolean ignoreOptionEuler = true;
    private boolean ignoreOptionUncertainties = true;
    private boolean ignoreOptionNSigma = true;
    private boolean ignoreOptionHKL = true;
    private boolean ignoreOptionMinfracg = true;
    private boolean ignoreOptionRandom = true;
    private boolean ignoreOptionDsRange = true;
    private Logger logger;

    public InputFile() {
        this.logger = Logger.getLogger(InputFile.class);
    }

    public InputFile(String string) throws GrainSpotterException {
        this.iniFileName = string;
        this.options = new HashMap();
        this.setFile(string);
        this.logger = Logger.getLogger(InputFile.class);
    }

    public void setFile(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n >= 0) {
            this.iniFilePath = string.substring(0, n);
            if (n + 1 < string.length()) {
                this.iniFileName = string.substring(n + 1);
            }
        }
    }

    public void setMinMeasurementCuts(int n) {
        this.minMeasurementCuts = n;
    }

    public void setMinCompletenessCuts(float f) {
        this.minCompletenessCuts = f;
    }

    public void setTtUncertainties(float f) {
        this.ttUncertainties = f;
    }

    public void setOmegaUncertainties(float f) {
        this.omegaUncertainties = f;
    }

    public void setEtaUncertainties(float f) {
        this.etaUncertainties = f;
    }

    public void setStepEuler(float f) {
        this.stepEuler = f;
    }

    public void setNSigmas(float f) {
        this.nSigmas = f;
    }

    public void setNHKLs(int n) {
        this.nHKLs = n;
    }

    public void setMinfracg(float f) {
        this.minfracg = f;
    }

    public void setRandom(int n) {
        this.random = n;
    }

    public void setSpaceGroup(int n) {
        this.spaceGroup = n;
    }

    public void setMinEtatSpecs(float f) {
        this.minEtatSpecs = f;
    }

    public void setPositionFit(boolean bl) {
        this.positionFit = bl;
    }

    public void addDsRange(float f, float f2) {
        float[] fArray = new float[]{f, f2};
        this.dsRange.add(fArray);
    }

    public void addOmegaRange(float f, float f2) {
        float[] fArray = new float[]{f, f2};
        this.omegaRange.add(fArray);
    }

    public void addTthRange(float f, float f2) {
        float[] fArray = new float[]{f, f2};
        this.tthRange.add(fArray);
    }

    public void addEtaRange(float f, float f2) {
        float[] fArray = new float[]{f, f2};
        this.etaRange.add(fArray);
    }

    public void setDeltaOmegaSpecs(float f) {
        this.deltaOmegaSpecs = f;
    }

    public void setEtaUncertanties(float f) {
        this.etaUncertainties = f;
    }

    public String getIniFileName() {
        return this.iniFileName;
    }

    public String getIniFilePath() {
        return this.iniFilePath;
    }

    public String getGveFileName() {
        return this.gveFileName;
    }

    public String getGveFilePath() {
        return this.gveFilePath;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public float getDeltaOmegaSpecs() {
        return this.deltaOmegaSpecs;
    }

    public int getMinMeasurementCuts() {
        return this.minMeasurementCuts;
    }

    public float getMinCompletenessCuts() {
        return this.minCompletenessCuts;
    }

    public float getTtUncertainties() {
        return this.ttUncertainties;
    }

    public float getOmegaUncertainties() {
        return this.omegaUncertainties;
    }

    public float getEtaUncertainties() {
        return this.etaUncertainties;
    }

    public float getStepEuler() {
        return this.stepEuler;
    }

    public float getNSigmas() {
        return this.nSigmas;
    }

    public int getNHKLs() {
        return this.nHKLs;
    }

    public float getMinfracg() {
        return this.minfracg;
    }

    public boolean isPositionFit() {
        return this.positionFit;
    }

    public int getRandom() {
        return this.random;
    }

    public int getSpaceGroup() {
        return this.spaceGroup;
    }

    public float getMinEtatSpecs() {
        return this.minEtatSpecs;
    }

    public float getMaxEtatSpecs() {
        return this.maxEtatSpecs;
    }

    public Vector<float[]> getDsRange() {
        return this.dsRange;
    }

    public Vector<float[]> getOmegaRange() {
        return this.omegaRange;
    }

    public Vector<float[]> getTthRange() {
        return this.tthRange;
    }

    public Vector<float[]> getEtaRange() {
        return this.etaRange;
    }

    private void writeNewRange(BufferedWriter bufferedWriter, String string, Vector<float[]> vector) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            if (vector.get(n).length == 2) {
                bufferedWriter.write(String.valueOf(string) + " " + vector.get(n)[0] + " " + vector.get(n)[1]);
                bufferedWriter.newLine();
            }
            ++n;
        }
    }

    public void initWithDefaultValues() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.setIgnoreOptionDsRange(true);
        this.ignoreOptionDeltaOmegaSpec = false;
        this.ignoreOptionCuts = false;
        this.ignoreOptionEuler = false;
        this.ignoreOptionUncertainties = false;
        this.ignoreOptionNSigma = false;
        this.ignoreOptionHKL = false;
        this.ignoreOptionMinfracg = false;
        this.ignoreOptionRandom = false;
        this.ignoreOptionDsRange = true;
        this.setSpaceGroup(iPreferenceStore.getInt("pref_SpaceGroup"));
        this.set_minMeasurementCuts(iPreferenceStore.getInt("pref_cuts_minMesurement"));
        try {
            this.set_minCompletenessCuts(iPreferenceStore.getFloat("pref_cuts_completeness"));
        }
        catch (GrainSpotterException grainSpotterException) {
            FableUtils.errMsg((Object)this, (String)grainSpotterException.get_message());
        }
        this.setMinMeasurementUniqueness(iPreferenceStore.getFloat(DefaultvaluesPreferencePage.CUTS_UNIQUENESS));
        this.set_stepEuler(iPreferenceStore.getFloat("pref_eulerStep"));
        this.setOmegaUncertainties(iPreferenceStore.getFloat("pref_sigma_omega"));
        this.setEtaUncertainties(iPreferenceStore.getFloat("pref_sigma_eta"));
        this.setTtUncertainties(iPreferenceStore.getFloat("pref_sigma_tth"));
        this.setNSigmas(iPreferenceStore.getFloat("pref_sigmas"));
        this.setMinfracg(iPreferenceStore.getFloat("prefs_minfracg_grainspotter"));
        this.setNHKLs(iPreferenceStore.getInt("pref_nhkl"));
        this.setRandom(iPreferenceStore.getInt("prefs_Random_grainspotter"));
        this.setPositionFit(iPreferenceStore.getBoolean("prefs_positionFit_grainspotter"));
        if (iPreferenceStore.getString("prefs_TthrangeByDefault").equals("tthrangePreferred")) {
            this.addTthRange(iPreferenceStore.getFloat("prefs_tthRange_Min"), iPreferenceStore.getFloat("prefs_tthRange_Max"));
        } else {
            this.addDsRange(iPreferenceStore.getFloat("prefs_dsMin"), iPreferenceStore.getFloat("prefs_dsMax"));
        }
        this.addEtaRange(iPreferenceStore.getFloat("pref_etaspec_min"), iPreferenceStore.getFloat("pref_etaspec_max"));
        this.addOmegaRange(iPreferenceStore.getFloat("pref_omegaspec_min"), iPreferenceStore.getFloat("pref_omegaspec_max"));
        this.setDeltaOmegaSpecs(iPreferenceStore.getFloat("pref_omegaspec_delta"));
    }

    public void save() throws GrainSpotterException {
        String string = String.valueOf(this.iniFilePath) + File.separator + this.iniFileName;
        this.writeIniFile(string);
        this.setFile(string);
    }

    public void saveAs(String string) throws GrainSpotterException {
        this.writeIniFile(string);
        this.setFile(string);
    }

    private void writeIniFile(String string) throws GrainSpotterException {
        try {
            String string2;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("spacegroup " + this.getSpaceGroup());
            bufferedWriter.newLine();
            if (this.getTthRange() != null) {
                this.writeNewRange(bufferedWriter, "tthrange", this.getTthRange());
            }
            if (this.getEtaRange() != null) {
                this.writeNewRange(bufferedWriter, "etarange", this.getEtaRange());
            }
            if (this.omegaRange != null) {
                this.writeNewRange(bufferedWriter, "omegarange", this.getOmegaRange());
            }
            if (!this.ignoreOptionDeltaOmegaSpec) {
                bufferedWriter.write("domega " + this.getDeltaOmegaSpecs());
                bufferedWriter.newLine();
            }
            if (this.getDsRange() != null) {
                this.writeNewRange(bufferedWriter, "dsrange", this.getDsRange());
            }
            if ((string2 = this.getGveFileName()).equals(this.getIniFilePath())) {
                string2 = string2.substring(string2.lastIndexOf(File.separator) + 1);
            }
            String string3 = this.getLogFileName();
            if (this.getLogFilePath().equals(this.getIniFilePath())) {
                string3 = string3.substring(string3.lastIndexOf(File.separator) + 1);
            }
            bufferedWriter.write("filespecs " + string2 + " " + string3);
            bufferedWriter.newLine();
            if (!this.ignoreOptionCuts) {
                bufferedWriter.write("cuts " + this.getMinMeasurementCuts() + " " + this.getMinCompletenessCuts() + " " + this.getMinMeasurementUniqueness());
                bufferedWriter.newLine();
            }
            if (!this.ignoreOptionEuler) {
                bufferedWriter.write("eulerstep " + this.getStepEuler());
                bufferedWriter.newLine();
            }
            if (!this.ignoreOptionUncertainties) {
                bufferedWriter.write("uncertainties " + this.getTtUncertainties() + " " + this.getEtaUncertainties() + " " + this.getOmegaUncertainties());
                bufferedWriter.newLine();
            }
            if (!this.ignoreOptionNSigma) {
                bufferedWriter.write("nsigmas " + this.getNSigmas());
                bufferedWriter.newLine();
            }
            if (!this.ignoreOptionMinfracg) {
                bufferedWriter.write("minfracg " + this.getMinfracg());
                bufferedWriter.newLine();
            }
            if (!this.ignoreOptionHKL) {
                bufferedWriter.write("Nhkls_in_indexing " + this.getNHKLs());
                bufferedWriter.newLine();
            }
            if (!this.ignoreOptionRandom) {
                bufferedWriter.write("random " + this.getRandom());
                bufferedWriter.newLine();
            }
            if (this.isPositionFit()) {
                bufferedWriter.write("positionfit");
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.manageError("writeIniFile()", fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.manageError("writeIniFile()", iOException.getMessage());
        }
    }

    public void parseIniFile(String string, boolean bl) throws GrainSpotterException {
        block13: {
            BufferedReader bufferedReader = null;
            try {
                try {
                    String string2;
                    File file = new File(string);
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String[] stringArray = string2.split("\\p{Space}");
                        if (stringArray.length <= 0) continue;
                        String string3 = string2.substring(stringArray[0].length());
                        this.options.put(stringArray[0], string3);
                    }
                }
                catch (IOException iOException) {
                    this.manageError("parseIniFile()", iOException.getMessage());
                    if (bufferedReader == null) break block13;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        this.manageError("parseIniFile()", iOException2.getMessage());
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        this.manageError("parseIniFile()", iOException.getMessage());
                    }
                }
            }
        }
    }

    public void parseIniFile(String string) throws GrainSpotterException {
        block27: {
            BufferedReader bufferedReader = null;
            String string2 = "^spacegroup.*";
            String string3 = "^etarange.*";
            String string4 = "^domega.*";
            String string5 = "^omegarange.*";
            String string6 = "^filespecs.*";
            String string7 = "^cuts.*";
            String string8 = "^eulerstep.*";
            String string9 = "^uncertainties.*";
            String string10 = "^nsigmas.*";
            String string11 = "^Nhkls_in_indexing.*";
            String string12 = "^tthrange.*";
            String string13 = "^minfracg.*";
            String string14 = "^dsrange.*";
            String string15 = "^positionfit.*";
            String string16 = "^random.*";
            this.resetRange();
            try {
                try {
                    String string17;
                    File file = new File(string);
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    while ((string17 = bufferedReader.readLine()) != null) {
                        if (string17.matches(string2)) {
                            this.extractSpaceGroup(string17);
                            continue;
                        }
                        if (string17.matches(string3)) {
                            this.extractEtaRange(string17);
                            continue;
                        }
                        if (string17.matches(string4)) {
                            this.extractDOmega(string17);
                            this.ignoreOptionDeltaOmegaSpec = false;
                            continue;
                        }
                        if (string17.matches(string5)) {
                            this.extractOmegaRange(string17);
                            continue;
                        }
                        if (string17.matches(string6)) {
                            this.extractDataSpecs(string17);
                            continue;
                        }
                        if (string17.matches(string7)) {
                            this.extractCuts(string17);
                            this.ignoreOptionCuts = false;
                            continue;
                        }
                        if (string17.matches(string8)) {
                            this.extractStepEuler(string17);
                            this.ignoreOptionEuler = false;
                            continue;
                        }
                        if (string17.matches(string9)) {
                            this.extractUncertanties(string17);
                            this.ignoreOptionUncertainties = false;
                            continue;
                        }
                        if (string17.matches(string10)) {
                            this.extractNSigmas(string17);
                            this.ignoreOptionNSigma = false;
                            continue;
                        }
                        if (string17.matches(string12)) {
                            this.extractthRange(string17);
                            this.setIgnoreOptionDsRange(true);
                            continue;
                        }
                        if (string17.matches(string13)) {
                            this.extractMinFracg(string17);
                            this.ignoreOptionMinfracg = false;
                            continue;
                        }
                        if (string17.matches(string15)) {
                            this.extractPositionFit(true);
                            continue;
                        }
                        if (string17.matches(string14)) {
                            this.extractdsRange(string17);
                            this.setIgnoreOptionDsRange(false);
                            continue;
                        }
                        if (string17.matches(string11)) {
                            this.extractHKLS(string17);
                            this.ignoreOptionHKL = false;
                            continue;
                        }
                        if (!string17.matches(string16)) continue;
                        this.extractRandom(string17);
                        this.ignoreOptionRandom = false;
                    }
                }
                catch (IOException iOException) {
                    this.manageError("parseIniFile()", "Error while opening or reading ini file " + string);
                    if (bufferedReader == null) break block27;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        this.manageError("parseIniFile()", iOException2.getMessage());
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        this.manageError("parseIniFile()", iOException.getMessage());
                    }
                }
            }
        }
    }

    private void resetRange() {
        this.etaRange.removeAllElements();
        this.omegaRange.removeAllElements();
        this.dsRange.removeAllElements();
        this.tthRange.removeAllElements();
    }

    private void manageError(String string, String string2) throws GrainSpotterException {
        this.logger.error((Object)string2);
        throw new GrainSpotterException(0, this.getClass().getName(), string, string2);
    }

    public void extractSpaceGroup(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setSpaceGroup(Integer.valueOf(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractDataSpecs(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            this.setGveFileName(stringArray[1]);
            this.setLogFileName(stringArray[2]);
        }
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public void setGveFileName(String string) {
        this.gveFileName = string;
    }

    public void extractDOmega(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setDeltaOmegaSpecs(Float.parseFloat(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractCuts(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            try {
                this.setMinMeasurementCuts(Integer.parseInt(stringArray[1]));
                this.setMinCompletenessCuts(Float.parseFloat(stringArray[2]));
                this.setMinMeasurementUniqueness(Float.parseFloat(stringArray[3]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractStepEuler(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setStepEuler(Float.parseFloat(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractUncertanties(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 4) {
            try {
                this.setTtUncertainties(Float.parseFloat(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.setEtaUncertainties(Float.parseFloat(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.setOmegaUncertainties(Float.parseFloat(stringArray[3]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractNSigmas(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setNSigmas(Float.parseFloat(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractHKLS(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setNHKLs(Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractthRange(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            try {
                this.addTthRange(Float.valueOf(stringArray[1]).floatValue(), Float.valueOf(stringArray[2]).floatValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractMinFracg(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setMinfracg(Float.parseFloat(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractPositionFit(boolean bl) {
        this.setPositionFit(bl);
    }

    public void extractdsRange(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            try {
                this.addDsRange(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractOmegaRange(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            try {
                this.addOmegaRange(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractTthRange(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            try {
                this.addTthRange(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractEtaRange(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 3) {
            try {
                this.addEtaRange(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractRandom(String string) {
        String[] stringArray = string.split("\\p{Space}");
        if (stringArray.length >= 2) {
            try {
                this.setRandom(Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void set_deltaOmegaSpecs(String string) throws GrainSpotterException {
        try {
            this.setDeltaOmegaSpecs(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_deltaOmegaSpecs", numberFormatException.getMessage());
        }
    }

    public void set_etaUncertanties(String string) throws GrainSpotterException {
        try {
            this.setEtaUncertanties(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_etaUncertanties", numberFormatException.getMessage());
        }
    }

    public void setMaxEtatSpecs(float f) throws GrainSpotterException {
        if (!(f >= 0.0f) || !(f <= 360.0f)) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_maxEtatSpecs", "Max EtatSpecs out of range");
        }
        this.maxEtatSpecs = f;
    }

    public HashMap<String, String> getOptions() {
        return this.options;
    }

    public float getMinMeasurementUniqueness() {
        return this.cutsMinUniqueness;
    }

    public void setMinMeasurementUniqueness(float f) {
        this.cutsMinUniqueness = f;
    }

    public void set_minCompletenessCuts(float f) throws GrainSpotterException {
        if (!((double)f >= 0.0) || !((double)f <= 1.0)) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_minCompletenessCuts", "min completness value out of range");
        }
        this.setMinCompletenessCuts(f);
    }

    public void set_minEtatSpecs(float f) throws GrainSpotterException {
        if (!(f >= 0.0f) || !(f <= 360.0f)) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_minEtatSpecs", "min EtatSpecs out of range");
        }
        this.setMinEtatSpecs(f);
    }

    public void set_minEtatSpecs(String string) throws GrainSpotterException {
        try {
            this.set_minEtatSpecs(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_minEtatSpecs", numberFormatException.getMessage());
        }
    }

    public void setMinMeasurementUniqueness(String string) throws GrainSpotterException {
        try {
            this.setMinMeasurementUniqueness(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "setMinMeasurementUniqueness", numberFormatException.getMessage());
        }
    }

    public void set_minMeasurementCuts(int n) {
        this.setMinMeasurementCuts(n);
    }

    public void set_minMeasurementCuts(String string) throws GrainSpotterException {
        try {
            this.set_minMeasurementCuts(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_minMeasurementCuts", numberFormatException.getMessage());
        }
    }

    public void set_omegaUncertanties(float f) {
        this.setOmegaUncertainties(f);
    }

    public void set_omegaUncertanties(String string) throws GrainSpotterException {
        try {
            this.set_omegaUncertanties(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_omegaUncertanties", numberFormatException.getMessage());
        }
    }

    public void set_spaceGroup(int n) throws GrainSpotterException {
        if (n < 1 || n > 230) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_spaceGroup", "Invalid value for spaceGroup");
        }
        this.setSpaceGroup(n);
    }

    public void set_ttUncertanties(float f) {
        this.setTtUncertainties(f);
    }

    public void set_ttUncertanties(String string) throws GrainSpotterException {
        try {
            this.set_ttUncertanties(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_ttUncertanties", numberFormatException.getMessage());
        }
    }

    public void set_stepEuler(float f) {
        this.setStepEuler(f);
    }

    public void set_stepEuler(String string) throws GrainSpotterException {
        try {
            this.set_stepEuler(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_stepEuler", numberFormatException.getMessage());
        }
    }

    private void set_nHKLs(int n) {
        this.setNHKLs(n);
    }

    public void set_nHKLs(String string) throws GrainSpotterException {
        try {
            this.set_nHKLs(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_nHKLs", numberFormatException.getMessage());
        }
    }

    public void set_nSigmas(float f) {
        this.setNSigmas(f);
    }

    public void set_nSigmas(String string) throws GrainSpotterException {
        try {
            this.set_nSigmas(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_nSigmas", numberFormatException.getMessage());
        }
    }

    public void set_maxEtatSpecs(String string) throws GrainSpotterException {
        try {
            this.setMaxEtatSpecs(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_maxEtatSpecs", numberFormatException.getMessage());
        }
    }

    public void set_minCompletenessCuts(String string) throws GrainSpotterException {
        try {
            this.set_minCompletenessCuts(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_minCompletenessCuts", numberFormatException.getMessage());
        }
    }

    public void addOmegaRange(String string, String string2) throws GrainSpotterException {
        try {
            this.addOmegaRange(Float.valueOf(string).floatValue(), Float.valueOf(string2).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", numberFormatException.getMessage());
        }
    }

    public void addEtaRange(String string, String string2) throws GrainSpotterException {
        try {
            this.addEtaRange(Float.valueOf(string).floatValue(), Float.valueOf(string2).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", numberFormatException.getMessage());
        }
    }

    public void addtthRange(String string, String string2) throws GrainSpotterException {
        try {
            this.addTthRange(Float.valueOf(string).floatValue(), Float.valueOf(string2).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", numberFormatException.getMessage());
        }
    }

    public void addDsRange(String string, String string2) throws GrainSpotterException {
        try {
            this.addDsRange(Float.valueOf(string).floatValue(), Float.valueOf(string2).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", numberFormatException.getMessage());
        }
    }

    public void ignoreOptionDeltaOmegaSpecs(boolean bl) {
        this.ignoreOptionDeltaOmegaSpec = bl;
    }

    public void ignoreOptionCuts(boolean bl) {
        this.ignoreOptionCuts = bl;
    }

    public void ignoreOptionEuler(boolean bl) {
        this.ignoreOptionEuler = bl;
    }

    public void ignoreOptionUncertainties(boolean bl) {
        this.ignoreOptionUncertainties = bl;
    }

    public void ignoreOptionNSigma(boolean bl) {
        this.ignoreOptionNSigma = bl;
    }

    public void ignoreOptionHKL(boolean bl) {
        this.ignoreOptionHKL = bl;
    }

    public void ignoreOptionMinfracg(boolean bl) {
        this.ignoreOptionMinfracg = bl;
    }

    public void ignoreOptionRandom(boolean bl) {
        this.ignoreOptionRandom = bl;
    }

    public void setMinfracg(String string) throws GrainSpotterException {
        try {
            this.setMinfracg(Float.valueOf(string).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "setMinfracg", numberFormatException.getMessage());
        }
    }

    public void setRandom(String string) throws GrainSpotterException {
        try {
            this.setRandom(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", numberFormatException.getMessage());
        }
    }

    public boolean isIgnoreOptionDeltaOmegaSpec() {
        return this.ignoreOptionDeltaOmegaSpec;
    }

    public boolean isIgnoreOptionEuler() {
        return this.ignoreOptionEuler;
    }

    public boolean isIgnoreOptionUncertainties() {
        return this.ignoreOptionUncertainties;
    }

    public boolean isIgnoreOptionNSigma() {
        return this.ignoreOptionNSigma;
    }

    public boolean isIgnoreOptionHKL() {
        return this.ignoreOptionHKL;
    }

    public boolean isIgnoreOptionMinfracg() {
        return this.ignoreOptionMinfracg;
    }

    public boolean isIgnoreOptionRandom() {
        return this.ignoreOptionRandom;
    }

    public boolean isIgnoreOptionCuts() {
        return this.ignoreOptionCuts;
    }

    public void setIgnoreOptionDsRange(boolean bl) {
        this.ignoreOptionDsRange = bl;
    }

    public boolean isIgnoreOptionDsRange() {
        return this.ignoreOptionDsRange;
    }

    public void setLogFilePath(String string) {
        this.logFilePath = string;
    }
}

