/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.LogFile;
import fable.grainspotter.view.OutputView;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorViewPart;

public class GrainSpotter {
    private GrainspotterIniInput input;
    private String grainspotterCommand = "GrainSpotter";
    private String grainspotterPath = ".";
    private GrainSpotterThread grainspotterThread;
    private Process grainspotterProcess;
    public ArrayList<double[]> gveXYZ = new ArrayList();
    private static GrainSpotter grainspotter;
    public ArrayList<int[]> grainGvectors = new ArrayList();
    private Runtime runtime;
    private String pathSeparator = System.getProperty("file.separator");
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    protected IProgressMonitor grainspotterMonitor;
    private String gvectorFile;
    IPropertyChangeListener preferencesListener;
    private LogFile logFile;

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (!this.myListeners.contains(iPropertyChangeListener)) {
            this.myListeners.add(iPropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.myListeners.remove(iPropertyChangeListener);
    }

    private GrainSpotter() {
        this.grainspotterThread = new GrainSpotterThread();
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("pref_cmd_grainspotter")) {
                    GrainSpotter.this.setGrainspotterCommand(Activator.getDefault().getPreferenceStore().getString("pref_cmd_grainspotter"));
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        this.setGrainspotterCommand(Activator.getDefault().getPreferenceStore().getString("pref_cmd_grainspotter"));
    }

    public void dispose() {
        if (grainspotter != null) {
            this.myListeners.removeAll(this.myListeners);
        }
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null && grainspotter != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
            grainspotter = null;
        }
    }

    public void run() {
        this.fireStateChange("running");
        Job job = new Job("Running GrainSpotter " + this.input.getInputFile().iniFileName){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                GrainSpotter.this.grainspotterMonitor = iProgressMonitor;
                GrainSpotter.this.grainspotterMonitor.beginTask("Running GrainSpotter " + ((GrainSpotter)GrainSpotter.this).input.getInputFile().iniFileName + " ... ", 100);
                GrainSpotter.this.grainspotterMonitor.subTask("Building lookuptables");
                GrainSpotter.this.grainspotterMonitor.worked(1);
                GrainSpotter.this.grainspotterThread.run();
                GrainSpotter.this.grainspotterMonitor.done();
                GrainSpotter.this.fireStateChange("running");
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void stop() {
        this.fireStateChange("stopped");
        this.grainspotterProcess.destroy();
        final Cursor cursor = new Cursor((Device)Display.getDefault(), 0);
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    iWorkbenchWindow.getShell().setCursor(cursor);
                }
            });
        }
    }

    public void fireStateChange(String string) {
        for (IPropertyChangeListener iPropertyChangeListener : this.myListeners) {
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "grainspotter", null, (Object)string));
        }
    }

    public boolean gsCommandCanRun() {
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(this.grainspotterCommand);
        }
        catch (IOException iOException) {
            FableMessageConsole.console.displayError("Failed to execute the GrainSpotter command = " + this.grainspotterCommand + " !");
            FableMessageConsole.console.displayError("Check the path is correct and you have the right (execute) permissions");
            return false;
        }
        return true;
    }

    public String[] makeGSBatchCommand() {
        String[] stringArray = new String[3];
        String string = System.getProperty("os.name");
        File file = new File(this.grainspotterCommand);
        if (!file.exists()) {
            FableMessageConsole.console.displayError("The GrainSpotter command = " + this.grainspotterCommand + ", does not exist !");
            FableMessageConsole.console.displayError("Check the path is correct and the command exists (hint: use Edit -> Preferences to select the grainspotter command");
            return null;
        }
        try {
            if (string.toLowerCase().contains("windows")) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bat"));
                if (this.input.getInputFile().iniFilePath.length() >= 2) {
                    bufferedWriter.write(this.input.getInputFile().iniFilePath.substring(0, 2));
                }
                bufferedWriter.newLine();
                bufferedWriter.write("cd \"" + this.input.getInputFile().iniFilePath + "\"");
                bufferedWriter.newLine();
                bufferedWriter.write("\"" + this.grainspotterCommand + "\" " + this.input.getInputFile().iniFileName);
                bufferedWriter.close();
                stringArray[0] = "cmd.exe";
                stringArray[1] = "/C";
                stringArray[2] = String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bat";
            } else {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bash"));
                bufferedWriter.write("cd \"" + this.input.getInputFile().iniFilePath + "\"");
                bufferedWriter.newLine();
                bufferedWriter.write("\"" + this.grainspotterCommand + "\" " + this.input.getInputFile().iniFileName);
                bufferedWriter.close();
                stringArray[0] = "/bin/bash";
                stringArray[1] = String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bash";
                stringArray[2] = " ";
            }
        }
        catch (IOException iOException) {
            FableMessageConsole.console.displayError("Failed to create grainspotter batch file in directory : " + this.input.getInputFile().iniFilePath);
            FableMessageConsole.console.displayError("Check the path is correct and you have the right (write) permissions");
            return null;
        }
        return stringArray;
    }

    public String getGrainspotterCommand() {
        return this.grainspotterCommand;
    }

    public void setGrainspotterCommand(String string) {
        this.grainspotterCommand = string;
    }

    public void setgVectorFile(String string) {
        this.gvectorFile = string;
        this.fireNewGveFileToParse();
    }

    private void fireNewGveFileToParse() {
        for (IPropertyChangeListener iPropertyChangeListener : this.myListeners) {
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "new gve file", (Object)this.input.getInputFile().iniFilePath, (Object)this.gvectorFile));
        }
    }

    public String getGrainspotterPath() {
        return this.grainspotterPath;
    }

    public void setGrainspotterPath(String string) {
        this.grainspotterPath = string;
    }

    public String getIniFilePath() {
        return this.input.getInputFile().iniFilePath;
    }

    public void setIniFilePath(String string) {
        this.input.getInputFile().iniFilePath = string;
        if (this.input.getInputFile().gveFilePath.equals("")) {
            this.setGveFilePath(string);
        }
        if (this.input.getInputFile().logFilePath.equals("")) {
            this.setLogFilePath(string);
        }
    }

    public String getGveFilePath() {
        return this.input.getInputFile().gveFilePath;
    }

    public void setGveFilePath(String string) {
        this.input.getInputFile().gveFilePath = string;
    }

    public String getLogFilePath() {
        return this.input.getInputFile().logFilePath;
    }

    public void setLogFilePath(String string) {
        this.input.getInputFile().logFilePath = string;
        this.setLogFile(new LogFile(string));
    }

    private void fireLogFileHasBeenSet() {
        for (IPropertyChangeListener iPropertyChangeListener : this.myListeners) {
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "new log file", (Object)this.input.getInputFile().iniFilePath, (Object)this.getLogFile()));
        }
    }

    public String getIniFileName() {
        return String.valueOf(this.input.getInputFile().iniFilePath) + this.pathSeparator + this.input.getInputFile().iniFileName;
    }

    public void setIniFileName(String string) {
        if (string.indexOf(this.pathSeparator) >= 0) {
            this.input.getInputFile().iniFilePath = string.substring(string.lastIndexOf(this.pathSeparator) + 1);
            this.input.getInputFile().iniFilePath = string.substring(0, string.lastIndexOf(this.pathSeparator) + 1);
        } else {
            this.input.getInputFile().iniFileName = string;
        }
    }

    public void setLogFileName(String string) {
        if (string.indexOf(this.pathSeparator) >= 0) {
            this.input.getInputFile().logFileName = string.substring(string.lastIndexOf(this.pathSeparator) + 1);
            this.input.getInputFile().logFilePath = string.substring(0, string.lastIndexOf(this.pathSeparator));
        } else {
            this.input.getInputFile().logFilePath = this.input.getInputFile().iniFilePath;
            this.input.getInputFile().logFileName = string;
        }
    }

    public String getLogFileName() {
        if (this.input.getInputFile().logFilePath.equals("")) {
            this.setLogFilePath(this.input.getInputFile().iniFilePath);
        }
        return String.valueOf(this.input.getInputFile().logFilePath) + this.pathSeparator + this.input.getInputFile().logFileName;
    }

    public static GrainSpotter getInstance() {
        if (grainspotter == null) {
            grainspotter = new GrainSpotter();
        }
        return grainspotter;
    }

    public GrainspotterIniInput getInput() {
        return this.input;
    }

    public void setInput(IEditorInput iEditorInput) {
        this.input = (GrainspotterIniInput)iEditorInput;
    }

    public void setLogFile(LogFile logFile) {
        this.logFile = logFile;
        this.fireLogFileHasBeenSet();
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public ArrayList<double[]> getGveXYZ() {
        return this.gveXYZ;
    }

    public void setGveXYZ(ArrayList<double[]> arrayList) {
        this.gveXYZ = arrayList;
    }

    class GrainSpotterThread
    implements Runnable {
        String outputMessage;
        private StreamReaderThread outThread;
        private StreamReaderThread errThread;

        GrainSpotterThread() {
        }

        @Override
        public void run() {
            boolean bl;
            block7: {
                bl = false;
                try {
                    String[] stringArray;
                    GrainSpotter.this.runtime = Runtime.getRuntime();
                    if (GrainSpotter.this.gsCommandCanRun() && (stringArray = GrainSpotter.this.makeGSBatchCommand()) != null) {
                        GrainSpotter.this.grainspotterProcess = GrainSpotter.this.runtime.exec(stringArray);
                        this.outThread = new StreamReaderThread(GrainSpotter.this.grainspotterProcess.getInputStream());
                        this.errThread = new StreamReaderThread(GrainSpotter.this.grainspotterProcess.getErrorStream());
                        this.outThread.start();
                        this.errThread.start();
                        GrainSpotter.this.grainspotterProcess.waitFor();
                        bl = true;
                        this.outThread.join();
                        this.errThread.join();
                    }
                    this.outThread.setStopped(true);
                    this.errThread.setStopped(true);
                    GrainSpotter.this.fireStateChange("stopped");
                }
                catch (IOException iOException) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError(iOException.getMessage());
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (FableMessageConsole.console == null) break block7;
                    FableMessageConsole.console.displayError(interruptedException.getMessage());
                }
            }
            if (!Display.getDefault().isDisposed() && bl) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        Object object2;
                        Object var1_1 = null;
                        try {
                            object2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            object = object2.getActivePage();
                            object.showView("fable.grainspotter.view.outputview");
                        }
                        catch (PartInitException partInitException) {
                            FableMessageConsole.console.displayError("Exception occurred showing OutputView: " + (Object)((Object)partInitException) + "\n" + partInitException.getMessage());
                            partInitException.printStackTrace();
                        }
                        if (var1_1 instanceof ErrorViewPart) {
                            FableMessageConsole.console.displayError("Error showing OutputView");
                            return;
                        }
                        object2 = GrainSpotter.this.input.getInputFile().getLogFileName();
                        if (!ToolBox.checkIfFileExists((String)object2)) {
                            object = System.getProperty("file.separator");
                            int n = ((String)object2).lastIndexOf((String)object);
                            if (n > 0 && n < ((String)object2).length()) {
                                object2 = ((String)object2).substring(n);
                            }
                            object2 = String.valueOf(GrainSpotter.this.input.getInputFile().getIniFilePath()) + (String)object + (String)object2;
                        }
                        if (ToolBox.checkIfFileExists((String)object2)) {
                            OutputView.view.loadLogFile((String)object2);
                        } else if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayError("Log file " + (String)object2 + " nor found.");
                        }
                    }
                });
            }
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Cursor cursor = new Cursor((Device)Display.getDefault(), 0);
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        iWorkbenchWindow.getShell().setCursor(cursor);
                    }
                });
            }
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;
        private boolean stopped = false;

        public StreamReaderThread(InputStream inputStream) {
            this.inStream = inputStream;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while ((this.outputMessage = bufferedReader.readLine()) != null) {
                    if (this.outputMessage.indexOf("ngrain") != -1) {
                        ++n3;
                    }
                    if (this.outputMessage.indexOf("completed") != -1 && GrainSpotter.this.grainspotterMonitor != null) {
                        int n4 = this.outputMessage.indexOf("%");
                        String string = this.outputMessage.charAt(n4 - 2) == ' ' ? this.outputMessage.substring(n4 - 1, n4) : this.outputMessage.substring(n4 - 2, n4);
                        n = Integer.parseInt(string);
                        GrainSpotter.this.grainspotterMonitor.subTask("Looking for grains - " + n3 + " grains found so far");
                        GrainSpotter.this.grainspotterMonitor.worked(n - n2);
                        n2 = n;
                    }
                    if (Display.getDefault().isDisposed()) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FableMessageConsole.console.displayOut(StreamReaderThread.this.outputMessage);
                        }
                    });
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void setStopped(boolean bl) {
            this.stopped = bl;
        }
    }
}

