/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.providers;

import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.rcp.Activator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GrainspotterLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/greendot.gif");
    private ImageDescriptor matrixDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/umatrix3.gif");
    private ImageDescriptor infoDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/greendotinfo.gif");
    private ImageDescriptor ubiDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/ubi3.gif");
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(11);
    final Color light_green = new Color((Device)Display.getCurrent(), 228, 250, 240);

    public void dispose() {
        Iterator<Image> iterator = this.imageCache.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.imageCache.clear();
        if (this.light_green != null) {
            this.light_green.dispose();
        }
    }

    public Image getColumnImage(Object object, int n) {
        Image image = this.imageCache.get(this.descriptor);
        Image image2 = this.imageCache.get(this.matrixDescriptor);
        Image image3 = this.imageCache.get(this.infoDescriptor);
        Image image4 = this.imageCache.get(this.ubiDescriptor);
        if (image2 == null) {
            image2 = this.matrixDescriptor.createImage();
            this.imageCache.put(this.matrixDescriptor, image2);
        }
        if (image4 == null) {
            image4 = this.ubiDescriptor.createImage();
            this.imageCache.put(this.ubiDescriptor, image4);
        }
        if (image3 == null) {
            image3 = this.infoDescriptor.createImage();
            this.imageCache.put(this.infoDescriptor, image3);
        }
        if (image == null) {
            image = this.descriptor.createImage();
            this.imageCache.put(this.descriptor, image);
        }
        if (n == 0) {
            if (object instanceof GrainSyntaxModel) {
                return image;
            }
            if (object instanceof GrainUBIMatrixModel) {
                return image4;
            }
            if (object instanceof GrainUMatrixModel) {
                return image2;
            }
            if (object instanceof GrainInfoModel) {
                return image3;
            }
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        if (n == 0) {
            if (object instanceof GrainSyntaxModel) {
                return ((GrainSyntaxModel)object).toString();
            }
            if (object instanceof GrainInfoModel) {
                return ((GrainInfoModel)object).getKey();
            }
            if (object instanceof GrainUMatrixModel) {
                return ((GrainUMatrixModel)object).toString();
            }
        } else if (n == 1 && object instanceof GrainInfoModel) {
            return ((GrainInfoModel)object).getValue();
        }
        return "";
    }

    public Color getBackground(Object object) {
        if (object instanceof GrainSyntaxModel) {
            return this.light_green;
        }
        return Display.getCurrent().getSystemColor(1);
    }

    public Color getForeground(Object object) {
        return null;
    }
}

