/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.preferences;

import java.util.regex.Pattern;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

class FloatFieldEditor
extends StringFieldEditor {
    Float _minValue = null;
    Float _maxValue = null;
    boolean _maxValueIsIncluded = true;
    boolean _minValueIsIncluded = true;

    public FloatFieldEditor(Float f, Float f2) {
        this._minValue = f;
        this._maxValue = f2;
        this._maxValueIsIncluded = true;
        this._minValueIsIncluded = true;
    }

    public FloatFieldEditor() {
    }

    public FloatFieldEditor(String string, String string2, Composite composite, Float f, Float f2) {
        super(string, string2, composite);
        this._minValue = f;
        this._maxValue = f2;
        this._maxValueIsIncluded = true;
        this._minValueIsIncluded = true;
    }

    public FloatFieldEditor(String string, String string2, Composite composite) {
        super(string, string2, composite);
    }

    public void setMinValue(float f, boolean bl) {
        this._minValue = new Float(f);
        this._minValueIsIncluded = bl;
    }

    public void setMaxValue(float f, boolean bl) {
        this._maxValue = new Float(f);
        this._maxValueIsIncluded = bl;
    }

    protected boolean checkState() {
        boolean bl = true;
        if (this.getStringValue().compareTo("") == 0 && !this.isEmptyStringAllowed()) {
            bl = false;
            this.setErrorMessage("Field should contain a float value");
            this.showErrorMessage();
        } else {
            Pattern pattern = Pattern.compile("[ \\D &&[^\\.]&&[^-]]");
            if (pattern.matcher(this.getStringValue()).find()) {
                this.setErrorMessage("Field should contain a float value");
                this.showErrorMessage();
                bl = false;
            } else {
                this.clearErrorMessage();
                try {
                    float f = Float.parseFloat(this.getStringValue());
                    if (this._minValue != null && this._maxValue != null) {
                        if (this._minValueIsIncluded && this._maxValueIsIncluded) {
                            bl = Float.compare(f, this._minValue.floatValue()) >= 0 && Float.compare(f, this._maxValue.floatValue()) <= 0;
                            this.setErrorMessage("Field should contain a float value between " + this._minValue + " and " + this._maxValue);
                        } else if (!this._minValueIsIncluded && !this._maxValueIsIncluded) {
                            bl = Float.compare(f, this._minValue.floatValue()) > 0 && Float.compare(f, this._maxValue.floatValue()) < 0;
                            this.setErrorMessage("Field should contain a float value greater than " + this._minValue + "  and less than " + this._maxValue);
                        } else if (!this._minValueIsIncluded && this._maxValueIsIncluded) {
                            bl = Float.compare(f, this._minValue.floatValue()) > 0 && Float.compare(f, this._maxValue.floatValue()) <= 0;
                            this.setErrorMessage("Field should contain a float value greater than " + this._minValue + "  and less or equal than " + this._maxValue);
                        } else if (this._minValueIsIncluded && !this._maxValueIsIncluded) {
                            bl = Float.compare(f, this._minValue.floatValue()) >= 0 && Float.compare(f, this._maxValue.floatValue()) < 0;
                            this.setErrorMessage("Field should contain a float value greater or equel than " + this._minValue + "  and less than " + this._maxValue);
                        }
                    } else if (this._minValue == null && this._maxValue != null) {
                        if (this._maxValueIsIncluded) {
                            bl = Float.compare(f, this._maxValue.floatValue()) <= 0;
                            this.setErrorMessage("Field should contain a float value less or equal than " + this._maxValue);
                        } else {
                            bl = Float.compare(f, this._maxValue.floatValue()) < 0;
                            this.setErrorMessage("Field should contain a float value less than " + this._maxValue);
                        }
                    } else if (this._minValue != null && this._maxValue == null) {
                        if (this._minValueIsIncluded) {
                            bl = Float.compare(f, this._minValue.floatValue()) >= 0;
                            this.setErrorMessage("Field should contain a float value greater or equal than " + this._minValue);
                        } else {
                            bl = Float.compare(f, this._minValue.floatValue()) > 0;
                            this.setErrorMessage("Field should contain a float value greater than " + this._minValue);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            if (bl) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage();
            }
        }
        return bl;
    }
}

