/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.modelviewer;

import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainMeanModel;
import fable.grainspotter.modelviewer.GrainModel;
import fable.grainspotter.modelviewer.GrainOrientationEulerAngleModel;
import fable.grainspotter.modelviewer.GrainOrientationQuaternionModel;
import fable.grainspotter.modelviewer.GrainOrientationRModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.modelviewer.IModelVisitor;
import java.util.ArrayList;
import java.util.List;

public class GrainSyntaxModel
extends GrainModel {
    protected List<GrainSyntaxModel> grains = new ArrayList<GrainSyntaxModel>();
    protected List<GrainInfoModel> info = new ArrayList<GrainInfoModel>();
    protected List<GrainMeanModel> mean = new ArrayList<GrainMeanModel>();
    protected List<GrainUMatrixModel> Umatrix = new ArrayList<GrainUMatrixModel>();
    protected List<GrainUBIMatrixModel> UBImatrix = new ArrayList<GrainUBIMatrixModel>();
    protected List<GrainOrientationRModel> orientationRodrigues = new ArrayList<GrainOrientationRModel>();
    protected List<GrainOrientationQuaternionModel> orientationQuaternion = new ArrayList<GrainOrientationQuaternionModel>();
    protected List<GrainOrientationEulerAngleModel> orientationEuler = new ArrayList<GrainOrientationEulerAngleModel>();
    protected List<GrainGvectorModel> gvectors = new ArrayList<GrainGvectorModel>();
    private int gvecsMeasured = 0;
    private int gvecExpected = 0;
    private static IModelVisitor adder = new Adder();

    public GrainSyntaxModel(String string) {
        this();
        this.id = string;
        this.setName();
    }

    public void setName() {
        this.setName("Grain #" + this.id);
    }

    public GrainSyntaxModel() {
    }

    private void addInfo(GrainInfoModel grainInfoModel) {
        this.info.add(grainInfoModel);
        grainInfoModel.parent = this;
    }

    private void addMean(GrainMeanModel grainMeanModel) {
        this.mean.add(grainMeanModel);
        grainMeanModel.parent = this;
    }

    private void addUMatrix(GrainUMatrixModel grainUMatrixModel) {
        this.Umatrix.add(grainUMatrixModel);
        grainUMatrixModel.parent = this;
    }

    private void addUBIMatrix(GrainUBIMatrixModel grainUBIMatrixModel) {
        this.UBImatrix.add(grainUBIMatrixModel);
        grainUBIMatrixModel.parent = this;
    }

    private void addOrientationR(GrainOrientationRModel grainOrientationRModel) {
        this.orientationRodrigues.add(grainOrientationRModel);
        grainOrientationRModel.parent = this;
    }

    private void addOrientationQ(GrainOrientationQuaternionModel grainOrientationQuaternionModel) {
        this.orientationQuaternion.add(grainOrientationQuaternionModel);
        grainOrientationQuaternionModel.parent = this;
    }

    private void addOrientationEuler(GrainOrientationEulerAngleModel grainOrientationEulerAngleModel) {
        this.orientationEuler.add(grainOrientationEulerAngleModel);
        grainOrientationEulerAngleModel.parent = this;
    }

    private void addGvector(GrainGvectorModel grainGvectorModel) {
        this.gvectors.add(grainGvectorModel);
        grainGvectorModel.parent = this;
    }

    private void addGrain(GrainSyntaxModel grainSyntaxModel) {
        this.grains.add(grainSyntaxModel);
        grainSyntaxModel.parent = this;
    }

    public List<GrainInfoModel> getInfo() {
        return this.info;
    }

    public List<GrainMeanModel> getmean() {
        return this.mean;
    }

    public List<GrainUMatrixModel> getUMatrix() {
        return this.Umatrix;
    }

    public List<GrainUBIMatrixModel> getUBIMatrix() {
        return this.UBImatrix;
    }

    public List<GrainOrientationRModel> getOrientationRodrigues() {
        return this.orientationRodrigues;
    }

    public List<GrainOrientationQuaternionModel> getOrientationQuaternion() {
        return this.orientationQuaternion;
    }

    public List<GrainOrientationEulerAngleModel> getOrientationEuList() {
        return this.orientationEuler;
    }

    public List<GrainSyntaxModel> getGrains() {
        return this.grains;
    }

    public List<GrainGvectorModel> getGVectors() {
        return this.gvectors;
    }

    public void add(GrainModel grainModel) {
        grainModel.accept(adder, this);
    }

    public void add(GrainGvectorModel grainGvectorModel) {
        grainGvectorModel.accept(adder, this);
    }

    @Override
    public void accept(IModelVisitor iModelVisitor, Object object) {
        iModelVisitor.visitSyntax(this, object);
    }

    public String toString() {
        return this.getName();
    }

    public void add(GrainInfoModel grainInfoModel, String string) {
    }

    public void addGveMeasured(String string) {
        try {
            int n = Integer.valueOf(string);
            this.gvecsMeasured += n;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public int getGvecsMeasured() {
        return this.gvecsMeasured;
    }

    public void setGvecsMeasured(int n) {
        this.gvecsMeasured = n;
    }

    public int getgvecExpected() {
        return this.gvecExpected;
    }

    public void setgvecExpected(int n) {
        this.gvecExpected = n;
    }

    public void addGveExpected(String string) {
        try {
            int n = Integer.valueOf(string);
            this.gvecExpected += n;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static class Adder
    implements IModelVisitor {
        private Adder() {
        }

        @Override
        public void visitGrainInfo(GrainInfoModel grainInfoModel, Object object) {
            ((GrainSyntaxModel)object).addInfo(grainInfoModel);
        }

        @Override
        public void visitGrainUMatrix(GrainUMatrixModel grainUMatrixModel, Object object) {
            ((GrainSyntaxModel)object).addUMatrix(grainUMatrixModel);
        }

        @Override
        public void visitSyntax(GrainSyntaxModel grainSyntaxModel, Object object) {
            ((GrainSyntaxModel)object).addGrain(grainSyntaxModel);
        }

        @Override
        public void visitGVector(GrainGvectorModel grainGvectorModel, Object object) {
            ((GrainSyntaxModel)object).addGvector(grainGvectorModel);
        }

        @Override
        public void visitGrainMeanIA(GrainMeanModel grainMeanModel, Object object) {
            ((GrainSyntaxModel)object).addMean(grainMeanModel);
        }

        @Override
        public void visitGrainPhiOrientation(GrainOrientationEulerAngleModel grainOrientationEulerAngleModel, Object object) {
            ((GrainSyntaxModel)object).addOrientationEuler(grainOrientationEulerAngleModel);
        }

        @Override
        public void visitGrainQorienation(GrainOrientationQuaternionModel grainOrientationQuaternionModel, Object object) {
            ((GrainSyntaxModel)object).addOrientationQ(grainOrientationQuaternionModel);
        }

        @Override
        public void visitGrainRorientation(GrainOrientationRModel grainOrientationRModel, Object object) {
            ((GrainSyntaxModel)object).addOrientationR(grainOrientationRModel);
        }

        @Override
        public void visitGrainUBIMatrix(GrainUBIMatrixModel grainUBIMatrixModel, Object object) {
            ((GrainSyntaxModel)object).addUBIMatrix(grainUBIMatrixModel);
        }
    }
}

