/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.actions.RunAction;
import fable.grainspotter.actions.SaveAsInifile;
import fable.grainspotter.actions.SaveInifile;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterTextEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import java.io.File;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.examples.rcp.texteditor.editors.SimpleEditor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GrainspotterInputEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IPropertyChangeListener,
IReusableEditor {
    private static final String ID = "fable.grainspotter.editors.GrainspotterInputEditor";
    private SimpleEditor editor;
    private GrainspotterIniInput input;
    private boolean dirty = false;
    private Spinner spaceGroupSpinner;
    private Combo spaceGroupCombo;
    private Combo spaceGroupTypeCombo;
    private Table dsRange;
    private Table tthRange;
    private Table etaRange;
    private Table omegaRange;
    private StringText txtFilegve;
    private StringText txtFilelog;
    private IntegerText cutsMinMeasurement;
    private FloatText cutsMinCompletenessText;
    private FloatText cutsMinUniqueness;
    private FloatText eulerStep;
    private FloatText minfracg;
    private IntegerText random;
    private Button fitpositionYes;
    private Button fitpositionFalse;
    private FloatText sigmaTth;
    private FloatText sigmaEta;
    private FloatText sigmaOmega;
    private FloatText nsigma;
    private int spaceGroup = 1;
    private int spaceGroupType = 0;
    private static String command = "GrainSpotter";
    public static GrainSpotter grainSpotter;
    private static final int numColIniGroup = 2;
    private static final int MAXROWS = 1;
    private Shell shell;
    private Display display;
    private Composite parent;
    private IMemento memento = null;
    private static String initialDirIni;
    private static String initialDirGve;
    private static String initialDirLog;
    protected int activeColumn;
    private FloatText omegaDeltaText;
    private Group tthRangeGroup;
    private Group dsGroup;
    ImageDescriptor deleteDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/delete.gif");
    ImageDescriptor addDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/add.gif");
    private IntegerText hklRingsText;
    private Button chooseDspacing;
    private Button chooseTthRange;
    private SaveInifile save;
    private SaveAsInifile saveas;

    static {
        initialDirIni = null;
        initialDirGve = null;
        initialDirLog = null;
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.save();
    }

    public void save() {
        this.getEditorSite().getWorkbenchWindow();
        if (this.setOptions()) {
            block3: {
                this.dirty = false;
                this.firePropertyChange(257);
                try {
                    this.input.getInputFile().save();
                }
                catch (GrainSpotterException grainSpotterException) {
                    if (FableMessageConsole.console == null) break block3;
                    FableMessageConsole.console.displayError(grainSpotterException.get_message());
                    SWTUtils.errMsgAsync((String)grainSpotterException.get_message());
                }
            }
            this.firePropertyChange(258);
            this.setInput((IEditorInput)this.input);
            GrainSpotter.getInstance().setInput((IEditorInput)this.input);
        }
    }

    public void doSaveAs() {
        if (this.setOptions()) {
            FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
            String string = fileDialog.open();
            boolean bl = true;
            if (string != null && ToolBox.checkIfFileExists((String)string)) {
                bl = FableUtils.confirmMsg((Object)((Object)this), (String)(String.valueOf(string) + " already exists. Do you want to overwrite it?"));
            }
            if (bl) {
                this.doSaveAs(string);
            }
        }
    }

    public void doSaveAs(String string) {
        block2: {
            this.firePropertyChange(258);
            try {
                this.input.getInputFile().saveAs(string);
            }
            catch (GrainSpotterException grainSpotterException) {
                if (FableMessageConsole.console == null) break block2;
                FableMessageConsole.console.displayError(grainSpotterException.get_message());
                SWTUtils.errMsgAsync((String)grainSpotterException.get_message());
            }
        }
        this.dirty = false;
        this.firePropertyChange(257);
        this.setPageText(0, this.input.getName());
        this.input.getInputFile().setFile(string);
        File file = new File(string);
        Path path = new Path(file.getAbsolutePath());
        this.input = new GrainspotterIniInput((IPath)path);
        grainSpotter.setInput((IEditorInput)this.input);
        this.firePropertyChange(258);
        this.setInput((IEditorInput)this.input);
        this.setPartName(this.input.getName());
        GrainSpotter.getInstance().setInput((IEditorInput)this.input);
        this.setPageText(0, this.input.inputFile.iniFileName);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        block3: {
            if (!(iEditorInput instanceof GrainspotterIniInput)) {
                throw new PartInitException("Invalid Input: Must be ini file");
            }
            super.init(iEditorSite, iEditorInput);
            try {
                this.setSite((IWorkbenchPartSite)iEditorSite);
                this.setInput(iEditorInput);
                this.input = (GrainspotterIniInput)iEditorInput;
                this.input.inputFile.parseIniFile(this.input.getName());
            }
            catch (GrainSpotterException grainSpotterException) {
                if (FableMessageConsole.console == null) break block3;
                FableMessageConsole.console.displayError(grainSpotterException.get_message());
                SWTUtils.errMsgAsync((String)grainSpotterException.get_message());
            }
        }
        this.setPartName(this.input.getName());
        GrainSpotter.getInstance().setInput((IEditorInput)this.input);
        this.getEditorSite().getActionBars().setGlobalActionHandler("fable.grainspotter.actions.RunAction", (IAction)new RunAction());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public GrainspotterInputEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createPage0() {
        this.parent = this.getContainer();
        this.shell = this.parent.getShell();
        this.display = this.parent.getDisplay();
        if (grainSpotter == null) {
            grainSpotter = GrainSpotter.getInstance();
        }
        if (this.memento != null) {
            initialDirIni = this.memento.getString("initialDirIni");
            initialDirGve = this.memento.getString("initialDirGve");
            initialDirLog = this.memento.getString("initialDirLog");
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.makeColumnsEqualWidth = true;
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 3;
        gridLayout3.makeColumnsEqualWidth = true;
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.numColumns = 4;
        gridLayout4.makeColumnsEqualWidth = true;
        GridLayout gridLayout5 = new GridLayout();
        gridLayout5.numColumns = 6;
        gridLayout5.makeColumnsEqualWidth = true;
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.parent, 768);
        this.parent.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)scrolledComposite, 16);
        scrolledComposite.setContent((Control)composite);
        composite.setLayout((Layout)gridLayout4);
        composite.setLayoutData((Object)new GridData(16384, 16, false, false));
        this.createGroupDataSpecs(composite);
        this.createGroupSpacegrp(composite);
        this.createGroupThree(composite);
        this.createGroupCuts(composite);
        this.createGroupUncertainties(composite);
        Group group = new Group(composite, 0);
        group.setText("");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.chooseDspacing = new Button((Composite)group, 16);
        this.chooseDspacing.setText("Define d-spacing range");
        this.chooseDspacing.setSelection(true);
        this.chooseTthRange = new Button((Composite)group, 16);
        this.chooseTthRange.setText("or tth range");
        this.chooseDspacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.dsGroup, ((Button)selectionEvent.widget).getSelection());
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.tthRangeGroup, !((Button)selectionEvent.widget).getSelection());
            }
        });
        this.chooseTthRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.dsGroup, !((Button)selectionEvent.widget).getSelection());
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.tthRangeGroup, ((Button)selectionEvent.widget).getSelection());
            }
        });
        String[] stringArray = new String[]{"Minimum", "Maximum"};
        this.createGroupDsRange((Composite)group, stringArray);
        this.createGroupTthrange((Composite)group, stringArray);
        this.createGroupEtaRange(composite, stringArray);
        this.createGroupOmegaRange(composite, stringArray);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        int n = this.addPage((Control)scrolledComposite);
        this.setPageText(n, "View");
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDspacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDspacing.getSelection());
        this.setHelpContextToChildren(composite);
    }

    private void setHelpContextToChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Text text;
            TypedText typedText;
            if (controlArray[n] instanceof Group) {
                this.setHelpContextToChildren((Composite)((Group)controlArray[n]));
            } else if (controlArray[n] instanceof TypedText) {
                typedText = (TypedText)controlArray[n];
                if (typedText.getTextField().getToolTipText() == null) {
                    typedText.getTextField().setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    typedText.getTextField().setToolTipText(String.valueOf(typedText.getTextField().getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
                text = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                text.setHelp((Control)typedText.getTextField(), "fable.grainspotter.inifile");
            } else if (controlArray[n] instanceof Text) {
                typedText = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                typedText.setHelp((Control)((Text)controlArray[n]), "fable.grainspotter.inifile");
                text = (Text)controlArray[n];
                if (text.getToolTipText() == null) {
                    text.setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    text.setToolTipText(String.valueOf(text.getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
            } else if (controlArray[n] instanceof Table) {
                typedText = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                typedText.setHelp((Control)((Table)controlArray[n]), "fable.grainspotter.inifile");
            }
            ++n;
        }
    }

    private void createGroupOmegaRange(Composite composite, String[] stringArray) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Omegaspecs [-180/180 deg.]", (int)2, (int)1);
        GridData gridData = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData);
        group.setToolTipText("The active interval in the omega angle.");
        this.omegaDeltaText = new FloatText((Composite)group, 4, "Delta");
        this.omegaDeltaText.setMaxValue(new Float(1.0).floatValue(), true);
        this.omegaDeltaText.setMinValue(new Float(0.0).floatValue(), false);
        this.omegaDeltaText.setToolTipText("defines the omega step sizes for each diffraction used in the data collection");
        this.omegaDeltaText.getTextField().setToolTipText("defines the omega step sizes for each diffraction used in the data collection");
        this.omegaDeltaText.set_isRequiredField(false);
        GridData gridData2 = new GridData(4, 2, false, true, 2, 1);
        this.omegaDeltaText.setLayoutData((Object)gridData2);
        this.omegaRange = new Table((Composite)group, 68352);
        this.omegaRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.omegaRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                int n = 0;
                int n2 = 0;
                while (n2 < GrainspotterInputEditor.this.omegaRange.getColumnCount()) {
                    if (mouseEvent.x <= (n += GrainspotterInputEditor.this.omegaRange.getColumn(n2).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = n2;
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.createMinMaxColumnOmegaRange(stringArray);
        this.createRows(this.omegaRange, 1);
        this.createAddButtonOmegaRange((Composite)group);
        this.createRemoveItemButtonOmegarange((Composite)group);
        this.omegaRange.setToolTipText("You can add several range for omega.");
        this.triggerTableSelectionOmegaRange();
    }

    private void createGroupEtaRange(Composite composite, String[] stringArray) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Eta range [0-360 deg.]", (int)2, (int)1);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setToolTipText("etarange [min max], multiple ranges can be specified.");
        this.etaRange = new Table((Composite)group, 68352);
        this.etaRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.etaRange.setToolTipText("etarange [min max], eta angle range ");
        this.etaRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                int n = 0;
                int n2 = 0;
                while (n2 < GrainspotterInputEditor.this.etaRange.getColumnCount()) {
                    if (mouseEvent.x <= (n += GrainspotterInputEditor.this.etaRange.getColumn(n2).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = n2;
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.createMinMaxColumnEtaRange(stringArray);
        this.createRows(this.etaRange, 1);
        this.createAddButtonEtaRange((Composite)group);
        this.createRemoveItemButtonEtaRange((Composite)group);
        ((GridData)this.etaRange.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.etaRange.getLayoutData()).verticalSpan = 2;
        ((GridData)this.etaRange.getLayoutData()).verticalAlignment = 4;
        this.etaRange.setToolTipText("You can add several range for eta.");
        this.triggerTableSelectionEtaRange();
    }

    public void setEnableGroup(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        composite.setEnabled(bl);
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                if (controlArray[n] instanceof Group) {
                    this.setEnableGroup((Composite)controlArray[n], bl);
                } else if (bl) {
                    controlArray[n].setBackground(this.display.getSystemColor(1));
                } else {
                    controlArray[n].setBackground(this.display.getSystemColor(22));
                }
            } else {
                controlArray[n].setEnabled(bl);
            }
            ++n;
        }
    }

    private void createGroupTthrange(Composite composite, String[] stringArray) {
        this.tthRangeGroup = LookAndFeel.getGroup((Composite)composite, (String)"tth range [0-360 deg.]", (int)2, (int)1);
        this.tthRangeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tthRangeGroup.setToolTipText("tth range. Multiple ranges can be specified.");
        this.tthRange = new Table((Composite)this.tthRangeGroup, 68352);
        this.tthRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.tthRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                int n = 0;
                int n2 = 0;
                while (n2 < GrainspotterInputEditor.this.tthRange.getColumnCount()) {
                    if (mouseEvent.x <= (n += GrainspotterInputEditor.this.tthRange.getColumn(n2).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = n2;
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.createMinMaxColumntthRange(stringArray);
        this.createRows(this.tthRange, 1);
        this.createAddButtonTthrange((Composite)this.tthRangeGroup);
        this.createRemoveItemButtonTthRange((Composite)this.tthRangeGroup);
        this.tthRange.setToolTipText("You can add several range for tth.");
        this.triggerTableSelectionTthRange();
    }

    private void createGroupDsRange(Composite composite, String[] stringArray) {
        this.dsGroup = LookAndFeel.getGroup((Composite)composite, (String)"D-spacing in \u00c5", (int)2, (int)1);
        GridData gridData = new GridData(4, 4, true, false);
        this.dsGroup.setLayoutData((Object)gridData);
        this.dsGroup.setToolTipText("d-spacing range, multiple ranges can be specified.");
        this.dsRange = new Table((Composite)this.dsGroup, 68352);
        this.dsRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.dsRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                int n = 0;
                int n2 = 0;
                while (n2 < GrainspotterInputEditor.this.dsRange.getColumnCount()) {
                    if (mouseEvent.x <= (n += GrainspotterInputEditor.this.dsRange.getColumn(n2).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = n2;
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.createMinMaxColumnDsRange(stringArray);
        this.createRows(this.dsRange, 1);
        this.createAddButtonDsRange((Composite)this.dsGroup);
        this.createRemoveItemButtonDsRange((Composite)this.dsGroup);
        this.dsRange.setToolTipText("You can add several range for d-spacing.");
        this.triggerTableSelectionDsRange();
    }

    private void createGroupDataSpecs(Composite composite) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Filespecs", (int)3, (int)2);
        group.setToolTipText("filespecs");
        new Label((Composite)group, 0).setText("gve file");
        this.txtFilegve = new StringText((Composite)group, 0, "");
        this.txtFilegve.setToolTipText("Path and filenames of the input g-vector file (from ImageD11).");
        this.txtFilegve.getTextField().setToolTipText("Path and filenames of the input g-vector file (from ImageD11).");
        this.txtFilegve.set_isRequiredField(true);
        this.txtFilegve.setLayoutData((Object)new GridData(4, 16, true, false));
        this.txtFilegve.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    String string = GrainspotterInputEditor.this.txtFilegve.getText();
                    File file = new File(string);
                    GrainspotterInputEditor.this.loadGve(string, file.getAbsolutePath());
                }
            }
        });
        Button button = new Button((Composite)group, 8);
        button.setText("Browse");
        button.setToolTipText("Select or enter a gve file.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(GrainspotterInputEditor.this.shell, 0);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
                fileDialog.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
                fileDialog.setFilterPath(initialDirGve);
                fileDialog.setText("Select an existing gve file or enter a new file name");
                String string = fileDialog.open();
                if (string != null) {
                    GrainspotterInputEditor.this.txtFilegve.set_Text(string);
                    GrainspotterInputEditor.this.loadGve(string, fileDialog.getFilterPath());
                }
            }
        });
        new Label((Composite)group, 0).setText("log file");
        this.txtFilelog = new StringText((Composite)group, 0, "");
        this.txtFilelog.setToolTipText("Set output grains file containing the crystallographic orientations, \ninformation about fitting reflections etc..");
        this.txtFilelog.set_isRequiredField(true);
        this.txtFilelog.getTextField().setToolTipText("Set output grains file containing the crystallographic orientations,\ninformation about fitting reflections etc..");
        this.txtFilelog.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    File file = new File(GrainspotterInputEditor.this.txtFilelog.getText());
                    String string = "";
                    if (file != null) {
                        string = file.getPath();
                    }
                    GrainspotterInputEditor.this.setLogFile(GrainspotterInputEditor.this.txtFilelog.getText(), string);
                }
            }
        });
        this.txtFilelog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = GrainspotterInputEditor.this.txtFilelog.getText();
                File file = new File(string);
                String string2 = "";
                if (file != null) {
                    string2 = file.getPath();
                }
                GrainspotterInputEditor.this.setLogFile(string, string2);
            }
        });
        this.txtFilelog.setLayoutData((Object)new GridData(4, 16, false, false));
        Button button2 = new Button((Composite)group, 8);
        button2.setText("Browse");
        button2.setToolTipText("Select or enter a log file");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(GrainspotterInputEditor.this.shell, 8192);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDialog.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDialog.setFilterPath(initialDirLog);
                fileDialog.setText("Select an existing log file or enter a new file name");
                String string = fileDialog.open();
                GrainspotterInputEditor.this.txtFilelog.set_Text(string);
                if (string != null) {
                    GrainspotterInputEditor.this.setLogFile(string, new File(string).getPath());
                }
            }
        });
    }

    private void setLogFile(String string, String string2) {
        initialDirLog = string2;
        grainSpotter.setLogFilePath(initialDirLog);
        this.input.inputFile.setLogFilePath(initialDirLog);
        GrainspotterInputEditor.synchronizeInitialDirectories(initialDirLog);
        if (!string.endsWith(".log")) {
            string = String.valueOf(string) + ".log";
        }
    }

    private void loadGve(String string, String string2) {
        initialDirGve = string2;
        grainSpotter.setGveFilePath(initialDirGve);
        GrainspotterInputEditor.synchronizeInitialDirectories(initialDirGve);
        if (!string.endsWith(".gve")) {
            string = String.valueOf(string) + ".gve";
        }
        this.dirty = true;
        this.firePropertyChange(257);
        this.input.getInputFile().setGveFileName(string);
        grainSpotter.setgVectorFile(string);
    }

    private void createGroupSpacegrp(Composite composite) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"", (int)6, (int)2);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        group.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        new Label((Composite)group, 0).setText("Crystal system");
        this.spaceGroupTypeCombo = new Combo((Composite)group, 28);
        this.spaceGroupTypeCombo.setLayoutData((Object)new GridData(16384, 16, true, false));
        int n = 0;
        while (n < IVarKeys.SPACE_GROUP_TYPES.length) {
            this.spaceGroupTypeCombo.add(IVarKeys.SPACE_GROUP_TYPES[n]);
            ++n;
        }
        this.spaceGroupTypeCombo.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        this.spaceGroupTypeCombo.select(0);
        this.spaceGroupTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.spaceGroupType = GrainspotterInputEditor.this.spaceGroupTypeCombo.getSelectionIndex();
                GrainspotterInputEditor.this.spaceGroupCombo.setItems(IVarKeys.SPACE_GROUPS[GrainspotterInputEditor.this.spaceGroupType]);
                GrainspotterInputEditor.this.spaceGroupCombo.select(0);
                GrainspotterInputEditor.this.spaceGroup = IVarKeys.SPACE_GROUP_MINIMUM[GrainspotterInputEditor.this.spaceGroupType];
                GrainspotterInputEditor.this.spaceGroupSpinner.setSelection(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        new Label((Composite)group, 0).setText("Space group");
        this.spaceGroupCombo = new Combo((Composite)group, 28);
        this.spaceGroupCombo.setLayoutData((Object)new GridData(4, 16, true, false));
        this.spaceGroupCombo.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        n = 0;
        while (n < IVarKeys.SPACE_GROUPS[this.spaceGroupType].length) {
            this.spaceGroupCombo.add(IVarKeys.SPACE_GROUPS[this.spaceGroupType][n]);
            ++n;
        }
        this.spaceGroupTypeCombo.select(0);
        this.spaceGroupCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.spaceGroup = IVarKeys.SPACE_GROUP_MINIMUM[GrainspotterInputEditor.this.spaceGroupType] + GrainspotterInputEditor.this.spaceGroupCombo.getSelectionIndex();
                GrainspotterInputEditor.this.spaceGroupSpinner.setSelection(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        new Label((Composite)group, 0).setText("Number in the IUCr tables");
        this.spaceGroupSpinner = new Spinner((Composite)group, 2068);
        this.spaceGroupSpinner.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        this.spaceGroupSpinner.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.spaceGroupSpinner.setMaximum(230);
        this.spaceGroupSpinner.setMinimum(1);
        this.spaceGroupSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.spaceGroup = GrainspotterInputEditor.this.spaceGroupSpinner.getSelection();
                GrainspotterInputEditor.this.setSpaceGroup(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
    }

    private void createGroupCuts(Composite composite) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Cuts", (int)2, (int)1);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        group.setToolTipText("cuts [min_measuments min_completeness min_uniqueness] :\nMinimum requirement for accepting a grain solution");
        new Label((Composite)group, 0).setText("Min. measurement");
        this.cutsMinMeasurement = new IntegerText((Composite)group, 4, "");
        this.cutsMinMeasurement.getTextField().setToolTipText("min_no_measurements: \nMinimum number of g-vectors assigned to the grain (integer value > 3)");
        this.cutsMinMeasurement.setMinValue(new Integer(3).intValue(), false);
        this.cutsMinMeasurement.setToolTipText("min_no_measurements: \nMinimum number of g-vectors assigned to the grain (integer value > 3)");
        this.cutsMinMeasurement.set_isRequiredField(false);
        new Label((Composite)group, 0).setText("Min. completeness");
        this.cutsMinMeasurement.getTextField().setToolTipText("cuts [min_measuments min_completeness min_uniqueness] :Minimum requirement for accepting a grain solution");
        this.cutsMinCompletenessText = new FloatText((Composite)group, 4, "");
        this.cutsMinCompletenessText.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinCompletenessText.setToolTipText("min_completeness: \nThe minimum fraction of expected reflections assigned (#assigned relfections/#theretical reflections) to the grain,\n (floating number between 0 and 1).");
        this.cutsMinCompletenessText.set_isRequiredField(false);
        this.cutsMinCompletenessText.getTextField().setToolTipText("min_completeness: \nThe minimum fraction of expected reflections assigned (#assigned relfections/#theretical reflections) to the grain,\n (floating number between 0 and 1) .");
        new Label((Composite)group, 0).setText("Min. uniqueness");
        this.cutsMinUniqueness = new FloatText((Composite)group, 4, "");
        this.cutsMinUniqueness.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinUniqueness.setToolTipText("min_uniqueness: \nMinimum fraction of expected reflections assigned to the grain (0<min completeness<1); \noption cuts [min_measuments min_completeness min_uniqueness] .");
        this.cutsMinUniqueness.set_isRequiredField(false);
    }

    private void createGroupUncertainties(Composite composite) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Uncertainties (in degrees)", (int)2, (int)2);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        group.setToolTipText("uncertainties [sigma_tth sigma_eta sigma_omega]: Until full error estimation \nis available on the gvectors in the input gvector file, \nsigma_tth, sigma_eta and sigma_omega give YOUR estimation on \nthe uncertainties in degrees on eta, omega and tth.");
        new Label((Composite)group, 0).setText("Sigma tth");
        this.sigmaTth = new FloatText((Composite)group, 0, "");
        this.sigmaTth.setToolTipText("uncertainties sigma_twotheta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaTth.getTextField().setToolTipText("uncertainties sigma_twotheta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaTth.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaTth.set_isRequiredField(false);
        new Label((Composite)group, 0).setText("Sigma eta");
        this.sigmaEta = new FloatText((Composite)group, 0, "");
        this.sigmaEta.setToolTipText("uncertainties sigma_eta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaEta.getTextField().setToolTipText("uncertainties sigma_eta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaEta.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaEta.set_isRequiredField(false);
        new Label((Composite)group, 0).setText("uncertainties: sigma omega");
        this.sigmaOmega = new FloatText((Composite)group, 0, "");
        this.sigmaOmega.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaOmega.setToolTipText("uncertainties sigma_omega[degrees]: Until full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaOmega.getTextField().setToolTipText("uncertainties sigma_omega[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaOmega.set_isRequiredField(false);
        new Label((Composite)group, 0).setText("Sigmas (maximal deviation)");
        this.nsigma = new FloatText((Composite)group, 0, "");
        this.nsigma.setToolTipText("sigma (float >0).");
        this.nsigma.setMinValue(new Float(0.0).floatValue(), false);
        this.nsigma.set_isRequiredField(false);
        this.nsigma.getTextField().setToolTipText("nsigmas: Gives the maximal deviation when comparing two quantities. \nGenerally, |d_quantity| < nsigmas * sig_quantity.");
    }

    private void createGroupThree(Composite composite) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"", (int)3, (int)2);
        group.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        Label label = new Label((Composite)group, 0);
        label.setText("Step Size in Euler space [0/180 deg.]");
        group.setToolTipText("eulerstep.");
        this.eulerStep = new FloatText((Composite)group, 0, "", 0.0f, 180.0f);
        this.eulerStep.setToolTipText("eulerstep : \nThe Euler angles are sampled according to the metric (Linear in phi1 and phi2, not linear in PHI). \n\nNOTICE: If the the keyword random is used eulerstep has a diffent meaning than in scanning mode. \nIn this case the number defines a small volume around the random orientation in which a possible match can be found. \nBy making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.eulerStep.getTextField().setToolTipText("eulerstep : \nThe Euler angles are sampled according to the metric (Linear in phi1 and phi2, not linear in PHI). \n\nNOTICE: If the the keyword random is used eulerstep has a diffent meaning than in scanning mode. \nIn this case the number defines a small volume around the random orientation in which a possible match can be found. \nBy making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.eulerStep.set_isRequiredField(false);
        this.eulerStep.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("NHkls : Number hkl families used");
        this.hklRingsText = new IntegerText((Composite)group, 0, "");
        this.hklRingsText.setMinValue(new Integer(0).intValue(), false);
        this.hklRingsText.setToolTipText("Nhkls_in_indexing: \nUses the first Nhkls_in_indexing hklfamilies to recover the crystallographic orientations. \nAfterwards the search for additional gvectors belonging to the grain is done on the remaining rings. hkl rings (integer > 0).");
        this.hklRingsText.getTextField().setToolTipText("Nhkls_in_indexing: \nUses the first Nhkls_in_indexing hklfamilies to recover the crystallographic orientations. \nAfterwards the search for additional gvectors belonging to the grain is done on the remaining rings. hkl rings (integer > 0).");
        this.hklRingsText.set_isRequiredField(false);
        this.hklRingsText.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)group, 0).setText("Minfracg");
        this.minfracg = new FloatText((Composite)group, 0, "");
        this.minfracg.setToolTipText("minfracg: \nStop search when minfracg (0..1) of the gvectors have been assigned to grains.");
        this.minfracg.getTextField().setToolTipText("minfracg: \nStop search when minfracg (0..1) of the gvectors have been assigned to grains.");
        this.minfracg.set_isRequiredField(false);
        this.minfracg.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)group, 0).setText("Random : Number of trial orientation");
        this.random = new IntegerText((Composite)group, 0);
        this.random.setToolTipText("Instead of stepping through all orientation space systematically, sampling randomly is possible using the random keyword. \nThe number following random is the number of orientations tried. If this method is used the parameter given with the keyword eulerstep has a diffent meaning than in scanning mode: \nin this case the number defines a small volume around the random orientation in which a possible match can be found. By making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.random.getTextField().setToolTipText("Instead of stepping through all orientation space systematically, sampling randomly is possible using the random keyword. \nThe number following random is the number of orientations tried. If this method is used the parameter given with the keyword eulerstep has a diffent meaning than in scanning mode: \nin this case the number defines a small volume around the random orientation in which a possible match can be found. By making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.random.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)group, 0).setText("Fit position ?");
        this.fitpositionFalse = new Button((Composite)group, 16);
        this.fitpositionFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.fitpositionFalse.setText("No");
        this.fitpositionFalse.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitpositionYes = new Button((Composite)group, 16);
        this.fitpositionYes.setText("Yes");
        this.fitpositionYes.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitpositionYes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.fitpositionFalse.setSelection(true);
        this.fitpositionFalse.setToolTipText("positionfit: \nWhen a grain is found the spatial position of the grain is fitted simultaneously with the orientation matrix if this keyword is added.");
        this.fitpositionYes.setToolTipText("positionfit: \nWhen a grain is found the spatial position of the grain is fitted simultaneously with the orientation matrix if this keyword is added.");
    }

    private void createRows(Table table, int n) {
        int n2 = 0;
        while (n2 < n) {
            new TableItem(table, 0);
            ++n2;
        }
    }

    private void triggerTableSelectionDsRange() {
        final TableEditor tableEditor = new TableEditor(this.dsRange);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.dsRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = GrainspotterInputEditor.this.dsRange.getClientArea();
                Point point = new Point(event.x, event.y);
                int n = GrainspotterInputEditor.this.dsRange.getTopIndex();
                while (n < GrainspotterInputEditor.this.dsRange.getItemCount()) {
                    boolean bl = false;
                    final TableItem tableItem = GrainspotterInputEditor.this.dsRange.getItem(n);
                    int n2 = 0;
                    while (n2 < GrainspotterInputEditor.this.dsRange.getColumnCount()) {
                        Rectangle rectangle2 = tableItem.getBounds(n2);
                        if (rectangle2.contains(point)) {
                            final int n3 = n2;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.dsRange, 0);
                            Listener listener = new Listener(){

                                public void handleEvent(Event event) {
                                    switch (event.type) {
                                        case 16: {
                                            tableItem.setText(n3, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (event.detail) {
                                                case 4: {
                                                    tableItem.setText(n3, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    event.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, listener);
                            text.addListener(31, listener);
                            tableEditor.setEditor((Control)text, tableItem, n2);
                            text.setText(tableItem.getText(n2));
                            text.setFocus();
                            return;
                        }
                        if (!bl && rectangle2.intersects(rectangle)) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return;
                    }
                    ++n;
                }
            }
        });
    }

    private void triggerTableSelectionTthRange() {
        final TableEditor tableEditor = new TableEditor(this.tthRange);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.tthRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = GrainspotterInputEditor.this.tthRange.getClientArea();
                Point point = new Point(event.x, event.y);
                int n = GrainspotterInputEditor.this.tthRange.getTopIndex();
                while (n < GrainspotterInputEditor.this.tthRange.getItemCount()) {
                    boolean bl = false;
                    final TableItem tableItem = GrainspotterInputEditor.this.tthRange.getItem(n);
                    int n2 = 0;
                    while (n2 < GrainspotterInputEditor.this.tthRange.getColumnCount()) {
                        Rectangle rectangle2 = tableItem.getBounds(n2);
                        if (rectangle2.contains(point)) {
                            final int n3 = n2;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.tthRange, 0);
                            Listener listener = new Listener(){

                                public void handleEvent(Event event) {
                                    switch (event.type) {
                                        case 16: {
                                            tableItem.setText(n3, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (event.detail) {
                                                case 4: {
                                                    tableItem.setText(n3, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    event.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, listener);
                            text.addListener(31, listener);
                            tableEditor.setEditor((Control)text, tableItem, n2);
                            text.setText(tableItem.getText(n2));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!bl && rectangle2.intersects(rectangle)) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return;
                    }
                    ++n;
                }
            }
        });
    }

    private void triggerTableSelectionEtaRange() {
        final TableEditor tableEditor = new TableEditor(this.etaRange);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.etaRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = GrainspotterInputEditor.this.etaRange.getClientArea();
                Point point = new Point(event.x, event.y);
                int n = GrainspotterInputEditor.this.etaRange.getTopIndex();
                while (n < GrainspotterInputEditor.this.etaRange.getItemCount()) {
                    boolean bl = false;
                    final TableItem tableItem = GrainspotterInputEditor.this.etaRange.getItem(n);
                    int n2 = 0;
                    while (n2 < GrainspotterInputEditor.this.etaRange.getColumnCount()) {
                        Rectangle rectangle2 = tableItem.getBounds(n2);
                        if (rectangle2.contains(point)) {
                            final int n3 = n2;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.etaRange, 0);
                            Listener listener = new Listener(){

                                public void handleEvent(Event event) {
                                    switch (event.type) {
                                        case 16: {
                                            tableItem.setText(n3, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (event.detail) {
                                                case 4: {
                                                    tableItem.setText(n3, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    event.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, listener);
                            text.addListener(31, listener);
                            tableEditor.setEditor((Control)text, tableItem, n2);
                            text.setText(tableItem.getText(n2));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!bl && rectangle2.intersects(rectangle)) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return;
                    }
                    ++n;
                }
            }
        });
    }

    private void triggerTableSelectionOmegaRange() {
        final TableEditor tableEditor = new TableEditor(this.omegaRange);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.omegaRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = GrainspotterInputEditor.this.omegaRange.getClientArea();
                Point point = new Point(event.x, event.y);
                int n = GrainspotterInputEditor.this.omegaRange.getTopIndex();
                while (n < GrainspotterInputEditor.this.omegaRange.getItemCount()) {
                    boolean bl = false;
                    final TableItem tableItem = GrainspotterInputEditor.this.omegaRange.getItem(n);
                    int n2 = 0;
                    while (n2 < GrainspotterInputEditor.this.omegaRange.getColumnCount()) {
                        Rectangle rectangle2 = tableItem.getBounds(n2);
                        if (rectangle2.contains(point)) {
                            final int n3 = n2;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.omegaRange, 0);
                            Listener listener = new Listener(){

                                public void handleEvent(Event event) {
                                    switch (event.type) {
                                        case 16: {
                                            tableItem.setText(n3, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (event.detail) {
                                                case 4: {
                                                    tableItem.setText(n3, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    event.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, listener);
                            text.addListener(31, listener);
                            tableEditor.setEditor((Control)text, tableItem, n2);
                            text.setText(tableItem.getText(n2));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!bl && rectangle2.intersects(rectangle)) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return;
                    }
                    ++n;
                }
            }
        });
    }

    private void createMinMaxColumnOmegaRange(String[] stringArray) {
        TableColumn tableColumn = new TableColumn(this.omegaRange, 0);
        tableColumn.setText(stringArray[0]);
        tableColumn.setWidth(100);
        tableColumn.setData("index", (Object)0);
        TableColumn tableColumn2 = new TableColumn(this.omegaRange, 0);
        tableColumn2.setText(stringArray[1]);
        tableColumn2.setWidth(100);
        tableColumn2.setData("index", (Object)1);
        this.omegaRange.setHeaderVisible(true);
        tableColumn.pack();
        tableColumn2.pack();
        this.omegaRange.pack();
    }

    private void createMinMaxColumntthRange(String[] stringArray) {
        TableColumn tableColumn = new TableColumn(this.tthRange, 0);
        tableColumn.setText(stringArray[0]);
        tableColumn.setWidth(100);
        tableColumn.setData("index", (Object)0);
        TableColumn tableColumn2 = new TableColumn(this.tthRange, 0);
        tableColumn2.setText(stringArray[1]);
        tableColumn2.setWidth(100);
        tableColumn2.setData("index", (Object)1);
        this.tthRange.setHeaderVisible(true);
        tableColumn.pack();
        tableColumn2.pack();
        this.tthRange.pack();
    }

    private void createMinMaxColumnEtaRange(String[] stringArray) {
        TableColumn tableColumn = new TableColumn(this.etaRange, 0);
        tableColumn.setText(stringArray[0]);
        tableColumn.setWidth(100);
        tableColumn.setData("index", (Object)0);
        TableColumn tableColumn2 = new TableColumn(this.etaRange, 0);
        tableColumn2.setText(stringArray[1]);
        tableColumn2.setWidth(100);
        tableColumn2.setData("index", (Object)1);
        this.etaRange.setHeaderVisible(true);
        tableColumn.pack();
        tableColumn2.pack();
        this.etaRange.pack();
    }

    private void createMinMaxColumnDsRange(String[] stringArray) {
        TableColumn tableColumn = new TableColumn(this.dsRange, 0);
        tableColumn.setText(stringArray[0]);
        tableColumn.setWidth(100);
        tableColumn.setData("index", (Object)0);
        TableColumn tableColumn2 = new TableColumn(this.dsRange, 0);
        tableColumn2.setText(stringArray[1]);
        tableColumn2.setWidth(100);
        tableColumn2.setData("index", (Object)1);
        this.dsRange.setHeaderVisible(true);
        tableColumn.pack();
        tableColumn2.pack();
        this.dsRange.pack();
    }

    private void createRemoveItemButtonDsRange(Composite composite) {
        Button button = new Button(composite, 8);
        final Image image = this.deleteDescriptor.createImage();
        button.setImage(image);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setToolTipText("remove a range for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = GrainspotterInputEditor.this.dsRange.getSelectionIndex();
                if (n != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.dsRange.getItem(n);
                    tableItem.dispose();
                }
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonTthRange(Composite composite) {
        Button button = new Button(composite, 8);
        final Image image = this.deleteDescriptor.createImage();
        button.setImage(image);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setToolTipText("remove a range for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = GrainspotterInputEditor.this.tthRange.getSelectionIndex();
                if (n != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.tthRange.getItem(n);
                    tableItem.dispose();
                }
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonEtaRange(Composite composite) {
        Button button = new Button(composite, 8);
        final Image image = this.deleteDescriptor.createImage();
        button.setImage(image);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setToolTipText("remove a range for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = GrainspotterInputEditor.this.etaRange.getSelectionIndex();
                if (n != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.etaRange.getItem(n);
                    tableItem.dispose();
                }
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonOmegarange(Composite composite) {
        Button button = new Button(composite, 8);
        final Image image = this.deleteDescriptor.createImage();
        button.setImage(image);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setToolTipText("remove a range for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = GrainspotterInputEditor.this.omegaRange.getSelectionIndex();
                if (n != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.omegaRange.getItem(n);
                    tableItem.dispose();
                }
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createAddButtonTthrange(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image image = this.addDescriptor.createImage();
        button.setImage(image);
        button.setToolTipText("Add a new range in table for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new TableItem(GrainspotterInputEditor.this.tthRange, 0);
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createAddButtonOmegaRange(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image image = this.addDescriptor.createImage();
        button.setImage(image);
        button.setToolTipText("Add a new range in table for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new TableItem(GrainspotterInputEditor.this.omegaRange, 0);
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createAddButtonEtaRange(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image image = this.addDescriptor.createImage();
        button.setImage(image);
        button.setToolTipText("Add a new range in table for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new TableItem(GrainspotterInputEditor.this.etaRange, 0);
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createAddButtonDsRange(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image image = this.addDescriptor.createImage();
        button.setImage(image);
        button.setToolTipText("Add a new range in table for this option.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new TableItem(GrainspotterInputEditor.this.dsRange, 0);
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    public void setFocus() {
        GrainSpotter.getInstance().setInput((IEditorInput)this.input);
    }

    public static String getID() {
        return ID;
    }

    private void setModifyListener() {
        this.txtFilelog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.txtFilegve.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
                String string = GrainspotterInputEditor.this.txtFilegve.getText();
                if (ToolBox.checkIfFileExists((String)string)) {
                    grainSpotter.setgVectorFile(string);
                    GrainspotterInputEditor.this.input.getInputFile().setGveFileName(string);
                }
            }
        });
        this.minfracg.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.omegaDeltaText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.eulerStep.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.cutsMinMeasurement.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.hklRingsText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.cutsMinCompletenessText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
    }

    private void initFields() {
        if (this.input.inputFile.isIgnoreOptionDsRange()) {
            this.chooseTthRange.setSelection(true);
            this.chooseDspacing.setSelection(false);
        } else {
            this.chooseTthRange.setSelection(false);
            this.chooseDspacing.setSelection(true);
        }
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDspacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDspacing.getSelection());
        this.setGveFile(this.input.inputFile.getGveFileName());
        this.setLogFile(this.input.inputFile.getLogFileName());
        this.setSpaceGroup(this.input.inputFile.getSpaceGroup());
        this.setDsRange(this.input.inputFile.getDsRange());
        this.setOmegaRange(this.input.inputFile.getOmegaRange());
        if (!this.input.inputFile.isIgnoreOptionDeltaOmegaSpec()) {
            this.setDeltaOmega(this.input.inputFile.getDeltaOmegaSpecs());
        }
        if (!this.input.inputFile.isIgnoreOptionUncertainties()) {
            this.set_uncertTthText(this.input.inputFile.getTtUncertainties());
            this.set_uncertEtaText(this.input.inputFile.getEtaUncertainties());
            this.set_uncertOmegaText(this.input.inputFile.getOmegaUncertainties());
        }
        this.setTthRange(this.input.inputFile.getTthRange());
        this.setEtaRange(this.input.inputFile.getEtaRange());
        if (!this.input.inputFile.isIgnoreOptionCuts()) {
            this.set_cutsMinCompletenessText(this.input.inputFile.getMinCompletenessCuts());
            this.set_cutsMinMeasurement(this.input.inputFile.getMinMeasurementCuts());
            this.set_cutsMinUniqueness(this.input.inputFile.getMinMeasurementUniqueness());
        }
        if (!this.input.inputFile.isIgnoreOptionEuler()) {
            this.set_eulerStep(this.input.inputFile.getStepEuler());
        }
        if (!this.input.inputFile.isIgnoreOptionNSigma()) {
            this.set_sigmaText(this.input.inputFile.getNSigmas());
        }
        if (!this.input.inputFile.isIgnoreOptionHKL()) {
            this.setNHkls(this.input.inputFile.getNHKLs());
        }
        if (!this.input.inputFile.isIgnoreOptionMinfracg()) {
            this.setMinfracg(this.input.inputFile.getMinfracg());
        }
        if (!this.input.inputFile.isIgnoreOptionRandom()) {
            this.setRandom(this.input.inputFile.getRandom());
        }
        this.setPositionFit(this.input.inputFile.isPositionFit());
        GrainspotterInputEditor.synchronizeInitialDirectories(this.input.inputFile.getIniFilePath());
        grainSpotter.setLogFilePath(initialDirLog);
        grainSpotter.setGveFilePath(initialDirGve);
        this.setPageText(0, this.input.inputFile.iniFileName);
    }

    public void setLogFile(String string) {
        this.txtFilelog.set_Text(string);
        File file = new File(string);
        this.setLogFile(file.getName(), file.getPath());
    }

    public void setGveFile(String string) {
        this.txtFilegve.set_Text(string);
        grainSpotter.setgVectorFile(string);
    }

    private void setRandom(int n) {
        this.random.set_Text(String.valueOf(n));
    }

    private void setDeltaOmega(float f) {
        this.omegaDeltaText.set_Text(String.valueOf(f));
    }

    private void setPositionFit(boolean bl) {
        this.fitpositionYes.setSelection(bl);
        this.fitpositionFalse.setSelection(!bl);
    }

    private void setDsRange(Vector<float[]> vector) {
        int n = 0;
        while (n < vector.size()) {
            TableItem tableItem = new TableItem(this.dsRange, 0, 0);
            tableItem.setText(0, this.setTableItemText(vector.elementAt(n)[0]));
            tableItem.setText(1, this.setTableItemText(vector.elementAt(n)[1]));
            ++n;
        }
    }

    public String setTableItemText(float f) {
        DecimalFormat decimalFormat = new DecimalFormat();
        String string = "0";
        try {
            string = decimalFormat.format(f);
        }
        catch (NumberFormatException numberFormatException) {
            FableLogger.error((Object)numberFormatException.getMessage());
        }
        return string;
    }

    public String getItemText(String string) {
        DecimalFormat decimalFormat = new DecimalFormat();
        if (!string.trim().equals("")) {
            try {
                Number number = decimalFormat.parse(string);
                string = number.toString();
            }
            catch (ParseException parseException) {
                FableLogger.getLogger().error((Object)parseException.getMessage());
            }
        }
        FableLogger.debug((Object)(((Object)((Object)this)).getClass() + " getItemText :" + string));
        return string;
    }

    private void setTthRange(Vector<float[]> vector) {
        int n = 0;
        while (n < vector.size()) {
            TableItem tableItem = new TableItem(this.tthRange, 0, 0);
            tableItem.setText(0, this.setTableItemText(vector.elementAt(n)[0]));
            tableItem.setText(1, this.setTableItemText(vector.elementAt(n)[1]));
            ++n;
        }
    }

    private void setEtaRange(Vector<float[]> vector) {
        int n = 0;
        while (n < vector.size()) {
            TableItem tableItem = new TableItem(this.etaRange, 0, 0);
            tableItem.setText(0, this.setTableItemText(vector.elementAt(n)[0]));
            tableItem.setText(1, this.setTableItemText(vector.elementAt(n)[1]));
            ++n;
        }
    }

    private void setOmegaRange(Vector<float[]> vector) {
        int n = 0;
        while (n < vector.size()) {
            TableItem tableItem = new TableItem(this.omegaRange, 0, 0);
            tableItem.setText(0, this.setTableItemText(vector.elementAt(n)[0]));
            tableItem.setText(1, this.setTableItemText(vector.elementAt(n)[1]));
            ++n;
        }
    }

    public boolean setOptions() {
        boolean bl = true;
        try {
            TableItem tableItem;
            this.input.getInputFile().setSpaceGroup(this.spaceGroupSpinner.getSelection());
            if (!this.omegaDeltaText.getText().equals("")) {
                this.input.getInputFile().ignoreOptionDeltaOmegaSpecs(false);
                this.input.getInputFile().set_deltaOmegaSpecs(this.omegaDeltaText.getText());
            } else {
                this.input.getInputFile().ignoreOptionDeltaOmegaSpecs(true);
            }
            this.input.getInputFile().getOmegaRange().removeAllElements();
            int n = 0;
            while (n < this.omegaRange.getItemCount()) {
                tableItem = this.omegaRange.getItem(n);
                if (tableItem.getText(0) != null && !tableItem.getText(0).equals("") && tableItem.getText(1) != null && !tableItem.getText(1).equals("")) {
                    this.input.getInputFile().addOmegaRange(this.getItemText(tableItem.getText(0)), this.getItemText(tableItem.getText(1)));
                }
                ++n;
            }
            this.input.getInputFile().getEtaRange().removeAllElements();
            n = 0;
            while (n < this.etaRange.getItemCount()) {
                tableItem = this.etaRange.getItem(n);
                if (tableItem.getText(0) != null && !tableItem.getText(0).equals("") && tableItem.getText(1) != null && !tableItem.getText(1).equals("")) {
                    this.input.getInputFile().addEtaRange(this.getItemText(tableItem.getText(0)), this.getItemText(tableItem.getText(1)));
                }
                ++n;
            }
            this.input.getInputFile().getTthRange().removeAllElements();
            n = 0;
            while (this.chooseTthRange.getSelection() && n < this.tthRange.getItemCount()) {
                tableItem = this.tthRange.getItem(n);
                if (tableItem.getText(0) != null && !tableItem.getText(0).equals("") && tableItem.getText(1) != null && !tableItem.getText(1).equals("")) {
                    this.input.getInputFile().addtthRange(this.getItemText(tableItem.getText(0)), this.getItemText(tableItem.getText(1)));
                }
                ++n;
            }
            this.input.getInputFile().getDsRange().removeAllElements();
            n = 0;
            while (this.chooseDspacing.getSelection() && n < this.dsRange.getItemCount()) {
                tableItem = this.dsRange.getItem(n);
                if (tableItem.getText(0) != null && !tableItem.getText(0).equals("") && tableItem.getText(1) != null && !tableItem.getText(1).equals("")) {
                    this.input.getInputFile().addDsRange(this.getItemText(tableItem.getText(0)), this.getItemText(tableItem.getText(1)));
                }
                ++n;
            }
            if (!(this.cutsMinCompletenessText.getText().trim().equals("") || this.cutsMinMeasurement.getText().trim().equals("") || this.cutsMinUniqueness.getText().trim().equals(""))) {
                this.input.getInputFile().set_minCompletenessCuts(this.cutsMinCompletenessText.getText());
                this.input.getInputFile().set_minMeasurementCuts(this.cutsMinMeasurement.getText());
                this.input.getInputFile().setMinMeasurementUniqueness(this.cutsMinUniqueness.getText());
                this.input.getInputFile().ignoreOptionCuts(false);
            } else {
                this.input.getInputFile().ignoreOptionCuts(true);
            }
            if (!this.eulerStep.getText().trim().equals("")) {
                this.input.getInputFile().set_stepEuler(this.eulerStep.getText());
                this.input.getInputFile().ignoreOptionEuler(false);
            } else {
                this.input.getInputFile().ignoreOptionEuler(true);
            }
            if (!(this.sigmaTth.getText().trim().equals("") || this.sigmaEta.getText().trim().equals("") || this.sigmaOmega.getText().trim().equals(""))) {
                this.input.getInputFile().set_ttUncertanties(this.sigmaTth.getText());
                this.input.getInputFile().set_etaUncertanties(this.sigmaEta.getText());
                this.input.getInputFile().set_omegaUncertanties(this.sigmaOmega.getText());
                this.input.getInputFile().ignoreOptionUncertainties(false);
            } else {
                this.input.getInputFile().ignoreOptionUncertainties(true);
            }
            this.input.getInputFile().setGveFileName(this.txtFilegve.getText());
            this.input.getInputFile().setLogFileName(this.txtFilelog.getText());
            if (!this.nsigma.getText().trim().equals("")) {
                this.input.getInputFile().set_nSigmas(this.nsigma.getText());
                this.input.getInputFile().ignoreOptionNSigma(false);
            } else {
                this.input.getInputFile().ignoreOptionNSigma(true);
            }
            if (!this.hklRingsText.getText().trim().equals("")) {
                this.input.getInputFile().set_nHKLs(this.hklRingsText.getText());
                this.input.getInputFile().ignoreOptionHKL(false);
            } else {
                this.input.getInputFile().ignoreOptionHKL(true);
            }
            if (!this.minfracg.getText().trim().equals("")) {
                this.input.getInputFile().setMinfracg(this.minfracg.getText());
                this.input.getInputFile().ignoreOptionMinfracg(false);
            } else {
                this.input.getInputFile().ignoreOptionMinfracg(true);
            }
            if (!this.random.getText().trim().equals("")) {
                this.input.getInputFile().setRandom(this.random.getText());
                this.input.getInputFile().ignoreOptionRandom(false);
            } else {
                this.input.getInputFile().ignoreOptionRandom(true);
            }
            this.input.getInputFile().setPositionFit(this.fitpositionYes.getSelection());
        }
        catch (GrainSpotterException grainSpotterException) {
            FableMessageConsole.console.displayIn(grainSpotterException.get_message());
            bl = false;
        }
        return bl;
    }

    public void setSpaceGroup(int n) {
        int n2 = 0;
        this.spaceGroup = n;
        int n3 = 0;
        while (n3 < IVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (this.spaceGroup <= IVarKeys.SPACE_GROUP_MAXIMUM[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 != this.spaceGroupType) {
            this.spaceGroupCombo.setItems(IVarKeys.SPACE_GROUPS[n2]);
            this.spaceGroupType = n2;
        }
        this.spaceGroupSpinner.setSelection(this.spaceGroup);
        this.spaceGroupTypeCombo.select(this.spaceGroupType);
        this.spaceGroupCombo.select(this.spaceGroup - IVarKeys.SPACE_GROUP_MINIMUM[this.spaceGroupType]);
    }

    private void set_eulerStep(float f) {
        this.eulerStep.set_Text(String.valueOf(f));
    }

    private void set_cutsMinCompletenessText(float f) {
        this.cutsMinCompletenessText.set_Text(String.valueOf(f));
    }

    private void set_cutsMinMeasurement(int n) {
        this.cutsMinMeasurement.set_Text(String.valueOf(n));
    }

    private void set_cutsMinUniqueness(float f) {
        this.cutsMinUniqueness.set_Text(String.valueOf(f));
    }

    private void set_sigmaText(float f) {
        this.nsigma.set_Text(String.valueOf(f));
    }

    private void set_uncertEtaText(float f) {
        this.sigmaEta.set_Text(String.valueOf(f));
    }

    private void set_uncertOmegaText(float f) {
        this.sigmaOmega.set_Text(String.valueOf(f));
    }

    private void set_uncertTthText(float f) {
        this.sigmaTth.set_Text(String.valueOf(f));
    }

    public void setNHkls(int n) {
        this.hklRingsText.set_Text(String.valueOf(n));
    }

    public void setMinfracg(float f) {
        this.minfracg.set_Text(String.valueOf(f));
    }

    public static void synchronizeInitialDirectories(String string) {
        if (string == null) {
            return;
        }
        if (initialDirIni == null) {
            initialDirIni = string;
        }
        if (initialDirGve == null) {
            initialDirGve = string;
        }
        if (initialDirLog == null) {
            initialDirLog = string;
        }
    }

    protected void createPages() {
        this.createPage0();
        this.getEditorSite().getActionBars().setGlobalActionHandler(SaveInifile.ID, (IAction)this.save);
        this.getEditorSite().getActionBars().updateActionBars();
        this.initFields();
        this.setModifyListener();
        GrainSpotter.getInstance().addPropertyChangeListener(this);
        this.makeActions();
        this.contributetoActionBar();
    }

    public void makeActions() {
        this.save = new SaveInifile(){

            @Override
            public void run(GrainspotterInputEditor grainspotterInputEditor) {
                grainspotterInputEditor.doSave(null);
            }
        };
        this.save.setProps("Save ini file");
        this.save.setToolTipText("Save ini file");
        this.saveas = new SaveAsInifile(){

            @Override
            public void run(GrainspotterInputEditor grainspotterInputEditor) {
                grainspotterInputEditor.doSaveAs();
            }
        };
        this.saveas.setProps("Save ini file as...");
        this.saveas.setToolTipText("Save ini file as...");
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        iResourceChangeEvent.getType();
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.save);
        iToolBarManager.add((IAction)this.saveas);
    }

    private void contributetoActionBar() {
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    void createPage1() {
        try {
            this.editor = new GrainspotterTextEditor();
            int n = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(n, this.editor.getTitle());
        }
        catch (PartInitException partInitException) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)partInitException.getStatus());
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        GrainSpotter.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    public boolean runGrainSpotter() {
        boolean bl = true;
        if (this.checkFields(this.parent, true)) {
            FableMessageConsole.console.displayOut("start running grainspotter with command : ");
            FableMessageConsole.console.displayOut(command);
            if (this.isDirty()) {
                boolean bl2 = FableUtils.confirmMsg((Object)((Object)this), (String)"Your ini file has changed. Do you want to overwrite it?\n\nIf not, cancel operation.\n\nAfter that, you can save this new input file as in Menu File/Save as...");
                if (bl2) {
                    this.save();
                    grainSpotter.run();
                }
            } else {
                this.setOptions();
                grainSpotter.run();
            }
        } else {
            bl = false;
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Fields are not correct ");
                FableMessageConsole.console.activate();
            }
        }
        return bl;
    }

    private boolean checkFields(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (bl && n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                if (controlArray[n] instanceof TypedText && !((TypedText)controlArray[n]).is_bValide()) {
                    bl = false;
                    ((TypedText)controlArray[n]).showDecoration();
                } else {
                    bl = this.checkFields((Composite)controlArray[n], bl);
                }
            }
            ++n;
        }
        return bl;
    }

    public static String getInitialDirLog() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (propertyChangeEvent.getProperty().equals("grainspotter") && GrainSpotter.getInstance().getInput().equals((Object)this.input) && (string = (String)propertyChangeEvent.getNewValue()).equals("launch")) {
            this.runGrainSpotter();
        }
    }

    public String getLogFileName() {
        return this.txtFilelog.getText();
    }

    public String getGVE() {
        return this.txtFilegve.getText();
    }

    class CellModifier
    implements ICellModifier {
        private TableViewer tableviewer;

        public CellModifier(TableViewer tableViewer) {
            this.tableviewer = tableViewer;
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            this.tableviewer.getTable().getSelectionIndex();
            return null;
        }

        public void modify(Object object, String string, Object object2) {
        }
    }
}

