/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenIniFileAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        if (this.window != null) {
            Object object;
            FileDialog fileDialog = new FileDialog(new Shell(), 4096);
            try {
                object = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (object != null) {
                    object.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", (IWorkbenchWindow)object);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException workbenchException) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening perspective Grainspotter: " + workbenchException.getMessage()));
            }
            fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
            fileDialog.setFilterNames(IVarKeys.FILTER_NAMES_INI);
            fileDialog.setText("Select an ini file.");
            object = fileDialog.open();
            if (object != null) {
                File file;
                if (!((String)object).endsWith(".ini")) {
                    object = String.valueOf(object) + ".ini";
                }
                if ((file = new File((String)object)).exists()) {
                    this.input = OpenIniFileAction.createEditorInput(file);
                    String string = GrainspotterInputEditor.getID();
                    try {
                        this.window.getActivePage().openEditor(this.input, string);
                    }
                    catch (PartInitException partInitException) {
                        MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening ini file: " + partInitException.getMessage()));
                    }
                } else {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening ini file: " + file.getName()));
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public static GrainspotterIniInput createEditorInput(File file) {
        Path path = new Path(file.getAbsolutePath());
        GrainspotterIniInput grainspotterIniInput = new GrainspotterIniInput((IPath)path);
        return grainspotterIniInput;
    }
}

