/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.view.Grains3DView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenGveFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        this.launchAction();
    }

    private void launchAction() {
        if (this.window != null) {
            try {
                if (this.window != null) {
                    this.window.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", this.window);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException workbenchException) {
                workbenchException.printStackTrace();
            }
            FileDialog fileDialog = new FileDialog(new Shell(), 4096);
            fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
            fileDialog.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
            fileDialog.setText("Select an existing g-vector file.");
            String string = fileDialog.open();
            if (string != null && this.window != null) {
                Grains3DView grains3DView = (Grains3DView)this.window.getActivePage().findView("fable.grainspotter.grains3dview");
                try {
                    this.window.getActivePage().showView("fable.grainspotter.grains3dview");
                }
                catch (PartInitException partInitException) {
                    SWTUtils.excMsgAsync((String)"Error opening Grains3DView", (Exception)((Object)partInitException));
                }
                grains3DView.loadGVectors(string);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public OpenGveFileAction() {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setToolTipText("Select g-vector file (.gve)");
        this.setText("Open G-Vector file (.gve)");
    }

    public void run() {
        this.launchAction();
    }
}

