/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.run.GrainSpotterException;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class CreateNewIniFile
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        if (this.window != null) {
            IWorkbenchWindow iWorkbenchWindow;
            try {
                iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    iWorkbenchWindow.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", iWorkbenchWindow);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException workbenchException) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening perspective Grainspotter: " + workbenchException.getMessage()));
            }
            iWorkbenchWindow = this.getSaveAsFileDialog();
            String string = iWorkbenchWindow.open();
            boolean bl = false;
            bl = ToolBox.checkIfFileExists((String)string) ? FableUtils.confirmMsg((Object)this, (String)(String.valueOf(string) + " already exists. \nDo you want to overwrite it and start with a new .ini file containing default values ?")) : true;
            if (bl) {
                try {
                    this.openNewIniFile(string);
                }
                catch (PartInitException partInitException) {
                    FableUtils.excMsg((Object)this, (String)("Error opening ini file " + string), (Throwable)partInitException);
                }
            }
        }
    }

    public FileDialog getSaveAsFileDialog() {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog fileDialog = new FileDialog(this.window.getShell(), 8192);
        fileDialog.setText("Create a new ini file.");
        fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
        fileDialog.setFilterNames(IVarKeys.FILTER_NAMES_INI);
        return fileDialog;
    }

    public void openNewIniFile(String string) throws PartInitException {
        if (string != null && !string.equals("")) {
            String string2;
            block3: {
                this.input = this.createEditorInput(new File(string));
                string2 = GrainspotterInputEditor.getID();
                try {
                    ((GrainspotterIniInput)this.input).getInputFile().initWithDefaultValues();
                    ((GrainspotterIniInput)this.input).getInputFile().save();
                }
                catch (GrainSpotterException grainSpotterException) {
                    if (FableMessageConsole.console == null) break block3;
                    FableMessageConsole.console.displayError(grainSpotterException.get_message());
                    SWTUtils.errMsgAsync((String)grainSpotterException.get_message());
                }
            }
            this.window.getActivePage().openEditor(this.input, string2);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private GrainspotterIniInput createEditorInput(File file) {
        Path path = new Path(file.getAbsolutePath());
        GrainspotterIniInput grainspotterIniInput = new GrainspotterIniInput((IPath)path);
        return grainspotterIniInput;
    }
}

