/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.views;

import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.StringText;
import fable.framework.ui.views.JmolView;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.internal.PolyXSim;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;

public class PolyXSimInputView
extends ViewPart {
    public static final String ID = "fable.polyxsim.views.polyxsiminputview";
    private static Composite parent;
    private static Shell shell;
    public static PolyXSimInputView view;
    private static FloatText wavelengthFloatText;
    private static FloatText fluxFloatText;
    private static FloatText polarisationFactorFloatText;
    private static FloatText polarisationDirectionFloatText;
    private static FloatText beamCenterZFloatText;
    private static FloatText beamCenterYFloatText;
    private static FloatText pixelSizeZFloatText;
    private static FloatText pixelSizeYFloatText;
    private static FloatText detSizeYFloatText;
    private static FloatText detSizeZFloatText;
    private static FloatText samp2DetFloatText;
    private static FloatText detTiltXFloatText;
    private static FloatText detTiltYFloatText;
    private static FloatText detTiltZFloatText;
    private static Combo o11Combo;
    private static Combo o12Combo;
    private static Combo o21Combo;
    private static Combo o22Combo;
    private static Combo omegaDirectionCombo;
    private static FloatText wedgeFloatText;
    private static FloatText omegaMinFloatText;
    private static FloatText omegaMaxFloatText;
    private static FloatText omegaStepFloatText;
    private static FloatText grainNumFloatText;
    private static FloatText[] phaseGrainSizeFloatText;
    private static FloatText[] phaseGrainMinSizeFloatText;
    private static FloatText[] phaseGrainMaxSizeFloatText;
    private static Button grainOrientationButton;
    private static Button grainPositionButton;
    private static FloatText sampleXFloatText;
    private static FloatText sampleYFloatText;
    private static FloatText sampleZFloatText;
    private static FloatText[] unitCellAFloatText;
    private static FloatText[] unitCellBFloatText;
    private static FloatText[] unitCellCFloatText;
    private static FloatText[] unitCellAlphaFloatText;
    private static FloatText[] unitCellBetaFloatText;
    private static FloatText[] unitCellGammaFloatText;
    private static IntegerText[] unitCellSpaceGroupIntegerText;
    private static StringText[] structureFileText;
    private static Button[] structureFileViewButton;
    private static StringText inputFileFileText;
    private static Button imageFlagButton;
    private static StringText imageStemFileText;
    private static Combo fileFormatCombo;
    private static Button addNoiseButton;
    private static FloatText backgroundCountsFloatText;
    private static Button psfButton;
    private static Button outputFltButton;
    private static Button outputGveButton;
    private static Button outputUbiButton;
    private static Button outputParButton;
    private static Text inputFileText;
    private TabFolder tabFolder;
    private TabItem[] tabItem = new TabItem[6];
    private static Composite[] container;
    private ScrolledComposite[] scrolledComposite = new ScrolledComposite[6];
    static Button outputFileBrowseButton;
    GridLayout gridLayout;
    private static Combo intensityCombo;
    private static Button lorentzFactorButton;
    private static Button polarisationButton;
    private static Combo peakTypeCombo;
    private static FloatText gaussianPeakPixelsFloatText;
    private static FloatText gaussianPeakDegreesFloatText;
    private static Combo odfTypeCombo;
    private static StringText odfFileStringText;
    private static Button odfFileBrowseButton;
    private static FloatText mosaicityFloatText;
    private FloatText sampleHeightFloatText;
    private FloatText sampleDiameterFloatText;
    private static String[] structureFiles;
    private static Float[] unitCell;
    private Button addPhaseButton;
    private Button deletePhaseButton;
    private static Group grainSizeGroup;
    private static Combo sampleShapeCombo;
    private static Combo[] phaseDistributionCombo;
    private static IntegerText phasesNumIntegerText;
    private static int numPhases;
    private static Group structureFileGroup;
    private static Group unitCellGroup;
    private static Button structureFileButton;
    private static Button structureCellButton;
    private static String inputFileDirectory;
    private static Button[] structureFileBrowseButton;
    private static IntegerText[] phaseNumGrainsIntegerText;
    private static Label[] phaseLabel;
    private static Integer[] phaseGrains;
    private static Integer[] phases;
    private static Float[] phaseGrainSize;
    private static Float[] phaseGrainMinSize;
    private static Float[] phaseGrainMaxSize;
    static final int FILES_TAB = 0;
    static final int CRYSTAL_TAB = 1;
    static final int SAMPLE_TAB = 2;
    static final int REFLECTIONS_TAB = 3;
    static final int INSTRUMENTAL_TAB = 4;
    static final int DETECTOR_TAB = 5;

    static {
        structureFileText = null;
        structureFileViewButton = null;
        container = new Composite[6];
        structureFiles = null;
        unitCell = null;
        phaseDistributionCombo = null;
        numPhases = 1;
        phaseLabel = null;
        phaseGrains = null;
        phases = null;
        phaseGrainSize = null;
        phaseGrainMinSize = null;
        phaseGrainMaxSize = null;
    }

    public void createPartControl(Composite composite) {
        parent = composite;
        shell = parent.getShell();
        view = this;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.makeColumnsEqualWidth = true;
        this.tabFolder = new TabFolder(parent, 2560);
        this.tabFolder.setLayout((Layout)gridLayout);
        int n = 0;
        while (n < container.length) {
            this.scrolledComposite[n] = new ScrolledComposite((Composite)this.tabFolder, 2816);
            PolyXSimInputView.container[n] = new Composite((Composite)this.scrolledComposite[n], 20);
            container[n].setLayout((Layout)gridLayout);
            container[n].setLayoutData((Object)new GridData(4, 4, true, true));
            this.scrolledComposite[n].setContent((Control)container[n]);
            this.scrolledComposite[n].setMinSize(800, 500);
            this.scrolledComposite[n].setExpandHorizontal(true);
            this.scrolledComposite[n].setExpandVertical(true);
            ++n;
        }
        n = 0;
        while (n < this.tabItem.length) {
            this.tabItem[n] = new TabItem(this.tabFolder, 20);
            this.tabItem[n].setControl((Control)this.scrolledComposite[n]);
            ++n;
        }
        this.createFileTab();
        this.createCrystalPhasesTab();
        this.createSampleTab();
        this.createReflectionsTab();
        this.createInstrumentalTab();
        this.createDetectorTab();
        this.setHelpContextIDs();
    }

    private void createFileTab() {
        this.tabItem[0].setText("Files");
        Group group = LookAndFeel.getGroup((Composite)container[0], (String)"Output", (int)6, (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)gridLayout);
        imageFlagButton = new Button((Composite)group, 32);
        imageFlagButton.setText("Images in format");
        imageFlagButton.setToolTipText("Generate images during simulation");
        imageFlagButton.setLayoutData((Object)new GridData(4, 4, false, true));
        fileFormatCombo = new Combo((Composite)group, 8);
        fileFormatCombo.setLayoutData((Object)new GridData(16, 16, false, false));
        fileFormatCombo.setToolTipText("Image file format");
        fileFormatCombo.add("tif");
        fileFormatCombo.add("tif16bit");
        fileFormatCombo.add("edf");
        fileFormatCombo.setText("tif");
        outputFltButton = new Button((Composite)group, 32);
        outputFltButton.setText("Filtered peaks");
        outputFltButton.setToolTipText("Filtered peaks .flt file");
        outputFltButton.setLayoutData((Object)new GridData(4, 16, true, true));
        outputGveButton = new Button((Composite)group, 32);
        outputGveButton.setText("Scattering vectors");
        outputGveButton.setToolTipText("Scattering vectors .gve file");
        outputGveButton.setLayoutData((Object)new GridData(4, 16, true, true));
        outputUbiButton = new Button((Composite)group, 32);
        outputUbiButton.setText("Grain orientation");
        outputUbiButton.setToolTipText("Grain orientation .ubi file");
        outputUbiButton.setLayoutData((Object)new GridData(4, 16, true, true));
        outputParButton = new Button((Composite)group, 32);
        outputParButton.setText("Parameters");
        outputParButton.setToolTipText("ImageD11 parameters .par file");
        outputParButton.setLayoutData((Object)new GridData(4, 16, true, true));
        imageStemFileText = new StringText((Composite)group, 0, "File stem");
        GridData gridData = new GridData(4, 16, true, true);
        gridData.horizontalSpan = 5;
        imageStemFileText.setLayoutData((Object)gridData);
        Button button = new Button((Composite)group, 8);
        button.setText("Browse");
        button.setToolTipText("Select or enter the image stem directory file");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText("Select an existing directory or enter a new directory name");
                String string = directoryDialog.open();
                if (string != null) {
                    imageStemFileText.set_Text(string);
                }
            }
        });
        Group group2 = LookAndFeel.getGroup((Composite)container[0], (String)"Input", (int)3, (int)1);
        inputFileFileText = new StringText((Composite)group2, 0, "Input file");
        inputFileFileText.set_isRequiredField(true);
        inputFileFileText.setLayoutData((Object)new GridData(4, 4, true, true));
        Button button2 = new Button((Composite)group2, 8);
        button2.setText("Browse");
        button2.setToolTipText("Select or enter an input parameter file");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell(), 0);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDialog.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                fileDialog.setText("Select an existing Farfield Simulation input file or enter a new file name");
                String string = fileDialog.open();
                if (string != null) {
                    FableMessageConsole.console.displayOut("read farfield simulation input file " + string);
                    PolyXSimInputView.loadInputFile(string);
                    PolyXSim.loadInputFile(string);
                    PolyXSimInputView.getInputValues();
                }
            }
        });
        outputFileBrowseButton = new Button((Composite)group2, 8);
        outputFileBrowseButton.setText("Save as");
        outputFileBrowseButton.setToolTipText("Select or enter an output parameter file");
        outputFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell(), 0);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDialog.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                fileDialog.setText("Select an existing Farfield Simulation input file");
                String string = fileDialog.open();
                if (string != null) {
                    FableMessageConsole.console.displayOut("write farfield simulation input file " + string);
                    PolyXSimInputView.this.writeInputFile(string);
                }
            }
        });
        outputFileBrowseButton.setEnabled(false);
        GridData gridData2 = new GridData(4, 4, true, true);
        inputFileText = new Text(container[0], 2882);
        inputFileText.setText("Input file contents will be displayed here ...");
        inputFileText.setLayoutData((Object)gridData2);
        inputFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                outputFileBrowseButton.setEnabled(true);
            }
        });
    }

    public void createCrystalPhasesTab() {
        this.tabItem[1].setText("Crystal Phases");
        Group group = LookAndFeel.getGroup((Composite)container[1], (String)"Structure phases", (int)3, (int)1);
        this.gridLayout = (GridLayout)group.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        phasesNumIntegerText = new IntegerText((Composite)group, 8, "Number of phases in sample");
        phasesNumIntegerText.setToolTipText("Number of structure phases");
        phasesNumIntegerText.set_isRequiredField(true);
        phasesNumIntegerText.setLayoutData((Object)new GridData(4, 16, true, true));
        phasesNumIntegerText.setEnabled(false);
        this.addPhaseButton = new Button((Composite)group, 8);
        this.addPhaseButton.setText("Add phase");
        this.addPhaseButton.setToolTipText("Add new phase");
        this.addPhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                numPhases = numPhases + 1;
                phasesNumIntegerText.set_Text(Integer.toString(numPhases));
                PolyXSimInputView.this.deletePhaseButton.setEnabled(true);
                PolyXSimInputView.createPhaseGrains();
                PolyXSimInputView.createStructureFileGroup();
                int n = 0;
                while (n < PolyXSim.getNumPhases()) {
                    if (PolyXSim.getStructureFile(n) != null) {
                        structureFileText[n].set_Text(PolyXSim.getStructureFile(n));
                    }
                    ++n;
                }
                PolyXSimInputView.createUnitCellGroup();
            }
        });
        this.deletePhaseButton = new Button((Composite)group, 8);
        this.deletePhaseButton.setText("Delete phase");
        this.deletePhaseButton.setToolTipText("Delete last phase");
        this.deletePhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (numPhases > 1) {
                    numPhases = numPhases - 1;
                    phasesNumIntegerText.set_Text(Integer.toString(numPhases));
                    PolyXSimInputView.createStructureFileGroup();
                    PolyXSimInputView.createUnitCellGroup();
                    PolyXSimInputView.createPhaseGrains();
                    if (numPhases <= 1) {
                        PolyXSimInputView.this.deletePhaseButton.setEnabled(false);
                    }
                }
            }
        });
        structureFileButton = new Button((Composite)group, 16);
        structureFileButton.setText("Read structure from file (cif or pdb)");
        structureCellButton = new Button((Composite)group, 16);
        structureCellButton.setText("Choose space group and specify unit cell");
        structureFileGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure file(s)", (int)3, (int)1);
        structureCellButton.setSelection(false);
        structureFileButton.setSelection(true);
        new Label((Composite)group, 0);
        this.gridLayout = (GridLayout)structureFileGroup.getLayout();
        structureFiles = new String[numPhases];
        PolyXSimInputView.createStructureFileGroup();
        structureFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (structureFileButton.getSelection()) {
                    PolyXSimInputView.setEnableGroup(structureFileGroup, true);
                    PolyXSimInputView.setEnableGroup(unitCellGroup, false);
                } else {
                    PolyXSimInputView.setEnableGroup(structureFileGroup, false);
                    PolyXSimInputView.setEnableGroup(unitCellGroup, true);
                }
                PolyXSimInputView.createStructureFileGroup();
                PolyXSimInputView.createUnitCellGroup();
            }
        });
        unitCellGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Unit cell(s)", (int)7, (int)1);
        this.gridLayout = (GridLayout)unitCellGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        unitCell = new Float[numPhases];
        PolyXSimInputView.createUnitCellGroup();
        structureCellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (structureCellButton.getSelection()) {
                    PolyXSimInputView.setEnableGroup(structureFileGroup, false);
                    PolyXSimInputView.setEnableGroup(unitCellGroup, true);
                } else {
                    PolyXSimInputView.setEnableGroup(structureFileGroup, true);
                    PolyXSimInputView.setEnableGroup(unitCellGroup, false);
                }
                PolyXSimInputView.createStructureFileGroup();
                PolyXSimInputView.createUnitCellGroup();
            }
        });
        PolyXSimInputView.setEnableGroup(structureFileGroup, true);
        PolyXSimInputView.setEnableGroup(unitCellGroup, false);
    }

    private static void createStructureFileGroup() {
        int n;
        if (structureFileText != null) {
            structureFiles = new String[numPhases];
            n = 0;
            while (n < structureFileText.length) {
                if (n < structureFiles.length && !structureFileText[n].isDisposed()) {
                    PolyXSimInputView.structureFiles[n] = structureFileText[n].getText();
                }
                structureFileText[n].dispose();
                structureFileViewButton[n].dispose();
                structureFileBrowseButton[n].dispose();
                ++n;
            }
            structureFileText = null;
            structureFileViewButton = null;
            structureFileViewButton = null;
        }
        if (structureFileButton.getSelection()) {
            structureFileText = new StringText[numPhases];
            structureFileViewButton = new Button[numPhases];
            structureFileBrowseButton = new Button[numPhases];
            n = 0;
            while (n < numPhases) {
                PolyXSimInputView.structureFileText[n] = new StringText((Composite)structureFileGroup, 0, "Structure file for phase " + n);
                if (n < structureFiles.length && structureFiles[n] != null) {
                    structureFileText[n].set_Text(structureFiles[n]);
                }
                structureFileText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.structureFileBrowseButton[n] = new Button((Composite)structureFileGroup, 8);
                structureFileBrowseButton[n].setText("Browse");
                structureFileBrowseButton[n].setToolTipText("Browse structure file");
                structureFileBrowseButton[n].setData((Object)n);
                structureFileBrowseButton[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Integer n = (Integer)selectionEvent.widget.getData();
                        FileDialog fileDialog = new FileDialog(shell, 4096);
                        fileDialog.setText("Select an existing structure file");
                        String string = fileDialog.open();
                        if (string != null) {
                            structureFiles[n.intValue()] = string;
                            structureFileText[n].set_Text(string);
                        }
                    }
                });
                PolyXSimInputView.structureFileViewButton[n] = new Button((Composite)structureFileGroup, 8);
                structureFileViewButton[n].setText("View");
                structureFileViewButton[n].setToolTipText("View 3D structure");
                structureFileViewButton[n].setData((Object)n);
                structureFileViewButton[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Integer n = (Integer)selectionEvent.widget.getData();
                        String string = structureFileText[n].getText();
                        PolyXSimInputView.openJmolView(string);
                    }
                });
                ++n;
            }
        }
        structureFileGroup.pack();
        container[1].pack();
    }

    private static void createUnitCellGroup() {
        int n;
        if (unitCellAFloatText != null) {
            unitCell = new Float[numPhases * 7];
            n = 0;
            while (n < unitCellAFloatText.length) {
                if ((n + 1) * 7 <= unitCell.length) {
                    PolyXSimInputView.unitCell[n * 7] = unitCellAFloatText[n].getValue();
                    PolyXSimInputView.unitCell[n * 7 + 1] = unitCellBFloatText[n].getValue();
                    PolyXSimInputView.unitCell[n * 7 + 2] = unitCellCFloatText[n].getValue();
                    PolyXSimInputView.unitCell[n * 7 + 3] = unitCellAlphaFloatText[n].getValue();
                    PolyXSimInputView.unitCell[n * 7 + 4] = unitCellBetaFloatText[n].getValue();
                    PolyXSimInputView.unitCell[n * 7 + 5] = unitCellGammaFloatText[n].getValue();
                    try {
                        if (unitCellSpaceGroupIntegerText[n].getText() != null) {
                            PolyXSimInputView.unitCell[n * 7 + 6] = Float.valueOf(unitCellSpaceGroupIntegerText[n].getText());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                unitCellAFloatText[n].dispose();
                unitCellBFloatText[n].dispose();
                unitCellCFloatText[n].dispose();
                unitCellAlphaFloatText[n].dispose();
                unitCellBetaFloatText[n].dispose();
                unitCellGammaFloatText[n].dispose();
                unitCellSpaceGroupIntegerText[n].dispose();
                ++n;
            }
            unitCellAFloatText = null;
            unitCellBFloatText = null;
            unitCellCFloatText = null;
            unitCellAlphaFloatText = null;
            unitCellBetaFloatText = null;
            unitCellGammaFloatText = null;
            unitCellSpaceGroupIntegerText = null;
        }
        if (structureCellButton.getSelection()) {
            unitCellAFloatText = new FloatText[numPhases];
            unitCellBFloatText = new FloatText[numPhases];
            unitCellCFloatText = new FloatText[numPhases];
            unitCellAlphaFloatText = new FloatText[numPhases];
            unitCellBetaFloatText = new FloatText[numPhases];
            unitCellGammaFloatText = new FloatText[numPhases];
            unitCellSpaceGroupIntegerText = new IntegerText[numPhases];
            n = 0;
            while (n < numPhases) {
                PolyXSimInputView.unitCellAFloatText[n] = new FloatText((Composite)unitCellGroup, 0, "a (\u212b)");
                unitCellAFloatText[n].set_isRequiredField(true);
                unitCellAFloatText[n].setToolTipText("Unit cell a axis in Angstroms");
                unitCellAFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellBFloatText[n] = new FloatText((Composite)unitCellGroup, 0, "b (\u212b)");
                unitCellBFloatText[n].set_isRequiredField(true);
                unitCellBFloatText[n].setToolTipText("Unit cell b axis in Angstroms");
                unitCellBFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellCFloatText[n] = new FloatText((Composite)unitCellGroup, 0, "c (\u212b)");
                unitCellCFloatText[n].set_isRequiredField(true);
                unitCellCFloatText[n].setToolTipText("Unit cell c axis in Angstroms");
                unitCellCFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellAlphaFloatText[n] = new FloatText((Composite)unitCellGroup, 0, "\u03b1 (\u00b0)");
                unitCellAlphaFloatText[n].set_isRequiredField(true);
                unitCellAlphaFloatText[n].setToolTipText("Unit cell alpha angle in degrees");
                unitCellAlphaFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellBetaFloatText[n] = new FloatText((Composite)unitCellGroup, 0, "\u03b2 (\u00b0)");
                unitCellBetaFloatText[n].set_isRequiredField(true);
                unitCellBetaFloatText[n].setToolTipText("Unit cell beta angle in degrees");
                unitCellBetaFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellGammaFloatText[n] = new FloatText((Composite)unitCellGroup, 0, "\u03b3 (\u00b0)");
                unitCellGammaFloatText[n].set_isRequiredField(true);
                unitCellGammaFloatText[n].setToolTipText("Unit cell gamma angle in degrees");
                unitCellGammaFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellSpaceGroupIntegerText[n] = new IntegerText((Composite)unitCellGroup, 0, "Space\nGroup");
                unitCellSpaceGroupIntegerText[n].set_isRequiredField(true);
                unitCellSpaceGroupIntegerText[n].setToolTipText("Unit cell space group number");
                unitCellSpaceGroupIntegerText[n].setLayoutData((Object)new GridData(4, 16, true, true));
                if ((n + 1) * 7 <= unitCell.length) {
                    if (unitCell[n * 7] != null) {
                        unitCellAFloatText[n].set_Text(Float.toString(unitCell[n * 7].floatValue()));
                    }
                    if (unitCell[n * 7 + 1] != null) {
                        unitCellBFloatText[n].set_Text(Float.toString(unitCell[n * 7 + 1].floatValue()));
                    }
                    if (unitCell[n * 7 + 2] != null) {
                        unitCellCFloatText[n].set_Text(Float.toString(unitCell[n * 7 + 2].floatValue()));
                    }
                    if (unitCell[n * 7 + 3] != null) {
                        unitCellAlphaFloatText[n].set_Text(Float.toString(unitCell[n * 7 + 3].floatValue()));
                    }
                    if (unitCell[n * 7 + 4] != null) {
                        unitCellBetaFloatText[n].set_Text(Float.toString(unitCell[n * 7 + 4].floatValue()));
                    }
                    if (unitCell[n * 7 + 5] != null) {
                        unitCellGammaFloatText[n].set_Text(Float.toString(unitCell[n * 7 + 5].floatValue()));
                    }
                    if (unitCell[n * 7 + 6] != null) {
                        unitCellSpaceGroupIntegerText[n].set_Text(Integer.toString(unitCell[n * 7 + 6].intValue()));
                    }
                }
                ++n;
            }
        }
        unitCellGroup.pack();
        container[1].pack();
    }

    public void createSampleTab() {
        this.tabItem[2].setText("Sample");
        Group group = LookAndFeel.getGroup((Composite)container[2], (String)"Sample", (int)2, (int)1);
        this.gridLayout = (GridLayout)group.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout());
        this.gridLayout = (GridLayout)composite.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        composite.setLayoutData((Object)new GridData(4, 16, true, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16, 16, true, false));
        label.setText("Sample shape");
        sampleShapeCombo = new Combo(composite, 8);
        sampleShapeCombo.setLayoutData((Object)new GridData(16, 0x1000000, true, false));
        sampleShapeCombo.add("cylinder");
        sampleShapeCombo.add("box");
        new Label((Composite)group, 0);
        final Group group2 = LookAndFeel.getGroup((Composite)group, (String)"Box dimensions", (int)3, (int)1);
        this.gridLayout = (GridLayout)group.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        sampleXFloatText = new FloatText((Composite)group2, 0, "X (mm)");
        sampleXFloatText.set_isRequiredField(true);
        sampleXFloatText.setToolTipText("X sample size in mm");
        sampleXFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        sampleYFloatText = new FloatText((Composite)group2, 0, "Y (mm)");
        sampleYFloatText.set_isRequiredField(true);
        sampleYFloatText.setToolTipText("Y sample size in mm");
        sampleYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        sampleZFloatText = new FloatText((Composite)group2, 0, "Z (mm)");
        sampleZFloatText.set_isRequiredField(true);
        sampleZFloatText.setToolTipText("Z sample size in mm");
        sampleZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        final Group group3 = LookAndFeel.getGroup((Composite)group, (String)"Cylinder dimensions", (int)2, (int)1);
        this.gridLayout = (GridLayout)group.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.sampleHeightFloatText = new FloatText((Composite)group3, 0, "Diameter (mm)");
        this.sampleHeightFloatText.set_isRequiredField(true);
        this.sampleHeightFloatText.setToolTipText("Sample diameter in mm");
        this.sampleHeightFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sampleDiameterFloatText = new FloatText((Composite)group3, 0, "Height (mm)");
        this.sampleDiameterFloatText.set_isRequiredField(true);
        this.sampleDiameterFloatText.setToolTipText("Sample height in mm");
        this.sampleDiameterFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        sampleShapeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = sampleShapeCombo.getText();
                if (string.equalsIgnoreCase("cylinder")) {
                    PolyXSimInputView.setEnableGroup(group2, false);
                    PolyXSimInputView.setEnableGroup(group3, true);
                } else {
                    PolyXSimInputView.setEnableGroup(group2, true);
                    PolyXSimInputView.setEnableGroup(group3, false);
                }
            }
        });
        sampleShapeCombo.setText("box");
        Group group4 = LookAndFeel.getGroup((Composite)container[2], (String)"Grains", (int)3, (int)1);
        this.gridLayout = (GridLayout)group4.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        grainNumFloatText = new FloatText((Composite)group4, 0, "Total number of grains");
        grainNumFloatText.setToolTipText("Total number of grains");
        grainNumFloatText.set_isRequiredField(true);
        grainNumFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)group4, 0);
        new Label((Composite)group4, 0);
        grainSizeGroup = LookAndFeel.getGroup((Composite)group4, (String)"Size(s)", (int)6, (int)1);
        GridData gridData = new GridData(4, 16, true, true);
        gridData.horizontalSpan = 4;
        grainSizeGroup.setLayoutData((Object)gridData);
        grainPositionButton = new Button((Composite)grainSizeGroup, 32);
        grainPositionButton.setText("Generate random size(s)");
        grainPositionButton.setToolTipText("Generate grain positions");
        Label label2 = new Label((Composite)grainSizeGroup, 0);
        GridData gridData2 = new GridData(16, 16, true, false);
        gridData2.horizontalSpan = 5;
        label2.setLayoutData((Object)gridData2);
        PolyXSimInputView.createPhaseGrains();
        Group group5 = LookAndFeel.getGroup((Composite)group4, (String)"Orientation(s)", (int)10, (int)1);
        this.gridLayout = (GridLayout)group5.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        grainOrientationButton = new Button((Composite)group5, 32);
        grainOrientationButton.setText("Generate random orientations");
        grainOrientationButton.setToolTipText("Generate grain orientations");
        Label label3 = new Label((Composite)group5, 0);
        GridData gridData3 = new GridData(16, 16, true, false);
        gridData3.horizontalSpan = 9;
        label3.setLayoutData((Object)gridData3);
    }

    private static void createPhaseGrains() {
        int n;
        if (phaseLabel != null) {
            n = 0;
            while (n < phaseLabel.length) {
                phaseLabel[n].dispose();
                phaseNumGrainsIntegerText[n].dispose();
                phaseDistributionCombo[n].dispose();
                phaseGrainSizeFloatText[n].dispose();
                phaseGrainMinSizeFloatText[n].dispose();
                phaseGrainMaxSizeFloatText[n].dispose();
                ++n;
            }
        }
        phaseLabel = new Label[numPhases];
        phaseNumGrainsIntegerText = new IntegerText[numPhases];
        phaseDistributionCombo = new Combo[numPhases];
        phaseGrainSizeFloatText = new FloatText[numPhases];
        phaseGrainMinSizeFloatText = new FloatText[numPhases];
        phaseGrainMaxSizeFloatText = new FloatText[numPhases];
        n = 0;
        while (n < numPhases) {
            PolyXSimInputView.phaseLabel[n] = new Label((Composite)grainSizeGroup, 0);
            phaseLabel[n].setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            phaseLabel[n].setText("Phase " + n);
            PolyXSimInputView.phaseNumGrainsIntegerText[n] = new IntegerText((Composite)grainSizeGroup, 0, "Grains");
            phaseNumGrainsIntegerText[n].setToolTipText("Number of grains in this phase");
            phaseNumGrainsIntegerText[n].set_isRequiredField(true);
            phaseNumGrainsIntegerText[n].setLayoutData((Object)new GridData(4, 16, true, true));
            PolyXSimInputView.phaseDistributionCombo[n] = new Combo((Composite)grainSizeGroup, 8);
            phaseDistributionCombo[n].setLayoutData((Object)new GridData(16, 0x1000000, true, true));
            phaseDistributionCombo[n].add("fixed");
            phaseDistributionCombo[n].add("lognormal");
            phaseDistributionCombo[n].setText("lognormal");
            phaseDistributionCombo[n].setToolTipText("Grain size distribution");
            PolyXSimInputView.phaseGrainSizeFloatText[n] = new FloatText((Composite)grainSizeGroup, 0, "Median");
            phaseGrainSizeFloatText[n].setToolTipText("Median grain size for log normal distribution");
            phaseGrainSizeFloatText[n].set_isRequiredField(true);
            phaseGrainSizeFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
            PolyXSimInputView.phaseGrainMinSizeFloatText[n] = new FloatText((Composite)grainSizeGroup, 0, "Min");
            phaseGrainMinSizeFloatText[n].setToolTipText("Minimum grain cutoff size");
            phaseGrainMinSizeFloatText[n].set_isRequiredField(true);
            phaseGrainMinSizeFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
            PolyXSimInputView.phaseGrainMaxSizeFloatText[n] = new FloatText((Composite)grainSizeGroup, 0, "Max");
            phaseGrainMaxSizeFloatText[n].setToolTipText("Maximum grain cutoff size");
            phaseGrainMaxSizeFloatText[n].set_isRequiredField(true);
            phaseGrainMaxSizeFloatText[n].setLayoutData((Object)new GridData(4, 16, true, true));
            ++n;
        }
        grainSizeGroup.pack();
        container[2].pack();
    }

    public void createReflectionsTab() {
        this.tabItem[3].setText("Reflections");
        Group group = LookAndFeel.getGroup((Composite)container[3], (String)"Reflection intensities", (int)5, (int)1);
        this.gridLayout = (GridLayout)group.getLayout();
        this.gridLayout.numColumns = 5;
        this.gridLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)this.gridLayout);
        Label label = new Label((Composite)group, 0x1000000);
        label.setText("Intensity");
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        intensityCombo = new Combo((Composite)group, 8);
        intensityCombo.setLayoutData((Object)new GridData(16, 16, true, false));
        intensityCombo.add("constant");
        intensityCombo.add("structure factors");
        intensityCombo.setText("structure factors");
        FloatText floatText = new FloatText((Composite)group, 0, "constant");
        floatText.setLayoutData((Object)new GridData(16, 16, true, false));
        lorentzFactorButton = new Button((Composite)group, 32);
        lorentzFactorButton.setText("Apply Lorentz factor");
        lorentzFactorButton.setLayoutData((Object)new GridData(16, 16, true, false));
        polarisationButton = new Button((Composite)group, 32);
        polarisationButton.setText("Apply beam polarisation");
        polarisationButton.setLayoutData((Object)new GridData(16, 16, true, false));
        Group group2 = LookAndFeel.getGroup((Composite)container[3], (String)"Diffraction peaks", (int)2, (int)1);
        this.gridLayout = (GridLayout)group2.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        group2.setLayout((Layout)this.gridLayout);
        new Label((Composite)group2, 0);
        Composite composite = new Composite((Composite)group2, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)this.gridLayout);
        Label label2 = new Label(composite, 0x1000000);
        label2.setText("Peak type");
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        peakTypeCombo = new Combo(composite, 8);
        peakTypeCombo.setLayoutData((Object)new GridData(16, 16, true, false));
        peakTypeCombo.add("spike 2x2 square");
        peakTypeCombo.add("Gaussian");
        peakTypeCombo.add("ODF");
        peakTypeCombo.setText("spike 2x2 square");
        Group group3 = LookAndFeel.getGroup((Composite)group2, (String)"Gaussian peak parameters", (int)2, (int)1);
        group3.setLayoutData((Object)new GridData(16, 16, true, false));
        gaussianPeakPixelsFloatText = new FloatText((Composite)group3, 0, "FWHM (pixels)");
        gaussianPeakPixelsFloatText.set_isRequiredField(true);
        gaussianPeakPixelsFloatText.setToolTipText("Guassian peak spread in pixels");
        gaussianPeakPixelsFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        gaussianPeakDegreesFloatText = new FloatText((Composite)group3, 0, "FWHM (degrees)");
        gaussianPeakDegreesFloatText.set_isRequiredField(true);
        gaussianPeakDegreesFloatText.setToolTipText("Guassian peak spread in degrees");
        gaussianPeakDegreesFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group group4 = LookAndFeel.getGroup((Composite)group2, (String)"Orientation distribution function", (int)3, (int)1);
        group4.setLayoutData((Object)new GridData(4, 16, true, false));
        odfTypeCombo = new Combo((Composite)group4, 8);
        odfTypeCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        odfTypeCombo.add("isotropic Gaussian");
        odfTypeCombo.add("grid from file");
        odfTypeCombo.setText("isotropic Gaussian");
        odfTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = odfTypeCombo.getText();
                if (string.contains("Gaussian")) {
                    odfFileStringText.setEnabled(false);
                    odfFileBrowseButton.setEnabled(false);
                    mosaicityFloatText.setEnabled(true);
                } else {
                    odfFileStringText.setEnabled(true);
                    odfFileBrowseButton.setEnabled(true);
                    mosaicityFloatText.setEnabled(false);
                }
            }
        });
        odfFileStringText = new StringText((Composite)group4, 0, "ODF file");
        odfFileStringText.set_isRequiredField(true);
        odfFileStringText.setToolTipText("ODF file grid");
        odfFileStringText.setLayoutData((Object)new GridData(4, 16, true, true));
        odfFileBrowseButton = new Button((Composite)group4, 8);
        odfFileBrowseButton.setText("Browse");
        odfFileBrowseButton.setToolTipText("Browse ODF file");
        odfFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText("Select an existing structure file");
                String string = fileDialog.open();
                if (string != null) {
                    odfFileStringText.set_Text(string);
                }
            }
        });
        odfFileStringText.setEnabled(false);
        odfFileBrowseButton.setEnabled(false);
        new Label((Composite)group4, 0);
        mosaicityFloatText = new FloatText((Composite)group4, 0, "Mosaicity (degrees)");
        mosaicityFloatText.set_isRequiredField(true);
        mosaicityFloatText.setToolTipText("Mosaicity in degrees");
        mosaicityFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
    }

    public void createInstrumentalTab() {
        this.tabItem[4].setText("Instrumental");
        Group group = LookAndFeel.getGroup((Composite)container[4], (String)"Beam", (int)4, (int)1);
        Label label = new Label((Composite)group, 0);
        label.setText("Wavelength (angstrom)");
        wavelengthFloatText = new FloatText((Composite)group, 0, "");
        wavelengthFloatText.set_isRequiredField(true);
        wavelengthFloatText.setToolTipText("wavelength in Angstrom");
        wavelengthFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Flux (ph/s/mm2)");
        fluxFloatText = new FloatText((Composite)group, 0, "");
        fluxFloatText.set_isRequiredField(true);
        fluxFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label3 = new Label((Composite)group, 0);
        label3.setText("Polarisation factor (percent)");
        polarisationFactorFloatText = new FloatText((Composite)group, 0, "");
        polarisationFactorFloatText.set_isRequiredField(true);
        polarisationFactorFloatText.setToolTipText("polarisation factor in percent");
        polarisationFactorFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label4 = new Label((Composite)group, 0);
        label4.setText("Polarisation direction (degrees)");
        polarisationDirectionFloatText = new FloatText((Composite)group, 0, "");
        polarisationDirectionFloatText.set_isRequiredField(true);
        polarisationDirectionFloatText.setToolTipText("polarisation direction in degrees");
        polarisationDirectionFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group group2 = LookAndFeel.getGroup((Composite)container[4], (String)"Beam center on detector", (int)4, (int)1);
        Label label5 = new Label((Composite)group2, 0);
        label5.setText("Y beam (pixels)");
        beamCenterYFloatText = new FloatText((Composite)group2, 0, "");
        beamCenterYFloatText.set_isRequiredField(true);
        beamCenterYFloatText.setToolTipText("Y beamcenter in pixel coordinates");
        beamCenterYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label6 = new Label((Composite)group2, 0);
        label6.setText("Z beam (pixels)");
        beamCenterZFloatText = new FloatText((Composite)group2, 0, "");
        beamCenterZFloatText.set_isRequiredField(true);
        beamCenterZFloatText.setToolTipText("Z beamcenter in pixel coordinates");
        beamCenterZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group group3 = LookAndFeel.getGroup((Composite)container[4], (String)"Rotation axis", (int)3, (int)2);
        GridLayout gridLayout = (GridLayout)group3.getLayout();
        gridLayout.makeColumnsEqualWidth = true;
        Label label7 = new Label((Composite)group3, 0x1000000);
        label7.setText("Direction (+/-)");
        label7.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        omegaDirectionCombo = new Combo((Composite)group3, 8);
        omegaDirectionCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        omegaDirectionCombo.add("cw");
        omegaDirectionCombo.add("ccw");
        omegaDirectionCombo.setText("cw");
        wedgeFloatText = new FloatText((Composite)group3, 0, "Wedge (degrees)");
        wedgeFloatText.set_isRequiredField(true);
        wedgeFloatText.setToolTipText("angle between beam and rotation axis minus 90 in degrees");
        wedgeFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        omegaMinFloatText = new FloatText((Composite)group3, 0, "Start (degrees)");
        omegaMinFloatText.set_isRequiredField(true);
        omegaMinFloatText.setToolTipText("minimum rotation angle in degrees");
        omegaMinFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        omegaMaxFloatText = new FloatText((Composite)group3, 0, "End (degrees)");
        omegaMaxFloatText.set_isRequiredField(true);
        omegaMaxFloatText.setToolTipText("maximum rotation angle in degrees");
        omegaMaxFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        omegaStepFloatText = new FloatText((Composite)group3, 0, "Step (degrees)");
        omegaStepFloatText.set_isRequiredField(true);
        omegaStepFloatText.setToolTipText("rotation angle step size in degrees");
        omegaStepFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
    }

    public void createDetectorTab() {
        this.tabItem[5].setText("Detector");
        Composite composite = new Composite(container[5], 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 16, true, false));
        samp2DetFloatText = new FloatText(composite, 16384, "Sample to detector distance (mm)");
        samp2DetFloatText.set_isRequiredField(true);
        samp2DetFloatText.setToolTipText("sample-detector distance in mm");
        samp2DetFloatText.setLayoutData((Object)new GridData(16, 16, true, false));
        new Label(composite, 0x1000000);
        Composite composite2 = new Composite(container[5], 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 16, true, false));
        Group group = LookAndFeel.getGroup((Composite)composite2, (String)"Detector size", (int)4, (int)1);
        this.gridLayout = (GridLayout)group.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label label = new Label((Composite)group, 0);
        label.setText("Y size (pixels)");
        detSizeYFloatText = new FloatText((Composite)group, 0, "");
        detSizeYFloatText.set_isRequiredField(true);
        detSizeYFloatText.setToolTipText("Y detector size in pixels");
        detSizeYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Z size (pixels)");
        detSizeZFloatText = new FloatText((Composite)group, 0, "");
        detSizeZFloatText.set_isRequiredField(true);
        detSizeZFloatText.setToolTipText("Z detector size in pixels");
        detSizeZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group group2 = LookAndFeel.getGroup((Composite)composite2, (String)"Pixel size", (int)4, (int)1);
        this.gridLayout = (GridLayout)group2.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("Y pixel (mm)");
        pixelSizeYFloatText = new FloatText((Composite)group2, 0, "");
        pixelSizeYFloatText.set_isRequiredField(true);
        pixelSizeYFloatText.setToolTipText("Y pixel size in mm");
        pixelSizeYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Z pixel (mm)");
        pixelSizeZFloatText = new FloatText((Composite)group2, 0, "");
        pixelSizeZFloatText.set_isRequiredField(true);
        pixelSizeZFloatText.setToolTipText("Z pixel size in mm");
        pixelSizeZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group group3 = LookAndFeel.getGroup((Composite)container[5], (String)"Detector tilt", (int)6, (int)1);
        this.gridLayout = (GridLayout)group3.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label label5 = new Label((Composite)group3, 0);
        label5.setText("X tilt (radians)");
        detTiltXFloatText = new FloatText((Composite)group3, 0, "");
        detTiltXFloatText.set_isRequiredField(true);
        detTiltXFloatText.setToolTipText("detector tilt counterclockwise around lab x axis in radians");
        detTiltXFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label label6 = new Label((Composite)group3, 0);
        label6.setText("Y tilt (radians)");
        detTiltYFloatText = new FloatText((Composite)group3, 0, "");
        detTiltYFloatText.set_isRequiredField(true);
        detTiltYFloatText.setToolTipText("detector tilt counterclockwise around lab y axis in radians");
        detTiltYFloatText.setLayoutData((Object)new GridData(4, 16, true, false));
        Label label7 = new Label((Composite)group3, 0);
        label7.setText("Z tilt (radians)");
        detTiltZFloatText = new FloatText((Composite)group3, 0, "");
        detTiltZFloatText.set_isRequiredField(true);
        detTiltZFloatText.setToolTipText("Detector tilt counterclockwise around lab z axis in radians");
        detTiltZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group group4 = LookAndFeel.getGroup((Composite)container[5], (String)"Detector orientation", (int)8, (int)1);
        this.gridLayout = (GridLayout)group4.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label label8 = new Label((Composite)group4, 0);
        label8.setText("o11");
        o11Combo = this.createOrientationCombo(group4);
        Label label9 = new Label((Composite)group4, 0);
        label9.setText("o12");
        o12Combo = this.createOrientationCombo(group4);
        Label label10 = new Label((Composite)group4, 0);
        label10.setText("o21");
        o21Combo = this.createOrientationCombo(group4);
        Label label11 = new Label((Composite)group4, 0);
        label11.setText("o22");
        o22Combo = this.createOrientationCombo(group4);
        Group group5 = LookAndFeel.getGroup((Composite)container[5], (String)"Detector defects", (int)3, (int)1);
        this.gridLayout = (GridLayout)group5.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        addNoiseButton = new Button((Composite)group5, 32);
        addNoiseButton.setText("Noise");
        addNoiseButton.setToolTipText("Add Poissonian to images during simulation");
        addNoiseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label((Composite)group5, 0);
        new Label((Composite)group5, 0);
        addNoiseButton = new Button((Composite)group5, 32);
        addNoiseButton.setText("Background");
        addNoiseButton.setToolTipText("Add background to images during simulation");
        addNoiseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        backgroundCountsFloatText = new FloatText((Composite)group5, 0, "Counts");
        backgroundCountsFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)group5, 0);
        psfButton = new Button((Composite)group5, 32);
        psfButton.setText("Point spread");
        psfButton.setToolTipText("Add point spread function to images during simulation");
        psfButton.setLayoutData((Object)new GridData(4, 4, false, true));
        FloatText floatText = new FloatText((Composite)group5, 0, "FWHM (pixels)");
        floatText.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)group5, 0);
        Button button = new Button((Composite)group5, 32);
        button.setText("Spatial distortion");
        button.setToolTipText("Add spatial distortion to images during simulation");
        button.setLayoutData((Object)new GridData(4, 4, false, true));
        StringText stringText = new StringText((Composite)group5, 0, "Spline file");
        stringText.setLayoutData((Object)new GridData(4, 16, true, true));
        Button button2 = new Button((Composite)group5, 0);
        button2.setText("Browse");
        button2.setLayoutData((Object)new GridData(4, 16, true, false));
    }

    private Combo createOrientationCombo(Group group) {
        Combo combo = new Combo((Composite)group, 8);
        combo.setLayoutData((Object)new GridData(16, 16, true, true));
        combo.add("1");
        combo.add("0");
        combo.add("-1");
        combo.setText("0");
        return combo;
    }

    public void setPreferencesValues() {
    }

    public void setFocus() {
    }

    public static void getInputValues() {
        wavelengthFloatText.set_Text(Float.toString(PolyXSim.getWavelength()));
        fluxFloatText.set_Text(Float.toString(PolyXSim.getFlux().floatValue()));
        polarisationFactorFloatText.set_Text(Float.toString(PolyXSim.getPolarisationFactor()));
        polarisationDirectionFloatText.set_Text(Float.toString(PolyXSim.getPolarisationDirection()));
        beamCenterYFloatText.set_Text(Float.toString(PolyXSim.getDetyCenter().floatValue()));
        beamCenterZFloatText.set_Text(Float.toString(PolyXSim.getDetzCenter().floatValue()));
        pixelSizeYFloatText.set_Text(Float.toString(PolyXSim.getYSize().floatValue()));
        pixelSizeZFloatText.set_Text(Float.toString(PolyXSim.getZSize().floatValue()));
        detSizeYFloatText.set_Text(Float.toString(PolyXSim.getDetySize().floatValue()));
        detSizeZFloatText.set_Text(Float.toString(PolyXSim.getDetzSize().floatValue()));
        samp2DetFloatText.set_Text(Float.toString(PolyXSim.getDistance().floatValue()));
        detTiltXFloatText.set_Text(Float.toString(PolyXSim.getDetTiltX().floatValue()));
        detTiltYFloatText.set_Text(Float.toString(PolyXSim.getDetTiltY().floatValue()));
        detTiltZFloatText.set_Text(Float.toString(PolyXSim.getDetTiltZ().floatValue()));
        Integer[] integerArray = PolyXSim.getDetOrientation();
        if (integerArray[0] != null) {
            o11Combo.setText(integerArray[0].toString());
        }
        if (integerArray[1] != null) {
            o12Combo.setText(integerArray[1].toString());
        }
        if (integerArray[2] != null) {
            o21Combo.setText(integerArray[2].toString());
        }
        if (integerArray[3] != null) {
            o22Combo.setText(integerArray[3].toString());
        }
        wedgeFloatText.set_Text(Float.toString(PolyXSim.getWedge()));
        omegaMinFloatText.set_Text(Float.toString(PolyXSim.getOmegaStart().floatValue()));
        omegaMaxFloatText.set_Text(Float.toString(PolyXSim.getOmegaEnd().floatValue()));
        omegaStepFloatText.set_Text(Float.toString(PolyXSim.getOmegaStep().floatValue()));
        int n = PolyXSim.getOmegaSign();
        if (n == -1) {
            omegaDirectionCombo.select(1);
        } else {
            omegaDirectionCombo.select(0);
        }
        grainNumFloatText.set_Text(Integer.toString(PolyXSim.getNoGrains()));
        int n2 = PolyXSim.getGenGrainOrientation();
        grainOrientationButton.setSelection(n2 == 1);
        int n3 = PolyXSim.getGenGrainPosition();
        grainPositionButton.setSelection(n3 == 1);
        Float[] floatArray = PolyXSim.getSampleXyz();
        if (floatArray != null) {
            if (floatArray[0] != null) {
                sampleXFloatText.set_Text(Float.toString(floatArray[0].floatValue()));
            }
            if (floatArray[1] != null) {
                sampleYFloatText.set_Text(Float.toString(floatArray[1].floatValue()));
            }
            if (floatArray[2] != null) {
                sampleZFloatText.set_Text(Float.toString(floatArray[2].floatValue()));
            }
        }
        numPhases = PolyXSim.getNumPhases();
        phasesNumIntegerText.set_Text(Integer.toString(numPhases));
        phases = PolyXSim.getPhases();
        phaseGrains = PolyXSim.getPhaseGrains();
        phaseGrainSize = PolyXSim.getPhaseGrainSize();
        phaseGrainMinSize = PolyXSim.getPhaseGrainMinSize();
        phaseGrainMaxSize = PolyXSim.getPhaseGrainMaxSize();
        PolyXSimInputView.createPhaseGrains();
        if (PolyXSim.getStructureFile(0) != null) {
            structureFileButton.setSelection(true);
            structureCellButton.setSelection(false);
        } else {
            structureFileButton.setSelection(false);
            structureCellButton.setSelection(true);
        }
        PolyXSimInputView.createStructureFileGroup();
        PolyXSimInputView.createUnitCellGroup();
        unitCell = new Float[numPhases * 7];
        int n4 = 0;
        while (n4 < PolyXSim.getNumPhases()) {
            PolyXSimInputView.unitCell[n4 * 7] = PolyXSim.getUnitCellA()[n4];
            PolyXSimInputView.unitCell[n4 * 7 + 1] = PolyXSim.getUnitCellB()[n4];
            PolyXSimInputView.unitCell[n4 * 7 + 2] = PolyXSim.getUnitCellC()[n4];
            PolyXSimInputView.unitCell[n4 * 7 + 3] = PolyXSim.getUnitCellAlpha()[n4];
            PolyXSimInputView.unitCell[n4 * 7 + 4] = PolyXSim.getUnitCellBeta()[n4];
            PolyXSimInputView.unitCell[n4 * 7 + 5] = PolyXSim.getUnitCellGamma()[n4];
            if (PolyXSim.getUnitCellSpaceGroup()[n4] != null) {
                PolyXSimInputView.unitCell[n4 * 7 + 6] = Float.valueOf(PolyXSim.getUnitCellSpaceGroup()[n4].intValue());
            }
            if (structureCellButton.getSelection()) {
                if (PolyXSim.getUnitCellA() != null && PolyXSim.getUnitCellA()[n4] != null) {
                    unitCellAFloatText[n4].set_Text(Float.toString(PolyXSim.getUnitCellA()[n4].floatValue()));
                }
                if (PolyXSim.getUnitCellB() != null && PolyXSim.getUnitCellB()[n4] != null) {
                    unitCellBFloatText[n4].set_Text(Float.toString(PolyXSim.getUnitCellB()[n4].floatValue()));
                }
                if (PolyXSim.getUnitCellC() != null && PolyXSim.getUnitCellC()[n4] != null) {
                    unitCellCFloatText[n4].set_Text(Float.toString(PolyXSim.getUnitCellC()[n4].floatValue()));
                }
                if (PolyXSim.getUnitCellAlpha() != null && PolyXSim.getUnitCellAlpha()[n4] != null) {
                    unitCellAlphaFloatText[n4].set_Text(Float.toString(PolyXSim.getUnitCellAlpha()[n4].floatValue()));
                }
                if (PolyXSim.getUnitCellBeta() != null && PolyXSim.getUnitCellBeta()[n4] != null) {
                    unitCellBetaFloatText[n4].set_Text(Float.toString(PolyXSim.getUnitCellBeta()[n4].floatValue()));
                }
                if (PolyXSim.getUnitCellGamma() != null && PolyXSim.getUnitCellGamma()[n4] != null) {
                    unitCellGammaFloatText[n4].set_Text(Float.toString(PolyXSim.getUnitCellGamma()[n4].floatValue()));
                }
                if (PolyXSim.getUnitCellSpaceGroup() != null && PolyXSim.getUnitCellSpaceGroup()[n4] != null) {
                    unitCellSpaceGroupIntegerText[n4].set_Text(Integer.toString(PolyXSim.getUnitCellSpaceGroup()[n4]));
                }
            }
            if (PolyXSim.getStructureFile(n4) != null) {
                PolyXSimInputView.structureFiles[n4] = PolyXSim.getStructureFile(n4);
                if (structureFileButton.getSelection()) {
                    structureFileText[n4].set_Text(PolyXSim.getStructureFile(n4));
                }
            }
            if (phases[n4] != null) {
                phaseLabel[n4].setText("Phase " + phases[n4]);
            }
            if (phaseGrains[n4] != null) {
                phaseNumGrainsIntegerText[n4].set_Text(Integer.toString(phaseGrains[n4]));
            }
            if (phaseGrainSize[n4] != null) {
                if (phaseGrainSize[n4].floatValue() < 0.0f) {
                    phaseDistributionCombo[n4].setText("fixed");
                } else {
                    phaseDistributionCombo[n4].setText("lognormal");
                }
            }
            phaseGrainSizeFloatText[n4].set_Text(Float.toString(Math.abs(phaseGrainSize[n4].floatValue())));
            if (phaseGrainMinSize[n4] != null) {
                phaseGrainMinSizeFloatText[n4].set_Text(Float.toString(phaseGrainMinSize[n4].floatValue()));
            }
            if (phaseGrainMaxSize[n4] != null) {
                phaseGrainMaxSizeFloatText[n4].set_Text(Float.toString(phaseGrainMaxSize[n4].floatValue()));
            }
            ++n4;
        }
        n4 = PolyXSim.getMakeImages();
        imageFlagButton.setSelection(n4 == 1);
        String string = PolyXSim.getFormat();
        if (string.indexOf("edf") >= 0) {
            fileFormatCombo.setText("edf");
        } else if (string.indexOf("tif16") >= 0) {
            fileFormatCombo.setText("tif16bit");
        } else {
            fileFormatCombo.setText("tif");
        }
        String string2 = PolyXSim.getOutputDirectory();
        string2 = String.valueOf(string2) + File.separator + PolyXSim.getPrefix();
        imageStemFileText.set_Text(string2);
        inputFileFileText.set_Text(PolyXSim.getFileName());
        int n5 = PolyXSim.getNoise();
        addNoiseButton.setSelection(n5 == 1);
        int n6 = PolyXSim.getPsf();
        psfButton.setSelection(n6 == 1);
        peakTypeCombo.select(PolyXSim.getPeakShape().intValue());
        backgroundCountsFloatText.set_Text(Integer.toString(PolyXSim.getBackground()));
        outputFltButton.setSelection(PolyXSim.getOutputFlt());
        outputGveButton.setSelection(PolyXSim.getOutputGve());
        outputUbiButton.setSelection(PolyXSim.getOutputUbi());
        outputParButton.setSelection(PolyXSim.getOutputPar());
        mosaicityFloatText.set_Text(Float.toString(PolyXSim.getMosaicity()));
        polarisationDirectionFloatText.set_Text(Float.toString(PolyXSim.getPolarisationDirection()));
        polarisationButton.setSelection(PolyXSim.getPolarisation());
        lorentzFactorButton.setSelection(PolyXSim.getLorentzFactor());
        Float[] floatArray2 = PolyXSim.getPeakParameters();
        if (floatArray2[0] != null) {
            gaussianPeakPixelsFloatText.set_Text(floatArray2[0].toString());
        }
        if (floatArray2[1] != null) {
            gaussianPeakDegreesFloatText.set_Text(floatArray2[1].toString());
        }
    }

    private static void openJmolView(String string) {
        String string2 = System.getProperty("os.name");
        if (string2.toLowerCase().contains("windows")) {
            if (string.indexOf(":") == -1) {
                string = String.valueOf(inputFileDirectory) + File.separator + string;
            }
        } else if (!string.startsWith(File.separator)) {
            string = String.valueOf(inputFileDirectory) + File.separator + string;
        }
        if (string != null && new File(string).exists()) {
            try {
                JmolView jmolView = null;
                jmolView = (JmolView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.framework.ui.views.JmolView", Integer.toString(JmolView.viewCount), 1);
                if (jmolView != null) {
                    jmolView.openFile(string);
                }
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    public static void setInputValues() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Float[] floatArray;
        Float[] floatArray2;
        Float[] floatArray3;
        PolyXSim.setWavelength(wavelengthFloatText.getValue().floatValue());
        PolyXSim.setFlux(fluxFloatText.getValue().floatValue());
        PolyXSim.setPolarisation(polarisationButton.getSelection());
        PolyXSim.setLorentzFactor(lorentzFactorButton.getSelection());
        PolyXSim.setPolarisationFactor(polarisationFactorFloatText.getValue().floatValue());
        PolyXSim.setPolarisationDirection(polarisationDirectionFloatText.getValue().floatValue());
        PolyXSim.setDetyCenter(beamCenterYFloatText.getValue().floatValue());
        PolyXSim.setDetzCenter(beamCenterZFloatText.getValue().floatValue());
        PolyXSim.setYSize(pixelSizeYFloatText.getValue().floatValue());
        PolyXSim.setZSize(pixelSizeZFloatText.getValue().floatValue());
        PolyXSim.setDetySize(detSizeYFloatText.getValue().floatValue());
        PolyXSim.setDetzSize(detSizeZFloatText.getValue().floatValue());
        PolyXSim.setDistance(samp2DetFloatText.getValue().floatValue());
        PolyXSim.setDetTiltX(detTiltXFloatText.getValue().floatValue());
        PolyXSim.setDetTiltY(detTiltYFloatText.getValue().floatValue());
        PolyXSim.setDetTiltZ(detTiltZFloatText.getValue().floatValue());
        Integer[] integerArray = new Integer[]{Integer.valueOf(o11Combo.getText()), Integer.valueOf(o12Combo.getText()), Integer.valueOf(o21Combo.getText()), Integer.valueOf(o22Combo.getText())};
        PolyXSim.setDetOrientation(integerArray);
        PolyXSim.setOmegaStart(omegaMinFloatText.getValue().floatValue());
        PolyXSim.setOmegaEnd(omegaMaxFloatText.getValue().floatValue());
        PolyXSim.setOmegaStep(omegaStepFloatText.getValue().floatValue());
        PolyXSim.setNoGrains(grainNumFloatText.getValue().intValue());
        int n2 = 0;
        if (grainOrientationButton.getSelection()) {
            n2 = 1;
        }
        PolyXSim.setGenGrainOrientation(n2);
        if (grainPositionButton.getSelection()) {
            n2 = 1;
        }
        PolyXSim.setGenGrainPosition(n2);
        Float[] floatArray4 = new Float[]{sampleXFloatText.getValue(), sampleYFloatText.getValue(), sampleZFloatText.getValue()};
        PolyXSim.setSampleXyz(floatArray4);
        PolyXSim.setNumPhases(numPhases);
        if (structureCellButton.getSelection()) {
            floatArray3 = new Float[numPhases];
            floatArray2 = new Float[numPhases];
            floatArray = new Float[numPhases];
            Float[] floatArray5 = new Float[numPhases];
            object3 = new Float[numPhases];
            object2 = new Float[numPhases];
            object = new Integer[numPhases];
            n = 0;
            while (n < numPhases) {
                if (unitCellAFloatText[n].getValue() != null) {
                    floatArray3[n] = unitCellAFloatText[n].getValue();
                }
                if (unitCellBFloatText[n].getValue() != null) {
                    floatArray2[n] = unitCellBFloatText[n].getValue();
                }
                if (unitCellCFloatText[n].getValue() != null) {
                    floatArray[n] = unitCellCFloatText[n].getValue();
                }
                if (unitCellAlphaFloatText[n].getValue() != null) {
                    floatArray5[n] = unitCellAlphaFloatText[n].getValue();
                }
                if (unitCellBetaFloatText[n].getValue() != null) {
                    object3[n] = unitCellBetaFloatText[n].getValue();
                }
                if (unitCellGammaFloatText[n].getValue() != null) {
                    object2[n] = unitCellGammaFloatText[n].getValue();
                }
                if (unitCellSpaceGroupIntegerText[n].getText() != null) {
                    object[n] = Integer.valueOf(unitCellSpaceGroupIntegerText[n].getText());
                }
                ++n;
            }
            PolyXSim.setUnitCellA(floatArray3);
            PolyXSim.setUnitCellB(floatArray2);
            PolyXSim.setUnitCellC(floatArray);
            PolyXSim.setUnitCellAlpha(floatArray5);
            PolyXSim.setUnitCellBeta(object3);
            PolyXSim.setUnitCellGamma((Float[])object2);
            PolyXSim.setUnitCellSpaceGroup(object);
        } else {
            int n3 = 0;
            while (n3 < numPhases) {
                if (structureFileText[n3].getValue() != null) {
                    PolyXSim.setStructureFile(structureFileText[n3].getValue(), n3);
                }
                ++n3;
            }
        }
        floatArray3 = new Float[numPhases];
        floatArray2 = new Float[numPhases];
        floatArray = new Float[numPhases];
        int n4 = 0;
        while (n4 < numPhases) {
            if (structureFileText != null && structureFileText[n4].getValue() != null) {
                PolyXSim.setStructureFile(structureFileText[n4].getValue(), n4);
            }
            PolyXSimInputView.phaseGrains[n4] = Integer.valueOf(phaseNumGrainsIntegerText[n4].getText());
            if (phaseGrainSizeFloatText[n4].getValue() != null) {
                floatArray3[n4] = phaseDistributionCombo[n4].getText().equals("fixed") ? Float.valueOf(-Math.abs(phaseGrainSizeFloatText[n4].getValue().floatValue())) : Float.valueOf(Math.abs(phaseGrainSizeFloatText[n4].getValue().floatValue()));
            }
            if (phaseGrainMinSizeFloatText[n4].getValue() != null) {
                floatArray2[n4] = phaseGrainMinSizeFloatText[n4].getValue();
            }
            if (phaseGrainMaxSizeFloatText[n4].getValue() != null) {
                floatArray[n4] = phaseGrainMaxSizeFloatText[n4].getValue();
            }
            ++n4;
        }
        PolyXSim.setPhaseGrains(phaseGrains);
        PolyXSim.setPhaseGrainSize(floatArray3);
        PolyXSim.setPhaseGrainMinSize(floatArray2);
        PolyXSim.setPhaseGrainMaxSize(floatArray);
        n4 = 0;
        if (imageFlagButton.getSelection()) {
            n4 = 1;
        }
        PolyXSim.setMakeImages(n4);
        object3 = fileFormatCombo.getText();
        PolyXSim.setFormat("." + (String)object3);
        object = "";
        object2 = imageStemFileText.getText();
        if (((String)object2).lastIndexOf(File.separatorChar) != -1) {
            object = ((String)object2).substring(0, ((String)object2).lastIndexOf(File.separatorChar));
            object2 = ((String)object2).substring(((String)object2).lastIndexOf(File.separatorChar) + 1);
        }
        PolyXSim.setOutputDirectory((String)object);
        PolyXSim.setPrefix((String)object2);
        n = 0;
        if (addNoiseButton.getSelection()) {
            n = 1;
        }
        PolyXSim.setNoise(n);
        int n5 = 0;
        if (psfButton.getSelection()) {
            n5 = 1;
        }
        PolyXSim.setPsf(n5);
        PolyXSim.setPeakShape(peakTypeCombo.getSelectionIndex());
        Float[] floatArray6 = new Float[]{gaussianPeakPixelsFloatText.getValue(), gaussianPeakDegreesFloatText.getValue()};
        PolyXSim.setPeakParameters(floatArray6);
        backgroundCountsFloatText.set_Text(Integer.toString(PolyXSim.getBackground()));
        PolyXSim.setBackground(backgroundCountsFloatText.getValue().intValue());
        PolyXSim.setOutputFlt(outputFltButton.getSelection());
        PolyXSim.setOutputGve(outputGveButton.getSelection());
        PolyXSim.setOutputUbi(outputUbiButton.getSelection());
        PolyXSim.setOutputPar(outputParButton.getSelection());
        PolyXSim.setFormat("." + fileFormatCombo.getText());
        PolyXSim.setWedge(wedgeFloatText.getValue().floatValue());
        PolyXSim.setMosaicity(mosaicityFloatText.getValue().floatValue());
    }

    public static void loadInputFile(String string) {
        StringBuffer stringBuffer;
        block19: {
            inputFileDirectory = string.substring(0, string.lastIndexOf(File.separatorChar));
            PolyXSim.setInputFileDirectory(inputFileDirectory);
            File file = new File(string);
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2).append("\r\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break block19;
            }
            catch (IOException iOException) {
                try {
                    iOException.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        inputFileText.setText(stringBuffer.toString());
        outputFileBrowseButton.setEnabled(false);
        inputFileText.pack();
        container[0].pack();
    }

    private void writeInputFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(inputFileText.getText());
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    private static void setEnableGroup(Group group, boolean bl) {
        Control[] controlArray = group.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
        group.setEnabled(bl);
    }

    private void setHelpContextIDs() {
        IWorkbenchHelpSystem iWorkbenchHelpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        iWorkbenchHelpSystem.setHelp(this.tabItem[0].getControl(), "fable.polyxsim.files_tab");
    }
}

