/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.internal;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.views.PolyXSimInputView;
import fable.python.jep.FableJep;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PolyXSim
implements IPropertyChangeListener {
    private static PolyXSimThread polyXSimThread;
    private IProgressMonitor polyXSimMonitor;
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    private static FableJep jep;
    private static String inputFileName;
    private static float wavelength;
    private static Float distance;
    private static Float polarisationFactor;
    private static Float polarisationDirection;
    private static Float detyCenter;
    private static Float detzCenter;
    private static Float ySize;
    private static Float zSize;
    private static Float detySize;
    private static Float detzSize;
    private static Float omegaStart;
    private static Float omegaEnd;
    private static Float omegaStep;
    private static Float thetaMin;
    private static Float thetaMax;
    private static Integer[] detOrientation;
    private static Integer numGrains;
    private static Integer numPhases;
    private static Integer[] phases;
    private static Integer[] phaseGrains;
    private static Float grainSize;
    private static Float grainMinSize;
    private static Float grainMaxSize;
    private static Integer genGrainOrientation;
    private static Integer genGrainPosition;
    private static Float[] sampleXYZ;
    private static Float[] unitCellA;
    private static Float[] unitCellB;
    private static Float[] unitCellC;
    private static Float[] unitCellAlpha;
    private static Float[] unitCellBeta;
    private static Float[] unitCellGamma;
    private static Integer[] unitCellSpaceGroup;
    private static Integer makeImages;
    private static String prefix;
    private static String format;
    private static Float flux;
    private static Integer noise;
    private static Integer background;
    private static Integer psf;
    private static Integer peakShape;
    private static Float detTiltX;
    private static Float detTiltY;
    private static Float detTiltZ;
    private static String[] structureFile;
    private static boolean outputFlt;
    private static boolean outputGve;
    private static boolean outputUbi;
    private static boolean outputPar;
    private StdoutReaderThread stdoutThread;
    private String killFile = ".polyxsim.killfile";
    static Logger logger;
    static File tempFile;
    private static float wedge;
    private static float mosaicity;
    private static Float intensityConstant;
    private static boolean polarisation;
    private static boolean lorentzFactor;
    private static String inputDirectory;
    private static String outputDirectory;
    private static Float[] peakParameters;
    private static Integer omegaSign;
    private static Float[] phaseGrainSize;
    private static Float[] phaseGrainMinSize;
    private static Float[] phaseGrainMaxSize;
    boolean runStatus = false;
    boolean jobCanceled = false;

    static {
        jep = null;
        detOrientation = new Integer[4];
        numGrains = 0;
        numPhases = 0;
        phases = null;
        phaseGrains = null;
        sampleXYZ = new Float[6];
        unitCellA = null;
        unitCellB = null;
        unitCellC = null;
        unitCellAlpha = null;
        unitCellBeta = null;
        unitCellGamma = null;
        unitCellSpaceGroup = null;
        format = "edf";
        structureFile = null;
        outputFlt = false;
        outputGve = false;
        outputUbi = false;
        outputPar = false;
        peakParameters = new Float[2];
        phaseGrainSize = null;
        phaseGrainMinSize = null;
        phaseGrainMaxSize = null;
    }

    public PolyXSim() {
        polyXSimThread = new PolyXSimThread();
        logger = Logger.getLogger(PolyXSim.class);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (!this.myListeners.contains(iPropertyChangeListener)) {
            this.myListeners.add(iPropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.myListeners.remove(iPropertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void fireProperty(String string) {
        for (IPropertyChangeListener iPropertyChangeListener : this.myListeners) {
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "polyxsim", null, (Object)string));
        }
    }

    public static boolean loadInputFile(String string) {
        inputFileName = string;
        try {
            jep = new FableJep();
            jep.outputConsole(FableMessageConsole.console);
            try {
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"sys,os");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"CifFile");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"ImageD11");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
            }
            catch (JepException jepException) {
                logger.error((Object)jepException.getMessage());
            }
            try {
                jep.eval("from polyxsim import check_input");
            }
            catch (JepException jepException) {}
            jep.eval("from polyxsim import check_input");
            jep.set("sim_filename", inputFileName);
            String string2 = inputDirectory.replaceAll("\\\\", "/");
            jep.eval("os.chdir(\"" + string2 + "\")");
            jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
            jep.eval("myinput.read()");
            jep.eval("myinput.check()");
            jep.eval("myinput.initialize()");
            jep.eval("print myinput.param");
            jep.eval("print myinput.param['gen_phase']");
            wavelength = jep.getFloatValue("myinput.param['wavelength']").floatValue();
            flux = jep.getFloatValue("myinput.param['beamflux']");
            distance = jep.getFloatValue("myinput.param['distance']");
            intensityConstant = jep.getFloatValue("myinput.param['intensity_const']");
            polarisation = false;
            if (jep.getIntegerValue("myinput.param['beampol_apply']") != null && jep.getIntegerValue("myinput.param['beampol_apply']") == 1) {
                polarisation = true;
            }
            lorentzFactor = false;
            if (jep.getIntegerValue("myinput.param['lorentz_apply']") != null && jep.getIntegerValue("myinput.param['lorentz_apply']") == 1) {
                lorentzFactor = true;
            }
            polarisationFactor = jep.getFloatValue("myinput.param['beampol_factor']");
            polarisationFactor = jep.getFloatValue("myinput.param['beampol_factor']");
            polarisationDirection = jep.getFloatValue("myinput.param['beampol_direct']");
            detyCenter = jep.getFloatValue("myinput.param['dety_center']");
            detzCenter = jep.getFloatValue("myinput.param['detz_center']");
            ySize = jep.getFloatValue("myinput.param['y_size']");
            zSize = jep.getFloatValue("myinput.param['z_size']");
            detySize = jep.getFloatValue("myinput.param['dety_size']");
            detzSize = jep.getFloatValue("myinput.param['detz_size']");
            detTiltX = jep.getFloatValue("myinput.param['tilt_x']");
            detTiltY = jep.getFloatValue("myinput.param['tilt_y']");
            detTiltZ = jep.getFloatValue("myinput.param['tilt_z']");
            detTiltZ = jep.getFloatValue("myinput.param['tilt_z']");
            PolyXSim.detOrientation[0] = jep.getIntegerValue("myinput.param['o11']");
            PolyXSim.detOrientation[1] = jep.getIntegerValue("myinput.param['o12']");
            PolyXSim.detOrientation[2] = jep.getIntegerValue("myinput.param['o21']");
            PolyXSim.detOrientation[3] = jep.getIntegerValue("myinput.param['o22']");
            wedge = jep.getFloatValue("myinput.param['wedge']").floatValue();
            omegaStart = jep.getFloatValue("myinput.param['omega_start']");
            omegaEnd = jep.getFloatValue("myinput.param['omega_end']");
            omegaStep = jep.getFloatValue("myinput.param['omega_step']");
            omegaSign = jep.getIntegerValue("myinput.param['omega_sign']");
            numPhases = jep.getIntegerValue("myinput.param['no_phases']");
            numGrains = jep.getIntegerValue("myinput.param['no_grains']");
            genGrainOrientation = jep.getIntegerValue("myinput.param['gen_U']");
            genGrainPosition = jep.getIntegerValue("myinput.param['gen_pos'][0]");
            int n = 0;
            while (n < 3) {
                PolyXSim.sampleXYZ[n] = jep.getFloatValue("myinput.param['sample_xyz'][" + n + "]");
                ++n;
            }
            makeImages = jep.getIntegerValue("myinput.param['make_image']");
            outputDirectory = (String)jep.getValue("myinput.param['direc']");
            String string3 = System.getProperty("os.name");
            if (string3.toLowerCase().contains("windows")) {
                if (outputDirectory.indexOf(":") == -1) {
                    outputDirectory = String.valueOf(inputDirectory) + File.separator + outputDirectory;
                }
            } else if (!outputDirectory.startsWith(File.separator)) {
                outputDirectory = String.valueOf(inputDirectory) + File.separator + outputDirectory;
            }
            prefix = (String)jep.getValue("myinput.param['stem']");
            noise = jep.getIntegerValue("myinput.param['noise']");
            background = jep.getIntegerValue("myinput.param['bg']");
            psf = jep.getIntegerValue("myinput.param['psf']");
            peakShape = jep.getIntegerValue("myinput.param['peakshape'][0]");
            PolyXSim.peakParameters[0] = jep.getFloatValue("myinput.param['peakshape'][1]");
            PolyXSim.peakParameters[1] = jep.getFloatValue("myinput.param['peakshape'][2]");
            grainSize = jep.getFloatValue("myinput.param['gen_size'][1]");
            grainMinSize = jep.getFloatValue("float(myinput.param['gen_size'][2])");
            grainMaxSize = jep.getFloatValue("myinput.param['gen_size'][3]");
            phases = new Integer[numPhases.intValue()];
            phaseGrains = new Integer[numPhases.intValue()];
            phaseGrainSize = new Float[numPhases.intValue()];
            phaseGrainMinSize = new Float[numPhases.intValue()];
            phaseGrainMaxSize = new Float[numPhases.intValue()];
            structureFile = new String[numPhases.intValue()];
            int n2 = 0;
            while (n2 < numPhases) {
                int n3 = 1 + n2 * 2;
                PolyXSim.phases[n2] = jep.getIntegerValue("myinput.param['gen_phase'][" + n3 + "]");
                PolyXSim.phaseGrains[n2] = jep.getIntegerValue("myinput.param['gen_phase'][" + ++n3 + "]");
                PolyXSim.phaseGrainSize[n2] = jep.getFloatValue("myinput.param['gen_size_phase_" + n2 + "'][1]");
                PolyXSim.phaseGrainMinSize[n2] = jep.getFloatValue("myinput.param['gen_size_phase_" + n2 + "'][2]");
                PolyXSim.phaseGrainMaxSize[n2] = jep.getFloatValue("myinput.param['gen_size_phase_" + n2 + "'][3]");
                PolyXSim.structureFile[n2] = jep.getStringValue("myinput.param['structure_phase_" + n2 + "']");
                ++n2;
            }
        }
        catch (JepException jepException) {
            FableUtils.excMsg(PolyXSim.class, (String)"An error occured with jep", (Throwable)jepException);
            return false;
        }
        unitCellA = new Float[numPhases.intValue()];
        unitCellB = new Float[numPhases.intValue()];
        unitCellC = new Float[numPhases.intValue()];
        unitCellAlpha = new Float[numPhases.intValue()];
        unitCellBeta = new Float[numPhases.intValue()];
        unitCellGamma = new Float[numPhases.intValue()];
        unitCellSpaceGroup = new Integer[numPhases.intValue()];
        int n = 0;
        while (n < numPhases) {
            PolyXSim.unitCellA[n] = jep.getFloatValue("myinput.param['unit_cell_phase_" + n + "'][0]");
            PolyXSim.unitCellB[n] = jep.getFloatValue("myinput.param['unit_cell_phase_" + n + "'][1]");
            PolyXSim.unitCellC[n] = jep.getFloatValue("myinput.param['unit_cell_phase_" + n + "'][2]");
            PolyXSim.unitCellAlpha[n] = jep.getFloatValue("myinput.param['unit_cell_phase_" + n + "'][3]");
            PolyXSim.unitCellBeta[n] = jep.getFloatValue("myinput.param['unit_cell_phase_" + n + "'][4]");
            PolyXSim.unitCellGamma[n] = jep.getFloatValue("myinput.param['unit_cell_phase_" + n + "'][5]");
            PolyXSim.unitCellSpaceGroup[n] = jep.getIntegerValue("myinput.param['sgno_phase_" + n + "']");
            logger.debug((Object)("unit cell space group no " + unitCellSpaceGroup[n]));
            ++n;
        }
        try {
            n = jep.getIntegerValue("len(myinput.param['output'])");
            logger.debug((Object)("outFiles " + n));
            int n4 = 0;
            while (n4 < n) {
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("tif")) {
                    format = "tif";
                }
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("tif16bit")) {
                    format = "tif16bit";
                }
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("edf")) {
                    format = "edf";
                }
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("flt")) {
                    outputFlt = true;
                }
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("gve")) {
                    outputGve = true;
                }
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("ubi")) {
                    outputUbi = true;
                }
                if (((String)jep.getValue("myinput.param['output'][" + n4 + "]")).endsWith("par")) {
                    outputPar = true;
                }
                ++n4;
            }
        }
        catch (JepException jepException) {}
        return true;
    }

    public void run() {
        Job job = new Job("Running PolyXSim "){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                String string = inputFileName;
                if (inputFileName != null && !inputFileName.equals("")) {
                    if (inputFileName.lastIndexOf(File.separatorChar) != -1) {
                        string = inputFileName.substring(inputFileName.lastIndexOf(File.separatorChar) + 1);
                    }
                    PolyXSim.this.polyXSimMonitor = iProgressMonitor;
                    PolyXSim.this.polyXSimMonitor.beginTask("Running PolyXSim " + string + " ... ", 150);
                    polyXSimThread.run();
                    PolyXSim.this.polyXSimMonitor.done();
                    return Status.OK_STATUS;
                }
                FableMessageConsole.console.displayError("no input file specified - run aborted");
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                if (PolyXSim.this.runStatus) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " completed successfully");
                    }
                    if (makeImages == 1 && !Display.getDefault().isDisposed()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                PolyXSim.this.openImageViewer(outputDirectory);
                            }
                        });
                    }
                } else if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " did not complete successfully !");
                    if (!PolyXSim.this.jobCanceled) {
                        FableMessageConsole.console.displayOut(" Please check input file " + inputFileName);
                    }
                }
            }
        });
    }

    protected void openImageViewer(String string) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            iWorkbenchWindow.getWorkbench().showPerspective("fable.imageviewer.perspective", iWorkbenchWindow);
            SampleNavigatorView sampleNavigatorView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
            sampleNavigatorView.addDirectory(string);
        }
        catch (WorkbenchException workbenchException) {
            MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)"Polyxsim", (String)"ImageViewer cannot be opened");
        }
    }

    public static void updateValues(FableJep fableJep) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PolyXSimInputView.setInputValues();
                }
            });
        }
        try {
            int n;
            logger.trace((Object)("noGrains = " + numGrains));
            fableJep.eval("myinput.param['no_grains']=" + numGrains);
            fableJep.eval("myinput.param['wavelength']=" + wavelength);
            fableJep.eval("myinput.param['beamflux']=" + flux);
            if (polarisation) {
                fableJep.eval("myinput.param['beampol_factor']=1");
            } else {
                fableJep.eval("myinput.param['beampol_factor']=0");
            }
            if (lorentzFactor) {
                fableJep.eval("myinput.param['lorentz_factor']=1");
            } else {
                fableJep.eval("myinput.param['lorentz_factor']=0");
            }
            fableJep.eval("myinput.param['beampol_factor']=" + polarisationFactor);
            fableJep.eval("myinput.param['beampol_direct']=" + polarisationDirection);
            fableJep.eval("myinput.param['wavelength']=" + wavelength);
            fableJep.eval("myinput.param['distance']=" + distance);
            fableJep.eval("myinput.param['dety_center']=" + detyCenter);
            fableJep.eval("myinput.param['detz_center']=" + detzCenter);
            fableJep.eval("myinput.param['y_size']=" + ySize);
            fableJep.eval("myinput.param['z_size']=" + zSize);
            fableJep.eval("myinput.param['dety_size']=" + detySize);
            fableJep.eval("myinput.param['detz_size']=" + detzSize);
            fableJep.eval("myinput.param['tilt_x']=" + detTiltX);
            fableJep.eval("myinput.param['tilt_y']=" + detTiltY);
            fableJep.eval("myinput.param['tilt_z']=" + detTiltZ);
            if (detOrientation[0] != null) {
                fableJep.eval("myinput.param['o11']=" + detOrientation[0]);
            }
            if (detOrientation[1] != null) {
                fableJep.eval("myinput.param['o12']=" + detOrientation[1]);
            }
            if (detOrientation[2] != null) {
                fableJep.eval("myinput.param['o21']=" + detOrientation[2]);
            }
            if (detOrientation[3] != null) {
                fableJep.eval("myinput.param['o22']=" + detOrientation[3]);
            }
            fableJep.eval("myinput.param['wedge']=" + wedge);
            fableJep.eval("myinput.param['omega_start']=" + omegaStart);
            fableJep.eval("myinput.param['omega_end']=" + omegaEnd);
            fableJep.eval("myinput.param['omega_step']=" + omegaStep);
            fableJep.eval("myinput.param['no_phases']=" + numPhases);
            fableJep.eval("myinput.param['no_grains']=" + numGrains);
            if (genGrainOrientation == 1) {
                fableJep.eval("myinput.param['gen_size'][1]=" + grainSize);
                fableJep.eval("myinput.param['gen_size'][2]=" + grainMinSize);
                fableJep.eval("myinput.param['gen_size'][3]=" + grainMaxSize);
            }
            int n2 = 0;
            while (n2 < 3) {
                if (sampleXYZ[n2] != null) {
                    fableJep.eval("myinput.param['sample_xyz'][" + n2 + "]=" + sampleXYZ[n2]);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < numPhases) {
                n = 2 + n2 * 2;
                fableJep.eval("myinput.param['gen_phase'][" + n + "]=" + phaseGrains[n2]);
                fableJep.eval("myinput.param['no_grains_phase_" + n2 + "']=" + phaseGrains[n2]);
                String string = "myinput.param['gen_size_phase_" + n2 + "'][2]=" + phaseGrainMinSize[n2];
                string = "myinput.param['gen_size_phase_" + n2 + "'][3]=" + phaseGrainMaxSize[n2];
                string = "myinput.param['gen_size_phase_" + n2 + "'][1]=" + phaseGrainSize[n2];
                if (n2 < unitCellA.length) {
                    if (unitCellA[n2] != null) {
                        string = "myinput.param['unit_cell_phase_" + n2 + "'][0]=" + unitCellA[n2];
                        fableJep.eval(string);
                    }
                    if (unitCellB[n2] != null) {
                        string = "myinput.param['unit_cell_phase_" + n2 + "'][1]=" + unitCellB[n2];
                        fableJep.eval(string);
                    }
                    if (unitCellC[n2] != null) {
                        string = "myinput.param['unit_cell_phase_" + n2 + "'][2]=" + unitCellC[n2];
                        fableJep.eval(string);
                    }
                    if (unitCellAlpha[n2] != null) {
                        string = "myinput.param['unit_cell_phase_" + n2 + "'][3]=" + unitCellAlpha[n2];
                        fableJep.eval(string);
                    }
                    if (unitCellBeta[n2] != null) {
                        string = "myinput.param['unit_cell_phase_" + n2 + "'][4]=" + unitCellBeta[n2];
                        fableJep.eval(string);
                    }
                    if (unitCellGamma[n2] != null) {
                        string = "myinput.param['unit_cell_phase_" + n2 + "'][5]=" + unitCellGamma[n2];
                        fableJep.eval(string);
                    }
                    if (unitCellSpaceGroup[n2] != null) {
                        string = "myinput.param['sgno_phase_" + n2 + "']=" + unitCellSpaceGroup[n2];
                        fableJep.eval(string);
                    }
                }
                ++n2;
            }
            fableJep.eval("myinput.param['make_image']=" + makeImages);
            String string = outputDirectory.replaceAll("\\\\", "/");
            fableJep.eval("myinput.param['direc']='" + string + "'");
            fableJep.eval("myinput.param['stem']='" + prefix + "'");
            fableJep.eval("myinput.param['noise']=" + noise);
            fableJep.eval("myinput.param['bg']=" + background);
            fableJep.eval("myinput.param['psf']=" + psf);
            fableJep.eval("myinput.param['peakshape'][0]=" + peakShape);
            if (peakParameters[0] != null) {
                fableJep.eval("myinput.param['peakshape'][1]=" + peakParameters[0]);
            }
            if (peakParameters[1] != null) {
                fableJep.eval("myinput.param['peakshape'][2]=" + peakParameters[1]);
            }
            n = 0;
            while (n < numPhases) {
                if (n < structureFile.length && structureFile[n] != null) {
                    fableJep.eval("myinput.param['structure_phase_" + n + "']='" + structureFile[n] + "'");
                }
                ++n;
            }
            fableJep.eval("myinput.param['make_image']=" + makeImages);
            String string2 = "'" + format + "'";
            if (outputFlt || outputGve || outputUbi || outputPar) {
                if (outputFlt) {
                    string2 = String.valueOf(string2) + ",'.flt'";
                }
                if (outputGve) {
                    string2 = String.valueOf(string2) + ",'.gve'";
                }
                if (outputUbi) {
                    string2 = String.valueOf(string2) + ",'.ubi'";
                }
                if (outputPar) {
                    string2 = String.valueOf(string2) + ",'.par'";
                }
            }
            fableJep.eval("myinput.param['output']=[" + string2 + "]");
            if (format.startsWith("tif")) {
                fableJep.eval("myinput.param['format']='.tif'");
            } else {
                fableJep.eval("myinput.param['format']='" + format + "'");
            }
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
    }

    public static String getFileName() {
        return inputFileName;
    }

    public static float getWavelength() {
        return wavelength;
    }

    public static void setWavelength(float f) {
        wavelength = f;
    }

    public static Float getFlux() {
        return flux;
    }

    public static void setFlux(float f) {
        flux = Float.valueOf(f);
    }

    public static Float getDistance() {
        return distance;
    }

    public static void setDistance(float f) {
        distance = Float.valueOf(f);
    }

    public static Float getDetyCenter() {
        return detyCenter;
    }

    public static void setDetyCenter(float f) {
        detyCenter = Float.valueOf(f);
    }

    public static Float getDetzCenter() {
        return detzCenter;
    }

    public static void setDetzCenter(float f) {
        detzCenter = Float.valueOf(f);
    }

    public static Float getYSize() {
        return ySize;
    }

    public static void setYSize(float f) {
        ySize = Float.valueOf(f);
    }

    public static Float getZSize() {
        return zSize;
    }

    public static void setZSize(float f) {
        zSize = Float.valueOf(f);
    }

    public static Float getDetySize() {
        return detySize;
    }

    public static void setDetySize(float f) {
        detySize = Float.valueOf(f);
    }

    public static Float getDetzSize() {
        return detzSize;
    }

    public static void setDetzSize(float f) {
        detzSize = Float.valueOf(f);
    }

    public static Float getOmegaStart() {
        return omegaStart;
    }

    public static void setOmegaStart(float f) {
        omegaStart = Float.valueOf(f);
    }

    public static Float getOmegaEnd() {
        return omegaEnd;
    }

    public static void setOmegaEnd(float f) {
        omegaEnd = Float.valueOf(f);
    }

    public static Integer getOmegaSign() {
        return omegaSign;
    }

    public static void setOmegaSign(int n) {
        omegaSign = n;
    }

    public static Float getOmegaStep() {
        return omegaStep;
    }

    public static void setOmegaStep(float f) {
        omegaStep = Float.valueOf(f);
    }

    public static Float getDetTiltX() {
        return detTiltX;
    }

    public static void setDetTiltX(float f) {
        detTiltX = Float.valueOf(f);
    }

    public static Float getDetTiltY() {
        return detTiltY;
    }

    public static void setDetTiltY(float f) {
        detTiltY = Float.valueOf(f);
    }

    public static Float getDetTiltZ() {
        return detTiltZ;
    }

    public static void setDetTiltZ(float f) {
        detTiltZ = Float.valueOf(f);
    }

    public static Float getThetaMin() {
        return thetaMin;
    }

    public static void setThetaMin(float f) {
        thetaMin = Float.valueOf(f);
    }

    public static Float getThetaMax() {
        return thetaMax;
    }

    public static void setThetaMax(float f) {
        thetaMax = Float.valueOf(f);
    }

    public static Integer getNoGrains() {
        return numGrains;
    }

    public static void setNoGrains(int n) {
        numGrains = n;
    }

    public static Float getGrainSize() {
        return grainSize;
    }

    public static void setGrainSize(float f) {
        grainSize = Float.valueOf(f);
    }

    public static Float getGrainMinSize() {
        return grainMinSize;
    }

    public static void setGrainMinSize(float f) {
        grainMinSize = Float.valueOf(f);
    }

    public static Float getGrainMaxSize() {
        return grainMaxSize;
    }

    public static void setGrainMaxSize(float f) {
        grainMaxSize = Float.valueOf(f);
    }

    public static Float[] getSampleXyz() {
        return sampleXYZ;
    }

    public static void setSampleXyz(Float[] floatArray) {
        sampleXYZ = floatArray;
    }

    public static Float[] getUnitCellA() {
        return unitCellA;
    }

    public static void setUnitCellA(Float[] floatArray) {
        unitCellA = floatArray;
    }

    public static Float[] getUnitCellB() {
        return unitCellB;
    }

    public static void setUnitCellB(Float[] floatArray) {
        unitCellB = floatArray;
    }

    public static Float[] getUnitCellC() {
        return unitCellC;
    }

    public static void setUnitCellC(Float[] floatArray) {
        unitCellC = floatArray;
    }

    public static Float[] getUnitCellAlpha() {
        return unitCellAlpha;
    }

    public static void setUnitCellAlpha(Float[] floatArray) {
        unitCellAlpha = floatArray;
    }

    public static Float[] getUnitCellBeta() {
        return unitCellBeta;
    }

    public static void setUnitCellBeta(Float[] floatArray) {
        unitCellBeta = floatArray;
    }

    public static Float[] getUnitCellGamma() {
        return unitCellGamma;
    }

    public static void setUnitCellGamma(Float[] floatArray) {
        unitCellGamma = floatArray;
    }

    public static Integer[] getUnitCellSpaceGroup() {
        return unitCellSpaceGroup;
    }

    public static void setUnitCellSpaceGroup(Integer[] integerArray) {
        unitCellSpaceGroup = integerArray;
    }

    public static String getStructureFile(int n) {
        return structureFile[n];
    }

    public static void setStructureFile(String string, int n) {
        PolyXSim.structureFile[n] = string;
    }

    public static Integer getMakeImages() {
        return makeImages;
    }

    public static void setMakeImages(int n) {
        makeImages = n;
    }

    public static String getOutputDirectory() {
        return outputDirectory;
    }

    public static void setOutputDirectory(String string) {
        outputDirectory = string.replaceAll("\\\\", "/");
    }

    public static String getPrefix() {
        return prefix;
    }

    public static void setPrefix(String string) {
        prefix = string;
    }

    public static String getFormat() {
        return format;
    }

    public static void setFormat(String string) {
        format = string;
    }

    public static Integer getNoise() {
        return noise;
    }

    public static void setNoise(int n) {
        noise = n;
    }

    public static Integer getBackground() {
        return background;
    }

    public static void setBackground(int n) {
        background = n;
    }

    public static Integer getPsf() {
        return psf;
    }

    public static void setPsf(int n) {
        psf = n;
    }

    public static Integer getPeakShape() {
        return peakShape;
    }

    public static void setPeakShape(int n) {
        peakShape = n;
    }

    public static int getGenGrainOrientation() {
        return genGrainOrientation;
    }

    public static void setGenGrainOrientation(int n) {
        genGrainOrientation = n;
    }

    public static int getGenGrainPosition() {
        return genGrainPosition;
    }

    public static void setGenGrainPosition(int n) {
        genGrainPosition = n;
    }

    public static boolean getOutputFlt() {
        return outputFlt;
    }

    public static void setOutputFlt(boolean bl) {
        outputFlt = bl;
    }

    public static boolean getOutputGve() {
        return outputGve;
    }

    public static void setOutputGve(boolean bl) {
        outputGve = bl;
    }

    public static boolean getOutputUbi() {
        return outputUbi;
    }

    public static void setOutputUbi(boolean bl) {
        outputUbi = bl;
    }

    public static boolean getOutputPar() {
        return outputPar;
    }

    public static void setOutputPar(boolean bl) {
        outputPar = bl;
    }

    public static int getNumPhases() {
        return numPhases;
    }

    public static void setWedge(float f) {
        wedge = f;
    }

    public static float getWedge() {
        return wedge;
    }

    public static float getPolarisationFactor() {
        return polarisationFactor.floatValue();
    }

    public static float getPolarisationDirection() {
        return polarisationDirection.floatValue();
    }

    public static void setPolarisationFactor(float f) {
        polarisationFactor = Float.valueOf(f);
    }

    public static void setPolarisationDirection(float f) {
        polarisationDirection = Float.valueOf(f);
    }

    public static float getMosaicity() {
        return mosaicity;
    }

    public static void setMosaicity(float f) {
        mosaicity = f;
    }

    public static Float getIntensityConstant() {
        return intensityConstant;
    }

    public static void setIntensityConstant(Float f) {
        intensityConstant = f;
    }

    public static boolean getPolarisation() {
        return polarisation;
    }

    public static void setPolarisation(boolean bl) {
        polarisation = bl;
    }

    public static boolean getLorentzFactor() {
        return lorentzFactor;
    }

    public static void setLorentzFactor(boolean bl) {
        lorentzFactor = bl;
    }

    public static void setInputFileDirectory(String string) {
        inputDirectory = string;
    }

    public static void setNumPhases(int n) {
        numPhases = n;
    }

    public static Integer[] getDetOrientation() {
        return detOrientation;
    }

    public static void setDetOrientation(Integer[] integerArray) {
        int n = 0;
        while (n < 4) {
            PolyXSim.detOrientation[n] = integerArray[n];
            ++n;
        }
    }

    public static Float[] getPeakParameters() {
        return peakParameters;
    }

    public static void setPeakParameters(Float[] floatArray) {
        PolyXSim.peakParameters[0] = floatArray[0];
        PolyXSim.peakParameters[1] = floatArray[1];
    }

    public static Integer[] getPhaseGrains() {
        return phaseGrains;
    }

    public static void setPhaseGrains(Integer[] integerArray) {
        phaseGrains = new Integer[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            PolyXSim.phaseGrains[n] = integerArray[n];
            ++n;
        }
    }

    public static Integer[] getPhases() {
        return phases;
    }

    public static void setPhases(Integer[] integerArray) {
        phases = new Integer[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            PolyXSim.phases[n] = integerArray[n];
            ++n;
        }
    }

    public static Float[] getPhaseGrainSize() {
        return phaseGrainSize;
    }

    public static void setPhaseGrainSize(Float[] floatArray) {
        phaseGrainSize = floatArray;
    }

    public static Float[] getPhaseGrainMinSize() {
        return phaseGrainMinSize;
    }

    public static void setPhaseGrainMinSize(Float[] floatArray) {
        phaseGrainMinSize = floatArray;
    }

    public static Float[] getPhaseGrainMaxSize() {
        return phaseGrainMaxSize;
    }

    public static void setPhaseGrainMaxSize(Float[] floatArray) {
        phaseGrainMaxSize = floatArray;
    }

    class PolyXSimThread
    implements Runnable {
        String outputMessage;

        PolyXSimThread() {
        }

        @Override
        public void run() {
            this.setCursor(1);
            PolyXSim.this.jobCanceled = false;
            try {
                jep = new FableJep();
                jep.outputConsole(FableMessageConsole.console);
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"sys,os");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"CifFile");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"ImageD11");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
                try {
                    jep.eval("from polyxsim import check_input");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import find_refl");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import generate_grains");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import make_image");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import make_imagestack");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import reflections");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import file_io");
                }
                catch (JepException jepException) {}
                jep.eval("from polyxsim import check_input");
                jep.eval("from polyxsim import find_refl");
                jep.eval("from polyxsim import generate_grains");
                jep.eval("from polyxsim import make_image");
                jep.eval("from polyxsim import make_imagestack");
                jep.eval("from polyxsim import reflections");
                jep.eval("from polyxsim import file_io");
                jep.eval("from optparse import OptionParser");
                tempFile = File.createTempFile("polyxsim", ".stdout");
                tempFile.deleteOnExit();
                logger.debug((Object)("tempFile = " + tempFile.getAbsolutePath()));
                PolyXSim.this.killFile = tempFile.getAbsolutePath().replaceAll("stdout", "kill");
                logger.debug((Object)("killFile = " + PolyXSim.this.killFile));
                jep.redirectStdout(tempFile.getAbsolutePath());
                String string = inputDirectory.replaceAll("\\\\", "/");
                jep.eval("os.chdir(\"" + string + "\")");
                jep.set("sim_filename", inputFileName);
                PolyXSim.this.stdoutThread = new StdoutReaderThread(tempFile.getAbsolutePath());
                PolyXSim.this.stdoutThread.start();
                jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
                if (this.updateMonitorStatus("Read input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("read input");
                jep.eval("myinput.read()");
                PolyXSim.updateValues(jep);
                if (this.updateMonitorStatus("Check input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("check input");
                jep.eval("myinput.check()");
                if (this.updateMonitorStatus("Initialise", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("initialise");
                jep.eval("myinput.initialize()");
                if (this.updateMonitorStatus("Generate grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("generate reflections");
                jep.eval("hkl = []");
                jep.eval("print myinput.param['phase_list']");
                int n = 0;
                while (n < numPhases) {
                    jep.eval("phase = " + n);
                    jep.eval("print 'phase = ',phase");
                    if (jep.getValue("myinput.param['structure_phase_" + n + "']") != null) {
                        jep.eval("xtal_structure = reflections.open_structure(myinput.param,phase)");
                        jep.eval("print 'UNIT CELL', myinput.param['unit_cell_phase_" + n + "']");
                        jep.eval("print 'Generating miller indices'");
                        jep.eval("hkl_tmp = reflections.gen_miller(myinput.param,phase)");
                        if ((Integer)jep.getValue("myinput.param['structure_factors']") != 0) {
                            jep.eval("print 'Structure factor calculation'");
                            jep.eval("hkl.append(reflections.calc_intensity(hkl_tmp,xtal_structure,'" + PolyXSim.this.killFile + "'))");
                        } else {
                            jep.eval("print 'No structure factor calculation'");
                            jep.eval("hkl.append(reflections.add_intensity(hkl,myinput.param))");
                        }
                    } else {
                        jep.eval("hkl_tmp = reflections.gen_miller(myinput.param,phase)");
                        jep.eval("hkl.append(reflections.add_intensity(hkl_tmp,myinput.param))");
                    }
                    ++n;
                }
                FableMessageConsole.console.displayOut("generate grains");
                jep.eval("generate_grains.generate_grains(myinput.param)");
                if (this.updateMonitorStatus("Write grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("write grains");
                jep.eval("file_io.write_grains(myinput.param)");
                if (this.updateMonitorStatus("Write res", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("write reflections");
                jep.eval("file_io.write_res(myinput.param)");
                if (this.updateMonitorStatus("Generate reflections", 60)) {
                    return;
                }
                if (this.updateMonitorStatus("Determine the reflection parameters for grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("grain reflections");
                jep.eval("graindata = find_refl.find_refl(myinput.param,hkl,'" + PolyXSim.this.killFile + "')");
                jep.eval("graindata.frameinfo = myinput.frameinfo");
                jep.eval("graindata.run()");
                if (this.updateMonitorStatus("Save grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("save grains");
                jep.eval("graindata.save()");
                if (outputGve) {
                    if (this.updateMonitorStatus("Save gvectors", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("save gve");
                    jep.eval("graindata.write_gve()");
                }
                if (outputFlt) {
                    if (this.updateMonitorStatus("Save filtered peaks", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("save flt");
                    jep.eval("graindata.write_flt()");
                }
                if (this.updateMonitorStatus("Determine the reflection parameters for grains", 20)) {
                    return;
                }
                FableMessageConsole.console.displayOut("determine the reflection parameters for grains");
                jep.eval("graindata = find_refl.find_refl(myinput.param,hkl)");
                jep.eval("graindata.frameinfo = myinput.frameinfo");
                jep.eval("graindata.run()");
                jep.eval("graindata.save()");
                if (outputGve) {
                    jep.eval("graindata.write_gve()");
                }
                if (outputFlt) {
                    jep.eval("graindata.write_flt()");
                }
                if (peakShape == 2) {
                    if (this.updateMonitorStatus("Make image stack", 20)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("make images");
                    jep.eval("image = make_imagestack.make_image(graindata,'" + PolyXSim.this.killFile + "')");
                    if (this.updateMonitorStatus("Setup odf", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("setup odf");
                    jep.eval("image.setup_odf()");
                    if (this.updateMonitorStatus("Write images", 15)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("write images");
                    jep.eval("image.make_image()");
                    jep.eval("image.correct_image()");
                } else {
                    if (this.updateMonitorStatus("Make images", 20)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("make images");
                    jep.eval("image = make_image.make_image(graindata,'" + PolyXSim.this.killFile + "')");
                    if (this.updateMonitorStatus("Write images", 15)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("write images");
                    jep.eval("image.make_image()");
                }
                Thread.sleep(1000L);
                PolyXSim.this.runStatus = true;
            }
            catch (JepException jepException) {
                FableUtils.excMsg((Object)this, (String)jepException.getMessage(), (Throwable)jepException);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(jepException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                FableUtils.excMsg((Object)this, (String)interruptedException.getMessage(), (Throwable)interruptedException);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(interruptedException.getMessage());
            }
            catch (IOException iOException) {
                FableUtils.excMsg((Object)this, (String)iOException.getMessage(), (Throwable)iOException);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(iOException.getMessage());
            }
            if (PolyXSim.this.runStatus) {
                FableMessageConsole.console.displayOut("polyxsim simulation finished");
            } else {
                FableMessageConsole.console.displayError("polyxsim simulation failed ");
            }
            PolyXSim.this.fireProperty("stopped");
            if (PolyXSim.this.stdoutThread != null) {
                ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
                try {
                    PolyXSim.this.stdoutThread.join();
                }
                catch (InterruptedException interruptedException) {
                    FableUtils.excMsg((Object)this, (String)interruptedException.getMessage(), (Throwable)interruptedException);
                }
            }
            this.setCursor(0);
        }

        void setCursor(final int n) {
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Cursor cursor = new Cursor((Device)Display.getDefault(), n);
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        iWorkbenchWindow.getShell().setCursor(cursor);
                    }
                });
            }
        }

        boolean updateMonitorStatus(String string, int n) {
            PolyXSim.this.polyXSimMonitor.subTask(string);
            PolyXSim.this.polyXSimMonitor.worked(n);
            if (PolyXSim.this.polyXSimMonitor.isCanceled()) {
                File file = new File(PolyXSim.this.killFile);
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                FableMessageConsole.console.displayOut("canceled polyxsim simulation");
                PolyXSim.this.fireProperty("stopped");
                ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
                try {
                    PolyXSim.this.stdoutThread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.setCursor(0);
                file.delete();
                PolyXSim.this.jobCanceled = true;
                return true;
            }
            return false;
        }
    }

    public class StdoutReaderThread
    extends Thread {
        String outputMessage;
        BufferedReader outputread;
        public boolean stopped = false;

        public StdoutReaderThread(String string) {
            try {
                this.outputread = new BufferedReader(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

