/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TacoApi;

import fr.esrf.TacoApi.TacoException;
import fr.esrf.TacoApi.xdr.XdrDbAble;
import fr.esrf.TacoApi.xdr.XdrDevInfos;
import fr.esrf.TacoApi.xdr.XdrDevRes;
import fr.esrf.TacoApi.xdr.XdrManagerData;
import fr.esrf.TacoApi.xdr.XdrRegisterData;
import fr.esrf.TacoApi.xdr.XdrTacoType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrStrings;
import org.acplt.oncrpc.XdrVoid;

class NethostConnection {
    private static final int managerTimeout = 3000;
    private static final int dbaseTimeout = 4000;
    private static final int dbaseRetryCount = 2;
    private static final int dbaseReconnectionTimeout = 10000;
    private static final int NMSERVER_PROG = 100;
    private static final int NMSERVER_VERS = 4;
    private static final int RPC_GET_CONFIG = 1;
    private static final int RPC_DB_GETRES = 1;
    private static final int RPC_DB_DEVIMP = 4;
    private static final int DS_TEAM_SHIFT = 26;
    private static final int DS_IDENT_SHIFT = 18;
    private static final int DS_TEAM_MASK = 63;
    private static final int DS_IDENT_MASK = 255;
    private static int DS_ERRORNUMBER_NASK = 4095;
    private static int CMD_NUMBER_MASK = 262143;
    private String name;
    private OncRpcUdpClient manager = null;
    private boolean securityEnabled;
    private InetAddress dbHostName;
    private int dbProgNumber;
    private int dbVersNumber;
    private OncRpcUdpClient dbClient = null;
    private long lastConnection;
    private HashMap errorList;
    private HashMap commandList;
    private String dcServerReadName = null;
    private String dcServerWriteName = null;
    private String dcHostName = null;
    private TacoException lastDCError = null;
    private static Object nethostMonitor = new Object();
    private static Vector netHostList = new Vector();
    private static NethostConnection defNethost = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NethostConnection connectNethost(String string) throws TacoException {
        Object object = nethostMonitor;
        synchronized (object) {
            NethostConnection.connectDefaultNehost();
            if (string.length() == 0) {
                return defNethost;
            }
            if (!string.equals(NethostConnection.defNethost.name)) {
                NethostConnection nethostConnection = NethostConnection.getNethostByName(string);
                if (nethostConnection == null) {
                    nethostConnection = new NethostConnection(string);
                    netHostList.add(nethostConnection);
                }
                return nethostConnection;
            }
            return defNethost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NethostConnection getDefaultNethost() throws TacoException {
        Object object = nethostMonitor;
        synchronized (object) {
            NethostConnection.connectDefaultNehost();
        }
        return defNethost;
    }

    synchronized String getErrorString(int n) {
        if (n <= 0) {
            return "No error message stored in the database for negative error: " + n;
        }
        Integer n2 = new Integer(n);
        Object object = this.errorList.get(n2);
        if (object == null) {
            int n3 = n >> 26;
            n3 &= 0x3F;
            int n4 = n >> 18;
            n4 &= 0xFF;
            int n5 = n & DS_ERRORNUMBER_NASK;
            try {
                String[] stringArray = new String[]{"error/" + n3 + "/" + n4 + "/" + n5};
                String[] stringArray2 = this.dbGetResource(stringArray);
                String string = stringArray2.length == 0 || stringArray2[0].length() == 0 ? "No error message stored in the database for code " + n : stringArray2[0];
                this.errorList.put(n2, string);
                object = string;
            }
            catch (Exception exception) {
                return "Failed to get error message from database for code " + n + "\n" + exception.getMessage();
            }
        }
        return object.toString();
    }

    String getCommandName(int n) {
        return this.getCommandNames(new Integer[]{new Integer(n)})[0];
    }

    synchronized String[] getCommandNames(Integer[] integerArray) {
        String[] stringArray;
        String[] stringArray2 = new String[integerArray.length];
        int[] nArray = new int[integerArray.length];
        Vector<String> vector = new Vector<String>();
        int n = 0;
        for (int i = 0; i < integerArray.length; ++i) {
            stringArray = (String[])this.commandList.get(integerArray[i]);
            if (stringArray == null) {
                vector.add(this.buildCommandResString(integerArray[i]));
                nArray[n++] = i;
                stringArray2[i] = "Cmd" + integerArray[i];
                continue;
            }
            stringArray2[i] = stringArray;
        }
        if (vector.size() > 0) {
            try {
                String[] stringArray3 = XdrTacoType.toStrArr(vector);
                stringArray = this.dbGetResource(stringArray3);
                if (stringArray.length == stringArray3.length) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i].length() > 0 ? stringArray[i] : "Cmd" + integerArray[nArray[i]];
                        this.commandList.put(integerArray[nArray[i]], string);
                        stringArray2[nArray[i]] = string;
                    }
                }
            }
            catch (TacoException tacoException) {
                // empty catch block
            }
        }
        return stringArray2;
    }

    boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    String getName() {
        return this.name;
    }

    XdrDevInfos dbImportDevice(String[] stringArray) throws TacoException {
        XdrStrings xdrStrings = new XdrStrings(stringArray);
        XdrDevInfos xdrDevInfos = new XdrDevInfos();
        this.dataBaseCall(4, xdrStrings, xdrDevInfos);
        return xdrDevInfos;
    }

    String[] dbGetResource(String[] stringArray) throws TacoException {
        XdrStrings xdrStrings = new XdrStrings(stringArray);
        XdrDevRes xdrDevRes = new XdrDevRes();
        this.dataBaseCall(1, xdrStrings, xdrDevRes);
        return xdrDevRes.value.stringsValue();
    }

    String[] extractResourceArray(String string) {
        int n = string.indexOf(2);
        string = string.substring(n + 1);
        String string2 = new String(new char[]{'\u0002'});
        String[] stringArray = string.split(string2);
        return stringArray;
    }

    String getDcServerReadName() throws TacoException {
        if (this.lastDCError == null && this.dcServerReadName == null) {
            this.initDC();
        }
        if (this.dcServerReadName != null) {
            return this.dcServerReadName;
        }
        throw this.lastDCError;
    }

    String getDcServerWriteName() throws TacoException {
        if (this.lastDCError == null && this.dcServerReadName == null) {
            this.initDC();
        }
        if (this.dcServerWriteName != null) {
            return this.dcServerWriteName;
        }
        throw this.lastDCError;
    }

    private NethostConnection(String string) throws TacoException {
        OncRpcUdpClient oncRpcUdpClient;
        InetAddress inetAddress;
        if (string.length() == 0) {
            throw new TacoException("Environment variable NETHOST not defined");
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new TacoException("Cannot resolve the nethost ip address: " + string);
        }
        try {
            oncRpcUdpClient = new OncRpcUdpClient(inetAddress, 100, 4, 0);
            oncRpcUdpClient.setTimeout(3000);
            oncRpcUdpClient.setRetransmissionTimeout(3000);
        }
        catch (Exception exception) {
            throw new TacoException("No network manager available on " + string);
        }
        this.name = string;
        this.dbClient = null;
        this.manager = oncRpcUdpClient;
        this.lastConnection = 0L;
        this.initDBChache();
    }

    private void initDC() {
        try {
            String[] stringArray = this.dbGetResource(new String[]{"class/dc/1/host"});
            if (stringArray[0].equals("N_DEF")) {
                throw new TacoException("No DC system on " + this.getName());
            }
            if (stringArray[0].charAt(0) == '\u0005') {
                throw new TacoException("Multi host for DC not supported");
            }
            InetAddress inetAddress = null;
            this.dcHostName = stringArray[0];
            try {
                inetAddress = InetAddress.getByName(this.dcHostName);
            }
            catch (UnknownHostException unknownHostException) {
                throw new TacoException("Cannot resolve the DC Host ip address: " + stringArray[0]);
            }
            int n = inetAddress.getAddress()[3];
            n &= 0xFF;
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            String[] stringArray2 = new String[10];
            for (int i = 0; i < 10; ++i) {
                stringArray2[i] = "sys/dc_rd_" + n + "/request/" + (i + 1);
            }
            String[] stringArray3 = this.dbGetResource(stringArray2);
            if (stringArray3[0].equals("N_DEF")) {
                throw new TacoException("Cannot select the dc_read server");
            }
            for (int i = 0; i < 10; ++i) {
                int n4 = Integer.MAX_VALUE;
                try {
                    n4 = Integer.parseInt(stringArray3[i]);
                    if (n4 == 0) {
                        n4 = Integer.MAX_VALUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n4 >= n2) continue;
                n2 = n4;
                n3 = i;
            }
            this.dcServerReadName = "sys/dc_rd_" + n + "/" + (n3 + 1);
            this.dcServerWriteName = "sys/dc_wr_" + n + "/1";
        }
        catch (TacoException tacoException) {
            this.dcServerReadName = null;
            this.dcHostName = null;
            this.lastDCError = tacoException;
        }
    }

    private synchronized void dataBaseCall(int n, XdrAble xdrAble, XdrDbAble xdrDbAble) throws TacoException {
        block15: {
            if (this.dbClient == null) {
                this.importDataBase();
            }
            try {
                this.dbClient.call(n, xdrAble, xdrDbAble);
                if (xdrDbAble.dbError == 0) break block15;
                switch (xdrDbAble.dbError) {
                    case 436: {
                        boolean bl = false;
                        for (int i = 2; i > 0 && !bl; --i) {
                            try {
                                Thread.sleep(20L);
                                this.dbClient.call(n, xdrAble, xdrDbAble);
                                bl = xdrDbAble.dbError == 0;
                                continue;
                            }
                            catch (Exception exception) {
                                i = 0;
                            }
                        }
                        if (!bl) {
                            throw new TacoException("NethostConnection.dataBaseCall(" + n + ") failed after " + 2 + " retries", xdrDbAble.dbError);
                        }
                        break;
                    }
                    case 433: {
                        throw new TacoException("NethostConnection.dataBaseCall(" + n + ") TCP not yet upported", xdrDbAble.dbError);
                    }
                    default: {
                        throw new TacoException(xdrDbAble.dbError);
                    }
                }
            }
            catch (OncRpcException oncRpcException) {
                switch (oncRpcException.getReason()) {
                    case 1: 
                    case 11: 
                    case 42: 
                    case 43: {
                        throw new TacoException(23);
                    }
                    case 6: {
                        throw new TacoException("RPC databse server version number mismatch for function " + n);
                    }
                }
                this.dbClient = null;
                throw new TacoException(oncRpcException.getMessage(), 428);
            }
        }
    }

    private String buildCommandResString(int n) {
        int n2 = n >> 26;
        int n3 = n >> 18;
        int n4 = n & CMD_NUMBER_MASK;
        return "cmds/" + (n2 &= 0x3F) + "/" + (n3 &= 0xFF) + "/" + n4;
    }

    private void importDataBase() throws TacoException {
        long l = System.currentTimeMillis();
        if (l - this.lastConnection > 10000L) {
            this.lastConnection = l;
            XdrRegisterData xdrRegisterData = new XdrRegisterData();
            xdrRegisterData.hostName = this.name;
            xdrRegisterData.progNumber = 0;
            xdrRegisterData.versNumber = 0;
            XdrManagerData xdrManagerData = new XdrManagerData();
            try {
                this.manager.call(1, xdrRegisterData, xdrManagerData);
            }
            catch (Exception exception) {
                throw new TacoException(exception.getMessage(), 17);
            }
            if (xdrManagerData.status < 0) {
                String string = "Namager error code: " + xdrManagerData.error;
                throw new TacoException(string, 17);
            }
            try {
                this.dbHostName = InetAddress.getByName(xdrManagerData.dbInfo.hostName);
            }
            catch (UnknownHostException unknownHostException) {
                throw new TacoException("Cannot retrieve the databse host ip address\n" + unknownHostException.getMessage());
            }
            this.dbProgNumber = xdrManagerData.dbInfo.progNumber;
            this.dbVersNumber = xdrManagerData.dbInfo.versNumber;
            this.securityEnabled = xdrManagerData.security == 1;
            try {
                this.dbClient = new OncRpcUdpClient(this.dbHostName, this.dbProgNumber, this.dbVersNumber, 0);
                this.dbClient.setTimeout(4000);
                this.dbClient.setRetransmissionTimeout(4000);
                this.dbClient.call(0, new XdrVoid(), new XdrVoid());
            }
            catch (Exception exception) {
                this.dbClient = null;
                throw new TacoException(exception.getMessage(), 10);
            }
        }
        throw new TacoException(10);
    }

    private static void connectDefaultNehost() throws TacoException {
        if (defNethost == null) {
            String string = System.getProperty("NETHOST", "null");
            if (string.equals("null")) {
                throw new TacoException("Environment variable NETHOST not defined");
            }
            defNethost = new NethostConnection(string.toLowerCase());
        }
    }

    private static NethostConnection getNethostByName(String string) {
        int n = netHostList.size();
        for (int i = 0; i < n; ++i) {
            NethostConnection nethostConnection = (NethostConnection)netHostList.get(i);
            if (!string.equals(nethostConnection.name)) continue;
            return nethostConnection;
        }
        return null;
    }

    private void initDBChache() {
        this.commandList = new HashMap();
        this.commandList.put(new Integer(1), "DevOn");
        this.commandList.put(new Integer(2), "DevOff");
        this.commandList.put(new Integer(3), "DevReset");
        this.commandList.put(new Integer(4), "DevState");
        this.commandList.put(new Integer(5), "DevStandby");
        this.commandList.put(new Integer(6), "DevRun");
        this.commandList.put(new Integer(7), "DevLocal");
        this.commandList.put(new Integer(8), "DevStatus");
        this.commandList.put(new Integer(9), "DevOpen");
        this.commandList.put(new Integer(10), "DevClose");
        this.commandList.put(new Integer(11), "DevSetValue");
        this.commandList.put(new Integer(12), "DevReadValue");
        this.commandList.put(new Integer(13), "DevInsert");
        this.commandList.put(new Integer(14), "DevExtract");
        this.commandList.put(new Integer(15), "DevReadPos");
        this.commandList.put(new Integer(16), "DevWritePos");
        this.commandList.put(new Integer(17), "DevSetParam");
        this.commandList.put(new Integer(18), "DevReadParam");
        this.commandList.put(new Integer(19), "DevUnlock");
        this.commandList.put(new Integer(20), "DevSetConversion");
        this.commandList.put(new Integer(21), "DevSelectCh");
        this.commandList.put(new Integer(22), "DevSetProtThresh");
        this.commandList.put(new Integer(23), "DevReadPressure");
        this.commandList.put(new Integer(24), "DevResetInputBuffer");
        this.commandList.put(new Integer(25), "DevChangeCalibration");
        this.commandList.put(new Integer(26), "DevNAve");
        this.commandList.put(new Integer(27), "DevHello");
        this.commandList.put(new Integer(28), "DevRead");
        this.commandList.put(new Integer(29), "DevWrite");
        this.commandList.put(new Integer(238), "DevGetSigConfig");
        this.commandList.put(new Integer(199), "DevUpdateSigConfig");
        this.commandList.put(new Integer(239), "DevReadSigValues");
        this.errorList = new HashMap();
        this.errorList.put(new Integer(1), "Cannot create RPC client handle");
        this.errorList.put(new Integer(2), "RPC client call timed out");
        this.errorList.put(new Integer(3), "RPC client call failed");
        this.errorList.put(new Integer(4), "Import of message server failed");
        this.errorList.put(new Integer(5), "The XDR data type is not correctly defined");
        this.errorList.put(new Integer(6), "The list of possible XDR data types is full");
        this.errorList.put(new Integer(7), "The requested XDR data type is not loaded");
        this.errorList.put(new Integer(8), "Device has not been fully imported yet, (hint: start the device server)");
        this.errorList.put(new Integer(10), "Import of database server failed");
        this.errorList.put(new Integer(11), "Exceeded maximum number of servers");
        this.errorList.put(new Integer(12), "Lost connection to the device server");
        this.errorList.put(new Integer(13), "Unrecognised device argument type");
        this.errorList.put(new Integer(14), "Device server ran out of memory");
        this.errorList.put(new Integer(15), "Environment variable NETHOST not defined");
        this.errorList.put(new Integer(16), "No network manager available");
        this.errorList.put(new Integer(17), "Network manager is not responding");
        this.errorList.put(new Integer(18), "Not a valid signal value");
        this.errorList.put(new Integer(19), "Cannot setup signal handler function");
        this.errorList.put(new Integer(20), "Device argument type is not correctly implemented");
        this.errorList.put(new Integer(21), "Input parameter is unknown");
        this.errorList.put(new Integer(22), "Cannot establish connection to host");
        this.errorList.put(new Integer(23), "XDR: Cannot decode arguments");
        this.errorList.put(new Integer(30), "Environment variable DISPLAY has not been setup");
        this.errorList.put(new Integer(31), "Device of this name unknown to the server");
        this.errorList.put(new Integer(32), "The maximum of devices which can be served has been exceeded");
        this.errorList.put(new Integer(33), "Incompatible arguments types for command function");
        this.errorList.put(new Integer(34), "Tried to execute a command which is not implemented");
        this.errorList.put(new Integer(35), "The same Device Server is already running");
        this.errorList.put(new Integer(36), "The Device Server is still registered on a different host");
        this.errorList.put(new Integer(37), "Calculation of the XDR length of the data type failed");
        this.errorList.put(new Integer(38), "String exceeded length of character field");
        this.errorList.put(new Integer(39), "The device is no longer exported");
        this.errorList.put(new Integer(40), "Exceeded the maximum number of client connections");
        this.errorList.put(new Integer(200), "Environment variable DSHOME has not been setup");
        this.errorList.put(new Integer(300), "Message server cannot open error file");
        this.errorList.put(new Integer(301), "Message server cannot open named pipe");
        this.errorList.put(new Integer(302), "Message server cannot write to named pipe");
        this.errorList.put(new Integer(42), "Asynchronous calls not supported (hint: relink with V6 and/or use a remote device)");
        this.errorList.put(new Integer(41), "Asynchronous server not imported yet");
        this.errorList.put(new Integer(43), "No callback specified for asynchronous reply");
        this.errorList.put(new Integer(44), "Exceeded maximum no. of pending asynchronous calls (hint: try calling dev_synch() to clear pending calls)");
        this.errorList.put(new Integer(400), "No database therefore the process cannot query it (hint: try running with database)");
        this.errorList.put(new Integer(401), "Cannot create RPC client handle to database server");
        this.errorList.put(new Integer(402), "Problem during data reception from server");
        this.errorList.put(new Integer(403), "Something wrong during a database access function");
        this.errorList.put(new Integer(404), "Bad definition for a boolean resource");
        this.errorList.put(new Integer(405), "Problem occurs during XDR memory freeing");
        this.errorList.put(new Integer(406), "Impossible to allocate memory in the function client part");
        this.errorList.put(new Integer(407), "Impossible to allocate memory in the function server part");
        this.errorList.put(new Integer(408), "Bad domain definition in a resource definition");
        this.errorList.put(new Integer(409), "Resource not defined in the database");
        this.errorList.put(new Integer(410), "Device server not defined in the database");
        this.errorList.put(new Integer(411), "Too much devices for this device server");
        this.errorList.put(new Integer(412), "Device not defined in the database");
        this.errorList.put(new Integer(413), "The host name used in the db_dev_export function is not the same than the host name defined in the database");
        this.errorList.put(new Integer(414), "Try to import a device which has not been previously exported");
        this.errorList.put(new Integer(415), "Bad family definition in the data_key definition");
        this.errorList.put(new Integer(416), "Wrong time criterion for retrieval function");
        this.errorList.put(new Integer(417), "Bad boolean definition in the research criterions structure");
        this.errorList.put(new Integer(418), "Wrong criterion used for numrical data");
        this.errorList.put(new Integer(419), "Bad boolean criterion for retrieval function");
        this.errorList.put(new Integer(420), "Wrong string criterion for retrieval function");
        this.errorList.put(new Integer(421), "Bad member definition in the data_key definition");
        this.errorList.put(new Integer(422), "Wrong data definition in the data_key definition");
        this.errorList.put(new Integer(423), "Bad structure definition for data");
        this.errorList.put(new Integer(424), "Bad parameters initialization");
        this.errorList.put(new Integer(425), "Problem during file access in OS-9 stand alone system");
        this.errorList.put(new Integer(426), "Environment varaible NETHOST not defined");
        this.errorList.put(new Integer(427), "No database server available");
        this.errorList.put(new Integer(428), "Database server is not responding");
        this.errorList.put(new Integer(429), "Network manager returned error");
        this.errorList.put(new Integer(430), "No data available for this database server in the network manager");
        this.errorList.put(new Integer(431), "Too many exported devices for a UDP packet");
        this.errorList.put(new Integer(432), "The database server is not the only process which has connection to the database");
        this.errorList.put(new Integer(433), "The size of information sent back to the client is too big for UDP packet");
        this.errorList.put(new Integer(434), "The resource is not initialised as an array");
        this.errorList.put(new Integer(435), "The resource is too long to be stored in the database");
        this.errorList.put(new Integer(437), "The pseudo device name is already used for a device");
        this.errorList.put(new Integer(438), "XDR : Cannot encode arguments");
        this.errorList.put(new Integer(439), "XDR : Cannot decode results from db server");
        this.errorList.put(new Integer(1100), "Attribute name is neither defined for TACO nor for TANGO");
        this.errorList.put(new Integer(1102), "Cannot cast attribute data type to the requested type");
    }
}

