package fable;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.IActionSetContributionItem;

import fable.framework.logging.FableLogger;

public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {

	/**
	 * Constructor.
	 * 
	 * @param configurer
	 */
	public ApplicationWorkbenchWindowAdvisor(
			IWorkbenchWindowConfigurer configurer) {
		super(configurer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.application.WorkbenchWindowAdvisor#createActionBarAdvisor
	 * (org.eclipse.ui.application.IActionBarConfigurer)
	 */
	public ActionBarAdvisor createActionBarAdvisor(
			IActionBarConfigurer configurer) {
		return new ApplicationActionBarAdvisor(configurer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.application.WorkbenchWindowAdvisor#preWindowOpen()
	 */
	public void preWindowOpen() {
		IWorkbenchWindowConfigurer configurer = getWindowConfigurer();

		Rectangle screenWidth = Display.getCurrent().getPrimaryMonitor()
				.getBounds();
		float width = 0.9f;
		float heigth = 0.92f;
		int x = (int) (screenWidth.width * width);
		int y = (int) (screenWidth.height * heigth);
		configurer.setInitialSize(new Point(x, y));
		configurer.setShowCoolBar(true);
		configurer.setShowStatusLine(true);
		configurer.setTitle("Fable");
		configurer.setShowPerspectiveBar(true);
		configurer.setShowProgressIndicator(true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.application.WorkbenchWindowAdvisor#preWindowShellClose()
	 */
	@Override
	public boolean preWindowShellClose() {
		try {
			// Save the full workspace before quit
			// KE: Seems to be needed after implementing the CNF
			ResourcesPlugin.getWorkspace().save(true, null);
		} catch (final CoreException ex) {
			FableLogger.error("Problem saving the workbench: "
					+ ex.getMessage());
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.application.WorkbenchWindowAdvisor#postWindowCreate()
	 */
	public void postWindowOpen() {
		super.postWindowOpen();  // Does nothing
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.application.WorkbenchWindowAdvisor#postWindowOpen()
	 */
	public void postWindowCreate() {
		super.postWindowCreate();  // Does nothing
		if(false) {
			// Use this to determine IDs of action bar items
			printActionBarIDs();
		}
	}

	/**
	 * Prints out the IDs of all the items on the action bars.
	 */
	@SuppressWarnings("restriction") // IActionSetContributionItem
	public void printActionBarIDs() {
		System.out.println("ActionBar IDs");
		IActionBarConfigurer configurer = getWindowConfigurer()
				.getActionBarConfigurer();
		IContributionItem[] menuItems = configurer.getMenuManager().getItems();
		for (int i = 0; i < menuItems.length; i++) {
			IContributionItem menuItem = menuItems[i];
			System.out.println(menuItem.getId());
			if (menuItem instanceof IMenuManager) {
				IContributionItem[] items = ((IMenuManager) menuItem)
						.getItems();
				for (IContributionItem item : items) {
					System.out.println("  " + item.getId());
				}
			} else if (menuItem instanceof IActionSetContributionItem) {
				System.out.println("  [Action Set] "
						+ ((IActionSetContributionItem) menuItem)
								.getActionSetId());
			} else {
				System.out.println("menuItem " + menuItem);
			}
		}
	}

}
