/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.Lock;

public abstract class IndexReader {
    private Directory directory;
    private boolean directoryOwner;
    private boolean closeDirectory;
    private SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private boolean hasChanges;

    protected IndexReader(Directory directory) {
        this.directory = directory;
    }

    IndexReader(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory) {
        this.init(directory, segmentInfos, closeDirectory, true);
    }

    void init(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory, boolean directoryOwner) {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.directoryOwner = directoryOwner;
        this.closeDirectory = closeDirectory;
    }

    public static IndexReader open(String path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false), true);
    }

    public static IndexReader open(File path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false), true);
    }

    public static IndexReader open(Directory directory) throws IOException {
        return IndexReader.open(directory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexReader open(final Directory directory, final boolean closeDirectory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            return (IndexReader)new Lock.With(directory.makeLock("commit.lock"), 10000L){

                public Object doBody() throws IOException {
                    SegmentInfos infos = new SegmentInfos();
                    infos.read(directory);
                    if (infos.size() == 1) {
                        return SegmentReader.get(infos, infos.info(0), closeDirectory);
                    }
                    IndexReader[] readers = new IndexReader[infos.size()];
                    for (int i = 0; i < infos.size(); ++i) {
                        readers[i] = SegmentReader.get(infos.info(i));
                    }
                    return new MultiReader(directory, infos, closeDirectory, readers);
                }
            }.run();
        }
    }

    public Directory directory() {
        return this.directory;
    }

    public static long lastModified(String directory) throws IOException {
        return IndexReader.lastModified(new File(directory));
    }

    public static long lastModified(File directory) throws IOException {
        return FSDirectory.fileModified(directory, "segments");
    }

    public static long lastModified(Directory directory) throws IOException {
        return directory.fileModified("segments");
    }

    public static long getCurrentVersion(String directory) throws IOException {
        return IndexReader.getCurrentVersion(new File(directory));
    }

    public static long getCurrentVersion(File directory) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(directory, false);
        long version = IndexReader.getCurrentVersion(dir);
        ((Directory)dir).close();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCurrentVersion(Directory directory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            long l;
            block7: {
                Lock commitLock = directory.makeLock("commit.lock");
                boolean locked = false;
                try {
                    locked = commitLock.obtain(10000L);
                    l = SegmentInfos.readCurrentVersion(directory);
                    if (!locked) break block7;
                    commitLock.release();
                }
                catch (Throwable throwable) {
                    if (locked) {
                        commitLock.release();
                    }
                    throw throwable;
                }
            }
            return l;
        }
    }

    public long getVersion() {
        return this.segmentInfos.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrent() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            boolean bl;
            block7: {
                Lock commitLock = this.directory.makeLock("commit.lock");
                boolean locked = false;
                try {
                    locked = commitLock.obtain(10000L);
                    boolean bl2 = bl = SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
                    if (!locked) break block7;
                    commitLock.release();
                }
                catch (Throwable throwable) {
                    if (locked) {
                        commitLock.release();
                    }
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public static boolean indexExists(String directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(File directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return directory.fileExists("segments");
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public abstract Document document(int var1) throws IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public boolean hasNorms(String field) throws IOException {
        return this.norms(field) != null;
    }

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public final synchronized void setNorm(int doc, String field, byte value) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doSetNorm(doc, field, value);
        this.hasChanges = true;
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws IOException;

    public void setNorm(int doc, String field, float value) throws IOException {
        this.setNorm(doc, field, Similarity.encodeNorm(value));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    private void aquireWriteLock() throws IOException {
        if (this.stale) {
            throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
        }
        if (this.writeLock == null) {
            Lock writeLock = this.directory.makeLock("write.lock");
            if (!writeLock.obtain(1000L)) {
                throw new IOException("Index locked for write: " + writeLock);
            }
            this.writeLock = writeLock;
            if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                this.stale = true;
                this.writeLock.release();
                this.writeLock = null;
                throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
        }
    }

    public final synchronized void delete(int docNum) throws IOException {
        this.deleteDocument(docNum);
    }

    public final synchronized void deleteDocument(int docNum) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doDelete(docNum);
        this.hasChanges = true;
    }

    protected abstract void doDelete(int var1) throws IOException;

    public final int delete(Term term) throws IOException {
        return this.deleteDocuments(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deleteDocuments(Term term) throws IOException {
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.deleteDocument(docs.doc());
                ++n;
            }
        }
        finally {
            docs.close();
        }
        return n;
    }

    public final synchronized void undeleteAll() throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doUndeleteAll();
        this.hasChanges = true;
    }

    protected abstract void doUndeleteAll() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void commit() throws IOException {
        if (this.hasChanges) {
            if (this.directoryOwner) {
                Directory directory = this.directory;
                synchronized (directory) {
                    new Lock.With(this.directory.makeLock("commit.lock"), 10000L){

                        public Object doBody() throws IOException {
                            IndexReader.this.doCommit();
                            IndexReader.this.segmentInfos.write(IndexReader.this.directory);
                            return null;
                        }
                    }.run();
                }
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.doCommit();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit() throws IOException;

    public final synchronized void close() throws IOException {
        this.commit();
        this.doClose();
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected void finalize() {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public abstract Collection getFieldNames() throws IOException;

    public abstract Collection getFieldNames(boolean var1) throws IOException;

    public Collection getIndexedFieldNames(boolean storedTermVector) {
        if (storedTermVector) {
            HashSet fieldSet = new HashSet();
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.YES));
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.WITH_POSITIONS));
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.WITH_OFFSETS));
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.WITH_POSITIONS_OFFSETS));
            return fieldSet;
        }
        return this.getIndexedFieldNames(Field.TermVector.NO);
    }

    public abstract Collection getIndexedFieldNames(Field.TermVector var1);

    public abstract Collection getFieldNames(FieldOption var1);

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked() || directory.makeLock("commit.lock").isLocked();
    }

    public static boolean isLocked(String directory) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(directory, false);
        boolean result = IndexReader.isLocked(dir);
        ((Directory)dir).close();
        return result;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock("write.lock").release();
        directory.makeLock("commit.lock").release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block20: {
            String filename = null;
            boolean extract = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-extract")) {
                    extract = true;
                    continue;
                }
                if (filename != null) continue;
                filename = args[i];
            }
            if (filename == null) {
                System.out.println("Usage: org.apache.lucene.index.IndexReader [-extract] <cfsfile>");
                return;
            }
            Directory dir = null;
            CompoundFileReader cfr = null;
            File file = new File(filename);
            String dirname = file.getAbsoluteFile().getParent();
            filename = file.getName();
            dir = FSDirectory.getDirectory(dirname, false);
            cfr = new CompoundFileReader(dir, filename);
            Object[] files = cfr.list();
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                long len;
                if (extract) {
                    int bufLen;
                    System.out.println("extract " + (String)files[i] + " with " + len + " bytes to local directory...");
                    IndexInput ii = cfr.openInput((String)files[i]);
                    FileOutputStream f = new FileOutputStream((String)files[i]);
                    byte[] buffer = new byte[1024];
                    int chunk = buffer.length;
                    for (len = cfr.fileLength((String)files[i]); len > 0L; len -= (long)bufLen) {
                        bufLen = (int)Math.min((long)chunk, len);
                        ii.readBytes(buffer, 0, bufLen);
                        f.write(buffer, 0, bufLen);
                    }
                    f.close();
                    ii.close();
                    continue;
                }
                System.out.println((String)files[i] + ": " + len + " bytes");
            }
            Object var17_17 = null;
            try {
                if (dir != null) {
                    dir.close();
                }
                if (cfr != null) {
                    cfr.close();
                }
                break block20;
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
            break block20;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var17_18 = null;
                    try {
                        if (dir != null) {
                            dir.close();
                        }
                        if (cfr != null) {
                            cfr.close();
                        }
                        break block20;
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    if (dir != null) {
                        dir.close();
                    }
                    if (cfr != null) {
                        cfr.close();
                    }
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public static final class FieldOption {
        private String option;
        public static final FieldOption ALL = new FieldOption("ALL");
        public static final FieldOption INDEXED = new FieldOption("INDEXED");
        public static final FieldOption UNINDEXED = new FieldOption("UNINDEXED");
        public static final FieldOption INDEXED_WITH_TERMVECTOR = new FieldOption("INDEXED_WITH_TERMVECTOR");
        public static final FieldOption INDEXED_NO_TERMVECTOR = new FieldOption("INDEXED_NO_TERMVECTOR");
        public static final FieldOption TERMVECTOR = new FieldOption("TERMVECTOR");
        public static final FieldOption TERMVECTOR_WITH_POSITION = new FieldOption("TERMVECTOR_WITH_POSITION");
        public static final FieldOption TERMVECTOR_WITH_OFFSET = new FieldOption("TERMVECTOR_WITH_OFFSET");
        public static final FieldOption TERMVECTOR_WITH_POSITION_OFFSET = new FieldOption("TERMVECTOR_WITH_POSITION_OFFSET");

        private FieldOption() {
        }

        private FieldOption(String option) {
            this.option = option;
        }

        public String toString() {
            return this.option;
        }
    }
}

