/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.clipboard.FableClipboard;
import fable.framework.imageprint.FableImagePrinter;
import fable.framework.internal.IVarKeys;
import fable.framework.logging.FableLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IVarKeys {
    private boolean loggerLevelSet = false;
    private Preferences prefs = null;
    private Preferences.IPropertyChangeListener listener = null;
    public static final String PLUGIN_ID = "fable.framework.toolbox";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.prefs = Activator.getDefault().getPluginPreferences();
        int intVal = this.prefs.getInt("fableLoggerLevelPreference");
        Logger logger = FableLogger.getLogger();
        this.setLoggerLevel(logger, intVal);
        String value = this.prefs.getString("imagePrintUnitsPreference");
        FableImagePrinter.settings.setUnits(value);
        value = this.prefs.getString("imagePrintLeftPreference");
        FableImagePrinter.settings.setLeftString(value);
        value = this.prefs.getString("imagePrintRightPreference");
        FableImagePrinter.settings.setRightString(value);
        value = this.prefs.getString("imagePrintTopPreference");
        FableImagePrinter.settings.setTopString(value);
        value = this.prefs.getString("imagePrintBottomPreference");
        FableImagePrinter.settings.setBottomString(value);
        intVal = this.prefs.getInt("imagePrintHAlignPreference");
        FableImagePrinter.settings.setHorizontalAlign(intVal);
        intVal = this.prefs.getInt("imagePrintVAlignPreference");
        FableImagePrinter.settings.setVerticalAlign(intVal);
        value = this.prefs.getString("imagePrintOrientationPreference");
        FableImagePrinter.settings.setOrientation(value);
        if (!this.loggerLevelSet) {
            this.loggerLevelSet = true;
            logger.info((Object)"Fable Starting");
            logger.info((Object)("Setting " + logger.getName() + " to " + logger.getLevel()));
        }
        intVal = this.prefs.getInt("rootLoggerLevelPreference");
        Logger rootLogger = Logger.getRootLogger();
        this.setLoggerLevel(rootLogger, intVal);
        this.prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("fableLoggerLevelPreference")) {
                    String value = (String)event.getNewValue();
                    int intValue = Integer.parseInt(value);
                    Logger logger = FableLogger.getLogger();
                    Activator.this.setLoggerLevel(logger, intValue);
                } else if (property.equals("rootLoggerLevelPreference")) {
                    String value = (String)event.getNewValue();
                    int intValue = Integer.parseInt(value);
                    Logger rootLogger = Logger.getRootLogger();
                    Activator.this.setLoggerLevel(rootLogger, intValue);
                } else if (property.equals("imagePrintUnitsPreference")) {
                    String value = (String)event.getNewValue();
                    FableImagePrinter.settings.setUnits(value);
                } else if (property.equals("imagePrintLeftPreference")) {
                    String value = (String)event.getNewValue();
                    FableImagePrinter.settings.setLeftString(value);
                } else if (property.equals("imagePrintRightPreference")) {
                    String value = (String)event.getNewValue();
                    FableImagePrinter.settings.setRightString(value);
                } else if (property.equals("imagePrintTopPreference")) {
                    String value = (String)event.getNewValue();
                    FableImagePrinter.settings.setTopString(value);
                } else if (property.equals("imagePrintBottomPreference")) {
                    String value = (String)event.getNewValue();
                    FableImagePrinter.settings.setBottomString(value);
                } else if (property.equals("imagePrintHAlignPreference")) {
                    String value = (String)event.getNewValue();
                    int intValue = Integer.parseInt(value);
                    FableImagePrinter.settings.setHorizontalAlign(intValue);
                } else if (property.equals("imagePrintVAlignPreference")) {
                    String value = (String)event.getNewValue();
                    int intValue = Integer.parseInt(value);
                    FableImagePrinter.settings.setVerticalAlign(intValue);
                } else if (property.equals("imagePrintOrientationPreference")) {
                    String value = (String)event.getNewValue();
                    FableImagePrinter.settings.setOrientation(value);
                }
            }
        });
    }

    public void setLoggerLevel(Logger logger, int prefLevel) {
        switch (prefLevel) {
            case 0: {
                logger.setLevel(Level.ALL);
                break;
            }
            case 1: {
                logger.setLevel(Level.TRACE);
                break;
            }
            case 2: {
                logger.setLevel(Level.DEBUG);
                break;
            }
            case 3: {
                logger.setLevel(Level.INFO);
                break;
            }
            case 4: {
                logger.setLevel(Level.WARN);
                break;
            }
            case 5: {
                logger.setLevel(Level.ERROR);
                break;
            }
            case 6: {
                logger.setLevel(Level.FATAL);
                break;
            }
            case 7: {
                logger.setLevel(Level.OFF);
            }
        }
        if (this.loggerLevelSet) {
            logger.info((Object)("Setting " + logger.getName() + " to " + logger.getLevel()));
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            plugin = null;
            if (this.prefs != null && this.listener != null) {
                this.prefs.removePropertyChangeListener(this.listener);
            }
            this.prefs = null;
            this.listener = null;
            try {
                if (FableClipboard.clipboard != null && !FableClipboard.clipboard.isDisposed()) {
                    FableClipboard.clipboard.dispose();
                }
            }
            catch (SWTException sWTException) {
            }
            catch (Throwable throwable) {}
            FableLogger.info("Fable shutting down");
        }
        finally {
            super.stop(context);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }
}

