/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;

public class DbDevImportInfo {
    public String name = null;
    public String ior = null;
    public String version = null;
    public boolean exported;
    public int pid = 0;
    public String server = "unknown";
    public boolean is_taco = false;

    public DbDevImportInfo() {
    }

    public DbDevImportInfo(DevVarLongStringArray devVarLongStringArray) {
        this.name = new String(devVarLongStringArray.svalue[0]);
        this.ior = new String(devVarLongStringArray.svalue[1]);
        this.version = new String(devVarLongStringArray.svalue[2]);
        boolean bl = this.exported = devVarLongStringArray.lvalue[0] == 1;
        if (devVarLongStringArray.lvalue.length > 1) {
            this.pid = devVarLongStringArray.lvalue[1];
        }
        if (devVarLongStringArray.svalue.length > 3) {
            this.server = new String(devVarLongStringArray.svalue[3]);
        }
        this.is_taco = this.ior.startsWith("rpc:");
    }

    public String toString() {
        String string;
        try {
            IORdump iORdump = new IORdump(this.name, this.ior);
            string = iORdump.toString();
            string = string + "\nServer:          " + this.server;
            if (this.pid != 0) {
                string = string + "\nServer PID:      " + this.pid;
            }
            string = string + "\nExported:        " + this.exported;
        }
        catch (DevFailed devFailed) {
            StringBuffer stringBuffer = new StringBuffer(devFailed.toString() + ":\n");
            for (int i = 0; i < devFailed.errors.length; ++i) {
                stringBuffer.append(devFailed.errors[i].reason + " from " + devFailed.errors[i].origin + "\n");
                stringBuffer.append(devFailed.errors[i].desc + "\n");
                if (i >= devFailed.errors.length - 1) continue;
                stringBuffer.append("-------------------------------------------------------------\n");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            Database database = ApiUtil.get_db_obj();
            DbDevImportInfo dbDevImportInfo = database.import_device(string);
            System.out.println(dbDevImportInfo);
        }
        catch (DevFailed devFailed) {
            if (stringArray.length < 2 || !stringArray[1].equals("-no_exception")) {
                Except.print_exception(devFailed);
            }
            System.exit(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Device name ?");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

