/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import org.jmol.api.JmolViewer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.openscience.jmol.app.HelpDialog;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;

abstract class WebPanel
extends JPanel
implements ActionListener {
    protected String templateName;
    protected String listLabel;
    protected String infoFile;
    protected String appletInfoDivs;
    protected String htmlAppletTemplate;
    protected String appletTemplateName;
    protected String templateImage;
    protected boolean useAppletJS;
    protected JSpinner appletSizeSpinnerW;
    protected JSpinner appletSizeSpinnerH;
    protected JSpinner appletSizeSpinnerP;
    private JScrollPane editorScrollPane;
    private JButton saveButton;
    private JButton helpButton;
    private JButton addInstanceButton;
    private JButton deleteInstanceButton;
    private JButton showInstanceButton;
    private JTextField remoteAppletPath;
    private JTextField localAppletPath;
    private JTextField pageAuthorName;
    private JTextField webPageTitle;
    private JFileChooser fc;
    private JList instanceList;
    private JmolViewer viewer;
    private int panelIndex;
    private WebPanel[] webPanels;

    abstract String getAppletDefs(int var1, String var2, StringBuffer var3, JmolInstance var4);

    abstract String fixHtml(String var1);

    abstract JPanel appletParamPanel();

    protected WebPanel(JmolViewer jmolViewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        this.viewer = jmolViewer;
        this.fc = jFileChooser;
        this.webPanels = webPanelArray;
        this.panelIndex = n;
        this.remoteAppletPath = new JTextField(20);
        this.remoteAppletPath.addActionListener(this);
        this.remoteAppletPath.setText(WebExport.getAppletPath(true));
        this.localAppletPath = new JTextField(20);
        this.localAppletPath.addActionListener(this);
        this.localAppletPath.setText(WebExport.getAppletPath(false));
        this.pageAuthorName = new JTextField(20);
        this.pageAuthorName.addActionListener(this);
        this.pageAuthorName.setText(WebExport.getPageAuthorName());
        this.webPageTitle = new JTextField(20);
        this.webPageTitle.addActionListener(this);
        this.webPageTitle.setText("A web page containing Jmol applets");
    }

    JPanel getPanel(int n, int n2) {
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(1);
        this.instanceList.setTransferHandler(new ArrayListTransferHandler(this));
        this.instanceList.setCellRenderer(new InstanceCellRenderer());
        this.instanceList.setDragEnabled(true);
        this.instanceList.setPreferredSize(new Dimension(350, 200));
        JScrollPane jScrollPane = new JScrollPane(this.instanceList);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(this.listLabel), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)new JLabel("double-click and drag to reorder"), "South");
        this.addInstanceButton = new JButton("Add Present Jmol State as Instance...");
        this.addInstanceButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(350, 50));
        this.showInstanceButton = new JButton("Show Selected");
        this.showInstanceButton.addActionListener(this);
        this.deleteInstanceButton = new JButton("Delete Selected");
        this.deleteInstanceButton.addActionListener(this);
        jPanel2.add(this.showInstanceButton);
        jPanel2.add(this.deleteInstanceButton);
        JPanel jPanel3 = this.appletParamPanel();
        jPanel3.setMaximumSize(new Dimension(350, 70));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.addInstanceButton);
        jPanel4.setSize(300, 70);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel2, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setMinimumSize(new Dimension(350, 350));
        jPanel7.setMaximumSize(new Dimension(350, 1000));
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel6, "Center");
        jPanel7.setBorder(BorderFactory.createTitledBorder("Jmol Instances:"));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        JPanel jPanel9 = this.getLeftPanel(n, n2);
        jPanel9.setMaximumSize(new Dimension(350, 1000));
        jPanel8.add((Component)jPanel9, "Center");
        jPanel8.add((Component)jPanel7, "East");
        this.enableButtons(this.instanceList);
        return jPanel8;
    }

    private JPanel getLeftPanel(int n, int n2) {
        this.helpButton = new JButton("Help/Instructions");
        this.helpButton.addActionListener(this);
        URL uRL = WebExport.getResource(this, this.templateImage);
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, "Cartoon of Page");
        } else {
            System.err.println("Error Loading Page Cartoon Image " + this.templateImage);
        }
        JLabel jLabel = new JLabel(imageIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Cartoon of Page:"));
        jPanel.add(jLabel);
        this.saveButton = new JButton("Save HTML as...");
        this.saveButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.saveButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Relative server path to jar files:"));
        jPanel3.add((Component)this.remoteAppletPath, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Relative local path to jar files:"));
        jPanel4.add((Component)this.localAppletPath, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Author (your name):"));
        jPanel5.add((Component)this.pageAuthorName, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder("Browser window title for this web page:"));
        jPanel6.add((Component)this.webPageTitle, "North");
        jPanel6.add((Component)jPanel2, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel4, "South");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jPanel7, "North");
        jPanel8.add((Component)jPanel5, "Center");
        jPanel8.add((Component)jPanel6, "South");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.helpButton, "North");
        jPanel9.add((Component)jPanel, "Center");
        jPanel9.add((Component)jPanel8, "South");
        return jPanel9;
    }

    int getInfoWidth() {
        return this.editorScrollPane.getWidth();
    }

    int getInfoHeight() {
        return this.editorScrollPane.getHeight();
    }

    private String getResourceString(String string) throws IOException {
        Object object;
        URL uRL = WebExport.getResource(this, string);
        if (uRL == null) {
            throw new FileNotFoundException("Error loading resource " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            object = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            LogPanel.log(exception.getMessage());
        }
        object = stringBuffer.toString();
        return object;
    }

    private void writeFile(String string, String string2) {
        this.viewer.createImage(string, string2, Integer.MIN_VALUE, 0, 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.remoteAppletPath) {
            String string = this.remoteAppletPath.getText();
            WebExport.setAppletPath(string, true);
            return;
        }
        if (actionEvent.getSource() == this.localAppletPath) {
            String string = this.localAppletPath.getText();
            WebExport.setAppletPath(string, false);
            return;
        }
        if (actionEvent.getSource() == this.addInstanceButton) {
            JmolInstance jmolInstance;
            String string = this.instanceList.getSelectedIndices().length != 1 ? "" : this.getInstanceName(-1);
            String string2 = JOptionPane.showInputDialog("Give the occurance of Jmol a name:", (Object)string);
            if (string2 == null) {
                return;
            }
            String string3 = this.viewer.getStateInfo();
            if (string3 == null) {
                LogPanel.log("Error trying to get Jmol State within pop_in_Jmol.");
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int n = 300;
            int n2 = 300;
            if (this.appletSizeSpinnerH != null) {
                n = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
                n2 = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            }
            if ((jmolInstance = new JmolInstance(this.viewer, string2, string3, n, n2)) == null) {
                LogPanel.log("Error creating new instance containing script(s) and image.");
            }
            int n3 = this.instanceList.getModel().getSize();
            while (--n3 >= 0 && !this.getInstanceName(n3).equals(jmolInstance.name)) {
            }
            if (n3 < 0) {
                n3 = defaultListModel.getSize();
                defaultListModel.addElement(jmolInstance);
                LogPanel.log("added Instance " + jmolInstance.name);
            } else {
                defaultListModel.setElementAt(jmolInstance, n3);
                LogPanel.log("updated Instance " + jmolInstance.name);
            }
            this.instanceList.setSelectedIndex(n3);
            this.syncLists();
            return;
        }
        if (actionEvent.getSource() == this.deleteInstanceButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int[] nArray = this.instanceList.getSelectedIndices();
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                defaultListModel.remove(nArray[i] - n++);
            }
            this.syncLists();
            return;
        }
        if (actionEvent.getSource() == this.showInstanceButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int[] nArray = this.instanceList.getSelectedIndices();
            if (nArray.length != 1) {
                return;
            }
            JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[0]);
            this.viewer.evalStringQuiet(")" + jmolInstance.script);
            return;
        }
        if (actionEvent.getSource() == this.saveButton) {
            this.fc.setDialogTitle("Save file as (please do not use an extension):");
            int n = this.fc.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = this.fc.getSelectedFile();
            boolean bl = true;
            try {
                String string = this.remoteAppletPath.getText();
                WebExport.setAppletPath(string, true);
                string = this.localAppletPath.getText();
                WebExport.setAppletPath(string, false);
                String string4 = this.pageAuthorName.getText();
                WebExport.setWebPageAuthor(string4);
                bl = this.fileWriter(file, this.instanceList);
            }
            catch (IOException iOException) {
                LogPanel.log(iOException.getMessage());
            }
            if (!bl) {
                LogPanel.log("Call to FileWriter unsuccessful.");
            }
        }
        if (actionEvent.getSource() == this.helpButton) {
            HelpDialog helpDialog = new HelpDialog(WebExport.getFrame(), WebExport.getResource(this, this.infoFile));
            helpDialog.setVisible(true);
            helpDialog.setDefaultCloseOperation(2);
        }
    }

    String getInstanceName(int n) {
        JmolInstance jmolInstance;
        if (n < 0) {
            n = this.instanceList.getSelectedIndex();
        }
        return (jmolInstance = (JmolInstance)this.instanceList.getModel().getElementAt(n)) == null ? "" : jmolInstance.name;
    }

    boolean fileWriter(File file, JList jList) throws IOException {
        String string;
        String string2;
        this.useAppletJS = JmolViewer.checkOption(this.viewer, "webMakerCreateJS");
        String string3 = file.getPath();
        String string4 = file.getName();
        String string5 = null;
        if (string4.indexOf(".htm") > 0) {
            string5 = string4;
            string3 = file.getParent();
            file = new File(string3);
            string4 = file.getName();
        } else {
            string5 = string4 + ".html";
        }
        string3 = string3.replace('\\', '/');
        boolean bl = file.exists() && file.isDirectory() || file.mkdir();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        LogPanel.log("");
        if (bl) {
            Object object;
            LogPanel.log("Using directory " + string3);
            LogPanel.log("  adding JmolPopIn.js");
            this.writeFile(string3 + "/JmolPopIn.js", this.getResourceString("JmolPopIn.js"));
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                object = (JmolInstance)defaultListModel.getElementAt(i);
                String string6 = ((JmolInstance)object).javaname;
                String string7 = ((JmolInstance)object).script;
                LogPanel.log("  ...jmolApplet" + i);
                LogPanel.log("      ...adding " + string6 + ".png");
                ((JmolInstance)object).movepict(string3);
                String string8 = "";
                string8 = string8 + WebPanel.addFileList(string7, "/*file*/");
                string8 = string8 + WebPanel.addFileList(string7, "FILE0=");
                string8 = string8 + WebPanel.addFileList(string7, "FILE1=");
                if (this.localAppletPath.getText().equals(".") || this.remoteAppletPath.getText().equals(".")) {
                    string8 = string8 + "Jmol.js\nJmolApplet.jar";
                }
                String[] stringArray = TextFormat.split(string8, '\n');
                String string9 = "";
                for (int j = 0; j < stringArray.length; ++j) {
                    string9 = WebPanel.copyBinaryFile(stringArray[j], string3, string9);
                }
                string7 = WebPanel.localizeFileReferences(string7, stringArray);
                LogPanel.log("      ...adding " + string6 + ".spt");
                this.writeFile(string3 + "/" + string6 + ".spt", string7);
            }
            string2 = this.getResourceString(this.templateName);
            string2 = this.fixHtml(string2);
            this.appletInfoDivs = "";
            object = new StringBuffer();
            if (!this.useAppletJS) {
                this.htmlAppletTemplate = this.getResourceString(this.appletTemplateName);
            }
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                string2 = this.getAppletDefs(i, string2, (StringBuffer)object, (JmolInstance)defaultListModel.getElementAt(i));
            }
            string2 = TextFormat.simpleReplace(string2, "@AUTHOR@", this.pageAuthorName.getText());
            string2 = TextFormat.simpleReplace(string2, "@TITLE@", this.webPageTitle.getText());
            string2 = TextFormat.simpleReplace(string2, "@REMOTEAPPLETPATH@", this.remoteAppletPath.getText());
            string2 = TextFormat.simpleReplace(string2, "@LOCALAPPLETPATH@", this.localAppletPath.getText());
            string2 = TextFormat.simpleReplace(string2, "@DATADIRNAME@", string4);
            if (this.appletInfoDivs.length() > 0) {
                this.appletInfoDivs = "\n<div style='display:none'>\n" + this.appletInfoDivs + "\n</div>\n";
            }
            string = ((StringBuffer)object).toString();
            if (this.useAppletJS) {
                string = "<script type='text/javascript'>\n" + string + "\n</script>";
            }
        } else {
            IOException iOException = new IOException("Error creating directory: " + string3);
            throw iOException;
        }
        string2 = TextFormat.simpleReplace(string2, "@APPLETINFO@", this.appletInfoDivs);
        string2 = TextFormat.simpleReplace(string2, "@APPLETDEFS@", string);
        string2 = TextFormat.simpleReplace(string2, "@CREATIONDATA@", WebExport.TimeStamp_WebLink());
        string2 = TextFormat.simpleReplace(string2, "@AUTHORDATA@", "Based on template by A. Herr&aacute;ez as modified by J. Gutow");
        string2 = TextFormat.simpleReplace(string2, "@LOGDATA@", "<pre>\n" + LogPanel.getText() + "\n</pre>\n");
        LogPanel.log("      ...creating " + string5);
        this.writeFile(string3 + "/" + string5, string2);
        LogPanel.log("");
        return true;
    }

    private static String addFileList(String string, String string2) {
        String string3 = "";
        int n = -1;
        while ((n = string.indexOf(string2, n + 1)) >= 0) {
            string3 = string3 + Parser.getNextQuotedString(string, n) + "\n";
        }
        return string3;
    }

    private static String copyBinaryFile(String string, String string2, String string3) {
        String string4;
        String string5 = string.substring(string.lastIndexOf(47) + 1);
        int n = string5.indexOf("|");
        if (n >= 0) {
            string5 = string5.substring(0, n);
        }
        if (string3.indexOf(string4 = ";" + string5 + ";") >= 0) {
            return string3;
        }
        string3 = string3 + string4;
        string5 = string2 + "/" + string5;
        try {
            LogPanel.log("      ...copying " + string + " to " + string5);
            byte[] byArray = WebPanel.getFileAsBytes(string);
            if (byArray == null) {
                LogPanel.log("Could not find or open " + string);
            } else {
                WebPanel.writeFileBytes(string5, byArray);
            }
        }
        catch (Exception exception) {
            LogPanel.log(exception.getMessage());
        }
        return string3;
    }

    private static byte[] getFileAsBytes(String string) throws IOException {
        int n = 0;
        int n2 = 0;
        Object object = FileManager.getInputStream(string, false, null, null, "");
        if (object instanceof String) {
            LogPanel.log((String)object);
            return null;
        }
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }

    private static void writeFileBytes(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LogPanel.log(iOException.getMessage());
        }
    }

    private static String localizeFileReferences(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = string2.substring(string2.lastIndexOf(47) + 1);
            if (string3.equals(string2)) continue;
            string = TextFormat.simpleReplace(string, "\"" + string2 + "\"", "\"" + string3 + "\"");
        }
        return string;
    }

    void syncLists() {
        JList jList = this.webPanels[1 - this.panelIndex].instanceList;
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)jList.getModel();
        defaultListModel2.clear();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        jList.setSelectedIndices(new int[0]);
        this.enableButtons(this.instanceList);
        this.webPanels[1 - this.panelIndex].enableButtons(jList);
    }

    void enableButtons(JList jList) {
        int n = jList.getSelectedIndices().length;
        int n2 = jList.getModel().getSize();
        this.saveButton.setEnabled(n2 > 0);
        this.deleteInstanceButton.setEnabled(n > 0);
        this.showInstanceButton.setEnabled(n == 1);
    }

    class InstanceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        InstanceCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(" " + ((JmolInstance)object).name);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            WebPanel.this.enableButtons(jList);
            return this;
        }
    }
}

