/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jmol.util.Logger;

public class FileDropper
implements DropTargetListener {
    private String fd_oldFileName = "";
    private PropertyChangeSupport fd_propSupport = new PropertyChangeSupport(this);
    public static final String FD_PROPERTY_FILENAME = "filename";
    public static final String FD_PROPERTY_INLINE = "inline";

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Logger.debug("DropOver detected...");
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Logger.debug("DropEnter detected...");
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        Logger.debug("DropExit detected...");
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Logger.debug("Drop detected...");
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDropEvent.acceptDrop(3);
            Object object = null;
            try {
                object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.error(null, unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.error(null, iOException);
            }
            if (object != null && object instanceof List) {
                List list = (List)object;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    File file = (File)list.get(i);
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_FILENAME, this.fd_oldFileName, file.getAbsolutePath());
                    this.fd_propSupport.firePropertyChange(propertyChangeEvent);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            }
        } else {
            Logger.debug("browsing supported flavours to find something useful...");
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (dataFlavorArray != null && dataFlavorArray.length > 0) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    DataFlavor dataFlavor = dataFlavorArray[i];
                    if (Logger.debugging) {
                        Logger.debug("df " + i + " flavor " + dataFlavor);
                        Logger.debug("  class: " + dataFlavor.getRepresentationClass().getName());
                        Logger.debug("  mime : " + dataFlavor.getMimeType());
                    }
                    if (dataFlavor.getMimeType().startsWith("text/uri-list") && dataFlavor.getRepresentationClass().getName().equals("java.lang.String")) {
                        dropTargetDropEvent.acceptDrop(3);
                        Object object = null;
                        try {
                            object = transferable.getTransferData(dataFlavor);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            Logger.error(null, unsupportedFlavorException);
                        }
                        catch (IOException iOException) {
                            Logger.error(null, iOException);
                        }
                        if (object != null && object instanceof String) {
                            if (Logger.debugging) {
                                Logger.debug("  String: " + object.toString());
                            }
                            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_FILENAME, this.fd_oldFileName, object.toString());
                            this.fd_propSupport.firePropertyChange(propertyChangeEvent);
                            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        }
                        return;
                    }
                    if (!dataFlavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) continue;
                    dropTargetDropEvent.acceptDrop(3);
                    Object object = null;
                    try {
                        object = transferable.getTransferData(dataFlavorArray[i]);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Logger.error(null, unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        Logger.error(null, iOException);
                    }
                    if (object != null && object instanceof String) {
                        String string = (String)object;
                        if (Logger.debugging) {
                            Logger.debug("  String: " + string);
                        }
                        if (string.startsWith("file:/")) {
                            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_FILENAME, this.fd_oldFileName, string);
                            this.fd_propSupport.firePropertyChange(propertyChangeEvent);
                        } else {
                            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_INLINE, this.fd_oldFileName, string);
                            this.fd_propSupport.firePropertyChange(propertyChangeEvent);
                        }
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    }
                    return;
                }
            }
            dropTargetDropEvent.rejectDrop();
        }
    }
}

