/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.web.Base64;
import org.acplt.oncrpc.web.HttpClientConnection;

public class XdrHttpDecodingStream
extends XdrDecodingStream {
    private HttpClientConnection httpClient;
    private byte[] buffer;
    private int bufferSize;
    private byte[] asciiBuffer;
    private int asciiBufferSize;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrHttpDecodingStream(HttpClientConnection httpClientConnection) {
        this.httpClient = httpClientConnection;
        int n = 100;
        int n2 = n * 48;
        int n3 = n * 66;
        this.buffer = new byte[n2];
        this.bufferSize = n2;
        this.asciiBuffer = new byte[n3];
        this.asciiBufferSize = n3;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public InetAddress getSenderAddress() {
        return null;
    }

    public int getSenderPort() {
        return 0;
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.httpClient.beginDecoding();
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void endDecoding() throws OncRpcException, IOException {
        try {
            this.httpClient.endDecoding();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void close() throws OncRpcException, IOException {
        this.httpClient = null;
        this.buffer = null;
    }

    private void fill() throws OncRpcException, IOException {
        int n;
        int n2;
        try {
            n2 = this.httpClient.getRemainingContentLength();
            n = n2 < 0 ? this.httpClient.readContentBytes(this.asciiBuffer, 0, this.asciiBufferSize) : this.httpClient.readContentBytes(this.asciiBuffer, 0, n2);
        }
        catch (ProtocolException protocolException) {
            throw new OncRpcException(43);
        }
        n2 = 0;
        int n3 = 0;
        while (n > 0) {
            int n4 = n >= 64 ? 64 : n - 2;
            n2 += Base64.decode(this.asciiBuffer, n3, n4, this.buffer, n2);
            n3 += n4 + 2;
            n -= n4 + 2;
        }
        this.bufferIndex = 0;
        this.bufferHighmark = n2 - 4;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int n = this.buffer[this.bufferIndex++] & 0xFF;
        n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return n;
    }

    public byte[] xdrDecodeOpaque(int n) throws OncRpcException, IOException {
        int n2 = 4 - (n & 3) & 3;
        int n3 = 0;
        byte[] byArray = new byte[n];
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n > 0) {
            int n4 = this.bufferHighmark - this.bufferIndex + 4;
            if (n4 >= n) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n3, n);
                this.bufferIndex += n;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n3, n4);
            this.bufferIndex += n4;
            n3 += n4;
            n -= n4;
            this.fill();
        }
        this.bufferIndex += n2;
        return byArray;
    }

    public void xdrDecodeOpaque(byte[] byArray, int n, int n2) throws OncRpcException, IOException {
        int n3 = 4 - (n2 & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n2 > 0) {
            int n4 = this.bufferHighmark - this.bufferIndex + 4;
            if (n4 >= n2) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n, n2);
                this.bufferIndex += n2;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n, n4);
            this.bufferIndex += n4;
            n += n4;
            n2 -= n4;
            this.fill();
        }
        this.bufferIndex += n3;
    }
}

