/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUninstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UninstallOperation
extends FeatureOperation
implements IUninstallFeatureOperation {
    public UninstallOperation(IConfiguredSite site, IFeature feature) {
        super(site, feature);
    }

    public void setTargetSite(IConfiguredSite targetSite) {
        this.targetSite = targetSite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        if (this.targetSite == null) {
            this.targetSite = UpdateUtils.getConfigSite(this.feature, SiteManager.getLocalSite().getCurrentConfiguration());
        }
        boolean restartNeeded = false;
        if (this.targetSite != null) {
            if (this.targetSite.isConfigured(this.feature)) {
                IStatus status = OperationsManager.getValidator().validatePendingUnconfig(this.feature);
                if (status != null && status.getCode() == 4) {
                    throw new CoreException(status);
                }
                if (!UninstallOperation.unconfigure(this.feature, this.targetSite)) throw Utilities.newCoreException(NLS.bind((String)Messages.OperationsManager_error_uninstall, (Object[])new String[]{this.feature.getVersionedIdentifier().toString()}), null);
                restartNeeded = true;
            }
        } else {
            String message = NLS.bind((String)Messages.OperationsManager_error_uninstall, (Object[])new String[]{this.feature.getLabel()});
            Status status = new Status(4, UpdateUtils.getPluginId(), 0, message, null);
            throw new CoreException((IStatus)status);
        }
        this.targetSite.remove(this.feature, pm);
        this.markProcessed();
        if (listener != null) {
            listener.afterExecute(this, null);
        }
        restartNeeded = SiteManager.getLocalSite().save() && restartNeeded;
        OperationsManager.fireObjectChanged(this.feature, "uninstall");
        return restartNeeded;
    }
}

