/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.database.DerbyDatabase;
import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.internal.GrainSpotterEvent;
import fable.grainspotter.internal.GrainSpotterListener;
import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Scanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;

public class LogFile {
    private String fid = "-1";
    private File logFile = null;
    private GrainSyntaxModel grains;
    private GrainSyntaxModel currentGrain;
    private ListenerList listenerList = new ListenerList();
    public String LOG_FILE_PARSED = "Log File Parsed";
    private int nLines = 0;
    private int nGrain = 0;
    private int grainLine = 0;
    private Job parsingJob;
    private String name;
    private boolean writeToConsole;
    SQLException lastInsertException;
    int nInsertExceptions;
    private boolean logFileRead;

    public LogFile(String fileName, boolean writeToConsole) {
        this.logFile = new File(fileName);
        this.name = fileName;
        this.grains = new GrainSyntaxModel();
        this.writeToConsole = writeToConsole;
    }

    public LogFile(String fileName) {
        this(fileName, true);
    }

    public void addGrainSpotterListener(GrainSpotterListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeGrainSpotterListener(GrainSpotterListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void removeAllGrainSpotterListeners() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            this.listenerList.remove(listener);
            ++n2;
        }
    }

    protected void fireLogFileParsedEvent() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof GrainSpotterListener) {
                GrainSpotterEvent ev = new GrainSpotterEvent(this, this.LOG_FILE_PARSED, null, this.logFile);
                ((GrainSpotterListener)listener).propertyChange(ev);
            }
            ++n2;
        }
    }

    public void finish() {
        if (this.listenerList != null) {
            this.removeAllGrainSpotterListeners();
        }
        this.listenerList = null;
    }

    public void parseFile() {
        this.logFileRead = false;
        try {
            Job job = this.getParsingJob();
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IStatus status = event.getResult();
                            if (status.isOK()) {
                                LogFile.this.logFileRead = true;
                                LogFile.this.fireLogFileParsedEvent();
                            } else {
                                FableUtils.errMsg((Object)this, (String)"Error parsing file");
                            }
                        }
                    });
                }
            });
        }
        catch (GrainSpotterException ex) {
            String msg = "Cannot load grainspotter output log file " + this.getFileName();
            FableUtils.excMsg((Object)this, (String)msg, (Throwable)ex);
        }
    }

    private void initJob() throws GrainSpotterException {
        this.parsingJob = new Job("Parsing file " + this.logFile.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(LogFile.this.logFile)));
                    if (monitor.isCanceled()) {
                        reader.close();
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask("Reading " + LogFile.this.logFile.getName(), -1);
                    if (!LogFile.this.readLines(reader, monitor)) {
                        reader.close();
                        return Status.CANCEL_STATUS;
                    }
                    if (LogFile.this.writeToConsole && LogFile.this.grains != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayIn("For all grains, found " + LogFile.this.grains.getGvecsMeasured() + " g-vectors measured.");
                            }
                        });
                    }
                    monitor.done();
                }
                catch (IOException ex) {
                    FableLogger.error((Object)("Error parsing GrainSpotter log file: " + LogFile.this.logFile.getName() + ": " + ex.getMessage()));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.parsingJob.setUser(true);
    }

    boolean readLines(BufferedReader reader, IProgressMonitor monitor) throws IOException {
        String line;
        this.lastInsertException = null;
        this.nInsertExceptions = 0;
        int gve_expected = 0;
        int gve_measured = 0;
        double ia_mean = 0.0;
        double u11 = 0.0;
        double u12 = 0.0;
        double u13 = 0.0;
        double u21 = 0.0;
        double u22 = 0.0;
        double u23 = 0.0;
        double u31 = 0.0;
        double u32 = 0.0;
        double u33 = 0.0;
        int[] gVectors = new int[10000];
        int[] peakId = new int[10000];
        int[] h = new int[10000];
        int[] k = new int[10000];
        int[] l = new int[10000];
        double[] h_pred = new double[10000];
        double[] k_pred = new double[10000];
        double[] l_pred = new double[10000];
        double[] dh = new double[10000];
        double[] dl = new double[10000];
        double[] dk = new double[10000];
        double[] tth_meas = new double[10000];
        double[] tth_pred = new double[10000];
        double[] dtth = new double[10000];
        double[] omega_meas = new double[10000];
        double[] omega_pred = new double[10000];
        double[] domega = new double[10000];
        double[] eta_meas = new double[10000];
        double[] eta_pred = new double[10000];
        double[] deta = new double[10000];
        double[] ia = new double[10000];
        GrainUMatrixModel umatrix = null;
        GrainInfoModel infosModel = null;
        if (Activator.database != null) {
            this.fid = Integer.toString(this.getNextFid());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String values = " (" + this.fid + "," + " '" + this.logFile.getPath() + "', '" + now + "')";
            this.insert("files", values);
        }
        boolean foundGrain = false;
        while ((line = reader.readLine()) != null) {
            if (monitor.isCanceled()) {
                return false;
            }
            ++this.nLines;
            monitor.worked(1);
            String[] outTokens = line.split("\\s+");
            if (this.nLines != 1 && this.nLines <= 23) continue;
            if (line.length() > 0 || this.nLines - this.grainLine < 17) {
                if (foundGrain) {
                    try {
                        if (this.nLines - this.grainLine >= 17) {
                            Scanner scanner = new Scanner(line);
                            scanner.useDelimiter("\\s+");
                            scanner.useLocale(Locale.ENGLISH);
                            int index = this.nLines - this.grainLine - 17;
                            if (scanner.hasNext()) {
                                gVectors[index] = scanner.nextInt();
                                peakId[index] = scanner.nextInt();
                                h[index] = scanner.nextInt();
                                k[index] = scanner.nextInt();
                                l[index] = scanner.nextInt();
                                h_pred[index] = scanner.nextDouble();
                                k_pred[index] = scanner.nextDouble();
                                l_pred[index] = scanner.nextDouble();
                                dh[index] = scanner.nextDouble();
                                dk[index] = scanner.nextDouble();
                                dl[index] = scanner.nextDouble();
                                tth_meas[index] = scanner.nextDouble();
                                tth_pred[index] = scanner.nextDouble();
                                dtth[index] = scanner.nextDouble();
                                omega_meas[index] = scanner.nextDouble();
                                omega_pred[index] = scanner.nextDouble();
                                domega[index] = scanner.nextDouble();
                                eta_meas[index] = scanner.nextDouble();
                                eta_pred[index] = scanner.nextDouble();
                                deta[index] = scanner.nextDouble();
                                ia[index] = scanner.nextDouble();
                            }
                            scanner.close();
                        } else if (this.nLines - this.grainLine == 1) {
                            gve_expected = Integer.valueOf(outTokens[1]);
                            gve_measured = Integer.valueOf(outTokens[2]);
                            this.currentGrain.add(new GrainInfoModel("gve expected ", outTokens[1]));
                            this.grains.addGvecsExpected(outTokens[1]);
                            this.currentGrain.add(new GrainInfoModel("gve measured ", outTokens[2]));
                            this.grains.addGvecsMeasured(outTokens[2]);
                            this.currentGrain.add(new GrainInfoModel("measured once ", outTokens[3]));
                            this.currentGrain.add(new GrainInfoModel("measured more than once ", outTokens[4]));
                        } else if (this.nLines - this.grainLine == 2) {
                            if (outTokens != null && outTokens.length >= 4) {
                                ia_mean = Double.valueOf(outTokens[1]);
                                this.currentGrain.add(new GrainInfoModel("Mean IA", outTokens[1]));
                                this.currentGrain.add(new GrainInfoModel("position_x", outTokens[2]));
                                this.currentGrain.add(new GrainInfoModel("position_y", outTokens[3]));
                                this.currentGrain.add(new GrainInfoModel("position_z", outTokens[4]));
                            }
                        } else if (this.nLines - this.grainLine == 3) {
                            u11 = Double.valueOf(outTokens[0]);
                            u12 = Double.valueOf(outTokens[1]);
                            u13 = Double.valueOf(outTokens[2]);
                            umatrix = new GrainUMatrixModel("U1", "U2", "U3");
                            this.currentGrain.add(umatrix);
                            umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                        } else if (this.nLines - this.grainLine == 4) {
                            u21 = Double.valueOf(outTokens[0]);
                            u22 = Double.valueOf(outTokens[1]);
                            u23 = Double.valueOf(outTokens[2]);
                            umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                        } else if (this.nLines - this.grainLine == 5) {
                            u31 = Double.valueOf(outTokens[0]);
                            u32 = Double.valueOf(outTokens[1]);
                            u33 = Double.valueOf(outTokens[2]);
                            umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                        } else if (this.nLines - this.grainLine == 7) {
                            umatrix = new GrainUBIMatrixModel("UBI1", "UBI2", "UBI3");
                            umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                            this.currentGrain.add(umatrix);
                        } else if (this.nLines - this.grainLine == 8) {
                            umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                        } else if (this.nLines - this.grainLine == 9) {
                            umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                        } else if (this.nLines - this.grainLine == 11) {
                            infosModel = new GrainInfoModel("orientation given as a Rodrigues vector");
                            this.currentGrain.add(infosModel);
                            infosModel.add(new GrainInfoModel("r1", outTokens[0]));
                            infosModel.add(new GrainInfoModel("r2", outTokens[1]));
                            infosModel.add(new GrainInfoModel("r3", outTokens[2]));
                        } else if (this.nLines - this.grainLine == 13) {
                            infosModel = new GrainInfoModel("orientation given as Euler angles");
                            this.currentGrain.add(infosModel);
                            infosModel.add(new GrainInfoModel("phi11", outTokens[0]));
                            infosModel.add(new GrainInfoModel("phi", outTokens[1]));
                            infosModel.add(new GrainInfoModel("phi2", outTokens[2]));
                        } else if (this.nLines - this.grainLine == 15) {
                            infosModel = new GrainInfoModel("orientation given as a quarternion");
                            this.currentGrain.add(infosModel);
                            infosModel.add(new GrainInfoModel("q0", outTokens[0]));
                            infosModel.add(new GrainInfoModel("qx", outTokens[1]));
                            infosModel.add(new GrainInfoModel("qy", outTokens[2]));
                            infosModel.add(new GrainInfoModel("qz", outTokens[3]));
                        }
                    }
                    catch (Exception exception) {}
                }
                if (!outTokens[0].equals("Grain")) continue;
                if (!foundGrain) {
                    this.grainLine = this.nLines;
                    ++this.nGrain;
                    this.currentGrain = new GrainSyntaxModel("" + this.nGrain);
                    this.grains.add(this.currentGrain);
                }
                foundGrain = true;
                continue;
            }
            if (!foundGrain) continue;
            foundGrain = false;
            if (this.writeToConsole) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FableMessageConsole.console.displayIn("grain " + LogFile.this.nGrain + " found " + (LogFile.this.nLines - LogFile.this.grainLine - 17) + " g-vectors");
                    }
                });
            }
            monitor.subTask("grain " + this.nGrain + " found " + (this.nLines - this.grainLine - 17) + " g-vectors");
            int[] gveIds = new int[this.nLines - this.grainLine - 17];
            infosModel = new GrainInfoModel("g-vectors");
            this.currentGrain.add(infosModel);
            int _i = 0;
            while (_i < gveIds.length) {
                GrainGvectorModel gvecModel = new GrainGvectorModel(gVectors[_i]);
                this.currentGrain.add(gvecModel);
                gveIds[_i] = gVectors[_i];
                GrainInfoModel gv = new GrainInfoModel("g-vector #" + (_i + 1));
                infosModel.add(gv);
                GrainInfoModel info_gvId = new GrainInfoModel("gvector_id", "" + gVectors[_i]);
                gv.add(info_gvId);
                gv.add(new GrainInfoModel("peak_id  ", "" + peakId[_i]));
                gv.add(new GrainInfoModel("h k l ", h[_i] + " " + k[_i] + " " + l[_i]));
                gv.add(new GrainInfoModel("h_pred k_pred l_pred ", h_pred[_i] + " " + k_pred[_i] + " " + l_pred[_i]));
                gv.add(new GrainInfoModel("dh dk dl ", dh[_i] + " " + dk[_i] + " " + dl[_i]));
                gv.add(new GrainInfoModel("tth_meas", "" + tth_meas[_i]));
                gv.add(new GrainInfoModel("tth_pred", "" + tth_pred[_i]));
                gv.add(new GrainInfoModel("dtth", "" + dtth[_i]));
                gv.add(new GrainInfoModel("omega_meas", "" + omega_meas[_i]));
                gv.add(new GrainInfoModel("omega_pred", "" + omega_pred[_i]));
                gv.add(new GrainInfoModel("domega", "" + domega[_i]));
                gv.add(new GrainInfoModel("eta_meas", "" + eta_meas[_i]));
                gv.add(new GrainInfoModel("eta_pred", "" + eta_pred[_i]));
                gv.add(new GrainInfoModel("deta", "" + deta[_i]));
                gv.add(new GrainInfoModel("ia", "" + ia[_i]));
                if (Activator.database != null) {
                    String values = " (" + this.fid + "," + this.nGrain + "," + gVectors[_i] + "," + h[_i] + "," + k[_i] + "," + l[_i] + "," + h_pred[_i] + "," + k_pred[_i] + "," + l_pred[_i] + "," + dh[_i] + "," + dk[_i] + "," + dl[_i] + "," + tth_meas[_i] + "," + tth_pred[_i] + "," + dtth[_i] + "," + omega_meas[_i] + "," + omega_pred[_i] + "," + domega[_i] + "," + eta_meas[_i] + "," + eta_pred[_i] + "," + deta[_i] + "," + ia[_i] + ")";
                    this.insert("grainfits", values);
                }
                ++_i;
            }
            if (Activator.database == null) continue;
            String values = " (" + this.fid + "," + this.nGrain + "," + gve_expected + "," + gve_measured + "," + ia_mean + "," + u11 + "," + u12 + "," + u13 + "," + u21 + "," + u22 + "," + u23 + "," + u31 + "," + u32 + "," + u33 + ")";
            this.insert("grains", values);
        }
        if (this.nInsertExceptions > 0) {
            String msg = "Encountered " + this.nInsertExceptions + " exceptions inserting values into the database for " + this.logFile.getName() + ".  Only the last exception was retained.";
            FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)this.lastInsertException);
        }
        reader.close();
        return true;
    }

    void insert(String table, String values) {
        DerbyDatabase database = Activator.database;
        if (database == null) {
            return;
        }
        try {
            database.insert(table, values);
        }
        catch (SQLException ex) {
            ++this.nInsertExceptions;
            this.lastInsertException = ex;
        }
    }

    public synchronized int getNextFid() {
        int maxVal = -1;
        DerbyDatabase database = Activator.database;
        if (database == null) {
            return maxVal;
        }
        Connection conn = DerbyDatabase.getConnection();
        if (database == null) {
            return maxVal;
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet results = stmt.executeQuery("select * from files");
            while (results.next()) {
                int iVal = results.getInt(1);
                if (iVal <= maxVal) continue;
                maxVal = iVal;
            }
            results.close();
            stmt.close();
        }
        catch (SQLException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Got exception getting next GrainSpotter FID", (Throwable)ex);
        }
        return ++maxVal;
    }

    public GrainSyntaxModel getGrains() {
        return this.grains;
    }

    public Job getParsingJob() throws GrainSpotterException {
        if (this.parsingJob == null) {
            this.initJob();
        }
        return this.parsingJob;
    }

    public String getFileName() {
        return this.name;
    }

    public boolean getLogFileRead() {
        return this.logFileRead;
    }

    public String getDatabaseID() {
        return this.fid;
    }
}

