/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.internal.ICrystalSymmetryVarKeys;
import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainSpotterInputEditor;
import fable.grainspotter.internal.GrainSpotterParametersDialog;
import fable.grainspotter.internal.IGrainSpotterHelp;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.InputFile;
import java.io.File;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class GrainSpotterInput
extends ScrolledComposite
implements IGrainSpotterHelp,
IPropertyChangeListener {
    private static final int COMBO_BOX_WIDTH = 50;
    private GrainSpotterInputEditor editor;
    private GrainSpotter grainSpotter;
    private InputFile inputFile;
    private Shell shell;
    private Display display;
    private Composite parent;
    private IMemento memento = null;
    private static String initialDirIni = null;
    private static String initialDirGve = null;
    private static String initialDirLog = null;
    private Spinner spaceGroupSpinner;
    private Combo spaceGroupSymbolCombo;
    private Text spaceSystemText;
    private Table dsRange;
    private Table tthRange;
    private Table etaRange;
    private Table omegaRange;
    private StringText txtFilegve;
    private StringText txtFileLog;
    private IntegerText cutsMinMeasurement;
    private FloatText cutsMinCompletenessText;
    private FloatText cutsMinUniqueness;
    private FloatText eulerStep;
    private FloatText minfracg;
    private IntegerText random;
    private Button fitPositionTrue;
    private Button fitPositionFalse;
    private FloatText sigmaTth;
    private FloatText sigmaEta;
    private FloatText sigmaOmega;
    private FloatText nsigma;
    private int spaceGroup = 1;
    private int spaceGroupSystem = 0;
    private static final int numColInGroup = 2;
    private static final int MAXROWS = 1;
    protected int activeColumn;
    private FloatText omegaDeltaText;
    private Group tthRangeGroup;
    private Group dsGroup;
    ImageDescriptor deleteDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/delete.gif");
    ImageDescriptor addDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/add.gif");
    private IntegerText hklRingsText;
    private Button chooseDSpacing;
    private Button chooseTthRange;
    private Button scanMode;
    private Button randomMode;
    private DropTarget dropTargetGveFile;
    private DropTarget dropTargetLogFile;

    public GrainSpotterInput(Composite parent, int style, GrainSpotterInputEditor editor) {
        super(parent, style | 0x200 | 0x100);
        this.editor = editor;
        this.grainSpotter = new GrainSpotter();
        this.grainSpotter.addPropertyChangeListener(this);
        this.setInputFile(editor.getInputFile());
        this.parent = parent;
        this.createContents();
    }

    void createContents() {
        this.shell = this.parent.getShell();
        this.display = this.parent.getDisplay();
        if (this.memento != null) {
            initialDirIni = this.memento.getString("initialDirIni");
            initialDirGve = this.memento.getString("initialDirGve");
            initialDirLog = this.memento.getString("initialDirLog");
        }
        GridLayout oneColGridLayout = new GridLayout();
        oneColGridLayout.numColumns = 1;
        oneColGridLayout.makeColumnsEqualWidth = true;
        GridLayout twoColGridLayout = new GridLayout();
        twoColGridLayout.numColumns = 2;
        twoColGridLayout.makeColumnsEqualWidth = true;
        GridLayout threeColGridLayout = new GridLayout();
        threeColGridLayout.numColumns = 3;
        threeColGridLayout.makeColumnsEqualWidth = true;
        GridLayout fourColGridLayout = new GridLayout();
        fourColGridLayout.numColumns = 4;
        fourColGridLayout.makeColumnsEqualWidth = false;
        GridLayout sixColGridLayout = new GridLayout();
        sixColGridLayout.numColumns = 6;
        sixColGridLayout.makeColumnsEqualWidth = true;
        this.parent.setLayout((Layout)oneColGridLayout);
        Composite container = new Composite((Composite)this, 16);
        container.setLayout((Layout)fourColGridLayout);
        container.setLayoutData((Object)new GridData(16384, 16, false, false));
        this.setContent((Control)container);
        this.setExpandVertical(true);
        this.setExpandHorizontal(true);
        this.createGroupFileSpecs(container);
        Composite composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.createGroupControls(composite);
        this.createGroupSpaceGroup(composite);
        this.createGroupSearchParameters(container);
        this.createGroupCuts(container);
        this.createGroupUncertainties(container);
        Group chooseBetween = new Group(container, 0);
        chooseBetween.setText("Resolution Range");
        chooseBetween.setLayout((Layout)new GridLayout(2, false));
        chooseBetween.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.chooseDSpacing = new Button((Composite)chooseBetween, 16);
        this.chooseDSpacing.setText("Use d-spacing Range");
        this.chooseDSpacing.setToolTipText("You can choose to specify either d-spacing ranges or tth ranges");
        this.chooseDSpacing.setSelection(true);
        this.chooseDSpacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.setEnableGroup((Composite)GrainSpotterInput.this.dsGroup, ((Button)e.widget).getSelection());
                GrainSpotterInput.this.setEnableGroup((Composite)GrainSpotterInput.this.tthRangeGroup, !((Button)e.widget).getSelection());
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.chooseTthRange = new Button((Composite)chooseBetween, 16);
        this.chooseTthRange.setText("Use Tth range");
        this.chooseTthRange.setToolTipText("You can choose to specify either d-spacing ranges or tth ranges");
        this.chooseTthRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.setEnableGroup((Composite)GrainSpotterInput.this.dsGroup, !((Button)e.widget).getSelection());
                GrainSpotterInput.this.setEnableGroup((Composite)GrainSpotterInput.this.tthRangeGroup, ((Button)e.widget).getSelection());
                GrainSpotterInput.this.setDirty(true);
            }
        });
        String[] columnsProperties = new String[]{"Minimum", "Maximum"};
        this.createGroupDsRange((Composite)chooseBetween, columnsProperties);
        this.createGroupTthRange((Composite)chooseBetween, columnsProperties);
        this.createGroupEtaRange(container, columnsProperties);
        this.createGroupOmegaRange(container, columnsProperties);
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDSpacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDSpacing.getSelection());
        this.setHelpContextToChildren(container);
        this.setMinSize(container.computeSize(-1, -1));
    }

    private void setHelpContextToChildren(Composite parent2) {
        Control[] children = parent2.getChildren();
        int i = 0;
        while (i < children.length) {
            IWorkbenchHelpSystem helpSystem;
            if (children[i] instanceof Group) {
                this.setHelpContextToChildren((Composite)((Group)children[i]));
            } else if (children[i] instanceof TypedText) {
                TypedText text = (TypedText)children[i];
                if (text.getTextField().getToolTipText() == null) {
                    text.getTextField().setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " on the text entry for more help.");
                } else {
                    text.getTextField().setToolTipText(String.valueOf(text.getTextField().getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " on the text entry for more help.");
                }
                IWorkbenchHelpSystem helpSystem2 = this.editor.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                helpSystem2.setHelp((Control)text.getTextField(), "fable.grainspotter.inifile");
            } else if (children[i] instanceof Text) {
                helpSystem = this.editor.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                helpSystem.setHelp((Control)((Text)children[i]), "fable.grainspotter.inifile");
                Text text = (Text)children[i];
                if (text.getToolTipText() == null) {
                    text.setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " on the text entry for more help.");
                } else {
                    text.setToolTipText(String.valueOf(text.getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " on the text entry for more help.");
                }
            } else if (children[i] instanceof Table) {
                helpSystem = this.editor.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                helpSystem.setHelp((Control)((Table)children[i]), "fable.grainspotter.inifile");
            }
            ++i;
        }
    }

    private void createGroupOmegaRange(Composite container, String[] columnsProperties) {
        Group omegaGroup = LookAndFeel.getGroup((Composite)container, (String)"Omegaspecs [-180/180 deg.]", (int)2, (int)1);
        GridData gdForOmega = new GridData(4, 4, true, false);
        omegaGroup.setLayoutData((Object)gdForOmega);
        omegaGroup.setToolTipText("The active interval for omega.");
        this.omegaDeltaText = new FloatText((Composite)omegaGroup, 4, "Delta");
        this.omegaDeltaText.setMaxValue(new Float(360.0).floatValue(), true);
        this.omegaDeltaText.setMinValue(new Float(0.0).floatValue(), false);
        this.omegaDeltaText.setToolTipText("Defines the omega step size used in the data collection");
        this.omegaDeltaText.set_isRequiredField(false);
        GridData deltaGridData = new GridData(4, 2, false, true, 2, 1);
        this.omegaDeltaText.setLayoutData((Object)deltaGridData);
        this.omegaRange = new Table((Composite)omegaGroup, 68352);
        this.omegaRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.omegaRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainSpotterInput.this.omegaRange.getColumnCount()) {
                    if (e.x <= (x += GrainSpotterInput.this.omegaRange.getColumn(i).getWidth())) {
                        GrainSpotterInput.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumnOmegaRange(columnsProperties);
        this.createRows(this.omegaRange, 1);
        this.createAddButtonOmegaRange((Composite)omegaGroup);
        this.createRemoveItemButtonOmegarange((Composite)omegaGroup);
        this.omegaRange.setToolTipText("omegarange:\n\nOnly values of omega in these ranges will be considered.  \nYou can set one or more ranges");
        this.triggerTableSelectionOmegaRange();
    }

    private void createGroupEtaRange(Composite container, String[] columnsProperties) {
        Group grp_EtatSpec = LookAndFeel.getGroup((Composite)container, (String)"Eta range [0-360 deg.]", (int)2, (int)1);
        grp_EtatSpec.setLayoutData((Object)new GridData(4, 4, true, false));
        grp_EtatSpec.setToolTipText("etarange:\n\nOnly values of eta in these ranges will be considered.  \nYou can set one or more ranges");
        this.etaRange = new Table((Composite)grp_EtatSpec, 68352);
        this.etaRange.setToolTipText("etarange:\n\nOnly values of eta in these ranges will be considered.  \nYou can set one or more ranges");
        this.etaRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.etaRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainSpotterInput.this.etaRange.getColumnCount()) {
                    if (e.x <= (x += GrainSpotterInput.this.etaRange.getColumn(i).getWidth())) {
                        GrainSpotterInput.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumnEtaRange(columnsProperties);
        this.createRows(this.etaRange, 1);
        this.createAddButtonEtaRange((Composite)grp_EtatSpec);
        this.createRemoveItemButtonEtaRange((Composite)grp_EtatSpec);
        ((GridData)this.etaRange.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.etaRange.getLayoutData()).verticalSpan = 2;
        ((GridData)this.etaRange.getLayoutData()).verticalAlignment = 4;
        this.triggerTableSelectionEtaRange();
    }

    public void setEnableGroup(Composite parent, boolean benable) {
        Control[] element = parent.getChildren();
        parent.setEnabled(benable);
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof Group) {
                    this.setEnableGroup((Composite)element[i], benable);
                } else if (benable) {
                    element[i].setBackground(this.display.getSystemColor(1));
                } else {
                    element[i].setBackground(this.display.getSystemColor(22));
                }
            } else {
                element[i].setEnabled(benable);
            }
            ++i;
        }
    }

    private void createGroupTthRange(Composite container, String[] columnsProperties) {
        this.tthRangeGroup = LookAndFeel.getGroup((Composite)container, (String)"Tth range [0-360 deg.]", (int)2, (int)1);
        this.tthRangeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tthRangeGroup.setToolTipText("tthrange:\n\nOnly values of tth in these ranges will be considered.  \nYou can set one or more ranges");
        this.tthRange = new Table((Composite)this.tthRangeGroup, 68352);
        this.tthRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.tthRange.setToolTipText("tthrange:\n\nOnly values of tth in these ranges will be considered.  \nYou can set one or more ranges");
        this.tthRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainSpotterInput.this.tthRange.getColumnCount()) {
                    if (e.x <= (x += GrainSpotterInput.this.tthRange.getColumn(i).getWidth())) {
                        GrainSpotterInput.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumntthRange(columnsProperties);
        this.createRows(this.tthRange, 1);
        this.createAddButtonTthrange((Composite)this.tthRangeGroup);
        this.createRemoveItemButtonTthRange((Composite)this.tthRangeGroup);
        this.triggerTableSelectionTthRange();
    }

    private void createGroupDsRange(Composite container, String[] columnsProperties) {
        this.dsGroup = LookAndFeel.getGroup((Composite)container, (String)"D-spacing [\u00c5]", (int)2, (int)1);
        GridData gdfords = new GridData(4, 4, true, false);
        this.dsGroup.setLayoutData((Object)gdfords);
        this.dsGroup.setToolTipText("dsrange:\n\nOnly values of d in these ranges will be considered.  \nYou can set one or more ranges");
        this.dsRange = new Table((Composite)this.dsGroup, 68352);
        this.dsRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.dsRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainSpotterInput.this.dsRange.getColumnCount()) {
                    if (e.x <= (x += GrainSpotterInput.this.dsRange.getColumn(i).getWidth())) {
                        GrainSpotterInput.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumnDsRange(columnsProperties);
        this.createRows(this.dsRange, 1);
        this.createAddButtonDsRange((Composite)this.dsGroup);
        this.createRemoveItemButtonDsRange((Composite)this.dsGroup);
        this.dsRange.setToolTipText("dsrange:\n\nOnly values of d in these ranges will be considered.  \nYou can set one or more ranges");
        this.triggerTableSelectionDsRange();
    }

    private void createGroupFileSpecs(Composite container) {
        Group grp_fileSpec = LookAndFeel.getGroup((Composite)container, (String)"File Specifications", (int)2, (int)3);
        grp_fileSpec.setToolTipText("filespecs [gvector_file log_file]:\n\nGrainSpotter requires two file inputs: the name of the \ng-vector (.gve) file and the the name of the log (.log) file \nfor the output.");
        new Label((Composite)grp_fileSpec, 0).setText("Gve file");
        this.txtFilegve = new StringText((Composite)grp_fileSpec, 0, "");
        this.txtFilegve.setToolTipText("Path and filename of the input .gve (from ImageD11).");
        this.txtFilegve.set_isRequiredField(true);
        this.txtFilegve.setLayoutData((Object)new GridData(4, 16, true, false));
        this.txtFilegve.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String filename = GrainSpotterInput.this.txtFilegve.getText();
                    File file = new File(filename);
                    GrainSpotterInput.this.loadGve(filename, file.getAbsolutePath());
                }
            }
        });
        this.dropTargetGveFile = new DropTarget((Control)this.txtFilegve.getTextField(), 17);
        this.dropTargetGveFile.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        this.dropTargetGveFile.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String fileName = (String)event.data;
                    GrainSpotterInput.this.txtFilegve.getTextField().setText(fileName);
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] fileNames = (String[])event.data;
                    GrainSpotterInput.this.txtFilegve.getTextField().setText(fileNames[0]);
                }
            }
        });
        Button button = new Button((Composite)grp_fileSpec, 8);
        button.setText("Browse");
        button.setToolTipText("Select or enter a .gve file.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(GrainSpotterInput.this.shell, 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
                fileDlg.setFilterPath(initialDirGve);
                fileDlg.setText("Select an existing .gve file or enter a new file name");
                String file = fileDlg.open();
                if (file != null) {
                    GrainSpotterInput.this.txtFilegve.set_Text(file);
                    GrainSpotterInput.this.loadGve(file, fileDlg.getFilterPath());
                    GrainSpotterInput.this.setDirty(true);
                }
            }
        });
        button = new Button((Composite)grp_fileSpec, 8);
        button.setText("Open");
        button.setToolTipText("Open the .gve file in an editor.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fileName = GrainSpotterInput.this.txtFilegve.getText();
                FableUtils.infoMsg((Object)((Object)this), (String)("Open " + fileName));
            }
        });
        new Label((Composite)grp_fileSpec, 0).setText("Log file");
        this.txtFileLog = new StringText((Composite)grp_fileSpec, 0, "");
        this.txtFileLog.setLayoutData((Object)new GridData(4, 16, false, false));
        this.txtFileLog.setToolTipText("Set the GrainSpotter .log file.  \nMust have a .log extension.");
        this.txtFileLog.set_isRequiredField(true);
        this.txtFileLog.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    File myFile = new File(GrainSpotterInput.this.txtFileLog.getText());
                    String path = "";
                    if (myFile != null) {
                        path = myFile.getPath();
                    }
                    GrainSpotterInput.this.setLogFile(GrainSpotterInput.this.txtFileLog.getText(), path);
                }
            }
        });
        this.txtFileLog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String file = GrainSpotterInput.this.txtFileLog.getText();
                File myFile = new File(file);
                String path = "";
                if (myFile != null) {
                    path = myFile.getPath();
                }
                GrainSpotterInput.this.setLogFile(file, path);
            }
        });
        this.dropTargetLogFile = new DropTarget((Control)this.txtFileLog.getTextField(), 17);
        this.dropTargetLogFile.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        this.dropTargetLogFile.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String fileName = (String)event.data;
                    GrainSpotterInput.this.txtFileLog.getTextField().setText(fileName);
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] fileNames = (String[])event.data;
                    GrainSpotterInput.this.txtFileLog.getTextField().setText(fileNames[0]);
                }
            }
        });
        Composite composite = new Composite((Composite)grp_fileSpec, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(3, 1).applyTo((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        button = new Button(composite, 8);
        button.setText("Browse");
        button.setToolTipText("Select or enter a GrainSpotter .log file");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(GrainSpotterInput.this.shell, 8192);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDlg.setFilterPath(initialDirLog);
                fileDlg.setText("Select an existing .log file or enter a new file name");
                String file = fileDlg.open();
                GrainSpotterInput.this.txtFileLog.set_Text(file);
                if (file != null) {
                    GrainSpotterInput.this.setLogFile(file, new File(file).getPath());
                    GrainSpotterInput.this.setDirty(true);
                }
            }
        });
        button = new Button(composite, 8);
        button.setText("Generate Name");
        button.setToolTipText("Generate a .log file name based on the input file name");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IEditorInput editorInput = null;
                IPath path = null;
                String newName = null;
                if (GrainSpotterInput.this.editor != null) {
                    editorInput = GrainSpotterInput.this.editor.getEditorInput();
                }
                if (editorInput != null) {
                    path = SWTUtils.getPath(editorInput);
                }
                if (path != null) {
                    File file = path.toFile();
                    String oldName = file.getAbsolutePath();
                    newName = FableUtils.changeFileExtension((String)oldName, (String)".log");
                    if (newName != null) {
                        GrainSpotterInput.this.txtFileLog.set_Text(newName);
                        GrainSpotterInput.this.setLogFile(newName, new File(newName).getPath());
                        GrainSpotterInput.this.setDirty(true);
                    } else {
                        FableUtils.errMsg((Object)((Object)this), (String)"Error generating .log file name");
                    }
                }
            }
        });
        button = new Button(composite, 8);
        button.setText("Run");
        button.setToolTipText("Run GrainSpotter.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.runGrainSpotter();
            }
        });
    }

    private void setLogFile(String file, String filePath) {
        initialDirLog = filePath;
        this.grainSpotter.setLogFilePath(initialDirLog);
        this.inputFile.setLogFilePath(initialDirLog);
        GrainSpotterInput.synchronizeInitialDirectories(initialDirLog);
        if (!file.endsWith(".log")) {
            file = String.valueOf(file) + ".log";
        }
    }

    private void loadGve(String file, String gveDirectory) {
        initialDirGve = gveDirectory;
        this.grainSpotter.setGveFilePath(initialDirGve);
        GrainSpotterInput.synchronizeInitialDirectories(initialDirGve);
        if (!file.endsWith(".gve")) {
            file = String.valueOf(file) + ".gve";
        }
        this.setDirty(true);
        this.inputFile.setGveFileName(file);
        this.grainSpotter.setGveFileName(file);
    }

    private void createGroupControls(Composite container) {
        Group group = LookAndFeel.getGroup((Composite)container, (String)"Controls", (int)2, (int)2);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        group.setToolTipText("Controls for GrainSpotter.");
        Button button = new Button((Composite)group, 8);
        button.setText("Run");
        button.setToolTipText("Run GrainSpotter.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.runGrainSpotter();
            }
        });
        button = new Button((Composite)group, 8);
        button.setText("Parameters Help...");
        button.setToolTipText("Show descriptions of GrainSpotter parameters.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterParametersDialog dialog = new GrainSpotterParametersDialog(GrainSpotterInput.this.shell);
                dialog.open();
            }
        });
    }

    private void createGroupSpaceGroup(Composite container) {
        Group group = LookAndFeel.getGroup((Composite)container, (String)"Space Group", (int)2, (int)2);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in GrainSpotter");
        Composite composite = new Composite((Composite)group, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Symbol");
        this.spaceGroupSymbolCombo = new Combo(composite, 28);
        this.spaceGroupSymbolCombo.setLayoutData((Object)new GridData(4, 16, true, false));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(50, -1).applyTo((Control)this.spaceGroupSymbolCombo);
        this.spaceGroupSymbolCombo.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in GrainSpotter");
        int i = 0;
        while (i < 230) {
            this.spaceGroupSymbolCombo.add(ICrystalSymmetryVarKeys.SPACE_GROUP_SYMBOLS[i]);
            ++i;
        }
        this.spaceGroupSymbolCombo.select(0);
        this.spaceGroupSymbolCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.spaceGroup = GrainSpotterInput.this.spaceGroupSymbolCombo.getSelectionIndex() + 1;
                GrainSpotterInput.this.setSpaceGroup(GrainSpotterInput.this.spaceGroup);
                GrainSpotterInput.this.setDirty(true);
            }
        });
        composite = new Composite((Composite)group, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Number");
        this.spaceGroupSpinner = new Spinner(composite, 2068);
        this.spaceGroupSpinner.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in GrainSpotter");
        this.spaceGroupSpinner.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.spaceGroupSpinner.setMinimum(1);
        this.spaceGroupSpinner.setMaximum(230);
        this.spaceGroupSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.spaceGroup = GrainSpotterInput.this.spaceGroupSpinner.getSelection();
                GrainSpotterInput.this.setSpaceGroup(GrainSpotterInput.this.spaceGroup);
                GrainSpotterInput.this.setDirty(true);
            }
        });
        composite = new Composite((Composite)group, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)composite);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Crystal System:");
        this.spaceSystemText = new Text(composite, 0);
        this.spaceSystemText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.spaceSystemText);
        this.spaceSystemText.setText(ICrystalSymmetryVarKeys.SPACE_GROUP_TYPES[this.spaceGroupSystem]);
        this.spaceSystemText.setToolTipText("The crystal system is determined by the space group.");
    }

    private void createGroupCuts(Composite container) {
        Group cutseulerComposite = LookAndFeel.getGroup((Composite)container, (String)"Cuts", (int)2, (int)1);
        cutseulerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        cutseulerComposite.setToolTipText("cuts [min_measuments min_completeness min_uniqueness]:\n\nMinimum sigma requirements for accepting a grain solution.");
        new Label((Composite)cutseulerComposite, 0).setText("Min. measurement");
        this.cutsMinMeasurement = new IntegerText((Composite)cutseulerComposite, 4, "");
        this.cutsMinMeasurement.setMinValue(new Integer(3).intValue(), false);
        this.cutsMinMeasurement.setToolTipText("min_measurements:\n\nMinimum number of g-vectors assigned to the grain \n(integer value > 3).");
        this.cutsMinMeasurement.set_isRequiredField(false);
        new Label((Composite)cutseulerComposite, 0).setText("Min. completeness");
        this.cutsMinCompletenessText = new FloatText((Composite)cutseulerComposite, 4, "");
        this.cutsMinCompletenessText.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinCompletenessText.setToolTipText("min_completeness:\n\nThe minimum fraction of expected reflections assigned \n(#assigned relfections / #theretical reflections) to \nthe grain (0 <= min completeness <= 1).");
        this.cutsMinCompletenessText.set_isRequiredField(false);
        new Label((Composite)cutseulerComposite, 0).setText("Min. uniqueness");
        this.cutsMinUniqueness = new FloatText((Composite)cutseulerComposite, 4, "");
        this.cutsMinUniqueness.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinUniqueness.setToolTipText("min_uniqueness:\n\nMinimum fraction of reflections assigned to only\none grain (0 <= min uniqueness <= 1).  Use 0 to avoid the\ncheck.");
        this.cutsMinUniqueness.set_isRequiredField(false);
    }

    private void createGroupUncertainties(Composite container) {
        Group uncertGroup = LookAndFeel.getGroup((Composite)container, (String)"Uncertainties (in degrees)", (int)2, (int)2);
        uncertGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        uncertGroup.setToolTipText("uncertainties [sigma_tth, sigma_eta, sigma_omega:\n\nUntil full error estimation is available on the \ng-vectors in the input g-vector file, sigma_twotheta, \nsigma_eta and sigma_omega give your estimation of the \nuncertainties in degrees on two-theta, eta, and omega. \nSince these are estimated by the user and since they \n\"decide\" whether a theoretical gvector matches an \nobserved, it is important to vary these parameters a \nbit to obtain a set that allows GrainSpotter to able to \ndetermine the grain orientations. ");
        new Label((Composite)uncertGroup, 0).setText("Sigma tth");
        this.sigmaTth = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaTth.setToolTipText("sigma_tth:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in two-theta.");
        this.sigmaTth.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaTth.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigma eta");
        this.sigmaEta = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaEta.setToolTipText("sigma_eta:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in eta.");
        this.sigmaEta.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaEta.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigma omega");
        this.sigmaOmega = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaOmega.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaOmega.setToolTipText("sigma_omega:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in omega.");
        this.sigmaOmega.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigmas (maximal deviation)");
        this.nsigma = new FloatText((Composite)uncertGroup, 0, "");
        this.nsigma.setToolTipText("nsigmas:\n\nGives the maximum deviation (n-Sigma) to use when \ncomparing two quantities.  For example, when nsigmas is 2, \nthen the quantities must fit within the 2-sigma range. \nIn general, |d(quantity)| < nsigmas * sigma(quantity).");
        this.nsigma.setMinValue(new Float(0.0).floatValue(), false);
        this.nsigma.set_isRequiredField(false);
    }

    private void createGroupSearchParameters(Composite container) {
        Group grp = LookAndFeel.getGroup((Composite)container, (String)"Search Parameters", (int)4, (int)2);
        grp.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        this.createSearchModeGroup((Composite)grp);
        Composite searchComposite = new Composite((Composite)grp, 0);
        searchComposite.setLayout((Layout)new GridLayout(3, false));
        GridData searchLayout = new GridData(16384, 4, true, false, 3, 1);
        searchComposite.setLayoutData((Object)searchLayout);
        Label labelHkl = new Label(searchComposite, 0);
        labelHkl.setText("Nhkls");
        this.hklRingsText = new IntegerText(searchComposite, 0, "");
        this.hklRingsText.setMinValue(new Integer(0).intValue(), false);
        this.hklRingsText.setToolTipText("Nhkls_in_indexing:\n\nUses the first though this number of hkl families to recover \nthe crystallographic orientations. Afterwards the search \nfor additional g-vectors belonging to the grain is done \non the remaining families (integer > 0).");
        this.hklRingsText.set_isRequiredField(false);
        this.hklRingsText.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label(searchComposite, 0).setText("Minfracg");
        this.minfracg = new FloatText(searchComposite, 0, "");
        this.minfracg.setToolTipText("minfracg:\n\nStop search when minfracg of the gvectors have \nbeen assigned to grains. (0 < minfracg < 1)");
        this.minfracg.set_isRequiredField(false);
        this.minfracg.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label(searchComposite, 0).setText("Fit position ?");
        this.fitPositionFalse = new Button(searchComposite, 16);
        this.fitPositionFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.fitPositionFalse.setText("No");
        this.fitPositionFalse.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitPositionTrue = new Button(searchComposite, 16);
        this.fitPositionTrue.setText("Yes");
        this.fitPositionTrue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitPositionTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.fitPositionFalse.setSelection(true);
        this.fitPositionFalse.setToolTipText("positionfit:\n\nWhen this is set, the spatial position of the grain \nis fitted simultaneously with the orientation matrix if \nthis keyword is added.");
        this.fitPositionTrue.setToolTipText("positionfit:\n\nWhen this is set, the spatial position of the grain \nis fitted simultaneously with the orientation matrix if \nthis keyword is added.");
    }

    private void createSearchModeGroup(Composite container) {
        Group grp = LookAndFeel.getGroup((Composite)container, (String)"Search mode", (int)2, (int)2);
        grp.setToolTipText("The search mode can either be scan or random.  With scan, \nEuler space is scanned systematically.  With random, random \npoints in the space are used.  Random can be faster, but \nthe results may vary from run to run.  The meanning of \neulerstep is different depending on the mode.  Note that \nrandom can give different results for different runs with \nthe same input parameters");
        grp.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        this.scanMode = new Button((Composite)grp, 16);
        this.scanMode.setText("Scan");
        this.scanMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.setSearchMode(((Button)e.widget).getSelection());
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.scanMode.setToolTipText("The search mode can either be scan or random.  With scan, \nEuler space is scanned systematically.  With random, random \npoints in the space are used.  Random can be faster, but \nthe results may vary from run to run.  The meanning of \neulerstep is different depending on the mode.  Note that \nrandom can give different results for different runs with \nthe same input parameters");
        GridData scanModelayout = new GridData(16384, 4, true, false, 2, 1);
        this.scanMode.setLayoutData((Object)scanModelayout);
        this.randomMode = new Button((Composite)grp, 16);
        this.randomMode.setText("Random");
        this.randomMode.setToolTipText("The search mode can either be scan or random.  With scan, \nEuler space is scanned systematically.  With random, random \npoints in the space are used.  Random can be faster, but \nthe results may vary from run to run.  The meanning of \neulerstep is different depending on the mode.  Note that \nrandom can give different results for different runs with \nthe same input parameters");
        this.randomMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterInput.this.setSearchMode(!((Button)e.widget).getSelection());
                GrainSpotterInput.this.setDirty(true);
            }
        });
        GridData randomModelayout = new GridData(16384, 4, true, false, 2, 1);
        this.randomMode.setLayoutData((Object)randomModelayout);
        new Label((Composite)grp, 0).setText("Euler Step Size");
        this.eulerStep = new FloatText((Composite)grp, 0, "", 0.0f, 180.0f);
        this.eulerStep.set_isRequiredField(false);
        this.eulerStep.setToolTipText("eulerstep:\n\nWhen scanning through Euler space (orientation space),\neulerstep gives the size in degrees of each step in the scan. \nShould be between 0 and 180. \n\nWhen using random, eulerstep denotes a small volume around \nthe random orientation in which a possible match can be \nfound. By making eulerstep small the possible solutions \nfor each step are reduced, which makes it faster. However, \nyou might also need more random steps to find all grains. \nA sensible value is around 3-6 degrees.");
        new Label((Composite)grp, 0).setText("Random Trials");
        this.random = new IntegerText((Composite)grp, 0);
        this.random.setToolTipText("ramdom:\n\nRandom is the number of orientations tried. It is only \nmeaningful if the mode is random.");
        this.random.set_isRequiredField(this.randomMode.getSelection());
    }

    private void createRows(Table table, int maxrows) {
        int i = 0;
        while (i < maxrows) {
            new TableItem(table, 0);
            ++i;
        }
    }

    private void triggerTableSelectionDsRange() {
        final TableEditor rangeEditor = new TableEditor(this.dsRange);
        rangeEditor.horizontalAlignment = 16384;
        rangeEditor.grabHorizontal = true;
        rangeEditor.minimumWidth = 50;
        this.dsRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainSpotterInput.this.dsRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainSpotterInput.this.dsRange.getTopIndex();
                while (index < GrainSpotterInput.this.dsRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainSpotterInput.this.dsRange.getItem(index);
                    int i = 0;
                    while (i < GrainSpotterInput.this.dsRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainSpotterInput.this.dsRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainSpotterInput.this.setDirty(true);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainSpotterInput.this.setDirty(true);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            rangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void triggerTableSelectionTthRange() {
        final TableEditor tthRangeEditor = new TableEditor(this.tthRange);
        tthRangeEditor.horizontalAlignment = 16384;
        tthRangeEditor.grabHorizontal = true;
        tthRangeEditor.minimumWidth = 50;
        this.tthRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainSpotterInput.this.tthRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainSpotterInput.this.tthRange.getTopIndex();
                while (index < GrainSpotterInput.this.tthRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainSpotterInput.this.tthRange.getItem(index);
                    int i = 0;
                    while (i < GrainSpotterInput.this.tthRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainSpotterInput.this.tthRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainSpotterInput.this.setDirty(true);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainSpotterInput.this.setDirty(true);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            tthRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void triggerTableSelectionEtaRange() {
        final TableEditor etaRangeEditor = new TableEditor(this.etaRange);
        etaRangeEditor.horizontalAlignment = 16384;
        etaRangeEditor.grabHorizontal = true;
        etaRangeEditor.minimumWidth = 50;
        this.etaRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainSpotterInput.this.etaRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainSpotterInput.this.etaRange.getTopIndex();
                while (index < GrainSpotterInput.this.etaRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainSpotterInput.this.etaRange.getItem(index);
                    int i = 0;
                    while (i < GrainSpotterInput.this.etaRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainSpotterInput.this.etaRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainSpotterInput.this.setDirty(true);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainSpotterInput.this.setDirty(true);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            etaRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void triggerTableSelectionOmegaRange() {
        final TableEditor omegaRangeEditor = new TableEditor(this.omegaRange);
        omegaRangeEditor.horizontalAlignment = 16384;
        omegaRangeEditor.grabHorizontal = true;
        omegaRangeEditor.minimumWidth = 50;
        this.omegaRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainSpotterInput.this.omegaRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainSpotterInput.this.omegaRange.getTopIndex();
                while (index < GrainSpotterInput.this.omegaRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainSpotterInput.this.omegaRange.getItem(index);
                    int i = 0;
                    while (i < GrainSpotterInput.this.omegaRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainSpotterInput.this.omegaRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainSpotterInput.this.setDirty(true);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainSpotterInput.this.setDirty(true);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            omegaRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void createMinMaxColumnOmegaRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.omegaRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.omegaRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.omegaRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.omegaRange.pack();
    }

    private void createMinMaxColumntthRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.tthRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.tthRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.tthRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.tthRange.pack();
    }

    private void createMinMaxColumnEtaRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.etaRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.etaRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.etaRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.etaRange.pack();
    }

    private void createMinMaxColumnDsRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.dsRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.dsRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.dsRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.dsRange.pack();
    }

    private void createRemoveItemButtonDsRange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("Remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainSpotterInput.this.dsRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainSpotterInput.this.dsRange.getItem(index);
                    tableItem.dispose();
                    GrainSpotterInput.this.setDirty(true);
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonTthRange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("Remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainSpotterInput.this.tthRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainSpotterInput.this.tthRange.getItem(index);
                    tableItem.dispose();
                    GrainSpotterInput.this.setDirty(true);
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonEtaRange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainSpotterInput.this.etaRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainSpotterInput.this.etaRange.getItem(index);
                    tableItem.dispose();
                    GrainSpotterInput.this.setDirty(true);
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonOmegarange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("Remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainSpotterInput.this.omegaRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainSpotterInput.this.omegaRange.getItem(index);
                    tableItem.dispose();
                    GrainSpotterInput.this.setDirty(true);
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createAddButtonTthrange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainSpotterInput.this.tthRange, 0);
                GrainSpotterInput.this.setDirty(true);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    private void createAddButtonOmegaRange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainSpotterInput.this.omegaRange, 0);
                GrainSpotterInput.this.setDirty(true);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    private void createAddButtonEtaRange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainSpotterInput.this.etaRange, 0);
                GrainSpotterInput.this.setDirty(true);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    private void createAddButtonDsRange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainSpotterInput.this.dsRange, 0);
                GrainSpotterInput.this.setDirty(true);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    public void init() {
        if (this.inputFile == null) {
            FableLogger.info((Object)"InputFile is null for GrainSpotterInput.initFields");
            return;
        }
        if (this.inputFile.isIgnoreOptionDsRange()) {
            this.chooseTthRange.setSelection(true);
            this.chooseDSpacing.setSelection(false);
        } else {
            this.chooseTthRange.setSelection(false);
            this.chooseDSpacing.setSelection(true);
        }
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDSpacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDSpacing.getSelection());
        this.setGveFile(this.inputFile.getGveFileName());
        this.setLogFile(this.inputFile.getLogFileName());
        this.setSpaceGroup(this.inputFile.getSpaceGroup());
        this.setDsRange(this.inputFile.getDsRange());
        this.setOmegaRange(this.inputFile.getOmegaRange());
        if (!this.inputFile.isIgnoreOptionDeltaOmegaSpec()) {
            this.setDeltaOmega(this.inputFile.getDeltaOmegaSpecs());
        }
        if (!this.inputFile.isIgnoreOptionUncertainties()) {
            this.set_uncertTthText(this.inputFile.getTtUncertainties());
            this.set_uncertEtaText(this.inputFile.getEtaUncertainties());
            this.set_uncertOmegaText(this.inputFile.getOmegaUncertainties());
        }
        this.setTthRange(this.inputFile.getTthRange());
        this.setEtaRange(this.inputFile.getEtaRange());
        if (!this.inputFile.isIgnoreOptionCuts()) {
            this.set_cutsMinCompletenessText(this.inputFile.getMinCompletenessCuts());
            this.set_cutsMinMeasurement(this.inputFile.getMinMeasurementCuts());
            this.set_cutsMinUniqueness(this.inputFile.getMinMeasurementUniqueness());
        }
        if (!this.inputFile.isIgnoreOptionEuler()) {
            this.set_eulerStep(this.inputFile.getStepEuler());
        }
        if (!this.inputFile.isIgnoreOptionNSigma()) {
            this.set_sigmaText(this.inputFile.getNSigmas());
        }
        if (!this.inputFile.isIgnoreOptionHKL()) {
            this.setNHkls(this.inputFile.getNHKLs());
        }
        if (!this.inputFile.isIgnoreOptionMinfracg()) {
            this.setMinfracg(this.inputFile.getMinfracg());
        }
        if (!this.inputFile.isIgnoreOptionRandom()) {
            this.setRandom(this.inputFile.getRandom());
        }
        this.inputFile.isIgnoreOptionRandom();
        this.setSearchMode(this.inputFile.isIgnoreOptionRandom());
        this.setPositionFit(this.inputFile.isPositionFit());
        this.setModifyListeners();
        GrainSpotterInput.synchronizeInitialDirectories(this.inputFile.getIniFilePath());
        this.grainSpotter.setLogFilePath(initialDirLog);
        this.grainSpotter.setGveFilePath(initialDirGve);
    }

    public void setModifyListeners() {
        this.txtFileLog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.txtFilegve.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
                String file = GrainSpotterInput.this.txtFilegve.getText();
                if (ToolBox.checkIfFileExists((String)file)) {
                    GrainSpotterInput.this.grainSpotter.setGveFileName(file);
                    GrainSpotterInput.this.inputFile.setGveFileName(file);
                }
            }
        });
        this.minfracg.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.omegaDeltaText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.eulerStep.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.cutsMinMeasurement.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.hklRingsText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
        this.cutsMinCompletenessText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainSpotterInput.this.setDirty(true);
            }
        });
    }

    private void setSearchMode(boolean isscanMode) {
        this.random.set_isRequiredField(!isscanMode);
        this.random.setEnabled(!isscanMode);
        this.scanMode.setSelection(isscanMode);
        this.randomMode.setSelection(!isscanMode);
    }

    public void setLogFile(String logFileName) {
        this.txtFileLog.set_Text(logFileName);
        File f = new File(logFileName);
        this.setLogFile(f.getName(), f.getPath());
    }

    public void setGveFile(String gveFileName) {
        this.txtFilegve.set_Text(gveFileName);
        this.grainSpotter.setGveFileName(gveFileName);
    }

    private void setRandom(int sigmas) {
        this.random.set_Text(String.valueOf(sigmas));
        this.random.set_isRequiredField(true);
        this.scanMode.setSelection(false);
        this.randomMode.setSelection(true);
    }

    private void setDeltaOmega(float deltaOmegaSpecs) {
        this.omegaDeltaText.set_Text(String.valueOf(deltaOmegaSpecs));
    }

    private void setPositionFit(boolean positionFit) {
        this.fitPositionTrue.setSelection(positionFit);
        this.fitPositionFalse.setSelection(!positionFit);
    }

    private void setDsRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.dsRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    public String setTableItemText(float f) {
        DecimalFormat form = new DecimalFormat();
        String txt = "0";
        try {
            txt = form.format(f);
        }
        catch (NumberFormatException e) {
            FableLogger.error((Object)e.getMessage());
        }
        return txt;
    }

    public String getItemText(String s) {
        DecimalFormat d = new DecimalFormat();
        if (!s.trim().equals("")) {
            try {
                Number n = d.parse(s);
                s = n.toString();
            }
            catch (ParseException e) {
                FableLogger.getLogger().error((Object)e.getMessage());
            }
        }
        FableLogger.debug((Object)(this.getClass() + " getItemText :" + s));
        return s;
    }

    private void setTthRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.tthRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setEtaRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.etaRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setOmegaRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.omegaRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    public boolean setOptions() {
        boolean bok = true;
        try {
            TableItem item;
            this.inputFile.setSpaceGroup(this.spaceGroupSpinner.getSelection());
            if (!this.omegaDeltaText.getText().equals("")) {
                this.inputFile.ignoreOptionDeltaOmegaSpecs(false);
                this.inputFile.set_deltaOmegaSpecs(this.omegaDeltaText.getText());
            } else {
                this.inputFile.ignoreOptionDeltaOmegaSpecs(true);
            }
            this.inputFile.getOmegaRange().removeAllElements();
            int i = 0;
            while (i < this.omegaRange.getItemCount()) {
                item = this.omegaRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.inputFile.addOmegaRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            this.inputFile.getEtaRange().removeAllElements();
            i = 0;
            while (i < this.etaRange.getItemCount()) {
                item = this.etaRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.inputFile.addEtaRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            this.inputFile.getTthRange().removeAllElements();
            i = 0;
            while (this.chooseTthRange.getSelection() && i < this.tthRange.getItemCount()) {
                item = this.tthRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.inputFile.addtthRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            this.inputFile.getDsRange().removeAllElements();
            i = 0;
            while (this.chooseDSpacing.getSelection() && i < this.dsRange.getItemCount()) {
                item = this.dsRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.inputFile.addDsRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            if (!(this.cutsMinCompletenessText.getText().trim().equals("") || this.cutsMinMeasurement.getText().trim().equals("") || this.cutsMinUniqueness.getText().trim().equals(""))) {
                this.inputFile.set_minCompletenessCuts(this.cutsMinCompletenessText.getText());
                this.inputFile.set_minMeasurementCuts(this.cutsMinMeasurement.getText());
                this.inputFile.setMinMeasurementUniqueness(this.cutsMinUniqueness.getText());
                this.inputFile.ignoreOptionCuts(false);
            } else {
                this.inputFile.ignoreOptionCuts(true);
            }
            if (!this.eulerStep.getText().trim().equals("")) {
                this.inputFile.set_stepEuler(this.eulerStep.getText());
                this.inputFile.ignoreOptionEuler(false);
            } else {
                this.inputFile.ignoreOptionEuler(true);
            }
            if (!(this.sigmaTth.getText().trim().equals("") || this.sigmaEta.getText().trim().equals("") || this.sigmaOmega.getText().trim().equals(""))) {
                this.inputFile.set_ttUncertanties(this.sigmaTth.getText());
                this.inputFile.set_etaUncertanties(this.sigmaEta.getText());
                this.inputFile.set_omegaUncertanties(this.sigmaOmega.getText());
                this.inputFile.ignoreOptionUncertainties(false);
            } else {
                this.inputFile.ignoreOptionUncertainties(true);
            }
            this.inputFile.setGveFileName(this.txtFilegve.getText());
            this.inputFile.setLogFileName(this.txtFileLog.getText());
            if (!this.nsigma.getText().trim().equals("")) {
                this.inputFile.set_nSigmas(this.nsigma.getText());
                this.inputFile.ignoreOptionNSigma(false);
            } else {
                this.inputFile.ignoreOptionNSigma(true);
            }
            if (!this.hklRingsText.getText().trim().equals("")) {
                this.inputFile.set_nHKLs(this.hklRingsText.getText());
                this.inputFile.ignoreOptionHKL(false);
            } else {
                this.inputFile.ignoreOptionHKL(true);
            }
            if (!this.minfracg.getText().trim().equals("")) {
                this.inputFile.setMinfracg(this.minfracg.getText());
                this.inputFile.ignoreOptionMinfracg(false);
            } else {
                this.inputFile.ignoreOptionMinfracg(true);
            }
            if (this.randomMode.getSelection() && !this.random.getText().trim().equals("")) {
                this.inputFile.setRandom(this.random.getText());
                this.inputFile.ignoreOptionRandom(false);
            } else {
                this.inputFile.ignoreOptionRandom(true);
            }
            this.inputFile.setPositionFit(this.fitPositionTrue.getSelection());
        }
        catch (GrainSpotterException e) {
            FableMessageConsole.console.displayIn(e.get_message());
            bok = false;
        }
        return bok;
    }

    public void setSpaceGroup(int spaceGroup) {
        this.spaceGroup = spaceGroup;
        if (this.spaceGroupSymbolCombo.getSelectionIndex() != spaceGroup - 1) {
            this.spaceGroupSymbolCombo.select(spaceGroup - 1);
        }
        if (this.spaceGroupSpinner.getSelection() != spaceGroup) {
            this.spaceGroupSpinner.setSelection(spaceGroup);
        }
        int newspaceGroupSystem = 0;
        int i = 0;
        while (i < ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (spaceGroup <= ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM[i]) {
                newspaceGroupSystem = i;
                break;
            }
            ++i;
        }
        this.spaceGroupSystem = newspaceGroupSystem;
        this.spaceSystemText.setText(ICrystalSymmetryVarKeys.SPACE_GROUP_TYPES[this.spaceGroupSystem]);
    }

    private void set_eulerStep(float step) {
        this.eulerStep.set_Text(String.valueOf(step));
    }

    private void set_cutsMinCompletenessText(float f) {
        this.cutsMinCompletenessText.set_Text(String.valueOf(f));
    }

    private void set_cutsMinMeasurement(int minText) {
        this.cutsMinMeasurement.set_Text(String.valueOf(minText));
    }

    private void set_cutsMinUniqueness(float minText) {
        this.cutsMinUniqueness.set_Text(String.valueOf(minText));
    }

    private void set_sigmaText(float text) {
        this.nsigma.set_Text(String.valueOf(text));
    }

    private void set_uncertEtaText(float etaText) {
        this.sigmaEta.set_Text(String.valueOf(etaText));
    }

    private void set_uncertOmegaText(float omegaText) {
        this.sigmaOmega.set_Text(String.valueOf(omegaText));
    }

    private void set_uncertTthText(float thetaText) {
        this.sigmaTth.set_Text(String.valueOf(thetaText));
    }

    public void setNHkls(int hkl) {
        this.hklRingsText.set_Text(String.valueOf(hkl));
    }

    public void setMinfracg(float minfracg) {
        this.minfracg.set_Text(String.valueOf(minfracg));
    }

    public static void synchronizeInitialDirectories(String dir) {
        if (dir == null) {
            return;
        }
        if (initialDirIni == null) {
            initialDirIni = dir;
        }
        if (initialDirGve == null) {
            initialDirGve = dir;
        }
        if (initialDirLog == null) {
            initialDirLog = dir;
        }
    }

    public void dispose() {
        this.grainSpotter.removePropertyChangeListener(this);
        super.dispose();
    }

    public boolean runGrainSpotter() {
        boolean fieldsOk = true;
        if (this.checkFields(this.parent, true)) {
            if (this.editor.isDirty()) {
                String msg = "Your ini file has changed. Do you want to overwrite it?\n\nIf not, cancel the operation.\n\nAfter that, you can save this new input file using File/Save As...";
                boolean confirm = FableUtils.confirmMsg((Object)this, (String)msg);
                if (confirm) {
                    this.editor.save();
                    this.grainSpotter.run();
                }
            } else {
                this.setOptions();
                this.grainSpotter.run();
            }
        } else {
            fieldsOk = false;
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Fields are not correct ");
                FableMessageConsole.console.activate();
            }
        }
        return fieldsOk;
    }

    private boolean checkFields(Composite parent2, boolean bok) {
        Control[] element = parent2.getChildren();
        int i = 0;
        while (bok && i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText && !((TypedText)element[i]).is_bValide()) {
                    bok = false;
                    ((TypedText)element[i]).showDecoration();
                } else {
                    bok = this.checkFields((Composite)element[i], bok);
                }
            }
            ++i;
        }
        return bok;
    }

    private void setDirty(boolean dirty) {
        if (this.editor != null) {
            this.editor.setDirty(dirty);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String val;
        if (event.getProperty().equals("grainspotter") && (val = (String)event.getNewValue()).equals("launch")) {
            this.runGrainSpotter();
        }
    }

    public String getLogFileName() {
        return this.txtFileLog.getText();
    }

    public String getGVE() {
        return this.txtFilegve.getText();
    }

    public static String getInitialDirLog() {
        return initialDirLog;
    }

    public static void setInitialDirLog(String initialDirLog) {
        GrainSpotterInput.initialDirLog = initialDirLog;
    }

    public GrainSpotterInputEditor getEditor() {
        return this.editor;
    }

    public InputFile getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(InputFile inputFile) {
        this.inputFile = inputFile;
        if (this.grainSpotter != null) {
            this.grainSpotter.setInputFile(inputFile);
        }
    }

    public GrainSpotter getGrainSpotter() {
        return this.grainSpotter;
    }

    class CellModifier
    implements ICellModifier {
        private TableViewer tableviewer;

        public CellModifier(TableViewer viewer) {
            this.tableviewer = viewer;
        }

        public boolean canModify(Object arg0, String arg1) {
            return true;
        }

        public Object getValue(Object arg0, String arg1) {
            this.tableviewer.getTable().getSelectionIndex();
            return null;
        }

        public void modify(Object element, String property, Object value) {
        }
    }
}

