/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.editors.ColumnFileEditor;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.ColumnFilePlotEditor;
import fable.framework.views.FableIOConsole;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ColumnEditorAction
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "fable.framework.ui.actions.ColumnEditorAction";
    private Display display;
    private IEditorInput input;
    private IWorkbenchPage page;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.setDisplay(window.getShell().getDisplay());
        if (window != null) {
            this.page = window.getActivePage();
            FileDialog dialog = new FileDialog(window.getShell(), 2);
            dialog.setFilterNames(new String[]{"*.flt", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*.flt", "*.*"});
            if (dialog.open() != null) {
                String path = dialog.getFilterPath();
                String[] files = dialog.getFileNames();
                int i = 0;
                while (i < files.length) {
                    final String name = files[i];
                    final String fileToLoad = String.valueOf(path) + File.separatorChar + files[i];
                    Job j = new Job("Load column file job " + name){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask("Please wait while loading file in editor " + name, -1);
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            ColumnEditorAction.this.input = new ColumnFileEditorInput(fileToLoad);
                            monitor.done();
                            ColumnEditorAction.this.openEditors(ColumnEditorAction.this.input, ColumnEditorAction.this.page);
                            return Status.OK_STATUS;
                        }
                    };
                    j.setUser(true);
                    j.schedule();
                    j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult().isOK()) {
                                if (FableIOConsole.console != null) {
                                    FableIOConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " completed successfully");
                                }
                            } else if (FableIOConsole.console != null) {
                                FableIOConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " did not complete successfully");
                            }
                        }
                    });
                    ++i;
                }
            }
        }
    }

    private void openEditors(final IEditorInput input, final IWorkbenchPage page) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (page != null) {
                    String id = ColumnFileEditor.getId();
                    try {
                        page.openEditor(input, id, true);
                    }
                    catch (PartInitException e) {
                        FableUtils.errMsg((Object)this, (String)e.getMessage());
                    }
                    String plotId = ColumnFilePlotEditor.getId();
                    try {
                        page.openEditor(input, plotId, true);
                    }
                    catch (PartInitException e) {
                        FableUtils.errMsg((Object)this, (String)e.getMessage());
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Display getDisplay() {
        return this.display;
    }
}

