/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.plugins.DefaultPlugin;
import org.eclipse.core.internal.plugins.InternalPlatform;
import org.eclipse.core.internal.plugins.Library;
import org.eclipse.core.internal.plugins.PluginClassLoader;
import org.eclipse.core.internal.plugins.PluginPrerequisite;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PluginDescriptor
implements IPluginDescriptor {
    private static final String PLUGIN_CLASS = "Plugin-Class";
    protected Plugin pluginObject = null;
    private Bundle bundleOsgi;
    private boolean active = false;
    private volatile boolean activePending = false;
    private boolean deactivated = false;
    private ResourceBundle resources = null;
    private PluginClassLoader classLoader;
    static final String PLUGIN_URL = "platform:/plugin/";
    static final String VERSION_SEPARATOR = "_";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public synchronized void doPluginDeactivation() {
        this.pluginObject = null;
        this.active = false;
        this.activePending = false;
        this.deactivated = false;
    }

    public IExtension getExtension(String id) {
        IExtension[] exts = this.getExtensions();
        int i = 0;
        while (i < exts.length) {
            if (exts[i].getSimpleIdentifier().equals(id)) {
                return exts[i];
            }
            ++i;
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getRegistry().getExtensionPoint(this.getId(), extensionPointId);
    }

    public IExtensionPoint[] getExtensionPoints() {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getRegistry().getExtensionPoints(this.getId());
    }

    public IExtension[] getExtensions() {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getRegistry().getExtensions(this.getId());
    }

    public URL getInstallURL() {
        try {
            return new URL(PLUGIN_URL + this.toString() + '/');
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public String getLabel() {
        return (String)this.bundleOsgi.getHeaders().get("Bundle-Name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getPluginClassLoader() {
        PluginDescriptor pluginDescriptor = this;
        synchronized (pluginDescriptor) {
            if (this.classLoader == null) {
                this.classLoader = new PluginClassLoader(this);
            }
        }
        return this.classLoader;
    }

    public PluginRegistry getPluginRegistry() {
        return (PluginRegistry)InternalPlatform.getPluginRegistry();
    }

    public String getProviderName() {
        return (String)this.bundleOsgi.getHeaders().get("Bundle-Vendor");
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        if (this.resources == null) {
            this.resources = ResourceTranslator.getResourceBundle((Bundle)this.bundleOsgi);
        }
        return this.resources;
    }

    public String getResourceString(String value) {
        return ResourceTranslator.getResourceString((Bundle)this.bundleOsgi, (String)value);
    }

    public String getResourceString(String value, ResourceBundle b) {
        return ResourceTranslator.getResourceString((Bundle)this.bundleOsgi, (String)value, (ResourceBundle)b);
    }

    public ILibrary[] getRuntimeLibraries() {
        Bundle[] allBundles;
        Bundle[] fragments = org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getFragments(this.bundleOsgi);
        if (fragments != null) {
            allBundles = new Bundle[fragments.length + 1];
            allBundles[0] = this.bundleOsgi;
            System.arraycopy(fragments, 0, allBundles, 1, fragments.length);
        } else {
            allBundles = new Bundle[]{this.bundleOsgi};
        }
        ArrayList<Library> allLibraries = new ArrayList<Library>();
        boolean addedDot = false;
        int i = 0;
        while (i < allBundles.length) {
            try {
                ManifestElement[] classpathElements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)allBundles[i].getHeaders("").get("Bundle-ClassPath")));
                if (classpathElements == null) {
                    if (!addedDot) {
                        allLibraries.add(new Library("."));
                        addedDot = true;
                    }
                } else {
                    int j = 0;
                    while (j < classpathElements.length) {
                        allLibraries.add(new Library(classpathElements[j].getValue()));
                        ++j;
                    }
                }
            }
            catch (BundleException bundleException) {}
            ++i;
        }
        return allLibraries.toArray(new ILibrary[allLibraries.size()]);
    }

    public String getUniqueIdentifier() {
        return this.getId();
    }

    public static String getUniqueIdentifierFromString(String pluginString) {
        int ix = pluginString.indexOf(VERSION_SEPARATOR);
        return ix == -1 ? pluginString : pluginString.substring(0, ix);
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        String version = (String)this.bundleOsgi.getHeaders("").get("Bundle-Version");
        try {
            return new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return new PluginVersionIdentifier("1.0.0");
        }
    }

    public static PluginVersionIdentifier getVersionIdentifierFromString(String pluginString) {
        return new PluginVersionIdentifier(pluginString);
    }

    public IPluginPrerequisite[] getPluginPrerequisites() {
        BundleDescription description = Platform.getPlatformAdmin().getState(false).getBundle(this.bundleOsgi.getBundleId());
        BundleSpecification[] specs = description.getRequiredBundles();
        IPluginPrerequisite[] resolvedPrerequisites = new IPluginPrerequisite[specs.length];
        int j = 0;
        while (j < specs.length) {
            resolvedPrerequisites[j] = new PluginPrerequisite(specs[j]);
            ++j;
        }
        return resolvedPrerequisites;
    }

    boolean hasActivationStarted() {
        return this.activePending || this.active;
    }

    public synchronized boolean isPluginActivated() {
        return this.bundleOsgi.getState() == 32;
    }

    public boolean isPluginDeactivated() {
        return this.deactivated;
    }

    private void logError(IStatus status) {
        org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getLog(org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
    }

    private boolean pluginActivationEnter() throws CoreException {
        if (this.deactivated) {
            String errorMsg = NLS.bind((String)Messages.plugin_pluginDisabled, (Object)this.getId());
            this.throwException(errorMsg, null);
        }
        if (this.active || this.activePending) {
            return false;
        }
        this.activePending = true;
        return true;
    }

    private void pluginActivationExit(boolean errorExit) {
        if (errorExit) {
            this.active = false;
            this.deactivated = true;
        } else {
            this.active = true;
        }
        this.activePending = false;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.core.runtime", 2, message, exception);
        this.logError((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + VERSION_SEPARATOR + this.getVersionIdentifier().toString();
    }

    public final URL find(IPath path) {
        URL result = FindSupport.find((Bundle)this.bundleOsgi, (IPath)path);
        if (result != null) {
            try {
                result = Platform.resolve((URL)result);
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public final URL find(IPath path, Map override) {
        URL result = FindSupport.find((Bundle)this.bundleOsgi, (IPath)path, (Map)override);
        if (result != null) {
            try {
                result = Platform.resolve((URL)result);
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public Plugin getPlugin() throws CoreException {
        if (this.pluginObject == null) {
            this.doPluginActivation();
        }
        return this.pluginObject;
    }

    synchronized void doPluginActivation() throws CoreException {
        if ((this.bundleOsgi.getState() & 0x2C) == 0) {
            throw new IllegalArgumentException();
        }
        try {
            org.eclipse.core.internal.runtime.InternalPlatform.start((Bundle)this.bundleOsgi);
        }
        catch (BundleException e) {
            this.throwException(NLS.bind((String)Messages.plugin_startupProblems, (Object)((Object)e)), e);
        }
        if (this.pluginObject != null) {
            return;
        }
        boolean errorExit = true;
        if (this.pluginActivationEnter()) {
            try {
                this.internalDoPluginActivation();
                errorExit = false;
            }
            finally {
                this.pluginActivationExit(errorExit);
            }
        } else if (this.active && this.pluginObject == null) {
            this.active = false;
            this.pluginObject = new DefaultPlugin(this);
            this.active = true;
        }
    }

    private String getPluginClass() {
        return (String)this.bundleOsgi.getHeaders("").get(PLUGIN_CLASS);
    }

    private String getId() {
        return this.bundleOsgi.getSymbolicName();
    }

    private void internalDoPluginActivation() throws CoreException {
        String errorMsg;
        Class runtimeClass;
        String pluginClassName;
        block19: {
            pluginClassName = this.getPluginClass();
            runtimeClass = null;
            try {
                if (pluginClassName == null || pluginClassName.equals("")) {
                    Class clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.internal.plugins.DefaultPlugin");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    runtimeClass = clazz;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.core.internal.plugins.DefaultPlugin");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    pluginClassName = clazz2.getName();
                    break block19;
                }
                runtimeClass = this.bundleOsgi.loadClass(pluginClassName);
            }
            catch (ClassNotFoundException e) {
                errorMsg = NLS.bind((String)Messages.plugin_loadClassError, (Object)this.getId(), (Object)pluginClassName);
                this.throwException(errorMsg, e);
            }
        }
        Constructor construct = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.runtime.IPluginDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            construct = runtimeClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException eNoConstructor) {
            errorMsg = NLS.bind((String)Messages.plugin_instantiateClassError, (Object)this.getId(), (Object)pluginClassName);
            this.throwException(errorMsg, eNoConstructor);
        }
        try {
            this.pluginObject = (Plugin)construct.newInstance(this);
        }
        catch (ClassCastException e) {
            errorMsg = NLS.bind((String)Messages.plugin_notPluginClass, (Object)pluginClassName);
            this.throwException(errorMsg, e);
        }
        catch (Exception e) {
            errorMsg = NLS.bind((String)Messages.plugin_instantiateClassError, (Object)this.getId(), (Object)pluginClassName);
            this.throwException(errorMsg, e);
        }
    }

    public PluginDescriptor(Bundle b) {
        this.bundleOsgi = b;
        if ((b.getState() & 0x20) != 0) {
            this.active = true;
        }
    }

    public Bundle getBundle() {
        return this.bundleOsgi;
    }

    public void setPlugin(Plugin object) {
        this.pluginObject = object;
    }

    public synchronized void setActive() {
        this.active = true;
    }

    public boolean hasPluginObject() {
        return this.pluginObject != null;
    }

    public void markAsDeactivated() {
        this.deactivated = true;
    }
}

