/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.actions;

import fable.fabric.Activator;
import fable.fabric.editors.FabricEditor;
import fable.fabric.editors.ProgramThread;
import fable.fabric.internal.Fabric;
import fable.framework.toolbox.FableUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends Action
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
IEditorActionDelegate {
    private static final String ID = "fable.framework.ui.RunInputEditorAction";
    IWorkbenchWindow window;
    Fabric fabric;
    private Job job;
    private String currentDirectory = null;
    private String fileName = null;
    private FabricEditor currentEditor = null;
    public static int ANSWER_YES = 0;
    public static int ANSWER_CANCEL = 1;

    public RunAction() {
        this.setImageDescriptor(Activator.getImageDescriptor("images/fabric_run.gif"));
        this.setToolTipText("Run Fabric with this input file");
    }

    private void createJob(final String filename) {
        this.job = new Job("Fabric -i " + filename){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Work in progresss for Fabric with input file " + filename, -1);
                ProgramThread p = new ProgramThread("Fabric -i " + filename, RunAction.this.fabric);
                p.start();
                while (!RunAction.this.fabric.hasFinished()) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        try {
                            ((Object)((Object)this)).wait(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (monitor.isCanceled()) {
                            File kill = new File(RunAction.this.fabric.getKillFile());
                            try {
                                kill.createNewFile();
                            }
                            catch (IOException e) {
                                FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error creating a file to kill  Fabric", (Throwable)e);
                            }
                            monitor.subTask("A cancel operation has been required. \nPlease wait while program is ending...");
                        }
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
    }

    private void launcher() {
        this.fabric = new Fabric();
        int answer = 0;
        if (this.currentDirectory != null && this.fileName != null) {
            this.createJob(this.fileName);
            this.fabric.setCurrentDirectory(this.currentDirectory);
            this.fabric.setInputFile(this.fileName);
            answer = this.confirmSave();
            if (answer != ANSWER_CANCEL) {
                this.fabric.setCurrentDirectory(this.currentDirectory);
                this.fabric.setInputFile(this.fileName);
                if (FableUtils.confirmMsg((Object)((Object)this), (String)("Do you want to run fabric in the current directory " + this.currentDirectory + " with the current file " + this.fileName + " ?"))) {
                    this.job.schedule();
                }
            }
        } else {
            FableUtils.errMsg((Object)((Object)this), (String)"Fabric cannot be launched. Filename or current directory not found");
        }
    }

    public void run() {
        FabricEditor editor = this.getActiveEditor();
        if (editor != null) {
            this.fileName = editor.getFileName();
            this.currentDirectory = editor.getCurrentDirectory();
        }
        if (editor != null) {
            this.launcher();
        } else {
            FableUtils.errMsg((Object)((Object)this), (String)"This editor is not an input file for Fabric. Change Editor or set inp extension to this file.");
        }
    }

    private FabricEditor getActiveEditor() {
        IEditorPart part;
        IWorkbenchPage page;
        FabricEditor editor = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActiveEditor()) instanceof FabricEditor) {
            editor = (FabricEditor)part;
        }
        return editor;
    }

    public void run_test_1() {
        FabricEditor editor = this.getActiveEditor();
        IEditorInput fileName = editor.getEditorInput();
        String longFileName = null;
        String shortFileName = null;
        if (fileName == null) {
            System.out.println("Long filename is null");
        } else {
            longFileName = fileName.toString();
            shortFileName = editor.getEditorInput().getName();
        }
        if (editor != null) {
            System.out.println("Running with file: " + shortFileName + "\n\t\taka: " + longFileName + "\n\t\tEditor: " + ((Object)((Object)editor)).toString());
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow windowArg) {
        this.window = windowArg;
        this.setImageDescriptor(Activator.getImageDescriptor("images/fabric_run.gif"));
        this.setText("Run Fabric");
        this.setToolTipText("Run Fabric with current input editor");
        this.setId(ID);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sSelection;
        Object first;
        if (selection instanceof IStructuredSelection && (first = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof org.eclipse.core.internal.resources.File) {
            File file = ((org.eclipse.core.internal.resources.File)first).getLocation().toFile();
            this.fileName = file.getName();
            this.currentDirectory = file.getParent();
        }
    }

    public void init(IViewPart view) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof FabricEditor) {
            this.currentEditor = (FabricEditor)targetEditor;
            this.fileName = this.currentEditor.getFileName();
            this.currentDirectory = this.currentEditor.getCurrentDirectory();
        } else {
            this.currentDirectory = null;
            this.fileName = null;
            this.currentEditor = null;
        }
    }

    private int confirmSave() {
        int answer = ANSWER_YES;
        if (this.currentEditor != null && this.currentEditor.isDirty() && (answer = FableUtils.questionMsg((String)("'" + this.fileName + "' has changed.\n\n" + "Do you want to save it before running ?"))) == ANSWER_YES) {
            this.currentEditor.doSave(null);
        }
        return answer;
    }
}

