/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.ExtensionPointTracker;
import org.eclipse.equinox.http.registry.internal.HttpRegistryManager;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServletManager
implements ExtensionPointTracker.Listener {
    private static final String SERVLETS_EXTENSION_POINT = "org.eclipse.equinox.http.registry.servlets";
    private static final String HTTPCONTEXT_NAME = "httpcontext-name";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_NAME = "name";
    private static final String INIT_PARAM = "init-param";
    private static final String SERVLET = "servlet";
    private static final String ALIAS = "alias";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String HTTPCONTEXT_ID = "httpcontextId";
    private static final String SERVICESELECTOR = "serviceSelector";
    private static final String CLASS = "class";
    private static final String FILTER = "filter";
    private ExtensionPointTracker tracker;
    private HttpRegistryManager httpRegistryManager;
    private List registered = new ArrayList();
    private ServiceReference reference;

    public ServletManager(HttpRegistryManager httpRegistryManager, ServiceReference reference, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.reference = reference;
        this.tracker = new ExtensionPointTracker(registry, SERVLETS_EXTENSION_POINT, this);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement serviceSelectorElement = elements[i];
            if (SERVICESELECTOR.equals(serviceSelectorElement.getName())) {
                Filter serviceSelector = null;
                String clazz = serviceSelectorElement.getAttribute(CLASS);
                if (clazz != null) {
                    try {
                        serviceSelector = (Filter)serviceSelectorElement.createExecutableExtension(CLASS);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                String filter = serviceSelectorElement.getAttribute(FILTER);
                if (filter == null) {
                    return;
                }
                try {
                    serviceSelector = FrameworkUtil.createFilter((String)filter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                    return;
                }
                if (serviceSelector.match(this.reference)) break;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            IConfigurationElement servletElement = elements[i];
            if (SERVLET.equals(servletElement.getName())) {
                ServletWrapper wrapper = new ServletWrapper(servletElement);
                String alias = servletElement.getAttribute(ALIAS);
                if (alias != null) {
                    String httpContextId;
                    Hashtable<String, String> initparams = new Hashtable<String, String>();
                    IConfigurationElement[] initParams = servletElement.getChildren(INIT_PARAM);
                    int j = 0;
                    while (j < initParams.length) {
                        String paramName = initParams[j].getAttribute(PARAM_NAME);
                        String paramValue = initParams[j].getAttribute(PARAM_VALUE);
                        ((Dictionary)initparams).put(paramName, paramValue);
                        ++j;
                    }
                    boolean loadOnStartup = new Boolean(servletElement.getAttribute(LOAD_ON_STARTUP));
                    if (loadOnStartup) {
                        wrapper.setLoadOnStartup();
                    }
                    if ((httpContextId = servletElement.getAttribute(HTTPCONTEXT_ID)) == null) {
                        httpContextId = servletElement.getAttribute(HTTPCONTEXT_NAME);
                    }
                    if (httpContextId != null && httpContextId.indexOf(46) == -1) {
                        httpContextId = String.valueOf(servletElement.getNamespaceIdentifier()) + "." + httpContextId;
                    }
                    if (this.httpRegistryManager.addServletContribution(alias, wrapper, initparams, httpContextId, extension.getContributor())) {
                        this.registered.add(servletElement);
                    }
                }
            }
            ++i;
        }
    }

    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement servletElement = elements[i];
            if (this.registered.remove(servletElement)) {
                String alias = servletElement.getAttribute(ALIAS);
                this.httpRegistryManager.removeContribution(alias);
            }
            ++i;
        }
    }

    private static class ServletWrapper
    implements Servlet {
        private static final String CLASS = "class";
        private IConfigurationElement element;
        private Servlet delegate;
        private ServletConfig config;
        private boolean loadOnStartup = false;

        public ServletWrapper(IConfigurationElement element) {
            this.element = element;
        }

        public void setLoadOnStartup() {
            this.loadOnStartup = true;
        }

        public void init(ServletConfig config) throws ServletException {
            this.config = config;
            if (this.loadOnStartup) {
                this.initializeDelegate();
            }
        }

        public ServletConfig getServletConfig() {
            return this.config;
        }

        public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
            this.initializeDelegate();
            this.delegate.service(arg0, arg1);
        }

        public String getServletInfo() {
            return "";
        }

        public void destroy() {
            this.destroyDelegate();
        }

        private void initializeDelegate() throws ServletException {
            if (this.delegate == null) {
                try {
                    Servlet newDelegate = (Servlet)this.element.createExecutableExtension("class");
                    newDelegate.init(this.config);
                    this.delegate = newDelegate;
                }
                catch (CoreException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }

        private void destroyDelegate() {
            if (this.delegate != null) {
                Servlet doomedDelegate = this.delegate;
                this.delegate = null;
                doomedDelegate.destroy();
            }
        }
    }
}

